" Vim completion script
" Language:	PHP
" Maintainer:	Mikolaj Machowski ( mikmach AT wp DOT pl )
" Last Change:	2006 Mar 5
"
"
"  - outside of <?php?> getting parent tag may cause problems. Heh, even in
"    perfect conditions GetLastOpenTag doesn't cooperate... Inside of
"    phpStrings this can be even a bonus but outside of <?php?> it is not the
"    best situation
" - Switching to HTML completion (SQL) inside of phpStrings

function! phpcomplete#CompletePHP(findstart, base)
	if a:findstart
		unlet! b:php_menu
		" Check if we are inside of PHP markup
		let pos = getpos('.')
		let phpbegin = searchpairpos('<?', '', '?>', 'bWn','synIDattr(synID(line("."), col("."), 0), "name") =~? "string"')
		let phpend = searchpairpos('<?', '', '?>', 'Wn','synIDattr(synID(line("."), col("."), 0), "name") =~? "string"')
		" TODO: deal with opened <? but without closing ?>

		if phpbegin == [0,0] && phpend == [0,0]
			" We are outside of any PHP markup. Complete HTML
			let htmlbegin = htmlcomplete#CompleteTags(1, '')
			let cursor_col = pos[2]
			let base = getline('.')[htmlbegin : cursor_col]
			let b:php_menu = htmlcomplete#CompleteTags(0, base)
			return htmlbegin
		"elseif phpbegin[0] < pos[1] || phpbegin[0] == pos[1] && phpbegin[1] < pos[2]
		else
			
			" locate the start of the word
			let line = getline('.')
			let start = col('.') - 1
			let curline = line('.')
			let compl_begin = col('.') - 2
			while start >= 0 && line[start - 1] =~ '[a-zA-Z_0-9\x7f-\xff$]'
				let start -= 1
			endwhile
			let b:compl_context = getline('.')[0:compl_begin]
			return start

			" We can be also inside of phpString with HTML tags. Deal with
			" it later.
		endif
	else
		" If exists b:php_menu it means completion was already constructed we
		" don't need to do anything more
		if exists("b:php_menu")
			return b:php_menu
		endif
		" Initialize base return lists
		let res = []
		let res2 = []
		" a:base is very short - we need context
		if exists("b:compl_context")
			let context = b:compl_context
			unlet! b:compl_context
		endif

		if a:base =~ '^\$'
			" Complete variables
			let b:php_builtin_vars = ['$GLOBALS', '$_SERVER', '$_GET', '$_POST', '$_COOKIE', 
				\ '$_FILES', '$_ENV', '$_REQUEST', '$_SESSION', '$HTTP_SERVER_VARS',
				\ '$HTTP_ENV_VARS', '$HTTP_COOKIE_VARS', '$HTTP_GET_VARS', '$HTTP_POST_VARS',
				\ '$HTTP_POST_FILES', '$HTTP_SESSION_VARS', '$php_errormsg'
				\ ]

			" Internal solution for current file.
			let file = getline(1, '$')
			let jfile = join(file, ' ')
			let int_values = split(jfile, '\ze\$')
			call map(int_values, 'matchstr(v:val, "^\\$[a-zA-Z_\\x7f-\\xff][a-zA-Z_0-9\\x7f-\\xff]*")')
			"call map(int_values, '"$".v:val')
			"
			let int_values += b:php_builtin_vars

			
			for m in sort(int_values)
				if m =~ '^'.a:base
					call add(res, m)
				elseif m =~ a:base
					call add(res2, m)
				endif
			endfor

			let int_list = res + res2

			let int_dict = []
			for i in int_list
				let int_dict += [{'word':i}]
			endfor

			" ctags has good support for PHP, use tags file for external
			" variables
			let fnames = join(map(tagfiles(), 'escape(v:val, " \\")'))
			if fnames != ''
				let sbase = substitute(a:base, '^\$', '', '')
				exe 'silent! vimgrep /^'.sbase.'.*\tv\(\t\|$\)/j '.fnames
				let qflist = getqflist()
				let ext_dict = []
				for field in qflist
					" Add space to make more space between 'word' and 'menu'
					let m_menu = ' '.matchstr(field['text'], '^[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\s\+\zs\f\+\ze')
					let item = '$'.matchstr(field['text'], '^\zs[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\ze')
					
					let ext_dict += [{'word':item, 'menu':m_menu}]
				endfor
			else
				let ext_dict = []
			endif

			let b:php_menu = int_dict + ext_dict

		else
			" Complete everything else - 
			"  + functions,  DONE
			"  + keywords of language DONE
			"  - classes (after new), 
			"  - defines (constant definitions),
			if !exists('b:php_builtin_functions')
				call phpcomplete#LoadData()
			endif

			" Internal solution for current file.
			let file = getline(1, '$')
			call filter(file, 'v:val =~ "function [a-zA-Z_\\x7f-\\xff][a-zA-Z_0-9\\x7f-\\xff]*\\s*("')
			let jfile = join(file, ' ')
			let int_values = split(jfile, 'function\s\+')
			let int_functions = {}
			for i in int_values
				let f_name = matchstr(i, '^&\?\zs[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\ze')
				let f_args = matchstr(i, '^&\?[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\s*(\zs.\{-}\ze)')
				let int_functions[f_name.'('] = f_args
			endfor

			" Prepare list from tags file
			let fnames = join(map(tagfiles(), 'escape(v:val, " \\")'))
				if fnames != ''
				exe 'silent! vimgrep /^'.a:base.'.*\tf\(\t\|$\)/j '.fnames
				let qflist = getqflist()
				let ext_funcs = {}
				for field in qflist
					" File name
					let item = matchstr(field['text'], '^[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*')
					let fname = matchstr(field['text'], '^[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\s\+\zs\f\+\ze')
					let prototype = matchstr(field['text'], 'function\s\+[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\s*(\zs.\{-}\ze)')
					let ext_funcs[item.'('] = prototype.' - '.fname
				endfor
			else
				let ext_funcs = {}
			endif

			" Keywords/reserved words, all other special things {{{
			" Later it is possible to add some help to values
			let keywords = {
				\ 'PHP_SELF':'',
				\ 'argv':'',
			    \ 'argc':'',
				\ 'GATEWAY_INTERFACE':'',
				\ 'SERVER_ADDR':'',
				\ 'SERVER_NAME':'',
				\ 'SERVER_SOFTWARE':'',
				\ 'SERVER_PROTOCOL':'',
 				\ 'REQUEST_METHOD':'',
				\ 'REQUEST_TIME':'',
				\ 'QUERY_STRING':'',
 				\ 'DOCUMENT_ROOT':'',
				\ 'HTTP_ACCEPT':'',
				\ 'HTTP_ACCEPT_CHARSET':'',
 				\ 'HTTP_ACCEPT_ENCODING':'',
				\ 'HTTP_ACCEPT_LANGUAGE':'',
				\ 'HTTP_CONNECTION':'',
 				\ 'HTTP_POST':'',
				\ 'HTTP_REFERER':'',
				\ 'HTTP_USER_AGENT':'',
				\ 'HTTPS':'',
 				\ 'REMOTE_ADDR':'',
				\ 'REMOTE_HOST':'',
				\ 'REMOTE_PORT':'',
				\ 'SCRIPT_FILENAME':'',
 				\ 'SERVER_ADMIN':'',
				\ 'SERVER_PORT':'',
				\ 'SERVER_SIGNATURE':'',
 				\ 'PATH_TRANSLATED':'',
				\ 'SCRIPT_NAME':'',
				\ 'REQUEST_URI':'',
				\ 'PHP_AUTH_DIGEST':'',
 				\ 'PHP_AUTH_USER':'',
				\ 'PHP_AUTH_PW':'',
				\ 'AUTH_TYPE':'',
				\ 'and':'',
				\ 'or':'',
				\ 'xor':'',
				\ '__FILE__':'',
				\ 'exception':'',
				\ '__LINE__':'',
				\ 'as':'',
				\ 'break':'',
				\ 'case':'',
				\ 'class':'',
				\ 'const':'',
				\ 'continue':'',
				\ 'declare':'',
				\ 'default':'',
				\ 'do':'',
				\ 'else':'',
				\ 'elseif':'',
				\ 'enddeclare':'',
				\ 'endfor':'',
				\ 'endforeach':'',
				\ 'endif':'',
				\ 'endswitch':'',
				\ 'endwhile':'',
				\ 'extends':'',
				\ 'for':'',
				\ 'foreach':'',
				\ 'function':'',
				\ 'global':'',
				\ 'if':'',
				\ 'new':'',
				\ 'static':'',
				\ 'switch':'',
				\ 'use':'',
				\ 'var':'',
				\ 'while':'',
				\ '__FUNCTION__':'',
				\ '__CLASS__':'',
				\ '__METHOD__':'',
				\ 'final':'',
				\ 'php_user_filter':'',
				\ 'interface':'',
				\ 'implements':'',
				\ 'public':'',
				\ 'private':'',
				\ 'protected':'',
				\ 'abstract':'',
				\ 'clone':'',
				\ 'try':'',
				\ 'catch':'',
				\ 'throw':'',
				\ 'cfunction':'',
				\ 'old_function':'',
				\ 'this':''
				\ }
			" }}}
			

			" One big dictionary
			call extend(int_functions, b:php_builtin_functions)
			call extend(int_functions, ext_funcs)
			call extend(int_functions, keywords)
			let g:fi = copy(int_functions)

			for m in sort(keys(int_functions))
				if m =~ '^'.a:base
					call add(res, m)
				elseif m =~ a:base
					call add(res2, m)
				endif
			endfor

			let int_list = res + res2

			let other_list = []
			for i in int_list
				let other_list += [{'word':i, 'menu':int_functions[i]}]
			endfor

			let b:php_menu = other_list

		endif

		" Real completion
		return b:php_menu
	endif
endfunction

function! phpcomplete#LoadData() " {{{
let b:php_builtin_functions =
\ {'abs(': 'mixed number | number',
\ 'acos(': 'float arg | float',
\ 'acosh(': 'float arg | float',
\ 'addcslashes(': 'string str, string charlist | string',
\ 'addslashes(': 'string str | string',
\ 'aggregate(': 'object object, string class_name | void',
\ 'aggregate_info(': 'object object | array',
\ 'aggregate_methods(': 'object object, string class_name | void',
\ 'aggregate_methods_by_list(': 'object object, string class_name, array methods_list [, bool exclude] | void',
\ 'aggregate_methods_by_regexp(': 'object object, string class_name, string regexp [, bool exclude] | void',
\ 'aggregate_properties(': 'object object, string class_name | void',
\ 'aggregate_properties_by_list(': 'object object, string class_name, array properties_list [, bool exclude] | void',
\ 'aggregate_properties_by_regexp(': 'object object, string class_name, string regexp [, bool exclude] | void',
\ 'apache_child_terminate(': 'void  | bool',
\ 'apache_getenv(': 'string variable [, bool walk_to_top] | string',
\ 'apache_get_modules(': 'void  | array',
\ 'apache_get_version(': 'void  | string',
\ 'apache_lookup_uri(': 'string filename | object',
\ 'apache_note(': 'string note_name [, string note_value] | string',
\ 'apache_request_headers(': 'void  | array',
\ 'apache_reset_timeout(': 'void  | bool',
\ 'apache_response_headers(': 'void  | array',
\ 'apache_setenv(': 'string variable, string value [, bool walk_to_top] | int',
\ 'apd_breakpoint(': 'int debug_level | void',
\ 'apd_callstack(': 'void  | array',
\ 'apd_clunk(': 'string warning [, string delimiter] | void',
\ 'apd_continue(': 'int debug_level | void',
\ 'apd_croak(': 'string warning [, string delimiter] | void',
\ 'apd_dump_function_table(': 'void  | void',
\ 'apd_dump_persistent_resources(': 'void  | array',
\ 'apd_dump_regular_resources(': 'void  | array',
\ 'apd_echo(': 'string output | void',
\ 'apd_get_active_symbols(': ' | array',
\ 'apd_set_pprof_trace(': '[string dump_directory] | void',
\ 'apd_set_session(': 'int debug_level | void',
\ 'apd_set_session_trace(': 'int debug_level [, string dump_directory] | void',
\ 'apd_set_socket_session_trace(': 'string ip_address_or_unix_socket_file, int socket_type, int port, int debug_level | bool',
\ 'array(': '[mixed ...] | array',
\ 'array_change_key_case(': 'array input [, int case] | array',
\ 'array_chunk(': 'array input, int size [, bool preserve_keys] | array',
\ 'array_combine(': 'array keys, array values | array',
\ 'array_count_values(': 'array input | array',
\ 'array_diff(': 'array array1, array array2 [, array ...] | array',
\ 'array_diff_assoc(': 'array array1, array array2 [, array ...] | array',
\ 'array_diff_key(': 'array array1, array array2 [, array ...] | array',
\ 'array_diff_uassoc(': 'array array1, array array2 [, array ..., callback key_compare_func] | array',
\ 'array_diff_ukey(': 'array array1, array array2 [, array ..., callback key_compare_func] | array',
\ 'array_fill(': 'int start_index, int num, mixed value | array',
\ 'array_filter(': 'array input [, callback callback] | array',
\ 'array_flip(': 'array trans | array',
\ 'array_intersect(': 'array array1, array array2 [, array ...] | array',
\ 'array_intersect_assoc(': 'array array1, array array2 [, array ...] | array',
\ 'array_intersect_key(': 'array array1, array array2 [, array ...] | array',
\ 'array_intersect_uassoc(': 'array array1, array array2 [, array ..., callback key_compare_func] | array',
\ 'array_intersect_ukey(': 'array array1, array array2 [, array ..., callback key_compare_func] | array',
\ 'array_key_exists(': 'mixed key, array search | bool',
\ 'array_keys(': 'array input [, mixed search_value [, bool strict]] | array',
\ 'array_map(': 'callback callback, array arr1 [, array ...] | array',
\ 'array_merge(': 'array array1 [, array array2 [, array ...]] | array',
\ 'array_merge_recursive(': 'array array1, array array2 [, array ...] | array',
\ 'array_multisort(': 'array ar1 [, mixed arg [, mixed ... [, array ...]]] | bool',
\ 'array_pad(': 'array input, int pad_size, mixed pad_value | array',
\ 'array_pop(': 'array &array | mixed',
\ 'array_push(': 'array &array, mixed var [, mixed ...] | int',
\ 'array_rand(': 'array input [, int num_req] | mixed',
\ 'array_reduce(': 'array input, callback function [, int initial] | mixed',
\ 'array_reverse(': 'array array [, bool preserve_keys] | array',
\ 'array_search(': 'mixed needle, array haystack [, bool strict] | mixed',
\ 'array_shift(': 'array &array | mixed',
\ 'array_slice(': 'array array, int offset [, int length [, bool preserve_keys]] | array',
\ 'array_splice(': 'array &input, int offset [, int length [, array replacement]] | array',
\ 'array_sum(': 'array array | number',
\ 'array_udiff(': 'array array1, array array2 [, array ..., callback data_compare_func] | array',
\ 'array_udiff_assoc(': 'array array1, array array2 [, array ..., callback data_compare_func] | array',
\ 'array_udiff_uassoc(': 'array array1, array array2 [, array ..., callback data_compare_func, callback key_compare_func] | array',
\ 'array_uintersect(': 'array array1, array array2 [, array ..., callback data_compare_func] | array',
\ 'array_uintersect_assoc(': 'array array1, array array2 [, array ..., callback data_compare_func] | array',
\ 'array_uintersect_uassoc(': 'array array1, array array2 [, array ..., callback data_compare_func, callback key_compare_func] | array',
\ 'array_unique(': 'array array | array',
\ 'array_unshift(': 'array &array, mixed var [, mixed ...] | int',
\ 'array_values(': 'array input | array',
\ 'array_walk(': 'array &array, callback funcname [, mixed userdata] | bool',
\ 'array_walk_recursive(': 'array &input, callback funcname [, mixed userdata] | bool',
\ 'arsort(': 'array &array [, int sort_flags] | bool',
\ 'ascii2ebcdic(': 'string ascii_str | int',
\ 'asin(': 'float arg | float',
\ 'asinh(': 'float arg | float',
\ 'asort(': 'array &array [, int sort_flags] | bool',
\ 'aspell_check(': 'int dictionary_link, string word | bool',
\ 'aspell_check_raw(': 'int dictionary_link, string word | bool',
\ 'aspell_new(': 'string master [, string personal] | int',
\ 'aspell_suggest(': 'int dictionary_link, string word | array',
\ 'assert(': 'mixed assertion | int',
\ 'assert_options(': 'int what [, mixed value] | mixed',
\ 'atan(': 'float arg | float',
\ 'atan2(': 'float y, float x | float',
\ 'atanh(': 'float arg | float',
\ 'base64_decode(': 'string encoded_data | string',
\ 'base64_encode(': 'string data | string',
\ 'base_convert(': 'string number, int frombase, int tobase | string',
\ 'basename(': 'string path [, string suffix] | string',
\ 'bcadd(': 'string left_operand, string right_operand [, int scale] | string',
\ 'bccomp(': 'string left_operand, string right_operand [, int scale] | int',
\ 'bcdiv(': 'string left_operand, string right_operand [, int scale] | string',
\ 'bcmod(': 'string left_operand, string modulus | string',
\ 'bcmul(': 'string left_operand, string right_operand [, int scale] | string',
\ 'bcompiler_load(': 'string filename | bool',
\ 'bcompiler_load_exe(': 'string filename | bool',
\ 'bcompiler_parse_class(': 'string class, string callback | bool',
\ 'bcompiler_read(': 'resource filehandle | bool',
\ 'bcompiler_write_class(': 'resource filehandle, string className [, string extends] | bool',
\ 'bcompiler_write_constant(': 'resource filehandle, string constantName | bool',
\ 'bcompiler_write_exe_footer(': 'resource filehandle, int startpos | bool',
\ 'bcompiler_write_file(': 'resource filehandle, string filename | bool',
\ 'bcompiler_write_footer(': 'resource filehandle | bool',
\ 'bcompiler_write_function(': 'resource filehandle, string functionName | bool',
\ 'bcompiler_write_functions_from_file(': 'resource filehandle, string fileName | bool',
\ 'bcompiler_write_header(': 'resource filehandle [, string write_ver] | bool',
\ 'bcpow(': 'string x, string y [, int scale] | string',
\ 'bcpowmod(': 'string x, string y, string modulus [, int scale] | string',
\ 'bcscale(': 'int scale | bool',
\ 'bcsqrt(': 'string operand [, int scale] | string',
\ 'bcsub(': 'string left_operand, string right_operand [, int scale] | string',
\ 'bin2hex(': 'string str | string',
\ 'bindec(': 'string binary_string | number',
\ 'bindtextdomain(': 'string domain, string directory | string',
\ 'bind_textdomain_codeset(': 'string domain, string codeset | string',
\ 'bzclose(': 'resource bz | int',
\ 'bzcompress(': 'string source [, int blocksize [, int workfactor]] | string',
\ 'bzdecompress(': 'string source [, int small] | string',
\ 'bzerrno(': 'resource bz | int',
\ 'bzerror(': 'resource bz | array',
\ 'bzerrstr(': 'resource bz | string',
\ 'bzflush(': 'resource bz | int',
\ 'bzopen(': 'string filename, string mode | resource',
\ 'bzread(': 'resource bz [, int length] | string',
\ 'bzwrite(': 'resource bz, string data [, int length] | int',
\ 'cal_days_in_month(': 'int calendar, int month, int year | int',
\ 'cal_from_jd(': 'int jd, int calendar | array',
\ 'cal_info(': '[int calendar] | array',
\ 'call_user_func(': 'callback function [, mixed parameter [, mixed ...]] | mixed',
\ 'call_user_func_array(': 'callback function, array param_arr | mixed',
\ 'call_user_method(': 'string method_name, object &obj [, mixed parameter [, mixed ...]] | mixed',
\ 'call_user_method_array(': 'string method_name, object &obj, array paramarr | mixed',
\ 'cal_to_jd(': 'int calendar, int month, int day, int year | int',
\ 'ccvs_add(': 'string session, string invoice, string argtype, string argval | string',
\ 'ccvs_auth(': 'string session, string invoice | string',
\ 'ccvs_command(': 'string session, string type, string argval | string',
\ 'ccvs_count(': 'string session, string type | int',
\ 'ccvs_delete(': 'string session, string invoice | string',
\ 'ccvs_done(': 'string sess | string',
\ 'ccvs_init(': 'string name | string',
\ 'ccvs_lookup(': 'string session, string invoice, int inum | string',
\ 'ccvs_new(': 'string session, string invoice | string',
\ 'ccvs_report(': 'string session, string type | string',
\ 'ccvs_return(': 'string session, string invoice | string',
\ 'ccvs_reverse(': 'string session, string invoice | string',
\ 'ccvs_sale(': 'string session, string invoice | string',
\ 'ccvs_status(': 'string session, string invoice | string',
\ 'ccvs_textvalue(': 'string session | string',
\ 'ccvs_void(': 'string session, string invoice | string',
\ 'ceil(': 'float value | float',
\ 'chdir(': 'string directory | bool',
\ 'checkdate(': 'int month, int day, int year | bool',
\ 'checkdnsrr(': 'string host [, string type] | int',
\ 'chgrp(': 'string filename, mixed group | bool',
\ 'chmod(': 'string filename, int mode | bool',
\ 'chown(': 'string filename, mixed user | bool',
\ 'chr(': 'int ascii | string',
\ 'chroot(': 'string directory | bool',
\ 'chunk_split(': 'string body [, int chunklen [, string end]] | string',
\ 'class_exists(': 'string class_name [, bool autoload] | bool',
\ 'class_implements(': 'object class | array',
\ 'classkit_import(': 'string filename | array',
\ 'classkit_method_add(': 'string classname, string methodname, string args, string code [, int flags] | bool',
\ 'classkit_method_copy(': 'string dClass, string dMethod, string sClass [, string sMethod] | bool',
\ 'classkit_method_redefine(': 'string classname, string methodname, string args, string code [, int flags] | bool',
\ 'classkit_method_remove(': 'string classname, string methodname | bool',
\ 'classkit_method_rename(': 'string classname, string methodname, string newname | bool',
\ 'class_parents(': 'object class | array',
\ 'clearstatcache(': 'void  | void',
\ 'closedir(': 'resource dir_handle | void',
\ 'closelog(': 'void  | int',
\ 'com_addref(': 'void  | void',
\ 'com_create_guid(': 'void  | string',
\ 'com_event_sink(': 'variant comobject, object sinkobject [, mixed sinkinterface] | bool',
\ 'com_get(': 'resource com_object, string property | mixed',
\ 'com_get_active_object(': 'string progid [, int code_page] | variant',
\ 'com_invoke(': 'resource com_object, string function_name [, mixed function_parameters] | mixed',
\ 'com_isenum(': 'variant com_module | bool',
\ 'com_load(': 'string module_name [, string server_name [, int codepage]] | resource',
\ 'com_load_typelib(': 'string typelib_name [, bool case_insensitive] | bool',
\ 'com_message_pump(': '[int timeoutms] | bool',
\ 'compact(': 'mixed varname [, mixed ...] | array',
\ 'com_print_typeinfo(': 'object comobject [, string dispinterface [, bool wantsink]] | bool',
\ 'com_release(': 'void  | void',
\ 'com_set(': 'resource com_object, string property, mixed value | void',
\ 'connection_aborted(': 'void  | int',
\ 'connection_status(': 'void  | int',
\ 'connection_timeout(': 'void  | bool',
\ 'constant(': 'string name | mixed',
\ 'convert_cyr_string(': 'string str, string from, string to | string',
\ 'convert_uudecode(': 'string data | string',
\ 'convert_uuencode(': 'string data | string',
\ 'copy(': 'string source, string dest | bool',
\ 'cos(': 'float arg | float',
\ 'cosh(': 'float arg | float',
\ 'count(': 'mixed var [, int mode] | int',
\ 'count_chars(': 'string string [, int mode] | mixed',
\ 'cpdf_add_annotation(': 'int pdf_document, float llx, float lly, float urx, float ury, string title, string content [, int mode] | bool',
\ 'cpdf_add_outline(': 'int pdf_document, int lastoutline, int sublevel, int open, int pagenr, string text | int',
\ 'cpdf_arc(': 'int pdf_document, float x_coor, float y_coor, float radius, float start, float end [, int mode] | bool',
\ 'cpdf_begin_text(': 'int pdf_document | bool',
\ 'cpdf_circle(': 'int pdf_document, float x_coor, float y_coor, float radius [, int mode] | bool',
\ 'cpdf_clip(': 'int pdf_document | bool',
\ 'cpdf_close(': 'int pdf_document | bool',
\ 'cpdf_closepath(': 'int pdf_document | bool',
\ 'cpdf_closepath_fill_stroke(': 'int pdf_document | bool',
\ 'cpdf_closepath_stroke(': 'int pdf_document | bool',
\ 'cpdf_continue_text(': 'int pdf_document, string text | bool',
\ 'cpdf_curveto(': 'int pdf_document, float x1, float y1, float x2, float y2, float x3, float y3 [, int mode] | bool',
\ 'cpdf_end_text(': 'int pdf_document | bool',
\ 'cpdf_fill(': 'int pdf_document | bool',
\ 'cpdf_fill_stroke(': 'int pdf_document | bool',
\ 'cpdf_finalize(': 'int pdf_document | bool',
\ 'cpdf_finalize_page(': 'int pdf_document, int page_number | bool',
\ 'cpdf_global_set_document_limits(': 'int maxpages, int maxfonts, int maximages, int maxannotations, int maxobjects | bool',
\ 'cpdf_import_jpeg(': 'int pdf_document, string file_name, float x_coor, float y_coor, float angle, float width, float height, float x_scale, float y_scale, int gsave [, int mode] | int',
\ 'cpdf_lineto(': 'int pdf_document, float x_coor, float y_coor [, int mode] | bool',
\ 'cpdf_moveto(': 'int pdf_document, float x_coor, float y_coor [, int mode] | bool',
\ 'cpdf_newpath(': 'int pdf_document | bool',
\ 'cpdf_open(': 'int compression [, string filename [, array doc_limits]] | int',
\ 'cpdf_output_buffer(': 'int pdf_document | bool',
\ 'cpdf_page_init(': 'int pdf_document, int page_number, int orientation, float height, float width [, float unit] | bool',
\ 'cpdf_place_inline_image(': 'int pdf_document, int image, float x_coor, float y_coor, float angle, float width, float height, int gsave [, int mode] | bool',
\ 'cpdf_rect(': 'int pdf_document, float x_coor, float y_coor, float width, float height [, int mode] | bool',
\ 'cpdf_restore(': 'int pdf_document | bool',
\ 'cpdf_rlineto(': 'int pdf_document, float x_coor, float y_coor [, int mode] | bool',
\ 'cpdf_rmoveto(': 'int pdf_document, float x_coor, float y_coor [, int mode] | bool',
\ 'cpdf_rotate(': 'int pdf_document, float angle | bool',
\ 'cpdf_rotate_text(': 'int pdfdoc, float angle | bool',
\ 'cpdf_save(': 'int pdf_document | bool',
\ 'cpdf_save_to_file(': 'int pdf_document, string filename | bool',
\ 'cpdf_scale(': 'int pdf_document, float x_scale, float y_scale | bool',
\ 'cpdf_set_action_url(': 'int pdfdoc, float xll, float yll, float xur, float xur, string url [, int mode] | bool',
\ 'cpdf_set_char_spacing(': 'int pdf_document, float space | bool',
\ 'cpdf_set_creator(': 'int pdf_document, string creator | bool',
\ 'cpdf_set_current_page(': 'int pdf_document, int page_number | bool',
\ 'cpdf_setdash(': 'int pdf_document, float white, float black | bool',
\ 'cpdf_setflat(': 'int pdf_document, float value | bool',
\ 'cpdf_set_font(': 'int pdf_document, string font_name, float size, string encoding | bool',
\ 'cpdf_set_font_directories(': 'int pdfdoc, string pfmdir, string pfbdir | bool',
\ 'cpdf_set_font_map_file(': 'int pdfdoc, string filename | bool',
\ 'cpdf_setgray(': 'int pdf_document, float gray_value | bool',
\ 'cpdf_setgray_fill(': 'int pdf_document, float value | bool',
\ 'cpdf_setgray_stroke(': 'int pdf_document, float gray_value | bool',
\ 'cpdf_set_horiz_scaling(': 'int pdf_document, float scale | bool',
\ 'cpdf_set_keywords(': 'int pdf_document, string keywords | bool',
\ 'cpdf_set_leading(': 'int pdf_document, float distance | bool',
\ 'cpdf_setlinecap(': 'int pdf_document, int value | bool',
\ 'cpdf_setlinejoin(': 'int pdf_document, int value | bool',
\ 'cpdf_setlinewidth(': 'int pdf_document, float width | bool',
\ 'cpdf_setmiterlimit(': 'int pdf_document, float value | bool',
\ 'cpdf_set_page_animation(': 'int pdf_document, int transition, float duration, float direction, int orientation, int inout | bool',
\ 'cpdf_setrgbcolor(': 'int pdf_document, float red_value, float green_value, float blue_value | bool',
\ 'cpdf_setrgbcolor_fill(': 'int pdf_document, float red_value, float green_value, float blue_value | bool',
\ 'cpdf_setrgbcolor_stroke(': 'int pdf_document, float red_value, float green_value, float blue_value | bool',
\ 'cpdf_set_subject(': 'int pdf_document, string subject | bool',
\ 'cpdf_set_text_matrix(': 'int pdf_document, array matrix | bool',
\ 'cpdf_set_text_pos(': 'int pdf_document, float x_coor, float y_coor [, int mode] | bool',
\ 'cpdf_set_text_rendering(': 'int pdf_document, int rendermode | bool',
\ 'cpdf_set_text_rise(': 'int pdf_document, float value | bool',
\ 'cpdf_set_title(': 'int pdf_document, string title | bool',
\ 'cpdf_set_viewer_preferences(': 'int pdfdoc, array preferences | bool',
\ 'cpdf_set_word_spacing(': 'int pdf_document, float space | bool',
\ 'cpdf_show(': 'int pdf_document, string text | bool',
\ 'cpdf_show_xy(': 'int pdf_document, string text, float x_coor, float y_coor [, int mode] | bool',
\ 'cpdf_stringwidth(': 'int pdf_document, string text | float',
\ 'cpdf_stroke(': 'int pdf_document | bool',
\ 'cpdf_text(': 'int pdf_document, string text [, float x_coor, float y_coor [, int mode [, float orientation [, int alignmode]]]] | bool',
\ 'cpdf_translate(': 'int pdf_document, float x_coor, float y_coor | bool',
\ 'crack_check(': 'resource dictionary, string password | bool',
\ 'crack_closedict(': '[resource dictionary] | bool',
\ 'crack_getlastmessage(': 'void  | string',
\ 'crack_opendict(': 'string dictionary | resource',
\ 'crc32(': 'string str | int',
\ 'create_function(': 'string args, string code | string',
\ 'crypt(': 'string str [, string salt] | string',
\ 'ctype_alnum(': 'string text | bool',
\ 'ctype_alpha(': 'string text | bool',
\ 'ctype_cntrl(': 'string text | bool',
\ 'ctype_digit(': 'string text | bool',
\ 'ctype_graph(': 'string text | bool',
\ 'ctype_lower(': 'string text | bool',
\ 'ctype_print(': 'string text | bool',
\ 'ctype_punct(': 'string text | bool',
\ 'ctype_space(': 'string text | bool',
\ 'ctype_upper(': 'string text | bool',
\ 'ctype_xdigit(': 'string text | bool',
\ 'curl_close(': 'resource ch | void',
\ 'curl_copy_handle(': 'resource ch | resource',
\ 'curl_errno(': 'resource ch | int',
\ 'curl_error(': 'resource ch | string',
\ 'curl_exec(': 'resource ch | mixed',
\ 'curl_getinfo(': 'resource ch [, int opt] | string',
\ 'curl_init(': '[string url] | resource',
\ 'curl_multi_add_handle(': 'resource mh, resource ch | int',
\ 'curl_multi_close(': 'resource mh | void',
\ 'curl_multi_exec(': 'resource mh, int &still_running | int',
\ 'curl_multi_getcontent(': 'resource ch | string',
\ 'curl_multi_info_read(': 'resource mh | array',
\ 'curl_multi_init(': 'void  | resource',
\ 'curl_multi_remove_handle(': 'resource mh, resource ch | int',
\ 'curl_multi_select(': 'resource mh [, float timeout] | int',
\ 'curl_setopt(': 'resource ch, int option, mixed value | bool',
\ 'curl_version(': '[int version] | string',
\ 'current(': 'array &array | mixed',
\ 'cybercash_base64_decode(': 'string inbuff | string',
\ 'cybercash_base64_encode(': 'string inbuff | string',
\ 'cybercash_decr(': 'string wmk, string sk, string inbuff | array',
\ 'cybercash_encr(': 'string wmk, string sk, string inbuff | array',
\ 'cyrus_authenticate(': 'resource connection [, string mechlist [, string service [, string user [, int minssf [, int maxssf [, string authname [, string password]]]]]]] | bool',
\ 'cyrus_bind(': 'resource connection, array callbacks | bool',
\ 'cyrus_close(': 'resource connection | bool',
\ 'cyrus_connect(': '[string host [, string port [, int flags]]] | resource',
\ 'cyrus_query(': 'resource connection, string query | bool',
\ 'cyrus_unbind(': 'resource connection, string trigger_name | bool',
\ 'date(': 'string format [, int timestamp] | string',
\ 'date_sunrise(': 'int timestamp [, int format [, float latitude [, float longitude [, float zenith [, float gmt_offset]]]]] | mixed',
\ 'date_sunset(': 'int timestamp [, int format [, float latitude [, float longitude [, float zenith [, float gmt_offset]]]]] | mixed',
\ 'dba_close(': 'resource handle | void',
\ 'dba_delete(': 'string key, resource handle | bool',
\ 'dba_exists(': 'string key, resource handle | bool',
\ 'dba_fetch(': 'string key, resource handle | string',
\ 'dba_firstkey(': 'resource handle | string',
\ 'dba_handlers(': '[bool full_info] | array',
\ 'dba_insert(': 'string key, string value, resource handle | bool',
\ 'dba_key_split(': 'mixed key | mixed',
\ 'dba_list(': 'void  | array',
\ 'dba_nextkey(': 'resource handle | string',
\ 'dba_open(': 'string path, string mode, string handler [, ...] | resource',
\ 'dba_optimize(': 'resource handle | bool',
\ 'dba_popen(': 'string path, string mode, string handler [, ...] | resource',
\ 'dba_replace(': 'string key, string value, resource handle | bool',
\ 'dbase_add_record(': 'int dbase_identifier, array record | bool',
\ 'dbase_close(': 'int dbase_identifier | bool',
\ 'dbase_create(': 'string filename, array fields | int',
\ 'dbase_delete_record(': 'int dbase_identifier, int record_number | bool',
\ 'dbase_get_header_info(': 'int dbase_identifier | array',
\ 'dbase_get_record(': 'int dbase_identifier, int record_number | array',
\ 'dbase_get_record_with_names(': 'int dbase_identifier, int record_number | array',
\ 'dbase_numfields(': 'int dbase_identifier | int',
\ 'dbase_numrecords(': 'int dbase_identifier | int',
\ 'dbase_open(': 'string filename, int mode | int',
\ 'dbase_pack(': 'int dbase_identifier | bool',
\ 'dbase_replace_record(': 'int dbase_identifier, array record, int record_number | bool',
\ 'dba_sync(': 'resource handle | bool',
\ 'dblist(': 'void  | string',
\ 'dbmclose(': 'resource dbm_identifier | bool',
\ 'dbmdelete(': 'resource dbm_identifier, string key | bool',
\ 'dbmexists(': 'resource dbm_identifier, string key | bool',
\ 'dbmfetch(': 'resource dbm_identifier, string key | string',
\ 'dbmfirstkey(': 'resource dbm_identifier | string',
\ 'dbminsert(': 'resource dbm_identifier, string key, string value | int',
\ 'dbmnextkey(': 'resource dbm_identifier, string key | string',
\ 'dbmopen(': 'string filename, string flags | resource',
\ 'dbmreplace(': 'resource dbm_identifier, string key, string value | int',
\ 'dbplus_add(': 'resource relation, array tuple | int',
\ 'dbplus_aql(': 'string query [, string server [, string dbpath]] | resource',
\ 'dbplus_chdir(': '[string newdir] | string',
\ 'dbplus_close(': 'resource relation | int',
\ 'dbplus_curr(': 'resource relation, array &tuple | int',
\ 'dbplus_errcode(': '[int errno] | string',
\ 'dbplus_errno(': 'void  | int',
\ 'dbplus_find(': 'resource relation, array constraints, mixed tuple | int',
\ 'dbplus_first(': 'resource relation, array &tuple | int',
\ 'dbplus_flush(': 'resource relation | int',
\ 'dbplus_freealllocks(': 'void  | int',
\ 'dbplus_freelock(': 'resource relation, string tname | int',
\ 'dbplus_freerlocks(': 'resource relation | int',
\ 'dbplus_getlock(': 'resource relation, string tname | int',
\ 'dbplus_getunique(': 'resource relation, int uniqueid | int',
\ 'dbplus_info(': 'resource relation, string key, array &result | int',
\ 'dbplus_last(': 'resource relation, array &tuple | int',
\ 'dbplus_lockrel(': 'resource relation | int',
\ 'dbplus_next(': 'resource relation, array &tuple | int',
\ 'dbplus_open(': 'string name | resource',
\ 'dbplus_prev(': 'resource relation, array &tuple | int',
\ 'dbplus_rchperm(': 'resource relation, int mask, string user, string group | int',
\ 'dbplus_rcreate(': 'string name, mixed domlist [, bool overwrite] | resource',
\ 'dbplus_rcrtexact(': 'string name, resource relation [, bool overwrite] | resource',
\ 'dbplus_rcrtlike(': 'string name, resource relation [, int overwrite] | resource',
\ 'dbplus_resolve(': 'string relation_name | int',
\ 'dbplus_restorepos(': 'resource relation, array tuple | int',
\ 'dbplus_rkeys(': 'resource relation, mixed domlist | resource',
\ 'dbplus_ropen(': 'string name | resource',
\ 'dbplus_rquery(': 'string query [, string dbpath] | int',
\ 'dbplus_rrename(': 'resource relation, string name | int',
\ 'dbplus_rsecindex(': 'resource relation, mixed domlist, int type | resource',
\ 'dbplus_runlink(': 'resource relation | int',
\ 'dbplus_rzap(': 'resource relation | int',
\ 'dbplus_savepos(': 'resource relation | int',
\ 'dbplus_setindex(': 'resource relation, string idx_name | int',
\ 'dbplus_setindexbynumber(': 'resource relation, int idx_number | int',
\ 'dbplus_sql(': 'string query [, string server [, string dbpath]] | resource',
\ 'dbplus_tcl(': 'int sid, string script | int',
\ 'dbplus_tremove(': 'resource relation, array tuple [, array &current] | int',
\ 'dbplus_undo(': 'resource relation | int',
\ 'dbplus_undoprepare(': 'resource relation | int',
\ 'dbplus_unlockrel(': 'resource relation | int',
\ 'dbplus_unselect(': 'resource relation | int',
\ 'dbplus_update(': 'resource relation, array old, array new | int',
\ 'dbplus_xlockrel(': 'resource relation | int',
\ 'dbplus_xunlockrel(': 'resource relation | int',
\ 'dbx_close(': 'object link_identifier | bool',
\ 'dbx_compare(': 'array row_a, array row_b, string column_key [, int flags] | int',
\ 'dbx_connect(': 'mixed module, string host, string database, string username, string password [, int persistent] | object',
\ 'dbx_error(': 'object link_identifier | string',
\ 'dbx_escape_string(': 'object link_identifier, string text | string',
\ 'dbx_fetch_row(': 'object result_identifier | object',
\ 'dbx_query(': 'object link_identifier, string sql_statement [, int flags] | object',
\ 'dbx_sort(': 'object result, string user_compare_function | bool',
\ 'dcgettext(': 'string domain, string message, int category | string',
\ 'dcngettext(': 'string domain, string msgid1, string msgid2, int n, int category | string',
\ 'deaggregate(': 'object object [, string class_name] | void',
\ 'debug_backtrace(': 'void  | array',
\ 'debugger_off(': 'void  | int',
\ 'debugger_on(': 'string address | int',
\ 'debug_print_backtrace(': 'void  | void',
\ 'debug_zval_dump(': 'mixed variable | void',
\ 'decbin(': 'int number | string',
\ 'dechex(': 'int number | string',
\ 'decoct(': 'int number | string',
\ 'define(': 'string name, mixed value [, bool case_insensitive] | bool',
\ 'defined(': 'string name | bool',
\ 'define_syslog_variables(': 'void  | void',
\ 'deg2rad(': 'float number | float',
\ 'delete(': 'string file | void',
\ 'dgettext(': 'string domain, string message | string',
\ 'dio_close(': 'resource fd | void',
\ 'dio_fcntl(': 'resource fd, int cmd [, mixed args] | mixed',
\ 'dio_open(': 'string filename, int flags [, int mode] | resource',
\ 'dio_read(': 'resource fd [, int n] | string',
\ 'dio_seek(': 'resource fd, int pos [, int whence] | int',
\ 'dio_stat(': 'resource fd | array',
\ 'dio_tcsetattr(': 'resource fd, array options | void',
\ 'dio_truncate(': 'resource fd, int offset | bool',
\ 'dio_write(': 'resource fd, string data [, int len] | int',
\ 'dirname(': 'string path | string',
\ 'disk_free_space(': 'string directory | float',
\ 'disk_total_space(': 'string directory | float',
\ 'dl(': 'string library | int',
\ 'dngettext(': 'string domain, string msgid1, string msgid2, int n | string',
\ 'dns_check_record(': 'string host [, string type] | int',
\ 'dns_get_mx(': 'string hostname, array &mxhosts [, array &weight] | int',
\ 'dns_get_record(': 'string hostname [, int type [, array &authns, array &addtl]] | array',
\ 'dom_import_simplexml(': 'SimpleXMLElement node | DOMElement',
\ 'domxml_new_doc(': 'string version | domdocument',
\ 'domxml_open_file(': 'string filename [, int mode [, array &error]] | domdocument',
\ 'domxml_open_mem(': 'string str [, int mode [, array &error]] | domdocument',
\ 'domxml_version(': 'void  | string',
\ 'domxml_xmltree(': 'string str | domdocument',
\ 'domxml_xslt_stylesheet(': 'string xsl_document | XsltStylesheet',
\ 'domxml_xslt_stylesheet_doc(': 'domdocument DocDocumentObject | XsltStylesheet',
\ 'domxml_xslt_stylesheet_file(': 'string xsl_file | XsltStylesheet',
\ 'dotnet_load(': 'string assembly_name [, string datatype_name [, int codepage]] | int',
\ 'each(': 'array &array | array',
\ 'easter_date(': '[int year] | int',
\ 'easter_days(': '[int year [, int method]] | int',
\ 'ebcdic2ascii(': 'string ebcdic_str | int',
\ 'echo(': 'string arg1 [, string ...] | void',
\ 'empty(': 'mixed var | bool',
\ 'end(': 'array &array | mixed',
\ 'ereg(': 'string pattern, string string [, array &regs] | int',
\ 'eregi(': 'string pattern, string string [, array &regs] | int',
\ 'eregi_replace(': 'string pattern, string replacement, string string | string',
\ 'ereg_replace(': 'string pattern, string replacement, string string | string',
\ 'error_log(': 'string message [, int message_type [, string destination [, string extra_headers]]] | int',
\ 'error_reporting(': '[int level] | int',
\ 'escapeshellarg(': 'string arg | string',
\ 'escapeshellcmd(': 'string command | string',
\ 'eval(': 'string code_str | mixed',
\ 'exec(': 'string command [, array &output [, int &return_var]] | string',
\ 'exif_imagetype(': 'string filename | int',
\ 'exif_read_data(': 'string filename [, string sections [, bool arrays [, bool thumbnail]]] | array',
\ 'exif_tagname(': 'string index | string',
\ 'exif_thumbnail(': 'string filename [, int &width [, int &height [, int &imagetype]]] | string',
\ 'exit(': '[string status] | void',
\ 'exp(': 'float arg | float',
\ 'explode(': 'string separator, string string [, int limit] | array',
\ 'expm1(': 'float number | float',
\ 'extension_loaded(': 'string name | bool',
\ 'extract(': 'array var_array [, int extract_type [, string prefix]] | int',
\ 'ezmlm_hash(': 'string addr | int',
\ 'fam_cancel_monitor(': 'resource fam, resource fam_monitor | bool',
\ 'fam_close(': 'resource fam | void',
\ 'fam_monitor_collection(': 'resource fam, string dirname, int depth, string mask | resource',
\ 'fam_monitor_directory(': 'resource fam, string dirname | resource',
\ 'fam_monitor_file(': 'resource fam, string filename | resource',
\ 'fam_next_event(': 'resource fam | array',
\ 'fam_open(': '[string appname] | resource',
\ 'fam_pending(': 'resource fam | bool',
\ 'fam_resume_monitor(': 'resource fam, resource fam_monitor | bool',
\ 'fam_suspend_monitor(': 'resource fam, resource fam_monitor | bool',
\ 'fbsql_affected_rows(': '[resource link_identifier] | int',
\ 'fbsql_autocommit(': 'resource link_identifier [, bool OnOff] | bool',
\ 'fbsql_blob_size(': 'string blob_handle [, resource link_identifier] | int',
\ 'fbsql_change_user(': 'string user, string password [, string database [, resource link_identifier]] | resource',
\ 'fbsql_clob_size(': 'string clob_handle [, resource link_identifier] | int',
\ 'fbsql_close(': '[resource link_identifier] | bool',
\ 'fbsql_commit(': '[resource link_identifier] | bool',
\ 'fbsql_connect(': '[string hostname [, string username [, string password]]] | resource',
\ 'fbsql_create_blob(': 'string blob_data [, resource link_identifier] | string',
\ 'fbsql_create_clob(': 'string clob_data [, resource link_identifier] | string',
\ 'fbsql_create_db(': 'string database_name [, resource link_identifier [, string database_options]] | bool',
\ 'fbsql_database(': 'resource link_identifier [, string database] | string',
\ 'fbsql_database_password(': 'resource link_identifier [, string database_password] | string',
\ 'fbsql_data_seek(': 'resource result_identifier, int row_number | bool',
\ 'fbsql_db_query(': 'string database, string query [, resource link_identifier] | resource',
\ 'fbsql_db_status(': 'string database_name [, resource link_identifier] | int',
\ 'fbsql_drop_db(': 'string database_name [, resource link_identifier] | bool',
\ 'fbsql_errno(': '[resource link_identifier] | int',
\ 'fbsql_error(': '[resource link_identifier] | string',
\ 'fbsql_fetch_array(': 'resource result [, int result_type] | array',
\ 'fbsql_fetch_assoc(': 'resource result | array',
\ 'fbsql_fetch_field(': 'resource result [, int field_offset] | object',
\ 'fbsql_fetch_lengths(': 'resource result | array',
\ 'fbsql_fetch_object(': 'resource result [, int result_type] | object',
\ 'fbsql_fetch_row(': 'resource result | array',
\ 'fbsql_field_flags(': 'resource result [, int field_offset] | string',
\ 'fbsql_field_len(': 'resource result [, int field_offset] | int',
\ 'fbsql_field_name(': 'resource result [, int field_index] | string',
\ 'fbsql_field_seek(': 'resource result [, int field_offset] | bool',
\ 'fbsql_field_table(': 'resource result [, int field_offset] | string',
\ 'fbsql_field_type(': 'resource result [, int field_offset] | string',
\ 'fbsql_free_result(': 'resource result | bool',
\ 'fbsql_get_autostart_info(': '[resource link_identifier] | array',
\ 'fbsql_hostname(': 'resource link_identifier [, string host_name] | string',
\ 'fbsql_insert_id(': '[resource link_identifier] | int',
\ 'fbsql_list_dbs(': '[resource link_identifier] | resource',
\ 'fbsql_list_fields(': 'string database_name, string table_name [, resource link_identifier] | resource',
\ 'fbsql_list_tables(': 'string database [, resource link_identifier] | resource',
\ 'fbsql_next_result(': 'resource result_id | bool',
\ 'fbsql_num_fields(': 'resource result | int',
\ 'fbsql_num_rows(': 'resource result | int',
\ 'fbsql_password(': 'resource link_identifier [, string password] | string',
\ 'fbsql_pconnect(': '[string hostname [, string username [, string password]]] | resource',
\ 'fbsql_query(': 'string query [, resource link_identifier [, int batch_size]] | resource',
\ 'fbsql_read_blob(': 'string blob_handle [, resource link_identifier] | string',
\ 'fbsql_read_clob(': 'string clob_handle [, resource link_identifier] | string',
\ 'fbsql_result(': 'resource result [, int row [, mixed field]] | mixed',
\ 'fbsql_rollback(': '[resource link_identifier] | bool',
\ 'fbsql_select_db(': '[string database_name [, resource link_identifier]] | bool',
\ 'fbsql_set_lob_mode(': 'resource result, string database_name | bool',
\ 'fbsql_set_password(': 'resource link_identifier, string user, string password, string old_password | bool',
\ 'fbsql_set_transaction(': 'resource link_identifier, int Locking, int Isolation | void',
\ 'fbsql_start_db(': 'string database_name [, resource link_identifier [, string database_options]] | bool',
\ 'fbsql_stop_db(': 'string database_name [, resource link_identifier] | bool',
\ 'fbsql_tablename(': 'resource result, int i | string',
\ 'fbsql_username(': 'resource link_identifier [, string username] | string',
\ 'fbsql_warnings(': '[bool OnOff] | bool',
\ 'fclose(': 'resource handle | bool',
\ 'fdf_add_doc_javascript(': 'resource fdfdoc, string script_name, string script_code | bool',
\ 'fdf_add_template(': 'resource fdfdoc, int newpage, string filename, string template, int rename | bool',
\ 'fdf_close(': 'resource fdf_document | bool',
\ 'fdf_create(': 'void  | resource',
\ 'fdf_enum_values(': 'resource fdfdoc, callback function [, mixed userdata] | bool',
\ 'fdf_errno(': 'void  | int',
\ 'fdf_error(': '[int error_code] | string',
\ 'fdf_get_ap(': 'resource fdf_document, string field, int face, string filename | bool',
\ 'fdf_get_attachment(': 'resource fdf_document, string fieldname, string savepath | array',
\ 'fdf_get_encoding(': 'resource fdf_document | string',
\ 'fdf_get_file(': 'resource fdf_document | string',
\ 'fdf_get_flags(': 'resource fdfdoc, string fieldname, int whichflags | int',
\ 'fdf_get_opt(': 'resource fdfdof, string fieldname [, int element] | mixed',
\ 'fdf_get_status(': 'resource fdf_document | string',
\ 'fdf_get_value(': 'resource fdf_document, string fieldname [, int which] | string',
\ 'fdf_get_version(': '[resource fdf_document] | string',
\ 'fdf_header(': 'void  | bool',
\ 'fdf_next_field_name(': 'resource fdf_document [, string fieldname] | string',
\ 'fdf_open(': 'string filename | resource',
\ 'fdf_open_string(': 'string fdf_data | resource',
\ 'fdf_remove_item(': 'resource fdfdoc, string fieldname, int item | bool',
\ 'fdf_save(': 'resource fdf_document [, string filename] | bool',
\ 'fdf_save_string(': 'resource fdf_document | string',
\ 'fdf_set_ap(': 'resource fdf_document, string field_name, int face, string filename, int page_number | bool',
\ 'fdf_set_encoding(': 'resource fdf_document, string encoding | bool',
\ 'fdf_set_file(': 'resource fdf_document, string url [, string target_frame] | bool',
\ 'fdf_set_flags(': 'resource fdf_document, string fieldname, int whichFlags, int newFlags | bool',
\ 'fdf_set_javascript_action(': 'resource fdf_document, string fieldname, int trigger, string script | bool',
\ 'fdf_set_on_import_javascript(': 'resource fdfdoc, string script [, bool before_data_import] | bool',
\ 'fdf_set_opt(': 'resource fdf_document, string fieldname, int element, string str1, string str2 | bool',
\ 'fdf_set_status(': 'resource fdf_document, string status | bool',
\ 'fdf_set_submit_form_action(': 'resource fdf_document, string fieldname, int trigger, string script, int flags | bool',
\ 'fdf_set_target_frame(': 'resource fdf_document, string frame_name | bool',
\ 'fdf_set_value(': 'resource fdf_document, string fieldname, mixed value [, int isName] | bool',
\ 'fdf_set_version(': 'resource fdf_document, string version | string',
\ 'feof(': 'resource handle | bool',
\ 'fflush(': 'resource handle | bool',
\ 'fgetc(': 'resource handle | string',
\ 'fgetcsv(': 'resource handle [, int length [, string delimiter [, string enclosure]]] | array',
\ 'fgets(': 'resource handle [, int length] | string',
\ 'fgetss(': 'resource handle [, int length [, string allowable_tags]] | string',
\ 'file(': 'string filename [, int use_include_path [, resource context]] | array',
\ 'fileatime(': 'string filename | int',
\ 'filectime(': 'string filename | int',
\ 'file_exists(': 'string filename | bool',
\ 'file_get_contents(': 'string filename [, bool use_include_path [, resource context [, int offset [, int maxlen]]]] | string',
\ 'filegroup(': 'string filename | int',
\ 'fileinode(': 'string filename | int',
\ 'filemtime(': 'string filename | int',
\ 'fileowner(': 'string filename | int',
\ 'fileperms(': 'string filename | int',
\ 'filepro(': 'string directory | bool',
\ 'filepro_fieldcount(': 'void  | int',
\ 'filepro_fieldname(': 'int field_number | string',
\ 'filepro_fieldtype(': 'int field_number | string',
\ 'filepro_fieldwidth(': 'int field_number | int',
\ 'filepro_retrieve(': 'int row_number, int field_number | string',
\ 'filepro_rowcount(': 'void  | int',
\ 'file_put_contents(': 'string filename, mixed data [, int flags [, resource context]] | int',
\ 'filesize(': 'string filename | int',
\ 'filetype(': 'string filename | string',
\ 'floatval(': 'mixed var | float',
\ 'flock(': 'resource handle, int operation [, int &wouldblock] | bool',
\ 'floor(': 'float value | float',
\ 'flush(': 'void  | void',
\ 'fmod(': 'float x, float y | float',
\ 'fnmatch(': 'string pattern, string string [, int flags] | bool',
\ 'fopen(': 'string filename, string mode [, bool use_include_path [, resource zcontext]] | resource',
\ 'fpassthru(': 'resource handle | int',
\ 'fprintf(': 'resource handle, string format [, mixed args [, mixed ...]] | int',
\ 'fputcsv(': 'resource handle [, array fields [, string delimiter [, string enclosure]]] | int',
\ 'fread(': 'resource handle, int length | string',
\ 'frenchtojd(': 'int month, int day, int year | int',
\ 'fribidi_log2vis(': 'string str, string direction, int charset | string',
\ 'fscanf(': 'resource handle, string format [, mixed &...] | mixed',
\ 'fseek(': 'resource handle, int offset [, int whence] | int',
\ 'fsockopen(': 'string target, int port [, int &errno [, string &errstr [, float timeout]]] | resource',
\ 'fstat(': 'resource handle | array',
\ 'ftell(': 'resource handle | int',
\ 'ftok(': 'string pathname, string proj | int',
\ 'ftp_alloc(': 'resource ftp_stream, int filesize [, string &result] | bool',
\ 'ftp_cdup(': 'resource ftp_stream | bool',
\ 'ftp_chdir(': 'resource ftp_stream, string directory | bool',
\ 'ftp_chmod(': 'resource ftp_stream, int mode, string filename | int',
\ 'ftp_close(': 'resource ftp_stream | bool',
\ 'ftp_connect(': 'string host [, int port [, int timeout]] | resource',
\ 'ftp_delete(': 'resource ftp_stream, string path | bool',
\ 'ftp_exec(': 'resource ftp_stream, string command | bool',
\ 'ftp_fget(': 'resource ftp_stream, resource handle, string remote_file, int mode [, int resumepos] | bool',
\ 'ftp_fput(': 'resource ftp_stream, string remote_file, resource handle, int mode [, int startpos] | bool',
\ 'ftp_get(': 'resource ftp_stream, string local_file, string remote_file, int mode [, int resumepos] | bool',
\ 'ftp_get_option(': 'resource ftp_stream, int option | mixed',
\ 'ftp_login(': 'resource ftp_stream, string username, string password | bool',
\ 'ftp_mdtm(': 'resource ftp_stream, string remote_file | int',
\ 'ftp_mkdir(': 'resource ftp_stream, string directory | string',
\ 'ftp_nb_continue(': 'resource ftp_stream | int',
\ 'ftp_nb_fget(': 'resource ftp_stream, resource handle, string remote_file, int mode [, int resumepos] | int',
\ 'ftp_nb_fput(': 'resource ftp_stream, string remote_file, resource handle, int mode [, int startpos] | int',
\ 'ftp_nb_get(': 'resource ftp_stream, string local_file, string remote_file, int mode [, int resumepos] | int',
\ 'ftp_nb_put(': 'resource ftp_stream, string remote_file, string local_file, int mode [, int startpos] | int',
\ 'ftp_nlist(': 'resource ftp_stream, string directory | array',
\ 'ftp_pasv(': 'resource ftp_stream, bool pasv | bool',
\ 'ftp_put(': 'resource ftp_stream, string remote_file, string local_file, int mode [, int startpos] | bool',
\ 'ftp_pwd(': 'resource ftp_stream | string',
\ 'ftp_raw(': 'resource ftp_stream, string command | array',
\ 'ftp_rawlist(': 'resource ftp_stream, string directory [, bool recursive] | array',
\ 'ftp_rename(': 'resource ftp_stream, string oldname, string newname | bool',
\ 'ftp_rmdir(': 'resource ftp_stream, string directory | bool',
\ 'ftp_set_option(': 'resource ftp_stream, int option, mixed value | bool',
\ 'ftp_site(': 'resource ftp_stream, string command | bool',
\ 'ftp_size(': 'resource ftp_stream, string remote_file | int',
\ 'ftp_ssl_connect(': 'string host [, int port [, int timeout]] | resource',
\ 'ftp_systype(': 'resource ftp_stream | string',
\ 'ftruncate(': 'resource handle, int size | bool',
\ 'func_get_arg(': 'int arg_num | mixed',
\ 'func_get_args(': 'void  | array',
\ 'func_num_args(': 'void  | int',
\ 'function_exists(': 'string function_name | bool',
\ 'fwrite(': 'resource handle, string string [, int length] | int',
\ 'gd_info(': 'void  | array',
\ 'getallheaders(': 'void  | array',
\ 'get_browser(': '[string user_agent [, bool return_array]] | object',
\ 'get_cfg_var(': 'string varname | string',
\ 'get_class(': 'object obj | string',
\ 'get_class_methods(': 'mixed class_name | array',
\ 'get_class_vars(': 'string class_name | array',
\ 'get_current_user(': 'void  | string',
\ 'getcwd(': 'void  | string',
\ 'getdate(': '[int timestamp] | array',
\ 'get_declared_classes(': 'void  | array',
\ 'get_declared_interfaces(': 'void  | array',
\ 'get_defined_constants(': '[mixed categorize] | array',
\ 'get_defined_functions(': 'void  | array',
\ 'get_defined_vars(': 'void  | array',
\ 'getenv(': 'string varname | string',
\ 'get_extension_funcs(': 'string module_name | array',
\ 'get_headers(': 'string url [, int format] | array',
\ 'gethostbyaddr(': 'string ip_address | string',
\ 'gethostbyname(': 'string hostname | string',
\ 'gethostbynamel(': 'string hostname | array',
\ 'get_html_translation_table(': '[int table [, int quote_style]] | array',
\ 'getimagesize(': 'string filename [, array &imageinfo] | array',
\ 'get_included_files(': 'void  | array',
\ 'get_include_path(': 'void  | string',
\ 'getlastmod(': 'void  | int',
\ 'get_loaded_extensions(': 'void  | array',
\ 'get_magic_quotes_gpc(': 'void  | int',
\ 'get_magic_quotes_runtime(': 'void  | int',
\ 'get_meta_tags(': 'string filename [, bool use_include_path] | array',
\ 'getmxrr(': 'string hostname, array &mxhosts [, array &weight] | bool',
\ 'getmygid(': 'void  | int',
\ 'getmyinode(': 'void  | int',
\ 'getmypid(': 'void  | int',
\ 'getmyuid(': 'void  | int',
\ 'get_object_vars(': 'object obj | array',
\ 'getopt(': 'string options [, array longopts] | array',
\ 'get_parent_class(': 'mixed obj | string',
\ 'getprotobyname(': 'string name | int',
\ 'getprotobynumber(': 'int number | string',
\ 'getrandmax(': 'void  | int',
\ 'get_resource_type(': 'resource handle | string',
\ 'getrusage(': '[int who] | array',
\ 'getservbyname(': 'string service, string protocol | int',
\ 'getservbyport(': 'int port, string protocol | string',
\ 'gettext(': 'string message | string',
\ 'gettimeofday(': '[bool return_float] | mixed',
\ 'gettype(': 'mixed var | string',
\ 'glob(': 'string pattern [, int flags] | array',
\ 'gmdate(': 'string format [, int timestamp] | string',
\ 'gmmktime(': '[int hour [, int minute [, int second [, int month [, int day [, int year [, int is_dst]]]]]]] | int',
\ 'gmp_abs(': 'resource a | resource',
\ 'gmp_add(': 'resource a, resource b | resource',
\ 'gmp_and(': 'resource a, resource b | resource',
\ 'gmp_clrbit(': 'resource &a, int index | void',
\ 'gmp_cmp(': 'resource a, resource b | int',
\ 'gmp_com(': 'resource a | resource',
\ 'gmp_divexact(': 'resource n, resource d | resource',
\ 'gmp_div_q(': 'resource a, resource b [, int round] | resource',
\ 'gmp_div_qr(': 'resource n, resource d [, int round] | array',
\ 'gmp_div_r(': 'resource n, resource d [, int round] | resource',
\ 'gmp_fact(': 'int a | resource',
\ 'gmp_gcd(': 'resource a, resource b | resource',
\ 'gmp_gcdext(': 'resource a, resource b | array',
\ 'gmp_hamdist(': 'resource a, resource b | int',
\ 'gmp_init(': 'mixed number [, int base] | resource',
\ 'gmp_intval(': 'resource gmpnumber | int',
\ 'gmp_invert(': 'resource a, resource b | resource',
\ 'gmp_jacobi(': 'resource a, resource p | int',
\ 'gmp_legendre(': 'resource a, resource p | int',
\ 'gmp_mod(': 'resource n, resource d | resource',
\ 'gmp_mul(': 'resource a, resource b | resource',
\ 'gmp_neg(': 'resource a | resource',
\ 'gmp_or(': 'resource a, resource b | resource',
\ 'gmp_perfect_square(': 'resource a | bool',
\ 'gmp_popcount(': 'resource a | int',
\ 'gmp_pow(': 'resource base, int exp | resource',
\ 'gmp_powm(': 'resource base, resource exp, resource mod | resource',
\ 'gmp_prob_prime(': 'resource a [, int reps] | int',
\ 'gmp_random(': 'int limiter | resource',
\ 'gmp_scan0(': 'resource a, int start | int',
\ 'gmp_scan1(': 'resource a, int start | int',
\ 'gmp_setbit(': 'resource &a, int index [, bool set_clear] | void',
\ 'gmp_sign(': 'resource a | int',
\ 'gmp_sqrt(': 'resource a | resource',
\ 'gmp_sqrtrem(': 'resource a | array',
\ 'gmp_strval(': 'resource gmpnumber [, int base] | string',
\ 'gmp_sub(': 'resource a, resource b | resource',
\ 'gmp_xor(': 'resource a, resource b | resource',
\ 'gmstrftime(': 'string format [, int timestamp] | string',
\ 'gregoriantojd(': 'int month, int day, int year | int',
\ 'gzclose(': 'resource zp | bool',
\ 'gzcompress(': 'string data [, int level] | string',
\ 'gzdeflate(': 'string data [, int level] | string',
\ 'gzencode(': 'string data [, int level [, int encoding_mode]] | string',
\ 'gzeof(': 'resource zp | int',
\ 'gzfile(': 'string filename [, int use_include_path] | array',
\ 'gzgetc(': 'resource zp | string',
\ 'gzgets(': 'resource zp, int length | string',
\ 'gzgetss(': 'resource zp, int length [, string allowable_tags] | string',
\ 'gzinflate(': 'string data [, int length] | string',
\ 'gzopen(': 'string filename, string mode [, int use_include_path] | resource',
\ 'gzpassthru(': 'resource zp | int',
\ 'gzread(': 'resource zp, int length | string',
\ 'gzrewind(': 'resource zp | bool',
\ 'gzseek(': 'resource zp, int offset | int',
\ 'gztell(': 'resource zp | int',
\ 'gzuncompress(': 'string data [, int length] | string',
\ 'gzwrite(': 'resource zp, string string [, int length] | int',
\ 'header(': 'string string [, bool replace [, int http_response_code]] | void',
\ 'headers_list(': 'void  | array',
\ 'headers_sent(': '[string &file [, int &line]] | bool',
\ 'hebrev(': 'string hebrew_text [, int max_chars_per_line] | string',
\ 'hebrevc(': 'string hebrew_text [, int max_chars_per_line] | string',
\ 'hexdec(': 'string hex_string | number',
\ 'highlight_file(': 'string filename [, bool return] | mixed',
\ 'highlight_string(': 'string str [, bool return] | mixed',
\ 'htmlentities(': 'string string [, int quote_style [, string charset]] | string',
\ 'html_entity_decode(': 'string string [, int quote_style [, string charset]] | string',
\ 'htmlspecialchars(': 'string string [, int quote_style [, string charset]] | string',
\ 'htmlspecialchars_decode(': 'string string [, int quote_style] | string',
\ 'http_build_query(': 'array formdata [, string numeric_prefix] | string',
\ 'hw_api_attribute(': '[string name [, string value]] | HW_API_Attribute',
\ 'hwapi_hgcsp(': 'string hostname [, int port] | HW_API',
\ 'hw_api_content(': 'string content, string mimetype | HW_API_Content',
\ 'hw_api_object(': 'array parameter | hw_api_object',
\ 'hw_array2objrec(': 'array object_array | string',
\ 'hw_changeobject(': 'int link, int objid, array attributes | void',
\ 'hw_children(': 'int connection, int objectID | array',
\ 'hw_childrenobj(': 'int connection, int objectID | array',
\ 'hw_close(': 'int connection | int',
\ 'hw_connect(': 'string host, int port, string username, string password | int',
\ 'hw_connection_info(': 'int link | void',
\ 'hw_cp(': 'int connection, array object_id_array, int destination_id | int',
\ 'hw_deleteobject(': 'int connection, int object_to_delete | int',
\ 'hw_docbyanchor(': 'int connection, int anchorID | int',
\ 'hw_docbyanchorobj(': 'int connection, int anchorID | string',
\ 'hw_document_attributes(': 'int hw_document | string',
\ 'hw_document_bodytag(': 'int hw_document [, string prefix] | string',
\ 'hw_document_content(': 'int hw_document | string',
\ 'hw_document_setcontent(': 'int hw_document, string content | string',
\ 'hw_document_size(': 'int hw_document | int',
\ 'hw_dummy(': 'int link, int id, int msgid | string',
\ 'hw_edittext(': 'int connection, int hw_document | int',
\ 'hw_error(': 'int connection | int',
\ 'hw_errormsg(': 'int connection | string',
\ 'hw_free_document(': 'int hw_document | int',
\ 'hw_getanchors(': 'int connection, int objectID | array',
\ 'hw_getanchorsobj(': 'int connection, int objectID | array',
\ 'hw_getandlock(': 'int connection, int objectID | string',
\ 'hw_getchildcoll(': 'int connection, int objectID | array',
\ 'hw_getchildcollobj(': 'int connection, int objectID | array',
\ 'hw_getchilddoccoll(': 'int connection, int objectID | array',
\ 'hw_getchilddoccollobj(': 'int connection, int objectID | array',
\ 'hw_getobject(': 'int connection, mixed objectID [, string query] | array',
\ 'hw_getobjectbyquery(': 'int connection, string query, int max_hits | array',
\ 'hw_getobjectbyquerycoll(': 'int connection, int objectID, string query, int max_hits | array',
\ 'hw_getobjectbyquerycollobj(': 'int connection, int objectID, string query, int max_hits | array',
\ 'hw_getobjectbyqueryobj(': 'int connection, string query, int max_hits | array',
\ 'hw_getparents(': 'int connection, int objectID | array',
\ 'hw_getparentsobj(': 'int connection, int objectID | array',
\ 'hw_getrellink(': 'int link, int rootid, int sourceid, int destid | string',
\ 'hw_getremote(': 'int connection, int objectID | int',
\ 'hw_getremotechildren(': 'int connection, string object_record | int',
\ 'hw_getsrcbydestobj(': 'int connection, int objectID | array',
\ 'hw_gettext(': 'int connection, int objectID [, mixed rootID/prefix] | int',
\ 'hw_getusername(': 'int connection | string',
\ 'hw_identify(': 'int link, string username, string password | int',
\ 'hw_incollections(': 'int connection, array object_id_array, array collection_id_array, int return_collections | array',
\ 'hw_info(': 'int connection | string',
\ 'hw_inscoll(': 'int connection, int objectID, array object_array | int',
\ 'hw_insdoc(': 'resource connection, int parentID, string object_record [, string text] | int',
\ 'hw_insertanchors(': 'int hwdoc, array anchorecs, array dest [, array urlprefixes] | string',
\ 'hw_insertdocument(': 'int connection, int parent_id, int hw_document | int',
\ 'hw_insertobject(': 'int connection, string object_rec, string parameter | int',
\ 'hw_mapid(': 'int connection, int server_id, int object_id | int',
\ 'hw_modifyobject(': 'int connection, int object_to_change, array remove, array add [, int mode] | int',
\ 'hw_mv(': 'int connection, array object_id_array, int source_id, int destination_id | int',
\ 'hw_new_document(': 'string object_record, string document_data, int document_size | int',
\ 'hw_objrec2array(': 'string object_record [, array format] | array',
\ 'hw_output_document(': 'int hw_document | int',
\ 'hw_pconnect(': 'string host, int port, string username, string password | int',
\ 'hw_pipedocument(': 'int connection, int objectID [, array url_prefixes] | int',
\ 'hw_root(': ' | int',
\ 'hw_setlinkroot(': 'int link, int rootid | void',
\ 'hw_stat(': 'int link | string',
\ 'hw_unlock(': 'int connection, int objectID | int',
\ 'hw_who(': 'int connection | int',
\ 'hypot(': 'float x, float y | float',
\ 'ibase_add_user(': 'resource service_handle, string user_name, string password [, string first_name [, string middle_name [, string last_name]]] | bool',
\ 'ibase_affected_rows(': '[resource link_identifier] | int',
\ 'ibase_backup(': 'resource service_handle, string source_db, string dest_file [, int options [, bool verbose]] | mixed',
\ 'ibase_blob_add(': 'resource blob_handle, string data | bool',
\ 'ibase_blob_cancel(': 'resource blob_handle | bool',
\ 'ibase_blob_close(': 'resource blob_handle | mixed',
\ 'ibase_blob_create(': '[resource link_identifier] | resource',
\ 'ibase_blob_echo(': 'resource link_identifier, string blob_id | bool',
\ 'ibase_blob_get(': 'resource blob_handle, int len | string',
\ 'ibase_blob_import(': 'resource link_identifier, resource file_handle | string',
\ 'ibase_blob_info(': 'resource link_identifier, string blob_id | array',
\ 'ibase_blob_open(': 'resource link_identifier, string blob_id | resource',
\ 'ibase_close(': '[resource connection_id] | bool',
\ 'ibase_commit(': '[resource link_or_trans_identifier] | bool',
\ 'ibase_commit_ret(': '[resource link_or_trans_identifier] | bool',
\ 'ibase_connect(': 'string database [, string username [, string password [, string charset [, int buffers [, int dialect [, string role]]]]]] | resource',
\ 'ibase_db_info(': 'resource service_handle, string db, int action [, int argument] | string',
\ 'ibase_delete_user(': 'resource service_handle, string user_name | bool',
\ 'ibase_drop_db(': '[resource connection] | bool',
\ 'ibase_errcode(': 'void  | int',
\ 'ibase_errmsg(': 'void  | string',
\ 'ibase_execute(': 'resource query [, mixed bind_arg [, mixed ...]] | resource',
\ 'ibase_fetch_assoc(': 'resource result [, int fetch_flag] | array',
\ 'ibase_fetch_object(': 'resource result_id [, int fetch_flag] | object',
\ 'ibase_fetch_row(': 'resource result_identifier [, int fetch_flag] | array',
\ 'ibase_field_info(': 'resource result, int field_number | array',
\ 'ibase_free_event_handler(': 'resource event | bool',
\ 'ibase_free_query(': 'resource query | bool',
\ 'ibase_free_result(': 'resource result_identifier | bool',
\ 'ibase_gen_id(': 'string generator [, int increment [, resource link_identifier]] | int',
\ 'ibase_maintain_db(': 'resource service_handle, string db, int action [, int argument] | bool',
\ 'ibase_modify_user(': 'resource service_handle, string user_name, string password [, string first_name [, string middle_name [, string last_name]]] | bool',
\ 'ibase_name_result(': 'resource result, string name | bool',
\ 'ibase_num_fields(': 'resource result_id | int',
\ 'ibase_num_params(': 'resource query | int',
\ 'ibase_param_info(': 'resource query, int param_number | array',
\ 'ibase_pconnect(': 'string database [, string username [, string password [, string charset [, int buffers [, int dialect [, string role]]]]]] | resource',
\ 'ibase_prepare(': 'string query | resource',
\ 'ibase_query(': '[resource link_identifier, string query [, int bind_args]] | resource',
\ 'ibase_restore(': 'resource service_handle, string source_file, string dest_db [, int options [, bool verbose]] | mixed',
\ 'ibase_rollback(': '[resource link_or_trans_identifier] | bool',
\ 'ibase_rollback_ret(': '[resource link_or_trans_identifier] | bool',
\ 'ibase_server_info(': 'resource service_handle, int action | string',
\ 'ibase_service_attach(': 'string host, string dba_username, string dba_password | resource',
\ 'ibase_service_detach(': 'resource service_handle | bool',
\ 'ibase_set_event_handler(': 'callback event_handler, string event_name1 [, string event_name2 [, string ...]] | resource',
\ 'ibase_timefmt(': 'string format [, int columntype] | int',
\ 'ibase_trans(': '[int trans_args [, resource link_identifier]] | resource',
\ 'ibase_wait_event(': 'string event_name1 [, string event_name2 [, string ...]] | string',
\ 'icap_close(': 'int icap_stream [, int flags] | int',
\ 'icap_create_calendar(': 'int stream_id, string calendar | string',
\ 'icap_delete_calendar(': 'int stream_id, string calendar | string',
\ 'icap_delete_event(': 'int stream_id, int uid | string',
\ 'icap_fetch_event(': 'int stream_id, int event_id [, int options] | int',
\ 'icap_list_alarms(': 'int stream_id, array date, array time | int',
\ 'icap_list_events(': 'int stream_id, int begin_date [, int end_date] | array',
\ 'icap_open(': 'string calendar, string username, string password, string options | resource',
\ 'icap_rename_calendar(': 'int stream_id, string old_name, string new_name | string',
\ 'icap_reopen(': 'int stream_id, string calendar [, int options] | int',
\ 'icap_snooze(': 'int stream_id, int uid | string',
\ 'icap_store_event(': 'int stream_id, object event | string',
\ 'iconv(': 'string in_charset, string out_charset, string str | string',
\ 'iconv_get_encoding(': '[string type] | mixed',
\ 'iconv_mime_decode(': 'string encoded_header [, int mode [, string charset]] | string',
\ 'iconv_mime_decode_headers(': 'string encoded_headers [, int mode [, string charset]] | array',
\ 'iconv_mime_encode(': 'string field_name, string field_value [, array preferences] | string',
\ 'iconv_set_encoding(': 'string type, string charset | bool',
\ 'iconv_strlen(': 'string str [, string charset] | int',
\ 'iconv_strpos(': 'string haystack, string needle [, int offset [, string charset]] | int',
\ 'iconv_strrpos(': 'string haystack, string needle [, string charset] | string',
\ 'iconv_substr(': 'string str, int offset [, int length [, string charset]] | string',
\ 'id3_get_frame_long_name(': 'string frameId | string',
\ 'id3_get_frame_short_name(': 'string frameId | string',
\ 'id3_get_genre_id(': 'string genre | int',
\ 'id3_get_genre_list(': 'void  | array',
\ 'id3_get_genre_name(': 'int genre_id | string',
\ 'id3_get_tag(': 'string filename [, int version] | array',
\ 'id3_get_version(': 'string filename | int',
\ 'id3_remove_tag(': 'string filename [, int version] | bool',
\ 'id3_set_tag(': 'string filename, array tag [, int version] | bool',
\ 'idate(': 'string format [, int timestamp] | int',
\ 'ifx_affected_rows(': 'int result_id | int',
\ 'ifx_blobinfile_mode(': 'int mode | void',
\ 'ifx_byteasvarchar(': 'int mode | void',
\ 'ifx_close(': '[int link_identifier] | int',
\ 'ifx_connect(': '[string database [, string userid [, string password]]] | int',
\ 'ifx_copy_blob(': 'int bid | int',
\ 'ifx_create_blob(': 'int type, int mode, string param | int',
\ 'ifx_create_char(': 'string param | int',
\ 'ifx_do(': 'int result_id | int',
\ 'ifx_error(': 'void  | string',
\ 'ifx_errormsg(': '[int errorcode] | string',
\ 'ifx_fetch_row(': 'int result_id [, mixed position] | array',
\ 'ifx_fieldproperties(': 'int result_id | array',
\ 'ifx_fieldtypes(': 'int result_id | array',
\ 'ifx_free_blob(': 'int bid | int',
\ 'ifx_free_char(': 'int bid | int',
\ 'ifx_free_result(': 'int result_id | int',
\ 'ifx_get_blob(': 'int bid | int',
\ 'ifx_get_char(': 'int bid | int',
\ 'ifx_getsqlca(': 'int result_id | array',
\ 'ifx_htmltbl_result(': 'int result_id [, string html_table_options] | int',
\ 'ifx_nullformat(': 'int mode | void',
\ 'ifx_num_fields(': 'int result_id | int',
\ 'ifx_num_rows(': 'int result_id | int',
\ 'ifx_pconnect(': '[string database [, string userid [, string password]]] | int',
\ 'ifx_prepare(': 'string query, int conn_id [, int cursor_def, mixed blobidarray] | int',
\ 'ifx_query(': 'string query, int link_identifier [, int cursor_type [, mixed blobidarray]] | int',
\ 'ifx_textasvarchar(': 'int mode | void',
\ 'ifx_update_blob(': 'int bid, string content | bool',
\ 'ifx_update_char(': 'int bid, string content | int',
\ 'ifxus_close_slob(': 'int bid | int',
\ 'ifxus_create_slob(': 'int mode | int',
\ 'ifxus_free_slob(': 'int bid | int',
\ 'ifxus_open_slob(': 'int bid, int mode | int',
\ 'ifxus_read_slob(': 'int bid, int nbytes | int',
\ 'ifxus_seek_slob(': 'int bid, int mode, int offset | int',
\ 'ifxus_tell_slob(': 'int bid | int',
\ 'ifxus_write_slob(': 'int bid, string content | int',
\ 'ignore_user_abort(': '[bool setting] | int',
\ 'iis_add_server(': 'string path, string comment, string server_ip, int port, string host_name, int rights, int start_server | int',
\ 'iis_get_dir_security(': 'int server_instance, string virtual_path | int',
\ 'iis_get_script_map(': 'int server_instance, string virtual_path, string script_extension | int',
\ 'iis_get_server_by_comment(': 'string comment | int',
\ 'iis_get_server_by_path(': 'string path | int',
\ 'iis_get_server_rights(': 'int server_instance, string virtual_path | int',
\ 'iis_get_service_state(': 'string service_id | int',
\ 'iis_remove_server(': 'int server_instance | int',
\ 'iis_set_app_settings(': 'int server_instance, string virtual_path, string application_scope | int',
\ 'iis_set_dir_security(': 'int server_instance, string virtual_path, int directory_flags | int',
\ 'iis_set_script_map(': 'int server_instance, string virtual_path, string script_extension, string engine_path, int allow_scripting | int',
\ 'iis_set_server_rights(': 'int server_instance, string virtual_path, int directory_flags | int',
\ 'iis_start_server(': 'int server_instance | int',
\ 'iis_start_service(': 'string service_id | int',
\ 'iis_stop_server(': 'int server_instance | int',
\ 'iis_stop_service(': 'string service_id | int',
\ 'image2wbmp(': 'resource image [, string filename [, int threshold]] | int',
\ 'imagealphablending(': 'resource image, bool blendmode | bool',
\ 'imageantialias(': 'resource im, bool on | bool',
\ 'imagearc(': 'resource image, int cx, int cy, int w, int h, int s, int e, int color | int',
\ 'imagechar(': 'resource image, int font, int x, int y, string c, int color | int',
\ 'imagecharup(': 'resource image, int font, int x, int y, string c, int color | int',
\ 'imagecolorallocate(': 'resource image, int red, int green, int blue | int',
\ 'imagecolorallocatealpha(': 'resource image, int red, int green, int blue, int alpha | int',
\ 'imagecolorat(': 'resource image, int x, int y | int',
\ 'imagecolorclosest(': 'resource image, int red, int green, int blue | int',
\ 'imagecolorclosestalpha(': 'resource image, int red, int green, int blue, int alpha | int',
\ 'imagecolorclosesthwb(': 'resource image, int red, int green, int blue | int',
\ 'imagecolordeallocate(': 'resource image, int color | int',
\ 'imagecolorexact(': 'resource image, int red, int green, int blue | int',
\ 'imagecolorexactalpha(': 'resource image, int red, int green, int blue, int alpha | int',
\ 'imagecolormatch(': 'resource image1, resource image2 | bool',
\ 'imagecolorresolve(': 'resource image, int red, int green, int blue | int',
\ 'imagecolorresolvealpha(': 'resource image, int red, int green, int blue, int alpha | int',
\ 'imagecolorset(': 'resource image, int index, int red, int green, int blue | bool',
\ 'imagecolorsforindex(': 'resource image, int index | array',
\ 'imagecolorstotal(': 'resource image | int',
\ 'imagecolortransparent(': 'resource image [, int color] | int',
\ 'imagecopy(': 'resource dst_im, resource src_im, int dst_x, int dst_y, int src_x, int src_y, int src_w, int src_h | int',
\ 'imagecopymerge(': 'resource dst_im, resource src_im, int dst_x, int dst_y, int src_x, int src_y, int src_w, int src_h, int pct | int',
\ 'imagecopymergegray(': 'resource dst_im, resource src_im, int dst_x, int dst_y, int src_x, int src_y, int src_w, int src_h, int pct | int',
\ 'imagecopyresampled(': 'resource dst_image, resource src_image, int dst_x, int dst_y, int src_x, int src_y, int dst_w, int dst_h, int src_w, int src_h | bool',
\ 'imagecopyresized(': 'resource dst_image, resource src_image, int dst_x, int dst_y, int src_x, int src_y, int dst_w, int dst_h, int src_w, int src_h | int',
\ 'imagecreate(': 'int x_size, int y_size | resource',
\ 'imagecreatefromgd(': 'string filename | resource',
\ 'imagecreatefromgd2(': 'string filename | resource',
\ 'imagecreatefromgd2part(': 'string filename, int srcX, int srcY, int width, int height | resource',
\ 'imagecreatefromgif(': 'string filename | resource',
\ 'imagecreatefromjpeg(': 'string filename | resource',
\ 'imagecreatefrompng(': 'string filename | resource',
\ 'imagecreatefromstring(': 'string image | resource',
\ 'imagecreatefromwbmp(': 'string filename | resource',
\ 'imagecreatefromxbm(': 'string filename | resource',
\ 'imagecreatefromxpm(': 'string filename | resource',
\ 'imagecreatetruecolor(': 'int x_size, int y_size | resource',
\ 'imagedashedline(': 'resource image, int x1, int y1, int x2, int y2, int color | int',
\ 'imagedestroy(': 'resource image | bool',
\ 'imageellipse(': 'resource image, int cx, int cy, int w, int h, int color | int',
\ 'imagefill(': 'resource image, int x, int y, int color | int',
\ 'imagefilledarc(': 'resource image, int cx, int cy, int w, int h, int s, int e, int color, int style | bool',
\ 'imagefilledellipse(': 'resource image, int cx, int cy, int w, int h, int color | bool',
\ 'imagefilledpolygon(': 'resource image, array points, int num_points, int color | int',
\ 'imagefilledrectangle(': 'resource image, int x1, int y1, int x2, int y2, int color | int',
\ 'imagefilltoborder(': 'resource image, int x, int y, int border, int color | int',
\ 'imagefilter(': 'resource src_im, int filtertype [, int arg1 [, int arg2 [, int arg3]]] | bool',
\ 'imagefontheight(': 'int font | int',
\ 'imagefontwidth(': 'int font | int',
\ 'imageftbbox(': 'float size, float angle, string font_file, string text [, array extrainfo] | array',
\ 'imagefttext(': 'resource image, float size, float angle, int x, int y, int col, string font_file, string text [, array extrainfo] | array',
\ 'imagegammacorrect(': 'resource image, float inputgamma, float outputgamma | int',
\ 'imagegd(': 'resource image [, string filename] | bool',
\ 'imagegd2(': 'resource image [, string filename [, int chunk_size [, int type]]] | bool',
\ 'imagegif(': 'resource image [, string filename] | bool',
\ 'imageinterlace(': 'resource image [, int interlace] | int',
\ 'imageistruecolor(': 'resource image | bool',
\ 'imagejpeg(': 'resource image [, string filename [, int quality]] | bool',
\ 'imagelayereffect(': 'resource image, int effect | bool',
\ 'imageline(': 'resource image, int x1, int y1, int x2, int y2, int color | int',
\ 'imageloadfont(': 'string file | int',
\ 'imagepalettecopy(': 'resource destination, resource source | int',
\ 'imagepng(': 'resource image [, string filename] | bool',
\ 'imagepolygon(': 'resource image, array points, int num_points, int color | int',
\ 'imagepsbbox(': 'string text, int font, int size [, int space, int tightness, float angle] | array',
\ 'imagepscopyfont(': 'int fontindex | int',
\ 'imagepsencodefont(': 'int font_index, string encodingfile | int',
\ 'imagepsextendfont(': 'int font_index, float extend | bool',
\ 'imagepsfreefont(': 'int fontindex | void',
\ 'imagepsloadfont(': 'string filename | int',
\ 'imagepsslantfont(': 'int font_index, float slant | bool',
\ 'imagepstext(': 'resource image, string text, int font, int size, int foreground, int background, int x, int y [, int space, int tightness, float angle, int antialias_steps] | array',
\ 'imagerectangle(': 'resource image, int x1, int y1, int x2, int y2, int col | int',
\ 'imagerotate(': 'resource src_im, float angle, int bgd_color | resource',
\ 'imagesavealpha(': 'resource image, bool saveflag | bool',
\ 'imagesetbrush(': 'resource image, resource brush | int',
\ 'imagesetpixel(': 'resource image, int x, int y, int color | int',
\ 'imagesetstyle(': 'resource image, array style | bool',
\ 'imagesetthickness(': 'resource image, int thickness | bool',
\ 'imagesettile(': 'resource image, resource tile | int',
\ 'imagestring(': 'resource image, int font, int x, int y, string s, int col | int',
\ 'imagestringup(': 'resource image, int font, int x, int y, string s, int col | int',
\ 'imagesx(': 'resource image | int',
\ 'imagesy(': 'resource image | int',
\ 'imagetruecolortopalette(': 'resource image, bool dither, int ncolors | void',
\ 'imagettfbbox(': 'float size, float angle, string fontfile, string text | array',
\ 'imagettftext(': 'resource image, float size, float angle, int x, int y, int color, string fontfile, string text | array',
\ 'imagetypes(': 'void  | int',
\ 'image_type_to_extension(': 'int imagetype [, bool include_dot] | string',
\ 'image_type_to_mime_type(': 'int imagetype | string',
\ 'imagewbmp(': 'resource image [, string filename [, int foreground]] | bool',
\ 'imagexbm(': 'resource image, string filename [, int foreground] | bool',
\ 'imap_8bit(': 'string string | string',
\ 'imap_alerts(': 'void  | array',
\ 'imap_append(': 'resource imap_stream, string mbox, string message [, string options] | bool',
\ 'imap_base64(': 'string text | string',
\ 'imap_binary(': 'string string | string',
\ 'imap_body(': 'resource imap_stream, int msg_number [, int options] | string',
\ 'imap_bodystruct(': 'resource stream_id, int msg_no, string section | object',
\ 'imap_check(': 'resource imap_stream | object',
\ 'imap_clearflag_full(': 'resource stream, string sequence, string flag [, string options] | bool',
\ 'imap_close(': 'resource imap_stream [, int flag] | bool',
\ 'imap_createmailbox(': 'resource imap_stream, string mbox | bool',
\ 'imap_delete(': 'int imap_stream, int msg_number [, int options] | bool',
\ 'imap_deletemailbox(': 'resource imap_stream, string mbox | bool',
\ 'imap_errors(': 'void  | array',
\ 'imap_expunge(': 'resource imap_stream | bool',
\ 'imap_fetchbody(': 'resource imap_stream, int msg_number, string part_number [, int options] | string',
\ 'imap_fetchheader(': 'resource imap_stream, int msgno [, int options] | string',
\ 'imap_fetch_overview(': 'resource imap_stream, string sequence [, int options] | array',
\ 'imap_fetchstructure(': 'resource imap_stream, int msg_number [, int options] | object',
\ 'imap_getacl(': 'resource stream_id, string mailbox | array',
\ 'imap_getmailboxes(': 'resource imap_stream, string ref, string pattern | array',
\ 'imap_get_quota(': 'resource imap_stream, string quota_root | array',
\ 'imap_get_quotaroot(': 'resource imap_stream, string quota_root | array',
\ 'imap_getsubscribed(': 'resource imap_stream, string ref, string pattern | array',
\ 'imap_headerinfo(': 'resource imap_stream, int msg_number [, int fromlength [, int subjectlength [, string defaulthost]]] | object',
\ 'imap_headers(': 'resource imap_stream | array',
\ 'imap_last_error(': 'void  | string',
\ 'imap_list(': 'resource imap_stream, string ref, string pattern | array',
\ 'imap_listscan(': 'resource imap_stream, string ref, string pattern, string content | array',
\ 'imap_lsub(': 'resource imap_stream, string ref, string pattern | array',
\ 'imap_mail(': 'string to, string subject, string message [, string additional_headers [, string cc [, string bcc [, string rpath]]]] | bool',
\ 'imap_mailboxmsginfo(': 'resource imap_stream | object',
\ 'imap_mail_compose(': 'array envelope, array body | string',
\ 'imap_mail_copy(': 'resource imap_stream, string msglist, string mbox [, int options] | bool',
\ 'imap_mail_move(': 'resource imap_stream, string msglist, string mbox [, int options] | bool',
\ 'imap_mime_header_decode(': 'string text | array',
\ 'imap_msgno(': 'resource imap_stream, int uid | int',
\ 'imap_num_msg(': 'resource imap_stream | int',
\ 'imap_num_recent(': 'resource imap_stream | int',
\ 'imap_open(': 'string mailbox, string username, string password [, int options] | resource',
\ 'imap_ping(': 'resource imap_stream | bool',
\ 'imap_qprint(': 'string string | string',
\ 'imap_renamemailbox(': 'resource imap_stream, string old_mbox, string new_mbox | bool',
\ 'imap_reopen(': 'resource imap_stream, string mailbox [, string options] | bool',
\ 'imap_rfc822_parse_adrlist(': 'string address, string default_host | array',
\ 'imap_rfc822_parse_headers(': 'string headers [, string defaulthost] | object',
\ 'imap_rfc822_write_address(': 'string mailbox, string host, string personal | string',
\ 'imap_search(': 'resource imap_stream, string criteria [, int options [, string charset]] | array',
\ 'imap_setacl(': 'resource stream_id, string mailbox, string id, string rights | bool',
\ 'imap_setflag_full(': 'resource stream, string sequence, string flag [, string options] | bool',
\ 'imap_set_quota(': 'resource imap_stream, string quota_root, int quota_limit | bool',
\ 'imap_sort(': 'resource stream, int criteria, int reverse [, int options [, string search_criteria [, string charset]]] | array',
\ 'imap_status(': 'resource imap_stream, string mailbox, int options | object',
\ 'imap_subscribe(': 'resource imap_stream, string mbox | bool',
\ 'imap_thread(': 'resource stream_id [, int options] | array',
\ 'imap_timeout(': 'int timeout_type [, int timeout] | mixed',
\ 'imap_uid(': 'resource imap_stream, int msgno | int',
\ 'imap_undelete(': 'resource imap_stream, int msg_number [, int flags] | bool',
\ 'imap_unsubscribe(': 'string imap_stream, string mbox | bool',
\ 'imap_utf7_decode(': 'string text | string',
\ 'imap_utf7_encode(': 'string data | string',
\ 'imap_utf8(': 'string mime_encoded_text | string',
\ 'implode(': 'string glue, array pieces | string',
\ 'import_request_variables(': 'string types [, string prefix] | bool',
\ 'in_array(': 'mixed needle, array haystack [, bool strict] | bool',
\ 'inet_ntop(': 'string in_addr | string',
\ 'inet_pton(': 'string address | string',
\ 'ingres_autocommit(': '[resource link] | bool',
\ 'ingres_close(': '[resource link] | bool',
\ 'ingres_commit(': '[resource link] | bool',
\ 'ingres_connect(': '[string database [, string username [, string password]]] | resource',
\ 'ingres_fetch_array(': '[int result_type [, resource link]] | array',
\ 'ingres_fetch_object(': '[int result_type [, resource link]] | object',
\ 'ingres_fetch_row(': '[resource link] | array',
\ 'ingres_field_length(': 'int index [, resource link] | int',
\ 'ingres_field_name(': 'int index [, resource link] | string',
\ 'ingres_field_nullable(': 'int index [, resource link] | bool',
\ 'ingres_field_precision(': 'int index [, resource link] | int',
\ 'ingres_field_scale(': 'int index [, resource link] | int',
\ 'ingres_field_type(': 'int index [, resource link] | string',
\ 'ingres_num_fields(': '[resource link] | int',
\ 'ingres_num_rows(': '[resource link] | int',
\ 'ingres_pconnect(': '[string database [, string username [, string password]]] | resource',
\ 'ingres_query(': 'string query [, resource link] | bool',
\ 'ingres_rollback(': '[resource link] | bool',
\ 'ini_get(': 'string varname | string',
\ 'ini_get_all(': '[string extension] | array',
\ 'ini_restore(': 'string varname | void',
\ 'ini_set(': 'string varname, string newvalue | string',
\ 'interface_exists(': 'string interface_name [, bool autoload] | bool',
\ 'intval(': 'mixed var [, int base] | int',
\ 'ip2long(': 'string ip_address | int',
\ 'iptcembed(': 'string iptcdata, string jpeg_file_name [, int spool] | array',
\ 'iptcparse(': 'string iptcblock | array',
\ 'ircg_channel_mode(': 'resource connection, string channel, string mode_spec, string nick | bool',
\ 'ircg_disconnect(': 'resource connection, string reason | bool',
\ 'ircg_eval_ecmascript_params(': 'string params | array',
\ 'ircg_fetch_error_msg(': 'resource connection | array',
\ 'ircg_get_username(': 'resource connection | string',
\ 'ircg_html_encode(': 'string html_string [, bool auto_links [, bool conv_br]] | bool',
\ 'ircg_ignore_add(': 'resource connection, string nick | bool',
\ 'ircg_ignore_del(': 'resource connection, string nick | bool',
\ 'ircg_invite(': 'resource connection, string channel, string nickname | bool',
\ 'ircg_is_conn_alive(': 'resource connection | bool',
\ 'ircg_join(': 'resource connection, string channel [, string key] | bool',
\ 'ircg_kick(': 'resource connection, string channel, string nick, string reason | bool',
\ 'ircg_list(': 'resource connection, string channel | bool',
\ 'ircg_lookup_format_messages(': 'string name | bool',
\ 'ircg_lusers(': 'resource connection | bool',
\ 'ircg_msg(': 'resource connection, string recipient, string message [, bool suppress] | bool',
\ 'ircg_names(': 'int connection, string channel [, string target] | bool',
\ 'ircg_nick(': 'resource connection, string nick | bool',
\ 'ircg_nickname_escape(': 'string nick | string',
\ 'ircg_nickname_unescape(': 'string nick | string',
\ 'ircg_notice(': 'resource connection, string recipient, string message | bool',
\ 'ircg_oper(': 'resource connection, string name, string password | bool',
\ 'ircg_part(': 'resource connection, string channel | bool',
\ 'ircg_pconnect(': 'string username [, string server_ip [, int server_port [, string msg_format [, array ctcp_messages [, array user_settings [, bool bailout_on_trivial]]]]]] | resource',
\ 'ircg_register_format_messages(': 'string name, array messages | bool',
\ 'ircg_set_current(': 'resource connection | bool',
\ 'ircg_set_file(': 'resource connection, string path | bool',
\ 'ircg_set_on_die(': 'resource connection, string host, int port, string data | bool',
\ 'ircg_topic(': 'resource connection, string channel, string new_topic | bool',
\ 'ircg_who(': 'resource connection, string mask [, bool ops_only] | bool',
\ 'ircg_whois(': 'resource connection, string nick | bool',
\ 'is_a(': 'object object, string class_name | bool',
\ 'is_array(': 'mixed var | bool',
\ 'is_bool(': 'mixed var | bool',
\ 'is_callable(': 'mixed var [, bool syntax_only [, string &callable_name]] | bool',
\ 'is_dir(': 'string filename | bool',
\ 'is_executable(': 'string filename | bool',
\ 'is_file(': 'string filename | bool',
\ 'is_finite(': 'float val | bool',
\ 'is_float(': 'mixed var | bool',
\ 'is_infinite(': 'float val | bool',
\ 'is_int(': 'mixed var | bool',
\ 'is_link(': 'string filename | bool',
\ 'is_nan(': 'float val | bool',
\ 'is_null(': 'mixed var | bool',
\ 'is_numeric(': 'mixed var | bool',
\ 'is_object(': 'mixed var | bool',
\ 'is_readable(': 'string filename | bool',
\ 'is_resource(': 'mixed var | bool',
\ 'is_scalar(': 'mixed var | bool',
\ 'isset(': 'mixed var [, mixed var [, ...]] | bool',
\ 'is_soap_fault(': 'mixed obj | bool',
\ 'is_string(': 'mixed var | bool',
\ 'is_subclass_of(': 'mixed object, string class_name | bool',
\ 'is_uploaded_file(': 'string filename | bool',
\ 'is_writable(': 'string filename | bool',
\ 'iterator_count(': 'IteratorAggregate iterator | int',
\ 'iterator_to_array(': 'IteratorAggregate iterator | array',
\ 'java_last_exception_clear(': 'void  | void',
\ 'java_last_exception_get(': 'void  | object',
\ 'jddayofweek(': 'int julianday [, int mode] | mixed',
\ 'jdmonthname(': 'int julianday, int mode | string',
\ 'jdtofrench(': 'int juliandaycount | string',
\ 'jdtogregorian(': 'int julianday | string',
\ 'jdtojewish(': 'int juliandaycount [, bool hebrew [, int fl]] | string',
\ 'jdtojulian(': 'int julianday | string',
\ 'jdtounix(': 'int jday | int',
\ 'jewishtojd(': 'int month, int day, int year | int',
\ 'jpeg2wbmp(': 'string jpegname, string wbmpname, int d_height, int d_width, int threshold | int',
\ 'juliantojd(': 'int month, int day, int year | int',
\ 'key(': 'array &array | mixed',
\ 'krsort(': 'array &array [, int sort_flags] | bool',
\ 'ksort(': 'array &array [, int sort_flags] | bool',
\ 'lcg_value(': 'void  | float',
\ 'ldap_8859_to_t61(': 'string value | string',
\ 'ldap_add(': 'resource link_identifier, string dn, array entry | bool',
\ 'ldap_bind(': 'resource link_identifier [, string bind_rdn [, string bind_password]] | bool',
\ 'ldap_close(': 'resource link_identifier | bool',
\ 'ldap_compare(': 'resource link_identifier, string dn, string attribute, string value | bool',
\ 'ldap_connect(': '[string hostname [, int port]] | resource',
\ 'ldap_count_entries(': 'resource link_identifier, resource result_identifier | int',
\ 'ldap_delete(': 'resource link_identifier, string dn | bool',
\ 'ldap_dn2ufn(': 'string dn | string',
\ 'ldap_err2str(': 'int errno | string',
\ 'ldap_errno(': 'resource link_identifier | int',
\ 'ldap_error(': 'resource link_identifier | string',
\ 'ldap_explode_dn(': 'string dn, int with_attrib | array',
\ 'ldap_first_attribute(': 'resource link_identifier, resource result_entry_identifier, int &ber_identifier | string',
\ 'ldap_first_entry(': 'resource link_identifier, resource result_identifier | resource',
\ 'ldap_first_reference(': 'resource link, resource result | resource',
\ 'ldap_free_result(': 'resource result_identifier | bool',
\ 'ldap_get_attributes(': 'resource link_identifier, resource result_entry_identifier | array',
\ 'ldap_get_dn(': 'resource link_identifier, resource result_entry_identifier | string',
\ 'ldap_get_entries(': 'resource link_identifier, resource result_identifier | array',
\ 'ldap_get_option(': 'resource link_identifier, int option, mixed &retval | bool',
\ 'ldap_get_values(': 'resource link_identifier, resource result_entry_identifier, string attribute | array',
\ 'ldap_get_values_len(': 'resource link_identifier, resource result_entry_identifier, string attribute | array',
\ 'ldap_list(': 'resource link_identifier, string base_dn, string filter [, array attributes [, int attrsonly [, int sizelimit [, int timelimit [, int deref]]]]] | resource',
\ 'ldap_mod_add(': 'resource link_identifier, string dn, array entry | bool',
\ 'ldap_mod_del(': 'resource link_identifier, string dn, array entry | bool',
\ 'ldap_modify(': 'resource link_identifier, string dn, array entry | bool',
\ 'ldap_mod_replace(': 'resource link_identifier, string dn, array entry | bool',
\ 'ldap_next_attribute(': 'resource link_identifier, resource result_entry_identifier, resource &ber_identifier | string',
\ 'ldap_next_entry(': 'resource link_identifier, resource result_entry_identifier | resource',
\ 'ldap_next_reference(': 'resource link, resource entry | resource',
\ 'ldap_parse_reference(': 'resource link, resource entry, array &referrals | bool',
\ 'ldap_parse_result(': 'resource link, resource result, int &errcode [, string &matcheddn [, string &errmsg [, array &referrals]]] | bool',
\ 'ldap_read(': 'resource link_identifier, string base_dn, string filter [, array attributes [, int attrsonly [, int sizelimit [, int timelimit [, int deref]]]]] | resource',
\ 'ldap_rename(': 'resource link_identifier, string dn, string newrdn, string newparent, bool deleteoldrdn | bool',
\ 'ldap_sasl_bind(': 'resource link | bool',
\ 'ldap_search(': 'resource link_identifier, string base_dn, string filter [, array attributes [, int attrsonly [, int sizelimit [, int timelimit [, int deref]]]]] | resource',
\ 'ldap_set_option(': 'resource link_identifier, int option, mixed newval | bool',
\ 'ldap_set_rebind_proc(': 'resource link, callback callback | bool',
\ 'ldap_sort(': 'resource link, resource result, string sortfilter | bool',
\ 'ldap_start_tls(': 'resource link | bool',
\ 'ldap_t61_to_8859(': 'string value | string',
\ 'ldap_unbind(': 'resource link_identifier | bool',
\ 'levenshtein(': 'string str1, string str2 [, int cost_ins [, int cost_rep, int cost_del]] | int',
\ 'libxml_clear_errors(': 'void  | void',
\ 'libxml_get_errors(': 'void  | array',
\ 'libxml_get_last_error(': 'void  | LibXMLError',
\ 'libxml_set_streams_context(': 'resource streams_context | void',
\ 'libxml_use_internal_errors(': '[bool use_errors] | bool',
\ 'link(': 'string target, string link | bool',
\ 'linkinfo(': 'string path | int',
\ 'list(': 'mixed varname, mixed ... | void',
\ 'localeconv(': 'void  | array',
\ 'localtime(': '[int timestamp [, bool is_associative]] | array',
\ 'log(': 'float arg [, float base] | float',
\ 'log10(': 'float arg | float',
\ 'log1p(': 'float number | float',
\ 'long2ip(': 'int proper_address | string',
\ 'lstat(': 'string filename | array',
\ 'ltrim(': 'string str [, string charlist] | string',
\ 'lzf_compress(': 'string data | string',
\ 'lzf_decompress(': 'string data | string',
\ 'lzf_optimized_for(': 'void  | int',
\ 'mail(': 'string to, string subject, string message [, string additional_headers [, string additional_parameters]] | bool',
\ 'mailparse_determine_best_xfer_encoding(': 'resource fp | int',
\ 'mailparse_msg_create(': 'void  | int',
\ 'mailparse_msg_extract_part(': 'resource rfc2045, string msgbody [, callback callbackfunc] | void',
\ 'mailparse_msg_extract_part_file(': 'resource rfc2045, string filename [, callback callbackfunc] | string',
\ 'mailparse_msg_free(': 'resource rfc2045buf | void',
\ 'mailparse_msg_get_part(': 'resource rfc2045, string mimesection | int',
\ 'mailparse_msg_get_part_data(': 'resource rfc2045 | array',
\ 'mailparse_msg_get_structure(': 'resource rfc2045 | array',
\ 'mailparse_msg_parse(': 'resource rfc2045buf, string data | void',
\ 'mailparse_msg_parse_file(': 'string filename | resource',
\ 'mailparse_rfc822_parse_addresses(': 'string addresses | array',
\ 'mailparse_stream_encode(': 'resource sourcefp, resource destfp, string encoding | bool',
\ 'mailparse_uudecode_all(': 'resource fp | array',
\ 'max(': 'number arg1, number arg2 [, number ...] | mixed',
\ 'maxdb_affected_rows(': 'resource link | mixed',
\ 'maxdb_autocommit(': 'resource link, bool mode | bool',
\ 'maxdb_change_user(': 'resource link, string user, string password, string database | bool',
\ 'maxdb_character_set_name(': 'resource link | string',
\ 'maxdb_close(': 'resource link | bool',
\ 'maxdb_commit(': 'resource link | bool',
\ 'maxdb_connect(': '[string host [, string username [, string passwd [, string dbname [, int port [, string socket]]]]]] | resource',
\ 'maxdb_connect_errno(': 'void  | int',
\ 'maxdb_connect_error(': 'void  | string',
\ 'maxdb_data_seek(': 'resource result, int offset | bool',
\ 'maxdb_debug(': 'string debug | void',
\ 'maxdb_disable_reads_from_master(': 'resource link | void',
\ 'maxdb_disable_rpl_parse(': 'resource link | void',
\ 'maxdb_dump_debug_info(': 'resource link | bool',
\ 'maxdb_embedded_connect(': '[string dbname] | resource',
\ 'maxdb_enable_reads_from_master(': 'resource link | void',
\ 'maxdb_enable_rpl_parse(': 'resource link | void',
\ 'maxdb_errno(': 'resource link | int',
\ 'maxdb_error(': 'resource link | string',
\ 'maxdb_fetch_array(': 'resource result [, int resulttype] | mixed',
\ 'maxdb_fetch_assoc(': 'resource result | array',
\ 'maxdb_fetch_field(': 'resource result | mixed',
\ 'maxdb_fetch_field_direct(': 'resource result, int fieldnr | mixed',
\ 'maxdb_fetch_fields(': 'resource result | mixed',
\ 'maxdb_fetch_lengths(': 'resource result | mixed',
\ 'maxdb_fetch_object(': 'object result | mixed',
\ 'maxdb_fetch_row(': 'resource result | mixed',
\ 'maxdb_field_count(': 'object link | int',
\ 'maxdb_field_seek(': 'object result, int fieldnr | int',
\ 'maxdb_field_tell(': 'resource result | int',
\ 'maxdb_free_result(': 'resource result | void',
\ 'maxdb_get_client_info(': 'void  | string',
\ 'maxdb_get_client_version(': 'void  | int',
\ 'maxdb_get_host_info(': 'resource link | string',
\ 'maxdb_get_proto_info(': 'resource link | int',
\ 'maxdb_get_server_info(': 'resource link | string',
\ 'maxdb_get_server_version(': 'resource link | int',
\ 'maxdb_info(': 'resource link | string',
\ 'maxdb_init(': 'void  | resource',
\ 'maxdb_insert_id(': 'resource link | mixed',
\ 'maxdb_kill(': 'resource link, int processid | bool',
\ 'maxdb_master_query(': 'resource link, string query | bool',
\ 'maxdb_more_results(': 'resource link | bool',
\ 'maxdb_multi_query(': 'resource link, string query | bool',
\ 'maxdb_next_result(': 'resource link | bool',
\ 'maxdb_num_fields(': 'resource result | int',
\ 'maxdb_num_rows(': 'resource result | mixed',
\ 'maxdb_options(': 'resource link, int option, mixed value | bool',
\ 'maxdb_ping(': 'resource link | bool',
\ 'maxdb_prepare(': 'resource link, string query | mixed',
\ 'maxdb_query(': 'resource link, string query [, int resultmode] | mixed',
\ 'maxdb_real_connect(': 'resource link [, string hostname [, string username [, string passwd [, string dbname [, int port [, string socket]]]]]] | bool',
\ 'maxdb_real_escape_string(': 'resource link, string escapestr | string',
\ 'maxdb_real_query(': 'resource link, string query | bool',
\ 'maxdb_report(': 'int flags | bool',
\ 'maxdb_rollback(': 'resource link | bool',
\ 'maxdb_rpl_parse_enabled(': 'resource link | int',
\ 'maxdb_rpl_probe(': 'resource link | bool',
\ 'maxdb_rpl_query_type(': 'string query | int',
\ 'maxdb_select_db(': 'resource link, string dbname | bool',
\ 'maxdb_send_query(': 'resource link, string query | bool',
\ 'maxdb_server_end(': 'void  | void',
\ 'maxdb_server_init(': '[array server [, array groups]] | bool',
\ 'maxdb_sqlstate(': 'resource link | string',
\ 'maxdb_ssl_set(': 'resource link [, string key [, string cert [, string ca [, string capath [, string cipher]]]]] | bool',
\ 'maxdb_stat(': 'resource link | mixed',
\ 'maxdb_stmt_affected_rows(': 'resource stmt | mixed',
\ 'maxdb_stmt_bind_param(': 'resource stmt, string types, mixed &var1 [, mixed &...] | bool',
\ 'maxdb_stmt_bind_result(': 'resource stmt, mixed &var1 [, mixed &...] | bool',
\ 'maxdb_stmt_close(': 'resource stmt | bool',
\ 'maxdb_stmt_data_seek(': 'resource statement, int offset | bool',
\ 'maxdb_stmt_errno(': 'resource stmt | int',
\ 'maxdb_stmt_error(': 'resource stmt | string',
\ 'maxdb_stmt_execute(': 'resource stmt | bool',
\ 'maxdb_stmt_fetch(': 'resource stmt | mixed',
\ 'maxdb_stmt_free_result(': 'resource stmt | void',
\ 'maxdb_stmt_init(': 'resource link | resource',
\ 'maxdb_stmt_num_rows(': 'resource stmt | mixed',
\ 'maxdb_stmt_param_count(': 'resource stmt | int',
\ 'maxdb_stmt_prepare(': 'resource stmt, string query | bool',
\ 'maxdb_stmt_reset(': 'resource stmt | bool',
\ 'maxdb_stmt_result_metadata(': 'resource stmt | mixed',
\ 'maxdb_stmt_send_long_data(': 'resource stmt, int param_nr [, string data] | bool',
\ 'maxdb_stmt_sqlstate(': 'resource stmt | string',
\ 'maxdb_stmt_store_result(': 'resource stmt | bool',
\ 'maxdb_store_result(': 'resource link | resource',
\ 'maxdb_thread_id(': 'resource link | int',
\ 'maxdb_thread_safe(': 'void  | bool',
\ 'maxdb_use_result(': 'resource link | mixed',
\ 'maxdb_warning_count(': 'resource link | int',
\ 'mb_convert_case(': 'string str, int mode [, string encoding] | string',
\ 'mb_convert_encoding(': 'string str, string to_encoding [, mixed from_encoding] | string',
\ 'mb_convert_kana(': 'string str [, string option [, string encoding]] | string',
\ 'mb_convert_variables(': 'string to_encoding, mixed from_encoding, mixed &vars [, mixed &...] | string',
\ 'mb_decode_mimeheader(': 'string str | string',
\ 'mb_decode_numericentity(': 'string str, array convmap [, string encoding] | string',
\ 'mb_detect_encoding(': 'string str [, mixed encoding_list [, bool strict]] | string',
\ 'mb_detect_order(': '[mixed encoding_list] | array',
\ 'mb_encode_mimeheader(': 'string str [, string charset [, string transfer_encoding [, string linefeed]]] | string',
\ 'mb_encode_numericentity(': 'string str, array convmap [, string encoding] | string',
\ 'mb_ereg(': 'string pattern, string string [, array regs] | int',
\ 'mb_eregi(': 'string pattern, string string [, array regs] | int',
\ 'mb_eregi_replace(': 'string pattern, string replace, string string | string',
\ 'mb_ereg_match(': 'string pattern, string string [, string option] | bool',
\ 'mb_ereg_replace(': 'string pattern, string replacement, string string [, array option] | string',
\ 'mb_ereg_search(': '[string pattern [, string option]] | bool',
\ 'mb_ereg_search_getpos(': 'void  | array',
\ 'mb_ereg_search_getregs(': 'void  | array',
\ 'mb_ereg_search_init(': 'string string [, string pattern [, string option]] | array',
\ 'mb_ereg_search_pos(': '[string pattern [, string option]] | array',
\ 'mb_ereg_search_regs(': '[string pattern [, string option]] | array',
\ 'mb_ereg_search_setpos(': 'int position | array',
\ 'mb_get_info(': '[string type] | string',
\ 'mb_http_input(': '[string type] | string',
\ 'mb_http_output(': '[string encoding] | string',
\ 'mb_internal_encoding(': '[string encoding] | mixed',
\ 'mb_language(': '[string language] | string',
\ 'mb_list_encodings(': 'void  | array',
\ 'mb_output_handler(': 'string contents, int status | string',
\ 'mb_parse_str(': 'string encoded_string [, array &result] | bool',
\ 'mb_preferred_mime_name(': 'string encoding | string',
\ 'mb_regex_encoding(': '[string encoding] | string',
\ 'mb_regex_set_options(': '[string options] | string',
\ 'mb_send_mail(': 'string to, string subject, string message [, string additional_headers [, string additional_parameter]] | bool',
\ 'mb_split(': 'string pattern, string string [, int limit] | array',
\ 'mb_strcut(': 'string str, int start [, int length [, string encoding]] | string',
\ 'mb_strimwidth(': 'string str, int start, int width [, string trimmarker [, string encoding]] | string',
\ 'mb_strlen(': 'string str [, string encoding] | string',
\ 'mb_strpos(': 'string haystack, string needle [, int offset [, string encoding]] | int',
\ 'mb_strrpos(': 'string haystack, string needle [, string encoding] | int',
\ 'mb_strtolower(': 'string str [, string encoding] | string',
\ 'mb_strtoupper(': 'string str [, string encoding] | string',
\ 'mb_strwidth(': 'string str [, string encoding] | int',
\ 'mb_substitute_character(': '[mixed substrchar] | mixed',
\ 'mb_substr(': 'string str, int start [, int length [, string encoding]] | string',
\ 'mb_substr_count(': 'string haystack, string needle [, string encoding] | int',
\ 'mcal_append_event(': 'int mcal_stream | int',
\ 'mcal_close(': 'int mcal_stream [, int flags] | int',
\ 'mcal_create_calendar(': 'int stream, string calendar | bool',
\ 'mcal_date_compare(': 'int a_year, int a_month, int a_day, int b_year, int b_month, int b_day | int',
\ 'mcal_date_valid(': 'int year, int month, int day | int',
\ 'mcal_day_of_week(': 'int year, int month, int day | int',
\ 'mcal_day_of_year(': 'int year, int month, int day | int',
\ 'mcal_days_in_month(': 'int month, int leap_year | int',
\ 'mcal_delete_calendar(': 'int stream, string calendar | string',
\ 'mcal_delete_event(': 'int mcal_stream, int event_id | int',
\ 'mcal_event_add_attribute(': 'int stream, string attribute, string value | void',
\ 'mcal_event_init(': 'int stream | int',
\ 'mcal_event_set_alarm(': 'int stream, int alarm | int',
\ 'mcal_event_set_category(': 'int stream, string category | int',
\ 'mcal_event_set_class(': 'int stream, int class | int',
\ 'mcal_event_set_description(': 'int stream, string description | int',
\ 'mcal_event_set_end(': 'int stream, int year, int month, int day [, int hour [, int min [, int sec]]] | int',
\ 'mcal_event_set_recur_daily(': 'int stream, int year, int month, int day, int interval | int',
\ 'mcal_event_set_recur_monthly_mday(': 'int stream, int year, int month, int day, int interval | int',
\ 'mcal_event_set_recur_monthly_wday(': 'int stream, int year, int month, int day, int interval | int',
\ 'mcal_event_set_recur_none(': 'int stream | int',
\ 'mcal_event_set_recur_weekly(': 'int stream, int year, int month, int day, int interval, int weekdays | int',
\ 'mcal_event_set_recur_yearly(': 'int stream, int year, int month, int day, int interval | int',
\ 'mcal_event_set_start(': 'int stream, int year, int month, int day [, int hour [, int min [, int sec]]] | int',
\ 'mcal_event_set_title(': 'int stream, string title | int',
\ 'mcal_expunge(': 'int stream | int',
\ 'mcal_fetch_current_stream_event(': 'int stream | object',
\ 'mcal_fetch_event(': 'int mcal_stream, int event_id [, int options] | object',
\ 'mcal_is_leap_year(': 'int year | int',
\ 'mcal_list_alarms(': 'int mcal_stream [, int begin_year, int begin_month, int begin_day, int end_year, int end_month, int end_day] | array',
\ 'mcal_list_events(': 'int mcal_stream [, int begin_year, int begin_month, int begin_day, int end_year, int end_month, int end_day] | array',
\ 'mcal_next_recurrence(': 'int stream, int weekstart, array next | int',
\ 'mcal_open(': 'string calendar, string username, string password [, int options] | int',
\ 'mcal_popen(': 'string calendar, string username, string password [, int options] | int',
\ 'mcal_rename_calendar(': 'int stream, string old_name, string new_name | string',
\ 'mcal_reopen(': 'int mcal_stream, string calendar [, int options] | int',
\ 'mcal_snooze(': 'int stream_id, int event_id | bool',
\ 'mcal_store_event(': 'int mcal_stream | int',
\ 'mcal_time_valid(': 'int hour, int minutes, int seconds | int',
\ 'mcal_week_of_year(': 'int day, int month, int year | int',
\ 'mcrypt_cbc(': 'int cipher, string key, string data, int mode [, string iv] | string',
\ 'mcrypt_cfb(': 'int cipher, string key, string data, int mode, string iv | string',
\ 'mcrypt_create_iv(': 'int size [, int source] | string',
\ 'mcrypt_decrypt(': 'string cipher, string key, string data, string mode [, string iv] | string',
\ 'mcrypt_ecb(': 'int cipher, string key, string data, int mode | string',
\ 'mcrypt_enc_get_algorithms_name(': 'resource td | string',
\ 'mcrypt_enc_get_block_size(': 'resource td | int',
\ 'mcrypt_enc_get_iv_size(': 'resource td | int',
\ 'mcrypt_enc_get_key_size(': 'resource td | int',
\ 'mcrypt_enc_get_modes_name(': 'resource td | string',
\ 'mcrypt_enc_get_supported_key_sizes(': 'resource td | array',
\ 'mcrypt_enc_is_block_algorithm(': 'resource td | bool',
\ 'mcrypt_enc_is_block_algorithm_mode(': 'resource td | bool',
\ 'mcrypt_enc_is_block_mode(': 'resource td | bool',
\ 'mcrypt_encrypt(': 'string cipher, string key, string data, string mode [, string iv] | string',
\ 'mcrypt_enc_self_test(': 'resource td | bool',
\ 'mcrypt_generic(': 'resource td, string data | string',
\ 'mcrypt_generic_deinit(': 'resource td | bool',
\ 'mcrypt_generic_end(': 'resource td | bool',
\ 'mcrypt_generic_init(': 'resource td, string key, string iv | int',
\ 'mcrypt_get_block_size(': 'int cipher | int',
\ 'mcrypt_get_cipher_name(': 'int cipher | string',
\ 'mcrypt_get_iv_size(': 'string cipher, string mode | int',
\ 'mcrypt_get_key_size(': 'int cipher | int',
\ 'mcrypt_list_algorithms(': '[string lib_dir] | array',
\ 'mcrypt_list_modes(': '[string lib_dir] | array',
\ 'mcrypt_module_close(': 'resource td | bool',
\ 'mcrypt_module_get_algo_block_size(': 'string algorithm [, string lib_dir] | int',
\ 'mcrypt_module_get_algo_key_size(': 'string algorithm [, string lib_dir] | int',
\ 'mcrypt_module_get_supported_key_sizes(': 'string algorithm [, string lib_dir] | array',
\ 'mcrypt_module_is_block_algorithm(': 'string algorithm [, string lib_dir] | bool',
\ 'mcrypt_module_is_block_algorithm_mode(': 'string mode [, string lib_dir] | bool',
\ 'mcrypt_module_is_block_mode(': 'string mode [, string lib_dir] | bool',
\ 'mcrypt_module_open(': 'string algorithm, string algorithm_directory, string mode, string mode_directory | resource',
\ 'mcrypt_module_self_test(': 'string algorithm [, string lib_dir] | bool',
\ 'mcrypt_ofb(': 'int cipher, string key, string data, int mode, string iv | string',
\ 'mcve_adduser(': 'resource conn, string admin_password, int usersetup | int',
\ 'mcve_adduserarg(': 'resource usersetup, int argtype, string argval | int',
\ 'mcve_bt(': 'resource conn, string username, string password | int',
\ 'mcve_checkstatus(': 'resource conn, int identifier | int',
\ 'mcve_chkpwd(': 'resource conn, string username, string password | int',
\ 'mcve_chngpwd(': 'resource conn, string admin_password, string new_password | int',
\ 'mcve_completeauthorizations(': 'resource conn, int &array | int',
\ 'mcve_connect(': 'resource conn | int',
\ 'mcve_connectionerror(': 'resource conn | string',
\ 'mcve_deleteresponse(': 'resource conn, int identifier | bool',
\ 'mcve_deletetrans(': 'resource conn, int identifier | bool',
\ 'mcve_deleteusersetup(': 'resource usersetup | void',
\ 'mcve_deluser(': 'resource conn, string admin_password, string username | int',
\ 'mcve_destroyconn(': 'resource conn | void',
\ 'mcve_destroyengine(': 'void  | void',
\ 'mcve_disableuser(': 'resource conn, string admin_password, string username | int',
\ 'mcve_edituser(': 'resource conn, string admin_password, int usersetup | int',
\ 'mcve_enableuser(': 'resource conn, string admin_password, string username | int',
\ 'mcve_force(': 'resource conn, string username, string password, string trackdata, string account, string expdate, float amount, string authcode, string comments, string clerkid, string stationid, int ptrannum | int',
\ 'mcve_getcell(': 'resource conn, int identifier, string column, int row | string',
\ 'mcve_getcellbynum(': 'resource conn, int identifier, int column, int row | string',
\ 'mcve_getcommadelimited(': 'resource conn, int identifier | string',
\ 'mcve_getheader(': 'resource conn, int identifier, int column_num | string',
\ 'mcve_getuserarg(': 'resource usersetup, int argtype | string',
\ 'mcve_getuserparam(': 'resource conn, int identifier, int key | string',
\ 'mcve_gft(': 'resource conn, string username, string password, int type, string account, string clerkid, string stationid, string comments, int ptrannum, string startdate, string enddate | int',
\ 'mcve_gl(': 'int conn, string username, string password, int type, string account, string batch, string clerkid, string stationid, string comments, int ptrannum, string startdate, string enddate | int',
\ 'mcve_gut(': 'resource conn, string username, string password, int type, string account, string clerkid, string stationid, string comments, int ptrannum, string startdate, string enddate | int',
\ 'mcve_initconn(': 'void  | resource',
\ 'mcve_initengine(': 'string location | int',
\ 'mcve_initusersetup(': 'void  | resource',
\ 'mcve_iscommadelimited(': 'resource conn, int identifier | int',
\ 'mcve_liststats(': 'resource conn, string admin_password | int',
\ 'mcve_listusers(': 'resource conn, string admin_password | int',
\ 'mcve_maxconntimeout(': 'resource conn, int secs | bool',
\ 'mcve_monitor(': 'resource conn | int',
\ 'mcve_numcolumns(': 'resource conn, int identifier | int',
\ 'mcve_numrows(': 'resource conn, int identifier | int',
\ 'mcve_override(': 'resource conn, string username, string password, string trackdata, string account, string expdate, float amount, string street, string zip, string cv, string comments, string clerkid, string stationid, int ptrannum | int',
\ 'mcve_parsecommadelimited(': 'resource conn, int identifier | int',
\ 'mcve_ping(': 'resource conn | int',
\ 'mcve_preauth(': 'resource conn, string username, string password, string trackdata, string account, string expdate, float amount, string street, string zip, string cv, string comments, string clerkid, string stationid, int ptrannum | int',
\ 'mcve_preauthcompletion(': 'resource conn, string username, string password, float finalamount, int sid, int ptrannum | int',
\ 'mcve_qc(': 'resource conn, string username, string password, string clerkid, string stationid, string comments, int ptrannum | int',
\ 'mcve_responseparam(': 'resource conn, int identifier, string key | string',
\ 'mcve_return(': 'int conn, string username, string password, string trackdata, string account, string expdate, float amount, string comments, string clerkid, string stationid, int ptrannum | int',
\ 'mcve_returncode(': 'resource conn, int identifier | int',
\ 'mcve_returnstatus(': 'resource conn, int identifier | int',
\ 'mcve_sale(': 'resource conn, string username, string password, string trackdata, string account, string expdate, float amount, string street, string zip, string cv, string comments, string clerkid, string stationid, int ptrannum | int',
\ 'mcve_setblocking(': 'resource conn, int tf | int',
\ 'mcve_setdropfile(': 'resource conn, string directory | int',
\ 'mcve_setip(': 'resource conn, string host, int port | int',
\ 'mcve_setssl(': 'resource conn, string host, int port | int',
\ 'mcve_setssl_files(': 'string sslkeyfile, string sslcertfile | int',
\ 'mcve_settimeout(': 'resource conn, int seconds | int',
\ 'mcve_settle(': 'resource conn, string username, string password, string batch | int',
\ 'mcve_text_avs(': 'string code | string',
\ 'mcve_text_code(': 'string code | string',
\ 'mcve_text_cv(': 'int code | string',
\ 'mcve_transactionauth(': 'resource conn, int identifier | string',
\ 'mcve_transactionavs(': 'resource conn, int identifier | int',
\ 'mcve_transactionbatch(': 'resource conn, int identifier | int',
\ 'mcve_transactioncv(': 'resource conn, int identifier | int',
\ 'mcve_transactionid(': 'resource conn, int identifier | int',
\ 'mcve_transactionitem(': 'resource conn, int identifier | int',
\ 'mcve_transactionssent(': 'resource conn | int',
\ 'mcve_transactiontext(': 'resource conn, int identifier | string',
\ 'mcve_transinqueue(': 'resource conn | int',
\ 'mcve_transnew(': 'resource conn | int',
\ 'mcve_transparam(': 'resource conn, int identifier, int key | int',
\ 'mcve_transsend(': 'resource conn, int identifier | int',
\ 'mcve_ub(': 'resource conn, string username, string password | int',
\ 'mcve_uwait(': 'int microsecs | int',
\ 'mcve_verifyconnection(': 'resource conn, int tf | bool',
\ 'mcve_verifysslcert(': 'resource conn, int tf | bool',
\ 'mcve_void(': 'resource conn, string username, string password, int sid, int ptrannum | int',
\ 'md5(': 'string str [, bool raw_output] | string',
\ 'md5_file(': 'string filename [, bool raw_output] | string',
\ 'mdecrypt_generic(': 'resource td, string data | string',
\ 'memcache_debug(': 'int on_off | bool',
\ 'memory_get_usage(': 'void  | int',
\ 'metaphone(': 'string str [, int phones] | string',
\ 'method_exists(': 'object object, string method_name | bool',
\ 'mhash(': 'int hash, string data [, string key] | string',
\ 'mhash_count(': 'void  | int',
\ 'mhash_get_block_size(': 'int hash | int',
\ 'mhash_get_hash_name(': 'int hash | string',
\ 'mhash_keygen_s2k(': 'int hash, string password, string salt, int bytes | string',
\ 'microtime(': '[bool get_as_float] | mixed',
\ 'mime_content_type(': 'string filename | string',
\ 'min(': 'number arg1, number arg2 [, number ...] | mixed',
\ 'ming_setcubicthreshold(': 'int threshold | void',
\ 'ming_setscale(': 'int scale | void',
\ 'ming_useswfversion(': 'int version | void',
\ 'mkdir(': 'string pathname [, int mode [, bool recursive [, resource context]]] | bool',
\ 'mktime(': '[int hour [, int minute [, int second [, int month [, int day [, int year [, int is_dst]]]]]]] | int',
\ 'money_format(': 'string format, float number | string',
\ 'move_uploaded_file(': 'string filename, string destination | bool',
\ 'msession_connect(': 'string host, string port | bool',
\ 'msession_count(': 'void  | int',
\ 'msession_create(': 'string session | bool',
\ 'msession_destroy(': 'string name | bool',
\ 'msession_disconnect(': 'void  | void',
\ 'msession_find(': 'string name, string value | array',
\ 'msession_get(': 'string session, string name, string value | string',
\ 'msession_get_array(': 'string session | array',
\ 'msession_get_data(': 'string session | string',
\ 'msession_inc(': 'string session, string name | string',
\ 'msession_list(': 'void  | array',
\ 'msession_listvar(': 'string name | array',
\ 'msession_lock(': 'string name | int',
\ 'msession_plugin(': 'string session, string val [, string param] | string',
\ 'msession_randstr(': 'int param | string',
\ 'msession_set(': 'string session, string name, string value | bool',
\ 'msession_set_array(': 'string session, array tuples | bool',
\ 'msession_set_data(': 'string session, string value | bool',
\ 'msession_timeout(': 'string session [, int param] | int',
\ 'msession_uniq(': 'int param | string',
\ 'msession_unlock(': 'string session, int key | int',
\ 'msg_get_queue(': 'int key [, int perms] | resource',
\ 'msg_receive(': 'resource queue, int desiredmsgtype, int &msgtype, int maxsize, mixed &message [, bool unserialize [, int flags [, int &errorcode]]] | bool',
\ 'msg_remove_queue(': 'resource queue | bool',
\ 'msg_send(': 'resource queue, int msgtype, mixed message [, bool serialize [, bool blocking [, int &errorcode]]] | bool',
\ 'msg_set_queue(': 'resource queue, array data | bool',
\ 'msg_stat_queue(': 'resource queue | array',
\ 'msql_affected_rows(': 'resource query_identifier | int',
\ 'msql_close(': '[resource link_identifier] | int',
\ 'msql_connect(': '[string hostname] | int',
\ 'msql_create_db(': 'string database_name [, resource link_identifier] | bool',
\ 'msql_data_seek(': 'resource query_identifier, int row_number | bool',
\ 'msql_db_query(': 'string database, string query [, resource link_identifier] | resource',
\ 'msql_drop_db(': 'string database_name [, resource link_identifier] | int',
\ 'msql_error(': 'void  | string',
\ 'msql_fetch_array(': 'resource query_identifier [, int result_type] | array',
\ 'msql_fetch_field(': 'resource query_identifier [, int field_offset] | object',
\ 'msql_fetch_object(': 'resource query_identifier [, int result_type] | object',
\ 'msql_fetch_row(': 'resource query_identifier [, int result_type] | array',
\ 'msql_field_flags(': 'resource query_identifier, int field_offset | string',
\ 'msql_field_len(': 'resource query_identifier, int field_offset | int',
\ 'msql_field_name(': 'resource query_identifier, int field | string',
\ 'msql_field_seek(': 'int query_identifier, int field_offset | int',
\ 'msql_field_table(': 'int query_identifier, int field | int',
\ 'msql_field_type(': 'resource query_identifier, int field_offset | string',
\ 'msql_free_result(': 'resource query_identifier | int',
\ 'msql_list_dbs(': '[resource link_identifier] | resource',
\ 'msql_list_fields(': 'string database, string tablename [, resource link_identifier] | resource',
\ 'msql_list_tables(': 'string database [, resource link_identifier] | resource',
\ 'msql_num_fields(': 'resource query_identifier | int',
\ 'msql_num_rows(': 'resource query_identifier | int',
\ 'msql_pconnect(': '[string server [, string username [, string password]]] | int',
\ 'msql_query(': 'string query [, resource link_identifier] | resource',
\ 'msql_result(': 'resource query_identifier, int row [, mixed field] | string',
\ 'msql_select_db(': 'string database_name [, resource link_identifier] | bool',
\ 'mssql_bind(': 'resource stmt, string param_name, mixed &var, int type [, int is_output [, int is_null [, int maxlen]]] | bool',
\ 'mssql_close(': '[resource link_identifier] | bool',
\ 'mssql_connect(': '[string servername [, string username [, string password]]] | int',
\ 'mssql_data_seek(': 'resource result_identifier, int row_number | bool',
\ 'mssql_execute(': 'resource stmt [, bool skip_results] | mixed',
\ 'mssql_fetch_array(': 'resource result [, int result_type] | array',
\ 'mssql_fetch_assoc(': 'resource result_id | array',
\ 'mssql_fetch_batch(': 'resource result_index | int',
\ 'mssql_fetch_field(': 'resource result [, int field_offset] | object',
\ 'mssql_fetch_object(': 'resource result | object',
\ 'mssql_fetch_row(': 'resource result | array',
\ 'mssql_field_length(': 'resource result [, int offset] | int',
\ 'mssql_field_name(': 'resource result [, int offset] | string',
\ 'mssql_field_seek(': 'resource result, int field_offset | bool',
\ 'mssql_field_type(': 'resource result [, int offset] | string',
\ 'mssql_free_result(': 'resource result | bool',
\ 'mssql_free_statement(': 'resource statement | bool',
\ 'mssql_get_last_message(': 'void  | string',
\ 'mssql_guid_string(': 'string binary [, int short_format] | string',
\ 'mssql_init(': 'string sp_name [, resource conn_id] | int',
\ 'mssql_min_error_severity(': 'int severity | void',
\ 'mssql_min_message_severity(': 'int severity | void',
\ 'mssql_next_result(': 'resource result_id | bool',
\ 'mssql_num_fields(': 'resource result | int',
\ 'mssql_num_rows(': 'resource result | int',
\ 'mssql_pconnect(': '[string servername [, string username [, string password]]] | int',
\ 'mssql_query(': 'string query [, resource link_identifier [, int batch_size]] | resource',
\ 'mssql_result(': 'resource result, int row, mixed field | string',
\ 'mssql_rows_affected(': 'resource conn_id | int',
\ 'mssql_select_db(': 'string database_name [, resource link_identifier] | bool',
\ 'mt_getrandmax(': 'void  | int',
\ 'mt_rand(': '[int min, int max] | int',
\ 'mt_srand(': '[int seed] | void',
\ 'muscat_close(': 'resource muscat_handle | int',
\ 'muscat_get(': 'resource muscat_handle | string',
\ 'muscat_give(': 'resource muscat_handle, string string | int',
\ 'muscat_setup(': 'int size [, string muscat_dir] | resource',
\ 'muscat_setup_net(': 'string muscat_host | resource',
\ 'mysql_affected_rows(': '[resource link_identifier] | int',
\ 'mysql_change_user(': 'string user, string password [, string database [, resource link_identifier]] | int',
\ 'mysql_client_encoding(': '[resource link_identifier] | string',
\ 'mysql_close(': '[resource link_identifier] | bool',
\ 'mysql_connect(': '[string server [, string username [, string password [, bool new_link [, int client_flags]]]]] | resource',
\ 'mysql_create_db(': 'string database_name [, resource link_identifier] | bool',
\ 'mysql_data_seek(': 'resource result, int row_number | bool',
\ 'mysql_db_name(': 'resource result, int row [, mixed field] | string',
\ 'mysql_db_query(': 'string database, string query [, resource link_identifier] | resource',
\ 'mysql_drop_db(': 'string database_name [, resource link_identifier] | bool',
\ 'mysql_errno(': '[resource link_identifier] | int',
\ 'mysql_error(': '[resource link_identifier] | string',
\ 'mysql_escape_string(': 'string unescaped_string | string',
\ 'mysql_fetch_array(': 'resource result [, int result_type] | array',
\ 'mysql_fetch_assoc(': 'resource result | array',
\ 'mysql_fetch_field(': 'resource result [, int field_offset] | object',
\ 'mysql_fetch_lengths(': 'resource result | array',
\ 'mysql_fetch_object(': 'resource result | object',
\ 'mysql_fetch_row(': 'resource result | array',
\ 'mysql_field_flags(': 'resource result, int field_offset | string',
\ 'mysql_field_len(': 'resource result, int field_offset | int',
\ 'mysql_field_name(': 'resource result, int field_offset | string',
\ 'mysql_field_seek(': 'resource result, int field_offset | int',
\ 'mysql_field_table(': 'resource result, int field_offset | string',
\ 'mysql_field_type(': 'resource result, int field_offset | string',
\ 'mysql_free_result(': 'resource result | bool',
\ 'mysql_get_client_info(': 'void  | string',
\ 'mysql_get_host_info(': '[resource link_identifier] | string',
\ 'mysql_get_proto_info(': '[resource link_identifier] | int',
\ 'mysql_get_server_info(': '[resource link_identifier] | string',
\ 'mysqli_affected_rows(': 'mysqli link | mixed',
\ 'mysqli_autocommit(': 'mysqli link, bool mode | bool',
\ 'mysqli_change_user(': 'mysqli link, string user, string password, string database | bool',
\ 'mysqli_character_set_name(': 'mysqli link | string',
\ 'mysqli_close(': 'mysqli link | bool',
\ 'mysqli_commit(': 'mysqli link | bool',
\ 'mysqli_connect(': '[string host [, string username [, string passwd [, string dbname [, int port [, string socket]]]]]] | mysqli',
\ 'mysqli_connect_errno(': 'void  | int',
\ 'mysqli_connect_error(': 'void  | string',
\ 'mysqli_data_seek(': 'mysqli_result result, int offset | bool',
\ 'mysqli_debug(': 'string debug | void',
\ 'mysqli_disable_reads_from_master(': 'mysqli link | void',
\ 'mysqli_disable_rpl_parse(': 'mysqli link | void',
\ 'mysqli_dump_debug_info(': 'mysqli link | bool',
\ 'mysqli_embedded_connect(': '[string dbname] | mysqli',
\ 'mysqli_enable_reads_from_master(': 'mysqli link | void',
\ 'mysqli_enable_rpl_parse(': 'mysqli link | void',
\ 'mysqli_errno(': 'mysqli link | int',
\ 'mysqli_error(': 'mysqli link | string',
\ 'mysqli_fetch_array(': 'mysqli_result result [, int resulttype] | mixed',
\ 'mysqli_fetch_assoc(': 'mysqli_result result | array',
\ 'mysqli_fetch_field(': 'mysqli_result result | mixed',
\ 'mysqli_fetch_field_direct(': 'mysqli_result result, int fieldnr | mixed',
\ 'mysqli_fetch_fields(': 'mysqli_result result | mixed',
\ 'mysqli_fetch_lengths(': 'mysqli_result result | mixed',
\ 'mysqli_fetch_object(': 'mysqli_result result | mixed',
\ 'mysqli_fetch_row(': 'mysqli_result result | mixed',
\ 'mysqli_field_count(': 'mysqli link | int',
\ 'mysqli_field_seek(': 'mysqli_result result, int fieldnr | int',
\ 'mysqli_field_tell(': 'mysqli_result result | int',
\ 'mysqli_free_result(': 'mysqli_result result | void',
\ 'mysqli_get_client_info(': 'void  | string',
\ 'mysqli_get_client_version(': 'void  | int',
\ 'mysqli_get_host_info(': 'mysqli link | string',
\ 'mysqli_get_proto_info(': 'mysqli link | int',
\ 'mysqli_get_server_info(': 'mysqli link | string',
\ 'mysqli_get_server_version(': 'mysqli link | int',
\ 'mysqli_info(': 'mysqli link | string',
\ 'mysqli_init(': 'void  | mysqli',
\ 'mysqli_insert_id(': 'mysqli link | mixed',
\ 'mysqli_kill(': 'mysqli link, int processid | bool',
\ 'mysqli_master_query(': 'mysqli link, string query | bool',
\ 'mysqli_more_results(': 'mysqli link | bool',
\ 'mysqli_multi_query(': 'mysqli link, string query | bool',
\ 'mysqli_next_result(': 'mysqli link | bool',
\ 'mysql_info(': '[resource link_identifier] | string',
\ 'mysql_insert_id(': '[resource link_identifier] | int',
\ 'mysqli_num_fields(': 'mysqli_result result | int',
\ 'mysqli_num_rows(': 'mysqli result | mixed',
\ 'mysqli_options(': 'mysqli link, int option, mixed value | bool',
\ 'mysqli_ping(': 'mysqli link | bool',
\ 'mysqli_prepare(': 'mysqli link, string query | mixed',
\ 'mysqli_query(': 'mysqli link, string query [, int resultmode] | mixed',
\ 'mysqli_real_connect(': 'mysqli link [, string hostname [, string username [, string passwd [, string dbname [, int port [, string socket [, int flags]]]]]]] | bool',
\ 'mysqli_real_escape_string(': 'mysqli link, string escapestr | string',
\ 'mysqli_real_query(': 'mysqli link, string query | bool',
\ 'mysqli_report(': 'int flags | bool',
\ 'mysqli_rollback(': 'mysqli link | bool',
\ 'mysqli_rpl_parse_enabled(': 'mysqli link | int',
\ 'mysqli_rpl_probe(': 'mysqli link | bool',
\ 'mysqli_rpl_query_type(': 'mysqli link, string query | int',
\ 'mysqli_select_db(': 'mysqli link, string dbname | bool',
\ 'mysqli_send_query(': 'mysqli link, string query | bool',
\ 'mysqli_server_end(': 'void  | void',
\ 'mysqli_server_init(': '[array server [, array groups]] | bool',
\ 'mysqli_sqlstate(': 'mysqli link | string',
\ 'mysqli_ssl_set(': 'mysqli link, string key, string cert, string ca, string capath, string cipher | bool',
\ 'mysqli_stat(': 'mysqli link | mixed',
\ 'mysqli_stmt_affected_rows(': 'mysqli_stmt stmt | mixed',
\ 'mysqli_stmt_bind_param(': 'mysqli_stmt stmt, string types, mixed &var1 [, mixed &...] | bool',
\ 'mysqli_stmt_bind_result(': 'mysqli_stmt stmt, mixed &var1 [, mixed &...] | bool',
\ 'mysqli_stmt_close(': 'mysqli_stmt stmt | bool',
\ 'mysqli_stmt_data_seek(': 'mysqli_stmt statement, int offset | bool',
\ 'mysqli_stmt_errno(': 'mysqli_stmt stmt | int',
\ 'mysqli_stmt_error(': 'mysqli_stmt stmt | string',
\ 'mysqli_stmt_execute(': 'mysqli_stmt stmt | bool',
\ 'mysqli_stmt_fetch(': 'mysqli_stmt stmt | mixed',
\ 'mysqli_stmt_free_result(': 'mysqli_stmt stmt | void',
\ 'mysqli_stmt_init(': 'mysqli link | mysqli_stmt',
\ 'mysqli_stmt_num_rows(': 'mysqli_stmt stmt | mixed',
\ 'mysqli_stmt_param_count(': 'mysqli_stmt stmt | int',
\ 'mysqli_stmt_prepare(': 'mysqli_stmt stmt, string query | bool',
\ 'mysqli_stmt_reset(': 'mysqli_stmt stmt | bool',
\ 'mysqli_stmt_result_metadata(': 'mysqli_stmt stmt | mixed',
\ 'mysqli_stmt_send_long_data(': 'mysqli_stmt stmt, int param_nr, string data | bool',
\ 'mysqli_stmt_sqlstate(': 'mysqli_stmt stmt | string',
\ 'mysqli_stmt_store_result(': 'mysqli_stmt stmt | bool',
\ 'mysqli_store_result(': 'mysqli link | mysqli_result',
\ 'mysqli_thread_id(': 'mysqli link | int',
\ 'mysqli_thread_safe(': 'void  | bool',
\ 'mysqli_use_result(': 'mysqli link | mixed',
\ 'mysqli_warning_count(': 'mysqli link | int',
\ 'mysql_list_dbs(': '[resource link_identifier] | resource',
\ 'mysql_list_fields(': 'string database_name, string table_name [, resource link_identifier] | resource',
\ 'mysql_list_processes(': '[resource link_identifier] | resource',
\ 'mysql_list_tables(': 'string database [, resource link_identifier] | resource',
\ 'mysql_num_fields(': 'resource result | int',
\ 'mysql_num_rows(': 'resource result | int',
\ 'mysql_pconnect(': '[string server [, string username [, string password [, int client_flags]]]] | resource',
\ 'mysql_ping(': '[resource link_identifier] | bool',
\ 'mysql_query(': 'string query [, resource link_identifier] | resource',
\ 'mysql_real_escape_string(': 'string unescaped_string [, resource link_identifier] | string',
\ 'mysql_result(': 'resource result, int row [, mixed field] | mixed',
\ 'mysql_select_db(': 'string database_name [, resource link_identifier] | bool',
\ 'mysql_stat(': '[resource link_identifier] | string',
\ 'mysql_tablename(': 'resource result, int i | string',
\ 'mysql_thread_id(': '[resource link_identifier] | int',
\ 'mysql_unbuffered_query(': 'string query [, resource link_identifier] | resource',
\ 'natcasesort(': 'array &array | bool',
\ 'natsort(': 'array &array | bool',
\ 'ncurses_addch(': 'int ch | int',
\ 'ncurses_addchnstr(': 'string s, int n | int',
\ 'ncurses_addchstr(': 'string s | int',
\ 'ncurses_addnstr(': 'string s, int n | int',
\ 'ncurses_addstr(': 'string text | int',
\ 'ncurses_assume_default_colors(': 'int fg, int bg | int',
\ 'ncurses_attroff(': 'int attributes | int',
\ 'ncurses_attron(': 'int attributes | int',
\ 'ncurses_attrset(': 'int attributes | int',
\ 'ncurses_baudrate(': 'void  | int',
\ 'ncurses_beep(': 'void  | int',
\ 'ncurses_bkgd(': 'int attrchar | int',
\ 'ncurses_bkgdset(': 'int attrchar | void',
\ 'ncurses_border(': 'int left, int right, int top, int bottom, int tl_corner, int tr_corner, int bl_corner, int br_corner | int',
\ 'ncurses_bottom_panel(': 'resource panel | int',
\ 'ncurses_can_change_color(': 'void  | bool',
\ 'ncurses_cbreak(': 'void  | bool',
\ 'ncurses_clear(': 'void  | bool',
\ 'ncurses_clrtobot(': 'void  | bool',
\ 'ncurses_clrtoeol(': 'void  | bool',
\ 'ncurses_color_content(': 'int color, int &r, int &g, int &b | int',
\ 'ncurses_color_set(': 'int pair | int',
\ 'ncurses_curs_set(': 'int visibility | int',
\ 'ncurses_define_key(': 'string definition, int keycode | int',
\ 'ncurses_def_prog_mode(': 'void  | bool',
\ 'ncurses_def_shell_mode(': 'void  | bool',
\ 'ncurses_delay_output(': 'int milliseconds | int',
\ 'ncurses_delch(': 'void  | bool',
\ 'ncurses_deleteln(': 'void  | bool',
\ 'ncurses_del_panel(': 'resource panel | int',
\ 'ncurses_delwin(': 'resource window | int',
\ 'ncurses_doupdate(': 'void  | bool',
\ 'ncurses_echo(': 'void  | bool',
\ 'ncurses_echochar(': 'int character | int',
\ 'ncurses_end(': 'void  | int',
\ 'ncurses_erase(': 'void  | bool',
\ 'ncurses_erasechar(': 'void  | string',
\ 'ncurses_filter(': 'void  | int',
\ 'ncurses_flash(': 'void  | bool',
\ 'ncurses_flushinp(': 'void  | bool',
\ 'ncurses_getch(': 'void  | int',
\ 'ncurses_getmaxyx(': 'resource window, int &y, int &x | void',
\ 'ncurses_getmouse(': 'array &mevent | bool',
\ 'ncurses_getyx(': 'resource window, int &y, int &x | void',
\ 'ncurses_halfdelay(': 'int tenth | int',
\ 'ncurses_has_colors(': 'void  | bool',
\ 'ncurses_has_ic(': 'void  | bool',
\ 'ncurses_has_il(': 'void  | bool',
\ 'ncurses_has_key(': 'int keycode | int',
\ 'ncurses_hide_panel(': 'resource panel | int',
\ 'ncurses_hline(': 'int charattr, int n | int',
\ 'ncurses_inch(': 'void  | string',
\ 'ncurses_init(': 'void  | int',
\ 'ncurses_init_color(': 'int color, int r, int g, int b | int',
\ 'ncurses_init_pair(': 'int pair, int fg, int bg | int',
\ 'ncurses_insch(': 'int character | int',
\ 'ncurses_insdelln(': 'int count | int',
\ 'ncurses_insertln(': 'void  | bool',
\ 'ncurses_insstr(': 'string text | int',
\ 'ncurses_instr(': 'string &buffer | int',
\ 'ncurses_isendwin(': 'void  | bool',
\ 'ncurses_keyok(': 'int keycode, bool enable | int',
\ 'ncurses_keypad(': 'resource window, bool bf | int',
\ 'ncurses_killchar(': 'void  | bool',
\ 'ncurses_longname(': 'void  | string',
\ 'ncurses_meta(': 'resource window, bool 8bit | int',
\ 'ncurses_mouseinterval(': 'int milliseconds | int',
\ 'ncurses_mousemask(': 'int newmask, int &oldmask | int',
\ 'ncurses_mouse_trafo(': 'int &y, int &x, bool toscreen | bool',
\ 'ncurses_move(': 'int y, int x | int',
\ 'ncurses_move_panel(': 'resource panel, int startx, int starty | int',
\ 'ncurses_mvaddch(': 'int y, int x, int c | int',
\ 'ncurses_mvaddchnstr(': 'int y, int x, string s, int n | int',
\ 'ncurses_mvaddchstr(': 'int y, int x, string s | int',
\ 'ncurses_mvaddnstr(': 'int y, int x, string s, int n | int',
\ 'ncurses_mvaddstr(': 'int y, int x, string s | int',
\ 'ncurses_mvcur(': 'int old_y, int old_x, int new_y, int new_x | int',
\ 'ncurses_mvdelch(': 'int y, int x | int',
\ 'ncurses_mvgetch(': 'int y, int x | int',
\ 'ncurses_mvhline(': 'int y, int x, int attrchar, int n | int',
\ 'ncurses_mvinch(': 'int y, int x | int',
\ 'ncurses_mvvline(': 'int y, int x, int attrchar, int n | int',
\ 'ncurses_mvwaddstr(': 'resource window, int y, int x, string text | int',
\ 'ncurses_napms(': 'int milliseconds | int',
\ 'ncurses_newpad(': 'int rows, int cols | resource',
\ 'ncurses_new_panel(': 'resource window | resource',
\ 'ncurses_newwin(': 'int rows, int cols, int y, int x | resource',
\ 'ncurses_nl(': 'void  | bool',
\ 'ncurses_nocbreak(': 'void  | bool',
\ 'ncurses_noecho(': 'void  | bool',
\ 'ncurses_nonl(': 'void  | bool',
\ 'ncurses_noqiflush(': 'void  | int',
\ 'ncurses_noraw(': 'void  | bool',
\ 'ncurses_pair_content(': 'int pair, int &f, int &b | int',
\ 'ncurses_panel_above(': 'resource panel | int',
\ 'ncurses_panel_below(': 'resource panel | int',
\ 'ncurses_panel_window(': 'resource panel | int',
\ 'ncurses_pnoutrefresh(': 'resource pad, int pminrow, int pmincol, int sminrow, int smincol, int smaxrow, int smaxcol | int',
\ 'ncurses_prefresh(': 'resource pad, int pminrow, int pmincol, int sminrow, int smincol, int smaxrow, int smaxcol | int',
\ 'ncurses_putp(': 'string text | int',
\ 'ncurses_qiflush(': 'void  | int',
\ 'ncurses_raw(': 'void  | bool',
\ 'ncurses_refresh(': 'int ch | int',
\ 'ncurses_replace_panel(': 'resource panel, resource window | int',
\ 'ncurses_reset_prog_mode(': 'void  | int',
\ 'ncurses_reset_shell_mode(': 'void  | int',
\ 'ncurses_resetty(': 'void  | bool',
\ 'ncurses_savetty(': 'void  | bool',
\ 'ncurses_scr_dump(': 'string filename | int',
\ 'ncurses_scr_init(': 'string filename | int',
\ 'ncurses_scrl(': 'int count | int',
\ 'ncurses_scr_restore(': 'string filename | int',
\ 'ncurses_scr_set(': 'string filename | int',
\ 'ncurses_show_panel(': 'resource panel | int',
\ 'ncurses_slk_attr(': 'void  | bool',
\ 'ncurses_slk_attroff(': 'int intarg | int',
\ 'ncurses_slk_attron(': 'int intarg | int',
\ 'ncurses_slk_attrset(': 'int intarg | int',
\ 'ncurses_slk_clear(': 'void  | bool',
\ 'ncurses_slk_color(': 'int intarg | int',
\ 'ncurses_slk_init(': 'int format | bool',
\ 'ncurses_slk_noutrefresh(': 'void  | bool',
\ 'ncurses_slk_refresh(': 'void  | bool',
\ 'ncurses_slk_restore(': 'void  | bool',
\ 'ncurses_slk_set(': 'int labelnr, string label, int format | bool',
\ 'ncurses_slk_touch(': 'void  | bool',
\ 'ncurses_standend(': 'void  | int',
\ 'ncurses_standout(': 'void  | int',
\ 'ncurses_start_color(': 'void  | int',
\ 'ncurses_termattrs(': 'void  | bool',
\ 'ncurses_termname(': 'void  | string',
\ 'ncurses_timeout(': 'int millisec | void',
\ 'ncurses_top_panel(': 'resource panel | int',
\ 'ncurses_typeahead(': 'int fd | int',
\ 'ncurses_ungetch(': 'int keycode | int',
\ 'ncurses_ungetmouse(': 'array mevent | bool',
\ 'ncurses_update_panels(': 'void  | void',
\ 'ncurses_use_default_colors(': 'void  | bool',
\ 'ncurses_use_env(': 'bool flag | void',
\ 'ncurses_use_extended_names(': 'bool flag | int',
\ 'ncurses_vidattr(': 'int intarg | int',
\ 'ncurses_vline(': 'int charattr, int n | int',
\ 'ncurses_waddch(': 'resource window, int ch | int',
\ 'ncurses_waddstr(': 'resource window, string str [, int n] | int',
\ 'ncurses_wattroff(': 'resource window, int attrs | int',
\ 'ncurses_wattron(': 'resource window, int attrs | int',
\ 'ncurses_wattrset(': 'resource window, int attrs | int',
\ 'ncurses_wborder(': 'resource window, int left, int right, int top, int bottom, int tl_corner, int tr_corner, int bl_corner, int br_corner | int',
\ 'ncurses_wclear(': 'resource window | int',
\ 'ncurses_wcolor_set(': 'resource window, int color_pair | int',
\ 'ncurses_werase(': 'resource window | int',
\ 'ncurses_wgetch(': 'resource window | int',
\ 'ncurses_whline(': 'resource window, int charattr, int n | int',
\ 'ncurses_wmouse_trafo(': 'resource window, int &y, int &x, bool toscreen | bool',
\ 'ncurses_wmove(': 'resource window, int y, int x | int',
\ 'ncurses_wnoutrefresh(': 'resource window | int',
\ 'ncurses_wrefresh(': 'resource window | int',
\ 'ncurses_wstandend(': 'resource window | int',
\ 'ncurses_wstandout(': 'resource window | int',
\ 'ncurses_wvline(': 'resource window, int charattr, int n | int',
\ 'next(': 'array &array | mixed',
\ 'ngettext(': 'string msgid1, string msgid2, int n | string',
\ 'nl2br(': 'string string | string',
\ 'nl_langinfo(': 'int item | string',
\ 'notes_body(': 'string server, string mailbox, int msg_number | array',
\ 'notes_copy_db(': 'string from_database_name, string to_database_name | string',
\ 'notes_create_db(': 'string database_name | bool',
\ 'notes_create_note(': 'string database_name, string form_name | string',
\ 'notes_drop_db(': 'string database_name | bool',
\ 'notes_find_note(': 'string database_name, string name [, string type] | bool',
\ 'notes_header_info(': 'string server, string mailbox, int msg_number | object',
\ 'notes_list_msgs(': 'string db | bool',
\ 'notes_mark_read(': 'string database_name, string user_name, string note_id | string',
\ 'notes_mark_unread(': 'string database_name, string user_name, string note_id | string',
\ 'notes_nav_create(': 'string database_name, string name | bool',
\ 'notes_search(': 'string database_name, string keywords | string',
\ 'notes_unread(': 'string database_name, string user_name | string',
\ 'notes_version(': 'string database_name | string',
\ 'nsapi_request_headers(': 'void  | array',
\ 'nsapi_response_headers(': 'void  | array',
\ 'nsapi_virtual(': 'string uri | bool',
\ 'number_format(': 'float number [, int decimals [, string dec_point, string thousands_sep]] | string',
\ 'ob_clean(': 'void  | void',
\ 'ob_end_clean(': 'void  | bool',
\ 'ob_end_flush(': 'void  | bool',
\ 'ob_flush(': 'void  | void',
\ 'ob_get_clean(': 'void  | string',
\ 'ob_get_contents(': 'void  | string',
\ 'ob_get_flush(': 'void  | string',
\ 'ob_get_length(': 'void  | int',
\ 'ob_get_level(': 'void  | int',
\ 'ob_get_status(': '[bool full_status] | array',
\ 'ob_gzhandler(': 'string buffer, int mode | string',
\ 'ob_iconv_handler(': 'string contents, int status | array',
\ 'ob_implicit_flush(': '[int flag] | void',
\ 'ob_list_handlers(': 'void  | array',
\ 'ob_start(': '[callback output_callback [, int chunk_size [, bool erase]]] | bool',
\ 'ob_tidyhandler(': 'string input [, int mode] | string',
\ 'ocibindbyname(': 'resource stmt, string ph_name, mixed &variable [, int maxlength [, int type]] | bool',
\ 'oci_bind_by_name(': 'resource stmt, string ph_name, mixed &variable [, int maxlength [, int type]] | bool',
\ 'ocicancel(': 'resource stmt | bool',
\ 'oci_cancel(': 'resource stmt | bool',
\ 'oci_close(': 'resource connection | bool',
\ 'ocicloselob(': 'void  | bool',
\ 'ocicollappend(': 'string value | bool',
\ 'ocicollassign(': 'OCI-Collection from | bool',
\ 'ocicollassignelem(': 'int ndx, string val | bool',
\ 'ocicollgetelem(': 'int ndx | string',
\ 'ocicollmax(': 'void  | int',
\ 'ocicollsize(': 'void  | int',
\ 'ocicolltrim(': 'int num | bool',
\ 'ocicolumnisnull(': 'resource stmt, mixed col | bool',
\ 'ocicolumnname(': 'resource stmt, int col | string',
\ 'ocicolumnprecision(': 'resource stmt, int col | int',
\ 'ocicolumnscale(': 'resource stmt, int col | int',
\ 'ocicolumnsize(': 'resource stmt, mixed column | int',
\ 'ocicolumntype(': 'resource stmt, int col | mixed',
\ 'ocicolumntyperaw(': 'resource stmt, int col | int',
\ 'ocicommit(': 'resource connection | bool',
\ 'oci_commit(': 'resource connection | bool',
\ 'oci_connect(': 'string username, string password [, string db [, string charset]] | resource',
\ 'ocidefinebyname(': 'resource stmt, string column_name, mixed &variable [, int type] | bool',
\ 'oci_define_by_name(': 'resource statement, string column_name, mixed &variable [, int type] | bool',
\ 'ocierror(': '[resource stmt_or_conn_or_global] | array',
\ 'oci_error(': '[resource source] | array',
\ 'ociexecute(': 'resource stmt [, int mode] | bool',
\ 'oci_execute(': 'resource stmt [, int mode] | bool',
\ 'ocifetch(': 'resource stmt | bool',
\ 'oci_fetch(': 'resource statement | bool',
\ 'oci_fetch_all(': 'resource statement, array &output [, int skip [, int maxrows [, int flags]]] | int',
\ 'oci_fetch_array(': 'resource statement [, int mode] | array',
\ 'oci_fetch_assoc(': 'resource statement | array',
\ 'ocifetchinto(': 'resource statement, array &result [, int mode] | int',
\ 'oci_fetch_object(': 'resource statement | object',
\ 'oci_fetch_row(': 'resource statement | array',
\ 'ocifetchstatement(': 'resource stmt, array &output [, int skip [, int maxrows [, int flags]]] | int',
\ 'oci_field_is_null(': 'resource stmt, mixed field | bool',
\ 'oci_field_name(': 'resource statement, int field | string',
\ 'oci_field_precision(': 'resource statement, int field | int',
\ 'oci_field_scale(': 'resource statement, int field | int',
\ 'oci_field_size(': 'resource stmt, mixed field | int',
\ 'oci_field_type(': 'resource stmt, int field | mixed',
\ 'oci_field_type_raw(': 'resource statement, int field | int',
\ 'ocifreecollection(': 'void  | bool',
\ 'ocifreecursor(': 'resource stmt | bool',
\ 'ocifreedesc(': 'void  | bool',
\ 'ocifreestatement(': 'resource stmt | bool',
\ 'oci_free_statement(': 'resource statement | bool',
\ 'ociinternaldebug(': 'int onoff | void',
\ 'oci_internal_debug(': 'int onoff | void',
\ 'ociloadlob(': 'void  | string',
\ 'oci_lob_copy(': 'OCI-Lob lob_to, OCI-Lob lob_from [, int length] | bool',
\ 'oci_lob_is_equal(': 'OCI-Lob lob1, OCI-Lob lob2 | bool',
\ 'ocilogoff(': 'resource connection | bool',
\ 'ocilogon(': 'string username, string password [, string db [, string charset]] | resource',
\ 'OCI-ocinewcollection(': 'resource connection, string tdo [, string schema] | Collection',
\ 'OCI-oci_new_collection(': 'resource connection, string tdo [, string schema] | Collection',
\ 'oci_new_connect(': 'string username, string password [, string db [, string charset]] | resource',
\ 'ocinewcursor(': 'resource conn | resource',
\ 'oci_new_cursor(': 'resource connection | resource',
\ 'OCI-ocinewdescriptor(': 'resource connection [, int type] | Lob',
\ 'OCI-oci_new_descriptor(': 'resource connection [, int type] | Lob',
\ 'ocinlogon(': 'string username, string password [, string db [, string charset]] | resource',
\ 'ocinumcols(': 'resource stmt | int',
\ 'oci_num_fields(': 'resource statement | int',
\ 'oci_num_rows(': 'resource stmt | int',
\ 'ociparse(': 'resource conn, string query | resource',
\ 'oci_parse(': 'resource connection, string query | resource',
\ 'oci_password_change(': 'resource connection, string username, string old_password, string new_password | bool',
\ 'oci_pconnect(': 'string username, string password [, string db [, string charset]] | resource',
\ 'ociplogon(': 'string username, string password [, string db [, string charset]] | resource',
\ 'ociresult(': 'resource statement, mixed col | mixed',
\ 'oci_result(': 'resource statement, mixed field | mixed',
\ 'ocirollback(': 'resource connection | bool',
\ 'oci_rollback(': 'resource connection | bool',
\ 'ocirowcount(': 'resource stmt | int',
\ 'ocisavelob(': 'void  | bool',
\ 'ocisavelobfile(': 'void  | bool',
\ 'ociserverversion(': 'resource conn | string',
\ 'oci_server_version(': 'resource connection | string',
\ 'ocisetprefetch(': 'resource stmt, int rows | bool',
\ 'oci_set_prefetch(': 'resource statement [, int rows] | bool',
\ 'ocistatementtype(': 'resource stmt | string',
\ 'oci_statement_type(': 'resource statement | string',
\ 'ociwritelobtofile(': '[string filename [, int start [, int length]]] | bool',
\ 'ociwritetemporarylob(': 'string var [, int lob_type] | bool',
\ 'octdec(': 'string octal_string | number',
\ 'odbc_autocommit(': 'resource connection_id [, bool OnOff] | bool',
\ 'odbc_binmode(': 'resource result_id, int mode | bool',
\ 'odbc_close(': 'resource connection_id | void',
\ 'odbc_close_all(': 'void  | void',
\ 'odbc_columnprivileges(': 'resource connection_id, string qualifier, string owner, string table_name, string column_name | resource',
\ 'odbc_columns(': 'resource connection_id [, string qualifier [, string schema [, string table_name [, string column_name]]]] | resource',
\ 'odbc_commit(': 'resource connection_id | bool',
\ 'odbc_connect(': 'string dsn, string user, string password [, int cursor_type] | resource',
\ 'odbc_cursor(': 'resource result_id | string',
\ 'odbc_data_source(': 'resource connection_id, int fetch_type | array',
\ 'odbc_do(': 'resource conn_id, string query | resource',
\ 'odbc_error(': '[resource connection_id] | string',
\ 'odbc_errormsg(': '[resource connection_id] | string',
\ 'odbc_exec(': 'resource connection_id, string query_string [, int flags] | resource',
\ 'odbc_execute(': 'resource result_id [, array parameters_array] | bool',
\ 'odbc_fetch_array(': 'resource result [, int rownumber] | array',
\ 'odbc_fetch_into(': 'resource result_id, array &result_array [, int rownumber] | int',
\ 'odbc_fetch_object(': 'resource result [, int rownumber] | object',
\ 'odbc_fetch_row(': 'resource result_id [, int row_number] | bool',
\ 'odbc_field_len(': 'resource result_id, int field_number | int',
\ 'odbc_field_name(': 'resource result_id, int field_number | string',
\ 'odbc_field_num(': 'resource result_id, string field_name | int',
\ 'odbc_field_precision(': 'resource result_id, int field_number | int',
\ 'odbc_field_scale(': 'resource result_id, int field_number | int',
\ 'odbc_field_type(': 'resource result_id, int field_number | string',
\ 'odbc_foreignkeys(': 'resource connection_id, string pk_qualifier, string pk_owner, string pk_table, string fk_qualifier, string fk_owner, string fk_table | resource',
\ 'odbc_free_result(': 'resource result_id | bool',
\ 'odbc_gettypeinfo(': 'resource connection_id [, int data_type] | resource',
\ 'odbc_longreadlen(': 'resource result_id, int length | bool',
\ 'odbc_next_result(': 'resource result_id | bool',
\ 'odbc_num_fields(': 'resource result_id | int',
\ 'odbc_num_rows(': 'resource result_id | int',
\ 'odbc_pconnect(': 'string dsn, string user, string password [, int cursor_type] | resource',
\ 'odbc_prepare(': 'resource connection_id, string query_string | resource',
\ 'odbc_primarykeys(': 'resource connection_id, string qualifier, string owner, string table | resource',
\ 'odbc_procedurecolumns(': 'resource connection_id [, string qualifier, string owner, string proc, string column] | resource',
\ 'odbc_procedures(': 'resource connection_id [, string qualifier, string owner, string name] | resource',
\ 'odbc_result(': 'resource result_id, mixed field | string',
\ 'odbc_result_all(': 'resource result_id [, string format] | int',
\ 'odbc_rollback(': 'resource connection_id | bool',
\ 'odbc_setoption(': 'resource id, int function, int option, int param | bool',
\ 'odbc_specialcolumns(': 'resource connection_id, int type, string qualifier, string owner, string table, int scope, int nullable | resource',
\ 'odbc_statistics(': 'resource connection_id, string qualifier, string owner, string table_name, int unique, int accuracy | resource',
\ 'odbc_tableprivileges(': 'resource connection_id, string qualifier, string owner, string name | resource',
\ 'odbc_tables(': 'resource connection_id [, string qualifier [, string owner [, string name [, string types]]]] | resource',
\ 'openal_buffer_create(': 'void  | resource',
\ 'openal_buffer_data(': 'resource buffer, int format, string data, int freq | bool',
\ 'openal_buffer_destroy(': 'resource buffer | bool',
\ 'openal_buffer_get(': 'resource buffer, int property | int',
\ 'openal_buffer_loadwav(': 'resource buffer, string wavfile | bool',
\ 'openal_context_create(': 'resource device | resource',
\ 'openal_context_current(': 'resource context | bool',
\ 'openal_context_destroy(': 'resource context | bool',
\ 'openal_context_process(': 'resource context | bool',
\ 'openal_context_suspend(': 'resource context | bool',
\ 'openal_device_close(': 'resource device | bool',
\ 'openal_device_open(': '[string device_desc] | resource',
\ 'openal_listener_get(': 'int property | mixed',
\ 'openal_listener_set(': 'int property, mixed setting | bool',
\ 'openal_source_create(': 'void  | resource',
\ 'openal_source_destroy(': 'resource source | resource',
\ 'openal_source_get(': 'resource source, int property | mixed',
\ 'openal_source_pause(': 'resource source | bool',
\ 'openal_source_play(': 'resource source | bool',
\ 'openal_source_rewind(': 'resource source | bool',
\ 'openal_source_set(': 'resource source, int property, mixed setting | bool',
\ 'openal_source_stop(': 'resource source | bool',
\ 'openal_stream(': 'resource source, int format, int rate | resource',
\ 'opendir(': 'string path | resource',
\ 'openlog(': 'string ident, int option, int facility | int',
\ 'openssl_csr_export(': 'resource csr, string &out [, bool notext] | bool',
\ 'openssl_csr_export_to_file(': 'resource csr, string outfilename [, bool notext] | bool',
\ 'openssl_csr_new(': 'array dn, resource &privkey [, array configargs [, array extraattribs]] | bool',
\ 'openssl_csr_sign(': 'mixed csr, mixed cacert, mixed priv_key, int days [, array configargs [, int serial]] | resource',
\ 'openssl_error_string(': 'void  | mixed',
\ 'openssl_free_key(': 'resource key_identifier | void',
\ 'openssl_get_privatekey(': 'mixed key [, string passphrase] | resource',
\ 'openssl_get_publickey(': 'mixed certificate | resource',
\ 'openssl_open(': 'string sealed_data, string &open_data, string env_key, mixed priv_key_id | bool',
\ 'openssl_pkcs7_decrypt(': 'string infilename, string outfilename, mixed recipcert [, mixed recipkey] | bool',
\ 'openssl_pkcs7_encrypt(': 'string infile, string outfile, mixed recipcerts, array headers [, int flags [, int cipherid]] | bool',
\ 'openssl_pkcs7_sign(': 'string infilename, string outfilename, mixed signcert, mixed privkey, array headers [, int flags [, string extracerts]] | bool',
\ 'openssl_pkcs7_verify(': 'string filename, int flags [, string outfilename [, array cainfo [, string extracerts]]] | bool',
\ 'openssl_pkey_export(': 'mixed key, string &out [, string passphrase [, array configargs]] | bool',
\ 'openssl_pkey_export_to_file(': 'mixed key, string outfilename [, string passphrase [, array configargs]] | bool',
\ 'openssl_pkey_get_private(': 'mixed key [, string passphrase] | resource',
\ 'openssl_pkey_get_public(': 'mixed certificate | resource',
\ 'openssl_pkey_new(': '[array configargs] | resource',
\ 'openssl_private_decrypt(': 'string data, string &decrypted, mixed key [, int padding] | bool',
\ 'openssl_private_encrypt(': 'string data, string &crypted, mixed key [, int padding] | bool',
\ 'openssl_public_decrypt(': 'string data, string &decrypted, mixed key [, int padding] | bool',
\ 'openssl_public_encrypt(': 'string data, string &crypted, mixed key [, int padding] | bool',
\ 'openssl_seal(': 'string data, string &sealed_data, array &env_keys, array pub_key_ids | int',
\ 'openssl_sign(': 'string data, string &signature, mixed priv_key_id [, int signature_alg] | bool',
\ 'openssl_verify(': 'string data, string signature, mixed pub_key_id | int',
\ 'openssl_x509_check_private_key(': 'mixed cert, mixed key | bool',
\ 'openssl_x509_checkpurpose(': 'mixed x509cert, int purpose [, array cainfo [, string untrustedfile]] | bool',
\ 'openssl_x509_export(': 'mixed x509, string &output [, bool notext] | bool',
\ 'openssl_x509_export_to_file(': 'mixed x509, string outfilename [, bool notext] | bool',
\ 'openssl_x509_free(': 'resource x509cert | void',
\ 'openssl_x509_parse(': 'mixed x509cert [, bool shortnames] | array',
\ 'openssl_x509_read(': 'mixed x509certdata | resource',
\ 'ora_bind(': 'resource cursor, string PHP_variable_name, string SQL_parameter_name, int length [, int type] | bool',
\ 'ora_close(': 'resource cursor | bool',
\ 'ora_columnname(': 'resource cursor, int column | string',
\ 'ora_columnsize(': 'resource cursor, int column | int',
\ 'ora_columntype(': 'resource cursor, int column | string',
\ 'ora_commit(': 'resource conn | bool',
\ 'ora_commitoff(': 'resource conn | bool',
\ 'ora_commiton(': 'resource conn | bool',
\ 'ora_do(': 'resource conn, string query | resource',
\ 'ora_error(': '[resource cursor_or_connection] | string',
\ 'ora_errorcode(': '[resource cursor_or_connection] | int',
\ 'ora_exec(': 'resource cursor | bool',
\ 'ora_fetch(': 'resource cursor | bool',
\ 'ora_fetch_into(': 'resource cursor, array &result [, int flags] | int',
\ 'ora_getcolumn(': 'resource cursor, int column | mixed',
\ 'ora_logoff(': 'resource connection | bool',
\ 'ora_logon(': 'string user, string password | resource',
\ 'ora_numcols(': 'resource cursor | int',
\ 'ora_numrows(': 'resource cursor | int',
\ 'ora_open(': 'resource connection | resource',
\ 'ora_parse(': 'resource cursor, string sql_statement [, int defer] | bool',
\ 'ora_plogon(': 'string user, string password | resource',
\ 'ora_rollback(': 'resource connection | bool',
\ 'ord(': 'string string | int',
\ 'output_add_rewrite_var(': 'string name, string value | bool',
\ 'output_reset_rewrite_vars(': 'void  | bool',
\ 'overload(': '[string class_name] | void',
\ 'override_function(': 'string function_name, string function_args, string function_code | bool',
\ 'ovrimos_close(': 'int connection | void',
\ 'ovrimos_commit(': 'int connection_id | bool',
\ 'ovrimos_connect(': 'string host, string db, string user, string password | int',
\ 'ovrimos_cursor(': 'int result_id | string',
\ 'ovrimos_exec(': 'int connection_id, string query | int',
\ 'ovrimos_execute(': 'int result_id [, array parameters_array] | bool',
\ 'ovrimos_fetch_into(': 'int result_id, array &result_array [, string how [, int rownumber]] | bool',
\ 'ovrimos_fetch_row(': 'int result_id [, int how [, int row_number]] | bool',
\ 'ovrimos_field_len(': 'int result_id, int field_number | int',
\ 'ovrimos_field_name(': 'int result_id, int field_number | string',
\ 'ovrimos_field_num(': 'int result_id, string field_name | int',
\ 'ovrimos_field_type(': 'int result_id, int field_number | int',
\ 'ovrimos_free_result(': 'int result_id | bool',
\ 'ovrimos_longreadlen(': 'int result_id, int length | bool',
\ 'ovrimos_num_fields(': 'int result_id | int',
\ 'ovrimos_num_rows(': 'int result_id | int',
\ 'ovrimos_prepare(': 'int connection_id, string query | int',
\ 'ovrimos_result(': 'int result_id, mixed field | string',
\ 'ovrimos_result_all(': 'int result_id [, string format] | int',
\ 'ovrimos_rollback(': 'int connection_id | bool',
\ 'pack(': 'string format [, mixed args [, mixed ...]] | string',
\ 'parse_ini_file(': 'string filename [, bool process_sections] | array',
\ 'parsekit_compile_file(': 'string filename [, array &errors [, int options]] | array',
\ 'parsekit_compile_string(': 'string phpcode [, array &errors [, int options]] | array',
\ 'parsekit_func_arginfo(': 'mixed function | array',
\ 'parse_str(': 'string str [, array &arr] | void',
\ 'parse_url(': 'string url | array',
\ 'passthru(': 'string command [, int &return_var] | void',
\ 'pathinfo(': 'string path [, int options] | array',
\ 'pclose(': 'resource handle | int',
\ 'pcntl_alarm(': 'int seconds | int',
\ 'pcntl_exec(': 'string path [, array args [, array envs]] | bool',
\ 'pcntl_fork(': 'void  | int',
\ 'pcntl_getpriority(': '[int pid [, int process_identifier]] | int',
\ 'pcntl_setpriority(': 'int priority [, int pid [, int process_identifier]] | bool',
\ 'pcntl_signal(': 'int signo, callback handle [, bool restart_syscalls] | bool',
\ 'pcntl_wait(': 'int &status [, int options] | int',
\ 'pcntl_waitpid(': 'int pid, int &status [, int options] | int',
\ 'pcntl_wexitstatus(': 'int status | int',
\ 'pcntl_wifexited(': 'int status | int',
\ 'pcntl_wifsignaled(': 'int status | int',
\ 'pcntl_wifstopped(': 'int status | int',
\ 'pcntl_wstopsig(': 'int status | int',
\ 'pcntl_wtermsig(': 'int status | int',
\ 'pdf_add_bookmark(': 'resource pdfdoc, string text, int parent, int open | int',
\ 'pdf_add_launchlink(': 'resource pdfdoc, float llx, float lly, float urx, float ury, string filename | bool',
\ 'pdf_add_locallink(': 'resource pdfdoc, float lowerleftx, float lowerlefty, float upperrightx, float upperrighty, int page, string dest | bool',
\ 'pdf_add_note(': 'resource pdfdoc, float llx, float lly, float urx, float ury, string contents, string title, string icon, int open | bool',
\ 'pdf_add_pdflink(': 'resource pdfdoc, float bottom_left_x, float bottom_left_y, float up_right_x, float up_right_y, string filename, int page, string dest | bool',
\ 'pdf_add_thumbnail(': 'resource pdfdoc, int image | bool',
\ 'pdf_add_weblink(': 'resource pdfdoc, float lowerleftx, float lowerlefty, float upperrightx, float upperrighty, string url | bool',
\ 'pdf_arc(': 'resource pdfdoc, float x, float y, float r, float alpha, float beta | bool',
\ 'pdf_arcn(': 'resource pdfdoc, float x, float y, float r, float alpha, float beta | bool',
\ 'pdf_attach_file(': 'resource pdfdoc, float llx, float lly, float urx, float ury, string filename, string description, string author, string mimetype, string icon | bool',
\ 'pdf_begin_page(': 'resource pdfdoc, float width, float height | bool',
\ 'pdf_begin_pattern(': 'resource pdfdoc, float width, float height, float xstep, float ystep, int painttype | int',
\ 'pdf_begin_template(': 'resource pdfdoc, float width, float height | int',
\ 'pdf_circle(': 'resource pdfdoc, float x, float y, float r | bool',
\ 'pdf_clip(': 'resource pdfdoc | bool',
\ 'pdf_close(': 'resource pdfdoc | bool',
\ 'pdf_close_image(': 'resource pdfdoc, int image | void',
\ 'pdf_closepath(': 'resource pdfdoc | bool',
\ 'pdf_closepath_fill_stroke(': 'resource pdfdoc | bool',
\ 'pdf_closepath_stroke(': 'resource pdfdoc | bool',
\ 'pdf_close_pdi(': 'resource pdfdoc, int dochandle | bool',
\ 'pdf_close_pdi_page(': 'resource pdfdoc, int pagehandle | bool',
\ 'pdf_concat(': 'resource pdfdoc, float a, float b, float c, float d, float e, float f | bool',
\ 'pdf_continue_text(': 'resource pdfdoc, string text | bool',
\ 'pdf_curveto(': 'resource pdfdoc, float x1, float y1, float x2, float y2, float x3, float y3 | bool',
\ 'pdf_delete(': 'resource pdfdoc | bool',
\ 'pdf_end_page(': 'resource pdfdoc | bool',
\ 'pdf_end_pattern(': 'resource pdfdoc | bool',
\ 'pdf_end_template(': 'resource pdfdoc | bool',
\ 'pdf_fill(': 'resource pdfdoc | bool',
\ 'pdf_fill_stroke(': 'resource pdfdoc | bool',
\ 'pdf_findfont(': 'resource pdfdoc, string fontname, string encoding, int embed | int',
\ 'pdf_get_buffer(': 'resource pdfdoc | string',
\ 'pdf_get_majorversion(': 'void  | int',
\ 'pdf_get_minorversion(': 'void  | int',
\ 'pdf_get_parameter(': 'resource pdfdoc, string key, float modifier | string',
\ 'pdf_get_pdi_parameter(': 'resource pdfdoc, string key, int document, int page, int index | string',
\ 'pdf_get_pdi_value(': 'resource pdfdoc, string key, int doc, int page, int index | string',
\ 'pdf_get_value(': 'resource pdfdoc, string key, float modifier | float',
\ 'pdf_initgraphics(': 'resource pdfdoc | bool',
\ 'pdf_lineto(': 'resource pdfdoc, float x, float y | bool',
\ 'pdf_makespotcolor(': 'resource pdfdoc, string spotname | bool',
\ 'pdf_moveto(': 'resource pdfdoc, float x, float y | bool',
\ 'pdf_new(': ' | resource',
\ 'pdf_open_ccitt(': 'resource pdfdoc, string filename, int width, int height, int BitReverse, int k, int Blackls1 | int',
\ 'pdf_open_file(': 'resource pdfdoc, string filename | bool',
\ 'pdf_open_image(': 'resource pdfdoc, string imagetype, string source, string data, int length, int width, int height, int components, int bpc, string params | int',
\ 'pdf_open_image_file(': 'resource pdfdoc, string imagetype, string filename, string stringparam, int intparam | int',
\ 'pdf_open_memory_image(': 'resource pdfdoc, resource image | int',
\ 'pdf_open_pdi(': 'resource pdfdoc, string filename, string stringparam, int intparam | int',
\ 'pdf_open_pdi_page(': 'resource pdfdoc, int dochandle, int pagenumber, string pagelabel | int',
\ 'pdf_place_image(': 'resource pdfdoc, int image, float x, float y, float scale | bool',
\ 'pdf_place_pdi_page(': 'resource pdfdoc, int page, float x, float y, float sx, float sy | bool',
\ 'pdf_rect(': 'resource pdfdoc, float x, float y, float width, float height | bool',
\ 'pdf_restore(': 'resource pdfdoc | bool',
\ 'pdf_rotate(': 'resource pdfdoc, float phi | bool',
\ 'pdf_save(': 'resource pdfdoc | bool',
\ 'pdf_scale(': 'resource pdfdoc, float x_scale, float y_scale | bool',
\ 'pdf_set_border_color(': 'resource pdfdoc, float red, float green, float blue | bool',
\ 'pdf_set_border_dash(': 'resource pdfdoc, float black, float white | bool',
\ 'pdf_set_border_style(': 'resource pdfdoc, string style, float width | bool',
\ 'pdf_setcolor(': 'resource pdfdoc, string type, string colorspace, float c1, float c2, float c3, float c4 | bool',
\ 'pdf_setdash(': 'resource pdfdoc, float b, float w | bool',
\ 'pdf_setflat(': 'resource pdfdoc, float flatness | bool',
\ 'pdf_setfont(': 'resource pdfdoc, int font, float size | bool',
\ 'pdf_setgray(': 'resource pdfdoc, float gray | bool',
\ 'pdf_setgray_fill(': 'resource pdfdoc, float gray | bool',
\ 'pdf_setgray_stroke(': 'resource pdfdoc, float gray | bool',
\ 'pdf_set_info(': 'resource pdfdoc, string key, string value | bool',
\ 'pdf_setlinecap(': 'resource pdfdoc, int linecap | void',
\ 'pdf_setlinejoin(': 'resource pdfdoc, int value | bool',
\ 'pdf_setlinewidth(': 'resource pdfdoc, float width | void',
\ 'pdf_setmatrix(': 'resource pdfdoc, float a, float b, float c, float d, float e, float f | bool',
\ 'pdf_setmiterlimit(': 'resource pdfdoc, float miter | bool',
\ 'pdf_set_parameter(': 'resource pdfdoc, string key, string value | bool',
\ 'pdf_setrgbcolor(': 'resource pdfdoc, float red_value, float green_value, float blue_value | bool',
\ 'pdf_setrgbcolor_fill(': 'resource pdfdoc, float red_value, float green_value, float blue_value | bool',
\ 'pdf_setrgbcolor_stroke(': 'resource pdfdoc, float red_value, float green_value, float blue_value | bool',
\ 'pdf_set_text_pos(': 'resource pdfdoc, float x, float y | bool',
\ 'pdf_set_value(': 'resource pdfdoc, string key, float value | bool',
\ 'pdf_show(': 'resource pdfdoc, string text | bool',
\ 'pdf_show_boxed(': 'resource pdfdoc, string text, float left, float top, float width, float height, string mode, string feature | int',
\ 'pdf_show_xy(': 'resource pdfdoc, string text, float x, float y | bool',
\ 'pdf_skew(': 'resource pdfdoc, float alpha, float beta | bool',
\ 'pdf_stringwidth(': 'resource pdfdoc, string text, int font, float size | float',
\ 'pdf_stroke(': 'resource pdfdoc | bool',
\ 'pdf_translate(': 'resource pdfdoc, float tx, float ty | bool',
\ 'pfpro_cleanup(': 'void  | void',
\ 'pfpro_init(': 'void  | void',
\ 'pfpro_process(': 'array parameters [, string address [, int port [, int timeout [, string proxy_address [, int proxy_port [, string proxy_logon [, string proxy_password]]]]]]] | array',
\ 'pfpro_process_raw(': 'string parameters [, string address [, int port [, int timeout [, string proxy_address [, int proxy_port [, string proxy_logon [, string proxy_password]]]]]]] | string',
\ 'pfpro_version(': 'void  | string',
\ 'pfsockopen(': 'string hostname, int port [, int &errno [, string &errstr [, int timeout]]] | resource',
\ 'pg_transaction_status(': 'resource connection | int',
\ 'pg_affected_rows(': 'resource result | int',
\ 'pg_cancel_query(': 'resource connection | bool',
\ 'pg_client_encoding(': '[resource connection] | string',
\ 'pg_close(': '[resource connection] | bool',
\ 'pg_connect(': 'string connection_string [, int connect_type] | resource',
\ 'pg_connection_busy(': 'resource connection | bool',
\ 'pg_connection_reset(': 'resource connection | bool',
\ 'pg_connection_status(': 'resource connection | int',
\ 'pg_convert(': 'resource connection, string table_name, array assoc_array [, int options] | array',
\ 'pg_copy_from(': 'resource connection, string table_name, array rows [, string delimiter [, string null_as]] | bool',
\ 'pg_copy_to(': 'resource connection, string table_name [, string delimiter [, string null_as]] | array',
\ 'pg_dbname(': 'resource connection | string',
\ 'pg_delete(': 'resource connection, string table_name, array assoc_array [, int options] | mixed',
\ 'pg_end_copy(': '[resource connection] | bool',
\ 'pg_escape_bytea(': 'string data | string',
\ 'pg_escape_string(': 'string data | string',
\ 'pg_execute(': 'string stmtname, array params | resource',
\ 'pg_fetch_all(': 'resource result | array',
\ 'pg_fetch_array(': 'resource result [, int row [, int result_type]] | array',
\ 'pg_fetch_assoc(': 'resource result [, int row] | array',
\ 'pg_fetch_object(': 'resource result [, int row [, int result_type]] | object',
\ 'pg_fetch_result(': 'resource result, int row, mixed field | mixed',
\ 'pg_fetch_row(': 'resource result [, int row] | array',
\ 'pg_field_is_null(': 'resource result, int row, mixed field | int',
\ 'pg_field_name(': 'resource result, int field_number | string',
\ 'pg_field_num(': 'resource result, string field_name | int',
\ 'pg_field_prtlen(': 'resource result [, int row_number, mixed field_name_or_number] | int',
\ 'pg_field_size(': 'resource result, int field_number | int',
\ 'pg_field_type(': 'resource result, int field_number | string',
\ 'pg_field_type_oid(': 'resource result, int field_number | int',
\ 'pg_free_result(': 'resource result | bool',
\ 'pg_get_notify(': 'resource connection [, int result_type] | array',
\ 'pg_get_pid(': 'resource connection | int',
\ 'pg_get_result(': '[resource connection] | resource',
\ 'pg_host(': 'resource connection | string',
\ 'pg_insert(': 'resource connection, string table_name, array assoc_array [, int options] | bool',
\ 'pg_last_error(': '[resource connection] | string',
\ 'pg_last_notice(': 'resource connection | string',
\ 'pg_last_oid(': 'resource result | int',
\ 'pg_lo_close(': 'resource large_object | bool',
\ 'pg_lo_create(': '[resource connection] | int',
\ 'pg_lo_export(': '[resource connection, int oid, string pathname] | bool',
\ 'pg_lo_import(': '[resource connection, string pathname] | int',
\ 'pg_lo_open(': 'resource connection, int oid, string mode | resource',
\ 'pg_lo_read(': 'resource large_object [, int len] | string',
\ 'pg_lo_read_all(': 'resource large_object | int',
\ 'pg_lo_seek(': 'resource large_object, int offset [, int whence] | bool',
\ 'pg_lo_tell(': 'resource large_object | int',
\ 'pg_lo_unlink(': 'resource connection, int oid | bool',
\ 'pg_lo_write(': 'resource large_object, string data [, int len] | int',
\ 'pg_meta_data(': 'resource connection, string table_name | array',
\ 'pg_num_fields(': 'resource result | int',
\ 'pg_num_rows(': 'resource result | int',
\ 'pg_options(': 'resource connection | string',
\ 'pg_parameter_status(': '[resource connection, string param_name] | string',
\ 'pg_pconnect(': 'string connection_string [, int connect_type] | resource',
\ 'pg_ping(': 'resource connection | bool',
\ 'pg_port(': 'resource connection | int',
\ 'pg_prepare(': 'string stmtname, string query | resource',
\ 'pg_put_line(': 'string data | bool',
\ 'pg_query(': 'string query | resource',
\ 'pg_query_params(': 'string query, array params | resource',
\ 'pg_result_error(': 'resource result | string',
\ 'pg_result_error_field(': 'resource result, int fieldcode | string',
\ 'pg_result_seek(': 'resource result, int offset | array',
\ 'pg_result_status(': 'resource result [, int type] | mixed',
\ 'pg_select(': 'resource connection, string table_name, array assoc_array [, int options] | array',
\ 'pg_send_execute(': 'string stmtname, array params | resource',
\ 'pg_send_prepare(': 'string stmtname, string query | resource',
\ 'pg_send_query(': 'resource connection, string query | bool',
\ 'pg_send_query_params(': 'resource connection, string query, array params | bool',
\ 'pg_set_client_encoding(': 'string encoding | int',
\ 'pg_set_error_verbosity(': 'int verbosity | int',
\ 'pg_trace(': 'string pathname [, string mode [, resource connection]] | bool',
\ 'pg_tty(': 'resource connection | string',
\ 'pg_unescape_bytea(': 'string data | string',
\ 'pg_untrace(': '[resource connection] | bool',
\ 'pg_update(': 'resource connection, string table_name, array data, array condition [, int options] | mixed',
\ 'pg_version(': '[resource connection] | array',
\ 'php_check_syntax(': 'string file_name [, string &error_message] | bool',
\ 'phpcredits(': '[int flag] | void',
\ 'phpinfo(': '[int what] | int',
\ 'php_ini_scanned_files(': 'void  | string',
\ 'php_logo_guid(': 'void  | string',
\ 'php_sapi_name(': 'void  | string',
\ 'php_strip_whitespace(': 'string filename | string',
\ 'php_uname(': '[string mode] | string',
\ 'phpversion(': '[string extension] | string',
\ 'pi(': 'void  | float',
\ 'png2wbmp(': 'string pngname, string wbmpname, int d_height, int d_width, int threshold | int',
\ 'popen(': 'string command, string mode | resource',
\ 'posix_access(': 'string file [, int mode] | bool',
\ 'posix_ctermid(': 'void  | string',
\ 'posix_getcwd(': 'void  | string',
\ 'posix_getegid(': 'void  | int',
\ 'posix_geteuid(': 'void  | int',
\ 'posix_getgid(': 'void  | int',
\ 'posix_getgrgid(': 'int gid | array',
\ 'posix_getgrnam(': 'string name | array',
\ 'posix_getgroups(': 'void  | array',
\ 'posix_get_last_error(': 'void  | int',
\ 'posix_getlogin(': 'void  | string',
\ 'posix_getpgid(': 'int pid | int',
\ 'posix_getpgrp(': 'void  | int',
\ 'posix_getpid(': 'void  | int',
\ 'posix_getppid(': 'void  | int',
\ 'posix_getpwnam(': 'string username | array',
\ 'posix_getpwuid(': 'int uid | array',
\ 'posix_getrlimit(': 'void  | array',
\ 'posix_getsid(': 'int pid | int',
\ 'posix_getuid(': 'void  | int',
\ 'posix_isatty(': 'int fd | bool',
\ 'posix_kill(': 'int pid, int sig | bool',
\ 'posix_mkfifo(': 'string pathname, int mode | bool',
\ 'posix_setegid(': 'int gid | bool',
\ 'posix_seteuid(': 'int uid | bool',
\ 'posix_setgid(': 'int gid | bool',
\ 'posix_setpgid(': 'int pid, int pgid | int',
\ 'posix_setsid(': 'void  | int',
\ 'posix_setuid(': 'int uid | bool',
\ 'posix_strerror(': 'int errno | string',
\ 'posix_times(': 'void  | array',
\ 'posix_ttyname(': 'int fd | string',
\ 'posix_uname(': 'void  | array',
\ 'pow(': 'number base, number exp | number',
\ 'preg_grep(': 'string pattern, array input [, int flags] | array',
\ 'preg_match(': 'string pattern, string subject [, array &matches [, int flags [, int offset]]] | mixed',
\ 'preg_match_all(': 'string pattern, string subject, array &matches [, int flags [, int offset]] | int',
\ 'preg_quote(': 'string str [, string delimiter] | string',
\ 'preg_replace(': 'mixed pattern, mixed replacement, mixed subject [, int limit [, int &count]] | mixed',
\ 'preg_replace_callback(': 'mixed pattern, callback callback, mixed subject [, int limit] | mixed',
\ 'preg_split(': 'string pattern, string subject [, int limit [, int flags]] | array',
\ 'prev(': 'array &array | mixed',
\ 'print(': 'string arg | int',
\ 'printer_abort(': 'resource handle | void',
\ 'printer_close(': 'resource handle | void',
\ 'printer_create_brush(': 'int style, string color | mixed',
\ 'printer_create_dc(': 'resource handle | void',
\ 'printer_create_font(': 'string face, int height, int width, int font_weight, bool italic, bool underline, bool strikeout, int orientation | mixed',
\ 'printer_create_pen(': 'int style, int width, string color | mixed',
\ 'printer_delete_brush(': 'resource handle | bool',
\ 'printer_delete_dc(': 'resource handle | bool',
\ 'printer_delete_font(': 'resource handle | bool',
\ 'printer_delete_pen(': 'resource handle | bool',
\ 'printer_draw_bmp(': 'resource handle, string filename, int x, int y [, int width, int height] | void',
\ 'printer_draw_chord(': 'resource handle, int rec_x, int rec_y, int rec_x1, int rec_y1, int rad_x, int rad_y, int rad_x1, int rad_y1 | void',
\ 'printer_draw_elipse(': 'resource handle, int ul_x, int ul_y, int lr_x, int lr_y | void',
\ 'printer_draw_line(': 'resource printer_handle, int from_x, int from_y, int to_x, int to_y | void',
\ 'printer_draw_pie(': 'resource handle, int rec_x, int rec_y, int rec_x1, int rec_y1, int rad1_x, int rad1_y, int rad2_x, int rad2_y | void',
\ 'printer_draw_rectangle(': 'resource handle, int ul_x, int ul_y, int lr_x, int lr_y | void',
\ 'printer_draw_roundrect(': 'resource handle, int ul_x, int ul_y, int lr_x, int lr_y, int width, int height | void',
\ 'printer_draw_text(': 'resource printer_handle, string text, int x, int y | void',
\ 'printer_end_doc(': 'resource handle | bool',
\ 'printer_end_page(': 'resource handle | bool',
\ 'printer_get_option(': 'resource handle, string option | mixed',
\ 'printer_list(': 'int enumtype [, string name [, int level]] | array',
\ 'printer_logical_fontheight(': 'resource handle, int height | int',
\ 'printer_open(': '[string devicename] | mixed',
\ 'printer_select_brush(': 'resource printer_handle, resource brush_handle | void',
\ 'printer_select_font(': 'resource printer_handle, resource font_handle | void',
\ 'printer_select_pen(': 'resource printer_handle, resource pen_handle | void',
\ 'printer_set_option(': 'resource handle, int option, mixed value | bool',
\ 'printer_start_doc(': 'resource handle [, string document] | bool',
\ 'printer_start_page(': 'resource handle | bool',
\ 'printer_write(': 'resource handle, string content | bool',
\ 'printf(': 'string format [, mixed args [, mixed ...]] | int',
\ 'print_r(': 'mixed expression [, bool return] | bool',
\ 'proc_close(': 'resource process | int',
\ 'proc_get_status(': 'resource process | array',
\ 'proc_nice(': 'int increment | bool',
\ 'proc_open(': 'string cmd, array descriptorspec, array &pipes [, string cwd [, array env [, array other_options]]] | resource',
\ 'proc_terminate(': 'resource process [, int signal] | int',
\ 'pspell_add_to_personal(': 'int dictionary_link, string word | int',
\ 'pspell_add_to_session(': 'int dictionary_link, string word | int',
\ 'pspell_check(': 'int dictionary_link, string word | bool',
\ 'pspell_clear_session(': 'int dictionary_link | int',
\ 'pspell_config_create(': 'string language [, string spelling [, string jargon [, string encoding]]] | int',
\ 'pspell_config_data_dir(': 'int conf, string directory | bool',
\ 'pspell_config_dict_dir(': 'int conf, string directory | bool',
\ 'pspell_config_ignore(': 'int dictionary_link, int n | int',
\ 'pspell_config_mode(': 'int dictionary_link, int mode | int',
\ 'pspell_config_personal(': 'int dictionary_link, string file | int',
\ 'pspell_config_repl(': 'int dictionary_link, string file | int',
\ 'pspell_config_runtogether(': 'int dictionary_link, bool flag | int',
\ 'pspell_config_save_repl(': 'int dictionary_link, bool flag | int',
\ 'pspell_new(': 'string language [, string spelling [, string jargon [, string encoding [, int mode]]]] | int',
\ 'pspell_new_config(': 'int config | int',
\ 'pspell_new_personal(': 'string personal, string language [, string spelling [, string jargon [, string encoding [, int mode]]]] | int',
\ 'pspell_save_wordlist(': 'int dictionary_link | int',
\ 'pspell_store_replacement(': 'int dictionary_link, string misspelled, string correct | int',
\ 'pspell_suggest(': 'int dictionary_link, string word | array',
\ 'putenv(': 'string setting | void',
\ 'qdom_error(': 'void  | string',
\ 'qdom_tree(': 'string doc | QDomDocument',
\ 'quoted_printable_decode(': 'string str | string',
\ 'quotemeta(': 'string str | string',
\ 'rad2deg(': 'float number | float',
\ 'rand(': '[int min, int max] | int',
\ 'range(': 'number low, number high [, number step] | array',
\ 'rar_close(': 'resource rar_file | bool',
\ 'rar_entry_get(': 'resource rar_file, string entry_name | RarEntry',
\ 'rar_list(': 'resource rar_file | array',
\ 'rar_open(': 'string filename [, string password] | resource',
\ 'rawurldecode(': 'string str | string',
\ 'rawurlencode(': 'string str | string',
\ 'readdir(': 'resource dir_handle | string',
\ 'readfile(': 'string filename [, bool use_include_path [, resource context]] | int',
\ 'readgzfile(': 'string filename [, int use_include_path] | int',
\ 'readline(': 'string prompt | string',
\ 'readline_add_history(': 'string line | void',
\ 'readline_callback_handler_install(': 'string prompt, callback callback | bool',
\ 'readline_callback_handler_remove(': 'void  | bool',
\ 'readline_callback_read_char(': 'void  | void',
\ 'readline_clear_history(': 'void  | bool',
\ 'readline_completion_function(': 'callback function | bool',
\ 'readline_info(': '[string varname [, string newvalue]] | mixed',
\ 'readline_list_history(': 'void  | array',
\ 'readline_on_new_line(': 'void  | void',
\ 'readline_read_history(': '[string filename] | bool',
\ 'readline_redisplay(': 'void  | void',
\ 'readline_write_history(': '[string filename] | bool',
\ 'readlink(': 'string path | string',
\ 'realpath(': 'string path | string',
\ 'recode_file(': 'string request, resource input, resource output | bool',
\ 'recode_string(': 'string request, string string | string',
\ 'register_shutdown_function(': 'callback function [, mixed parameter [, mixed ...]] | void',
\ 'register_tick_function(': 'callback function [, mixed arg [, mixed ...]] | void',
\ 'rename(': 'string oldname, string newname [, resource context] | bool',
\ 'rename_function(': 'string original_name, string new_name | bool',
\ 'reset(': 'array &array | mixed',
\ 'restore_error_handler(': 'void  | bool',
\ 'restore_exception_handler(': 'void  | bool',
\ 'restore_include_path(': 'void  | void',
\ 'rewind(': 'resource handle | bool',
\ 'rewinddir(': 'resource dir_handle | void',
\ 'rmdir(': 'string dirname [, resource context] | bool',
\ 'round(': 'float val [, int precision] | float',
\ 'rsort(': 'array &array [, int sort_flags] | bool',
\ 'rtrim(': 'string str [, string charlist] | string',
\ 'scandir(': 'string directory [, int sorting_order [, resource context]] | array',
\ 'sem_acquire(': 'resource sem_identifier | bool',
\ 'sem_get(': 'int key [, int max_acquire [, int perm [, int auto_release]]] | resource',
\ 'sem_release(': 'resource sem_identifier | bool',
\ 'sem_remove(': 'resource sem_identifier | bool',
\ 'serialize(': 'mixed value | string',
\ 'sesam_affected_rows(': 'string result_id | int',
\ 'sesam_commit(': 'void  | bool',
\ 'sesam_connect(': 'string catalog, string schema, string user | bool',
\ 'sesam_diagnostic(': 'void  | array',
\ 'sesam_disconnect(': 'void  | bool',
\ 'sesam_errormsg(': 'void  | string',
\ 'sesam_execimm(': 'string query | string',
\ 'sesam_fetch_array(': 'string result_id [, int whence [, int offset]] | array',
\ 'sesam_fetch_result(': 'string result_id [, int max_rows] | mixed',
\ 'sesam_fetch_row(': 'string result_id [, int whence [, int offset]] | array',
\ 'sesam_field_array(': 'string result_id | array',
\ 'sesam_field_name(': 'string result_id, int index | int',
\ 'sesam_free_result(': 'string result_id | int',
\ 'sesam_num_fields(': 'string result_id | int',
\ 'sesam_query(': 'string query [, bool scrollable] | string',
\ 'sesam_rollback(': 'void  | bool',
\ 'sesam_seek_row(': 'string result_id, int whence [, int offset] | bool',
\ 'sesam_settransaction(': 'int isolation_level, int read_only | bool',
\ 'session_cache_expire(': '[int new_cache_expire] | int',
\ 'session_cache_limiter(': '[string cache_limiter] | string',
\ 'session_decode(': 'string data | bool',
\ 'session_destroy(': 'void  | bool',
\ 'session_encode(': 'void  | string',
\ 'session_get_cookie_params(': 'void  | array',
\ 'session_id(': '[string id] | string',
\ 'session_is_registered(': 'string name | bool',
\ 'session_module_name(': '[string module] | string',
\ 'session_name(': '[string name] | string',
\ 'session_regenerate_id(': 'void  | bool',
\ 'session_register(': 'mixed name [, mixed ...] | bool',
\ 'session_save_path(': '[string path] | string',
\ 'session_set_cookie_params(': 'int lifetime [, string path [, string domain [, bool secure]]] | void',
\ 'session_set_save_handler(': 'string open, string close, string read, string write, string destroy, string gc | bool',
\ 'session_start(': 'void  | bool',
\ 'session_unregister(': 'string name | bool',
\ 'session_unset(': 'void  | void',
\ 'session_write_close(': 'void  | void',
\ 'setcookie(': 'string name [, string value [, int expire [, string path [, string domain [, bool secure]]]]] | bool',
\ 'set_error_handler(': 'callback error_handler [, int error_types] | mixed',
\ 'set_exception_handler(': 'callback exception_handler | string',
\ 'set_include_path(': 'string new_include_path | string',
\ 'setlocale(': 'mixed category, string locale [, string ...] | string',
\ 'set_magic_quotes_runtime(': 'int new_setting | bool',
\ 'setrawcookie(': 'string name [, string value [, int expire [, string path [, string domain [, bool secure]]]]] | bool',
\ 'set_time_limit(': 'int seconds | void',
\ 'settype(': 'mixed &var, string type | bool',
\ 'sha1(': 'string str [, bool raw_output] | string',
\ 'sha1_file(': 'string filename [, bool raw_output] | string',
\ 'shell_exec(': 'string cmd | string',
\ 'shm_attach(': 'int key [, int memsize [, int perm]] | int',
\ 'shm_detach(': 'int shm_identifier | bool',
\ 'shm_get_var(': 'int shm_identifier, int variable_key | mixed',
\ 'shmop_close(': 'int shmid | int',
\ 'shmop_delete(': 'int shmid | int',
\ 'shmop_open(': 'int key, string flags, int mode, int size | int',
\ 'shmop_read(': 'int shmid, int start, int count | string',
\ 'shmop_size(': 'int shmid | int',
\ 'shmop_write(': 'int shmid, string data, int offset | int',
\ 'shm_put_var(': 'int shm_identifier, int variable_key, mixed variable | bool',
\ 'shm_remove(': 'int shm_identifier | int',
\ 'shm_remove_var(': 'int shm_identifier, int variable_key | int',
\ 'shuffle(': 'array &array | bool',
\ 'similar_text(': 'string first, string second [, float &percent] | int',
\ 'simplexml_import_dom(': 'DOMNode node [, string class_name] | SimpleXMLElement',
\ 'simplexml_load_file(': 'string filename [, string class_name [, int options]] | object',
\ 'simplexml_load_string(': 'string data [, string class_name [, int options]] | object',
\ 'sin(': 'float arg | float',
\ 'sinh(': 'float arg | float',
\ 'sleep(': 'int seconds | void',
\ 'snmpget(': 'string hostname, string community, string object_id [, int timeout [, int retries]] | string',
\ 'snmpgetnext(': 'string host, string community, string object_id [, int timeout [, int retries]] | string',
\ 'snmp_get_quick_print(': 'void  | bool',
\ 'snmp_get_valueretrieval(': 'void  | int',
\ 'snmp_read_mib(': 'string filename | int',
\ 'snmprealwalk(': 'string host, string community, string object_id [, int timeout [, int retries]] | array',
\ 'snmpset(': 'string hostname, string community, string object_id, string type, mixed value [, int timeout [, int retries]] | bool',
\ 'snmp_set_enum_print(': 'int enum_print | void',
\ 'snmp_set_oid_numeric_print(': 'int oid_numeric_print | void',
\ 'snmp_set_quick_print(': 'bool quick_print | void',
\ 'snmp_set_valueretrieval(': 'int method | int',
\ 'snmpwalk(': 'string hostname, string community, string object_id [, int timeout [, int retries]] | array',
\ 'snmpwalkoid(': 'string hostname, string community, string object_id [, int timeout [, int retries]] | array',
\ 'socket_accept(': 'resource socket | resource',
\ 'socket_bind(': 'resource socket, string address [, int port] | bool',
\ 'socket_clear_error(': '[resource socket] | void',
\ 'socket_close(': 'resource socket | void',
\ 'socket_connect(': 'resource socket, string address [, int port] | bool',
\ 'socket_create(': 'int domain, int type, int protocol | resource',
\ 'socket_create_listen(': 'int port [, int backlog] | resource',
\ 'socket_create_pair(': 'int domain, int type, int protocol, array &fd | bool',
\ 'socket_get_option(': 'resource socket, int level, int optname | mixed',
\ 'socket_getpeername(': 'resource socket, string &addr [, int &port] | bool',
\ 'socket_getsockname(': 'resource socket, string &addr [, int &port] | bool',
\ 'socket_last_error(': '[resource socket] | int',
\ 'socket_listen(': 'resource socket [, int backlog] | bool',
\ 'socket_read(': 'resource socket, int length [, int type] | string',
\ 'socket_recv(': 'resource socket, string &buf, int len, int flags | int',
\ 'socket_recvfrom(': 'resource socket, string &buf, int len, int flags, string &name [, int &port] | int',
\ 'socket_select(': 'array &read, array &write, array &except, int tv_sec [, int tv_usec] | int',
\ 'socket_send(': 'resource socket, string buf, int len, int flags | int',
\ 'socket_sendto(': 'resource socket, string buf, int len, int flags, string addr [, int port] | int',
\ 'socket_set_block(': 'resource socket | bool',
\ 'socket_set_nonblock(': 'resource socket | bool',
\ 'socket_set_option(': 'resource socket, int level, int optname, mixed optval | bool',
\ 'socket_shutdown(': 'resource socket [, int how] | bool',
\ 'socket_strerror(': 'int errno | string',
\ 'socket_write(': 'resource socket, string buffer [, int length] | int',
\ 'sort(': 'array &array [, int sort_flags] | bool',
\ 'soundex(': 'string str | string',
\ 'spl_classes(': 'void  | array',
\ 'split(': 'string pattern, string string [, int limit] | array',
\ 'spliti(': 'string pattern, string string [, int limit] | array',
\ 'sprintf(': 'string format [, mixed args [, mixed ...]] | string',
\ 'sqlite_array_query(': 'resource dbhandle, string query [, int result_type [, bool decode_binary]] | array',
\ 'sqlite_busy_timeout(': 'resource dbhandle, int milliseconds | void',
\ 'sqlite_changes(': 'resource dbhandle | int',
\ 'sqlite_close(': 'resource dbhandle | void',
\ 'sqlite_column(': 'resource result, mixed index_or_name [, bool decode_binary] | mixed',
\ 'sqlite_create_aggregate(': 'resource dbhandle, string function_name, callback step_func, callback finalize_func [, int num_args] | bool',
\ 'sqlite_create_function(': 'resource dbhandle, string function_name, callback callback [, int num_args] | bool',
\ 'sqlite_current(': 'resource result [, int result_type [, bool decode_binary]] | array',
\ 'sqlite_error_string(': 'int error_code | string',
\ 'sqlite_escape_string(': 'string item | string',
\ 'sqlite_exec(': 'resource dbhandle, string query | bool',
\ 'sqlite_factory(': 'string filename [, int mode [, string &error_message]] | SQLiteDatabase',
\ 'sqlite_fetch_all(': 'resource result [, int result_type [, bool decode_binary]] | array',
\ 'sqlite_fetch_array(': 'resource result [, int result_type [, bool decode_binary]] | array',
\ 'sqlite_fetch_column_types(': 'string table_name, resource dbhandle [, int result_type] | array',
\ 'sqlite_fetch_object(': 'resource result [, string class_name [, array ctor_params [, bool decode_binary]]] | object',
\ 'sqlite_fetch_single(': 'resource result [, bool decode_binary] | string',
\ 'sqlite_field_name(': 'resource result, int field_index | string',
\ 'sqlite_has_more(': 'resource result | bool',
\ 'sqlite_has_prev(': 'resource result | bool',
\ 'sqlite_key(': 'resource result | int',
\ 'sqlite_last_error(': 'resource dbhandle | int',
\ 'sqlite_last_insert_rowid(': 'resource dbhandle | int',
\ 'sqlite_libencoding(': 'void  | string',
\ 'sqlite_libversion(': 'void  | string',
\ 'sqlite_next(': 'resource result | bool',
\ 'sqlite_num_fields(': 'resource result | int',
\ 'sqlite_num_rows(': 'resource result | int',
\ 'sqlite_open(': 'string filename [, int mode [, string &error_message]] | resource',
\ 'sqlite_popen(': 'string filename [, int mode [, string &error_message]] | resource',
\ 'sqlite_prev(': 'resource result | bool',
\ 'sqlite_query(': 'resource dbhandle, string query | resource',
\ 'sqlite_rewind(': 'resource result | bool',
\ 'sqlite_seek(': 'resource result, int rownum | bool',
\ 'sqlite_single_query(': 'resource db, string query [, bool first_row_only [, bool decode_binary]] | mixed',
\ 'sqlite_udf_decode_binary(': 'string data | string',
\ 'sqlite_udf_encode_binary(': 'string data | string',
\ 'sqlite_unbuffered_query(': 'resource dbhandle, string query | resource',
\ 'sqlite_valid(': 'resource result | bool',
\ 'sql_regcase(': 'string string | string',
\ 'sqrt(': 'float arg | float',
\ 'srand(': '[int seed] | void',
\ 'sscanf(': 'string str, string format [, mixed &...] | mixed',
\ 'ssh2_auth_hostbased_file(': 'resource session, string username, string hostname, string pubkeyfile, string privkeyfile [, string passphrase [, string local_username]] | bool',
\ 'ssh2_auth_none(': 'resource session, string username | array',
\ 'ssh2_auth_password(': 'resource session, string username, string password | bool',
\ 'ssh2_auth_pubkey_file(': 'resource session, string username, string pubkeyfile, string privkeyfile [, string passphrase] | bool',
\ 'ssh2_connect(': 'string host [, int port [, array methods [, array callbacks]]] | resource',
\ 'ssh2_exec(': 'resource session, string command [, array env] | stream',
\ 'ssh2_fetch_stream(': 'stream channel, int streamid | stream',
\ 'ssh2_fingerprint(': 'resource session [, int flags] | string',
\ 'ssh2_methods_negotiated(': 'resource session | array',
\ 'ssh2_scp_recv(': 'resource session, string remote_file, string local_file | bool',
\ 'ssh2_scp_send(': 'resource session, string local_file, string remote_file [, int create_mode] | stream',
\ 'ssh2_sftp(': 'resource session | resource',
\ 'ssh2_sftp_lstat(': 'resource sftp, string path | array',
\ 'ssh2_sftp_mkdir(': 'resource sftp, string dirname [, int mode [, bool recursive]] | bool',
\ 'ssh2_sftp_readlink(': 'resource sftp, string link | string',
\ 'ssh2_sftp_realpath(': 'resource sftp, string filename | string',
\ 'ssh2_sftp_rename(': 'resource sftp, string from, string to | bool',
\ 'ssh2_sftp_rmdir(': 'resource sftp, string dirname | bool',
\ 'ssh2_sftp_stat(': 'resource sftp, string path | array',
\ 'ssh2_sftp_symlink(': 'resource sftp, string target, string link | bool',
\ 'ssh2_sftp_unlink(': 'resource sftp, string filename | bool',
\ 'ssh2_shell(': 'resource session [, string term_type [, array env [, int width [, int height [, int width_height_type]]]]] | stream',
\ 'ssh2_tunnel(': 'resource session, string host, int port | stream',
\ 'stat(': 'string filename | array',
\ 'strcasecmp(': 'string str1, string str2 | int',
\ 'strcmp(': 'string str1, string str2 | int',
\ 'strcoll(': 'string str1, string str2 | int',
\ 'strcspn(': 'string str1, string str2 [, int start [, int length]] | int',
\ 'stream_context_create(': '[array options] | resource',
\ 'stream_context_get_default(': '[array options] | resource',
\ 'stream_context_get_options(': 'resource stream_or_context | array',
\ 'stream_context_set_option(': 'resource stream_or_context, string wrapper, string option, mixed value | bool',
\ 'stream_context_set_params(': 'resource stream_or_context, array params | bool',
\ 'stream_copy_to_stream(': 'resource source, resource dest [, int maxlength] | int',
\ 'stream_filter_append(': 'resource stream, string filtername [, int read_write [, mixed params]] | resource',
\ 'stream_filter_prepend(': 'resource stream, string filtername [, int read_write [, mixed params]] | resource',
\ 'stream_filter_register(': 'string filtername, string classname | bool',
\ 'stream_filter_remove(': 'resource stream_filter | bool',
\ 'stream_get_contents(': 'resource handle [, int maxlength [, int offset]] | string',
\ 'stream_get_filters(': 'void  | array',
\ 'stream_get_line(': 'resource handle, int length [, string ending] | string',
\ 'stream_get_meta_data(': 'resource stream | array',
\ 'stream_get_transports(': 'void  | array',
\ 'stream_get_wrappers(': 'void  | array',
\ 'stream_select(': 'array &read, array &write, array &except, int tv_sec [, int tv_usec] | int',
\ 'stream_set_blocking(': 'resource stream, int mode | bool',
\ 'stream_set_timeout(': 'resource stream, int seconds [, int microseconds] | bool',
\ 'stream_set_write_buffer(': 'resource stream, int buffer | int',
\ 'stream_socket_accept(': 'resource server_socket [, float timeout [, string &peername]] | resource',
\ 'stream_socket_client(': 'string remote_socket [, int &errno [, string &errstr [, float timeout [, int flags [, resource context]]]]] | resource',
\ 'stream_socket_enable_crypto(': 'resource stream, bool enable [, int crypto_type [, resource session_stream]] | mixed',
\ 'stream_socket_get_name(': 'resource handle, bool want_peer | string',
\ 'stream_socket_pair(': 'int domain, int type, int protocol | array',
\ 'stream_socket_recvfrom(': 'resource socket, int length [, int flags [, string &address]] | string',
\ 'stream_socket_sendto(': 'resource socket, string data [, int flags [, string address]] | int',
\ 'stream_socket_server(': 'string local_socket [, int &errno [, string &errstr [, int flags [, resource context]]]] | resource',
\ 'stream_wrapper_register(': 'string protocol, string classname | bool',
\ 'stream_wrapper_restore(': 'string protocol | bool',
\ 'stream_wrapper_unregister(': 'string protocol | bool',
\ 'strftime(': 'string format [, int timestamp] | string',
\ 'stripcslashes(': 'string str | string',
\ 'stripos(': 'string haystack, string needle [, int offset] | int',
\ 'stripslashes(': 'string str | string',
\ 'strip_tags(': 'string str [, string allowable_tags] | string',
\ 'str_ireplace(': 'mixed search, mixed replace, mixed subject [, int &count] | mixed',
\ 'stristr(': 'string haystack, string needle | string',
\ 'strlen(': 'string string | int',
\ 'strnatcasecmp(': 'string str1, string str2 | int',
\ 'strnatcmp(': 'string str1, string str2 | int',
\ 'strncasecmp(': 'string str1, string str2, int len | int',
\ 'strncmp(': 'string str1, string str2, int len | int',
\ 'str_pad(': 'string input, int pad_length [, string pad_string [, int pad_type]] | string',
\ 'strpbrk(': 'string haystack, string char_list | string',
\ 'strpos(': 'string haystack, mixed needle [, int offset] | int',
\ 'strptime(': 'string timestamp, string format | array',
\ 'strrchr(': 'string haystack, string needle | string',
\ 'str_repeat(': 'string input, int multiplier | string',
\ 'str_replace(': 'mixed search, mixed replace, mixed subject [, int &count] | mixed',
\ 'strrev(': 'string string | string',
\ 'strripos(': 'string haystack, string needle [, int offset] | int',
\ 'str_rot13(': 'string str | string',
\ 'strrpos(': 'string haystack, string needle [, int offset] | int',
\ 'str_shuffle(': 'string str | string',
\ 'str_split(': 'string string [, int split_length] | array',
\ 'strspn(': 'string str1, string str2 [, int start [, int length]] | int',
\ 'strstr(': 'string haystack, string needle | string',
\ 'strtok(': 'string str, string token | string',
\ 'strtolower(': 'string str | string',
\ 'strtotime(': 'string time [, int now] | int',
\ 'strtoupper(': 'string string | string',
\ 'strtr(': 'string str, string from, string to | string',
\ 'strval(': 'mixed var | string',
\ 'str_word_count(': 'string string [, int format [, string charlist]] | mixed',
\ 'substr(': 'string string, int start [, int length] | string',
\ 'substr_compare(': 'string main_str, string str, int offset [, int length [, bool case_insensitivity]] | int',
\ 'substr_count(': 'string haystack, string needle | int',
\ 'substr_replace(': 'string string, string replacement, int start [, int length] | string',
\ 'swfaction(': 'string script | SWFAction',
\ 'swf_actiongeturl(': 'string url, string target | void',
\ 'swf_actiongotoframe(': 'int framenumber | void',
\ 'swf_actiongotolabel(': 'string label | void',
\ 'swf_actionnextframe(': 'void  | void',
\ 'swf_actionplay(': 'void  | void',
\ 'swf_actionprevframe(': 'void  | void',
\ 'swf_actionsettarget(': 'string target | void',
\ 'swf_actionstop(': 'void  | void',
\ 'swf_actiontogglequality(': 'void  | void',
\ 'swf_actionwaitforframe(': 'int framenumber, int skipcount | void',
\ 'swf_addbuttonrecord(': 'int states, int shapeid, int depth | void',
\ 'swf_addcolor(': 'float r, float g, float b, float a | void',
\ 'swfbitmap(': 'mixed file [, mixed alphafile] | SWFBitmap',
\ 'swfbutton(': 'void  | SWFButton',
\ 'swfbutton_keypress(': 'string str | int',
\ 'swf_closefile(': '[int return_file] | void',
\ 'swf_definebitmap(': 'int objid, string image_name | void',
\ 'swf_definefont(': 'int fontid, string fontname | void',
\ 'swf_defineline(': 'int objid, float x1, float y1, float x2, float y2, float width | void',
\ 'swf_definepoly(': 'int objid, array coords, int npoints, float width | void',
\ 'swf_definerect(': 'int objid, float x1, float y1, float x2, float y2, float width | void',
\ 'swf_definetext(': 'int objid, string str, int docenter | void',
\ 'swfdisplayitem(': 'void  | SWFDisplayItem',
\ 'swf_endbutton(': 'void  | void',
\ 'swf_enddoaction(': 'void  | void',
\ 'swf_endshape(': 'void  | void',
\ 'swf_endsymbol(': 'void  | void',
\ 'swffill(': 'void  | SWFFill',
\ 'swffont(': 'string filename | SWFFont',
\ 'swf_fontsize(': 'float size | void',
\ 'swf_fontslant(': 'float slant | void',
\ 'swf_fonttracking(': 'float tracking | void',
\ 'swf_getbitmapinfo(': 'int bitmapid | array',
\ 'swf_getfontinfo(': 'void  | array',
\ 'swf_getframe(': 'void  | int',
\ 'swfgradient(': 'void  | SWFGradient',
\ 'swf_labelframe(': 'string name | void',
\ 'swf_lookat(': 'float view_x, float view_y, float view_z, float reference_x, float reference_y, float reference_z, float twist | void',
\ 'swf_modifyobject(': 'int depth, int how | void',
\ 'swfmorph(': 'void  | SWFMorph',
\ 'swfmovie(': 'void  | SWFMovie',
\ 'swf_mulcolor(': 'float r, float g, float b, float a | void',
\ 'swf_nextid(': 'void  | int',
\ 'swf_oncondition(': 'int transition | void',
\ 'swf_openfile(': 'string filename, float width, float height, float framerate, float r, float g, float b | void',
\ 'swf_ortho(': 'float xmin, float xmax, float ymin, float ymax, float zmin, float zmax | void',
\ 'swf_ortho2(': 'float xmin, float xmax, float ymin, float ymax | void',
\ 'swf_perspective(': 'float fovy, float aspect, float near, float far | void',
\ 'swf_placeobject(': 'int objid, int depth | void',
\ 'swf_polarview(': 'float dist, float azimuth, float incidence, float twist | void',
\ 'swf_popmatrix(': 'void  | void',
\ 'swf_posround(': 'int round | void',
\ 'swf_pushmatrix(': 'void  | void',
\ 'swf_removeobject(': 'int depth | void',
\ 'swf_rotate(': 'float angle, string axis | void',
\ 'swf_scale(': 'float x, float y, float z | void',
\ 'swf_setfont(': 'int fontid | void',
\ 'swf_setframe(': 'int framenumber | void',
\ 'swfshape(': 'void  | SWFShape',
\ 'swf_shapearc(': 'float x, float y, float r, float ang1, float ang2 | void',
\ 'swf_shapecurveto(': 'float x1, float y1, float x2, float y2 | void',
\ 'swf_shapecurveto3(': 'float x1, float y1, float x2, float y2, float x3, float y3 | void',
\ 'swf_shapefillbitmapclip(': 'int bitmapid | void',
\ 'swf_shapefillbitmaptile(': 'int bitmapid | void',
\ 'swf_shapefilloff(': 'void  | void',
\ 'swf_shapefillsolid(': 'float r, float g, float b, float a | void',
\ 'swf_shapelinesolid(': 'float r, float g, float b, float a, float width | void',
\ 'swf_shapelineto(': 'float x, float y | void',
\ 'swf_shapemoveto(': 'float x, float y | void',
\ 'swf_showframe(': 'void  | void',
\ 'swfsprite(': 'void  | SWFSprite',
\ 'swf_startbutton(': 'int objid, int type | void',
\ 'swf_startdoaction(': 'void  | void',
\ 'swf_startshape(': 'int objid | void',
\ 'swf_startsymbol(': 'int objid | void',
\ 'swftext(': 'void  | SWFText',
\ 'swftextfield(': '[int flags] | SWFTextField',
\ 'swf_textwidth(': 'string str | float',
\ 'swf_translate(': 'float x, float y, float z | void',
\ 'swf_viewport(': 'float xmin, float xmax, float ymin, float ymax | void',
\ 'sybase_affected_rows(': '[resource link_identifier] | int',
\ 'sybase_close(': '[resource link_identifier] | bool',
\ 'sybase_connect(': '[string servername [, string username [, string password [, string charset [, string appname]]]]] | resource',
\ 'sybase_data_seek(': 'resource result_identifier, int row_number | bool',
\ 'sybase_deadlock_retry_count(': 'int retry_count | void',
\ 'sybase_fetch_array(': 'resource result | array',
\ 'sybase_fetch_assoc(': 'resource result | array',
\ 'sybase_fetch_field(': 'resource result [, int field_offset] | object',
\ 'sybase_fetch_object(': 'resource result [, mixed object] | object',
\ 'sybase_fetch_row(': 'resource result | array',
\ 'sybase_field_seek(': 'resource result, int field_offset | bool',
\ 'sybase_free_result(': 'resource result | bool',
\ 'sybase_get_last_message(': 'void  | string',
\ 'sybase_min_client_severity(': 'int severity | void',
\ 'sybase_min_error_severity(': 'int severity | void',
\ 'sybase_min_message_severity(': 'int severity | void',
\ 'sybase_min_server_severity(': 'int severity | void',
\ 'sybase_num_fields(': 'resource result | int',
\ 'sybase_num_rows(': 'resource result | int',
\ 'sybase_pconnect(': '[string servername [, string username [, string password [, string charset [, string appname]]]]] | resource',
\ 'sybase_query(': 'string query [, resource link_identifier] | resource',
\ 'sybase_result(': 'resource result, int row, mixed field | string',
\ 'sybase_select_db(': 'string database_name [, resource link_identifier] | bool',
\ 'sybase_set_message_handler(': 'callback handler [, resource connection] | bool',
\ 'sybase_unbuffered_query(': 'string query, resource link_identifier [, bool store_result] | resource',
\ 'symlink(': 'string target, string link | bool',
\ 'syslog(': 'int priority, string message | int',
\ 'system(': 'string command [, int &return_var] | string',
\ 'tan(': 'float arg | float',
\ 'tanh(': 'float arg | float',
\ 'tcpwrap_check(': 'string daemon, string address [, string user [, bool nodns]] | bool',
\ 'tempnam(': 'string dir, string prefix | string',
\ 'textdomain(': 'string text_domain | string',
\ 'tidy_access_count(': 'tidy object | int',
\ 'tidy_clean_repair(': 'tidy object | bool',
\ 'tidy_config_count(': 'tidy object | int',
\ 'tidy_diagnose(': 'tidy object | bool',
\ 'tidy_error_count(': 'tidy object | int',
\ 'tidy_get_body(': 'tidy object | tidyNode',
\ 'tidy_get_config(': 'tidy object | array',
\ 'tidy_get_error_buffer(': 'tidy object | string',
\ 'tidy_get_head(': 'tidy object | tidyNode',
\ 'tidy_get_html(': 'tidy object | tidyNode',
\ 'tidy_get_html_ver(': 'tidy object | int',
\ 'tidy_getopt(': 'tidy object, string option | mixed',
\ 'tidy_get_output(': 'tidy object | string',
\ 'tidy_get_release(': 'void  | string',
\ 'tidy_get_root(': 'tidy object | tidyNode',
\ 'tidy_get_status(': 'tidy object | int',
\ 'tidy_is_xhtml(': 'tidy object | bool',
\ 'tidy_is_xml(': 'tidy object | bool',
\ 'tidy_load_config(': 'string filename, string encoding | void',
\ 'tidy_parse_file(': 'string filename [, mixed config [, string encoding [, bool use_include_path]]] | tidy',
\ 'tidy_parse_string(': 'string input [, mixed config [, string encoding]] | tidy',
\ 'tidy_repair_file(': 'string filename [, mixed config [, string encoding [, bool use_include_path]]] | string',
\ 'tidy_repair_string(': 'string data [, mixed config [, string encoding]] | string',
\ 'tidy_reset_config(': 'void  | bool',
\ 'tidy_save_config(': 'string filename | bool',
\ 'tidy_set_encoding(': 'string encoding | bool',
\ 'tidy_setopt(': 'string option, mixed value | bool',
\ 'tidy_warning_count(': 'tidy object | int',
\ 'time(': 'void  | int',
\ 'time_nanosleep(': 'int seconds, int nanoseconds | mixed',
\ 'tmpfile(': 'void  | resource',
\ 'token_get_all(': 'string source | array',
\ 'token_name(': 'int token | string',
\ 'touch(': 'string filename [, int time [, int atime]] | bool',
\ 'trigger_error(': 'string error_msg [, int error_type] | bool',
\ 'trim(': 'string str [, string charlist] | string',
\ 'uasort(': 'array &array, callback cmp_function | bool',
\ 'ucfirst(': 'string str | string',
\ 'ucwords(': 'string str | string',
\ 'udm_add_search_limit(': 'resource agent, int var, string val | bool',
\ 'udm_alloc_agent(': 'string dbaddr [, string dbmode] | resource',
\ 'udm_alloc_agent_array(': 'array databases | resource',
\ 'udm_api_version(': 'void  | int',
\ 'udm_cat_list(': 'resource agent, string category | array',
\ 'udm_cat_path(': 'resource agent, string category | array',
\ 'udm_check_charset(': 'resource agent, string charset | bool',
\ 'udm_check_stored(': 'resource agent, int link, string doc_id | int',
\ 'udm_clear_search_limits(': 'resource agent | bool',
\ 'udm_close_stored(': 'resource agent, int link | int',
\ 'udm_crc32(': 'resource agent, string str | int',
\ 'udm_errno(': 'resource agent | int',
\ 'udm_error(': 'resource agent | string',
\ 'udm_find(': 'resource agent, string query | resource',
\ 'udm_free_agent(': 'resource agent | int',
\ 'udm_free_ispell_data(': 'int agent | bool',
\ 'udm_free_res(': 'resource res | bool',
\ 'udm_get_doc_count(': 'resource agent | int',
\ 'udm_get_res_field(': 'resource res, int row, int field | string',
\ 'udm_get_res_param(': 'resource res, int param | string',
\ 'udm_hash32(': 'resource agent, string str | int',
\ 'udm_load_ispell_data(': 'resource agent, int var, string val1, string val2, int flag | bool',
\ 'udm_open_stored(': 'resource agent, string storedaddr | int',
\ 'udm_set_agent_param(': 'resource agent, int var, string val | bool',
\ 'uksort(': 'array &array, callback cmp_function | bool',
\ 'umask(': '[int mask] | int',
\ 'uniqid(': '[string prefix [, bool more_entropy]] | string',
\ 'unixtojd(': '[int timestamp] | int',
\ 'unlink(': 'string filename [, resource context] | bool',
\ 'unpack(': 'string format, string data | array',
\ 'unregister_tick_function(': 'string function_name | void',
\ 'unserialize(': 'string str | mixed',
\ 'unset(': 'mixed var [, mixed var [, mixed ...]] | void',
\ 'urldecode(': 'string str | string',
\ 'urlencode(': 'string str | string',
\ 'use_soap_error_handler(': '[bool handler] | void',
\ 'usleep(': 'int micro_seconds | void',
\ 'usort(': 'array &array, callback cmp_function | bool',
\ 'utf8_decode(': 'string data | string',
\ 'utf8_encode(': 'string data | string',
\ 'var_dump(': 'mixed expression [, mixed expression [, ...]] | void',
\ 'var_export(': 'mixed expression [, bool return] | mixed',
\ 'variant_abs(': 'mixed val | mixed',
\ 'variant_add(': 'mixed left, mixed right | mixed',
\ 'variant_and(': 'mixed left, mixed right | mixed',
\ 'variant_cast(': 'variant variant, int type | variant',
\ 'variant_cat(': 'mixed left, mixed right | mixed',
\ 'variant_cmp(': 'mixed left, mixed right [, int lcid [, int flags]] | int',
\ 'variant_date_from_timestamp(': 'int timestamp | variant',
\ 'variant_date_to_timestamp(': 'variant variant | int',
\ 'variant_div(': 'mixed left, mixed right | mixed',
\ 'variant_eqv(': 'mixed left, mixed right | mixed',
\ 'variant_fix(': 'mixed variant | mixed',
\ 'variant_get_type(': 'variant variant | int',
\ 'variant_idiv(': 'mixed left, mixed right | mixed',
\ 'variant_imp(': 'mixed left, mixed right | mixed',
\ 'variant_int(': 'mixed variant | mixed',
\ 'variant_mod(': 'mixed left, mixed right | mixed',
\ 'variant_mul(': 'mixed left, mixed right | mixed',
\ 'variant_neg(': 'mixed variant | mixed',
\ 'variant_not(': 'mixed variant | mixed',
\ 'variant_or(': 'mixed left, mixed right | mixed',
\ 'variant_pow(': 'mixed left, mixed right | mixed',
\ 'variant_round(': 'mixed variant, int decimals | mixed',
\ 'variant_set(': 'variant variant, mixed value | void',
\ 'variant_set_type(': 'variant variant, int type | void',
\ 'variant_sub(': 'mixed left, mixed right | mixed',
\ 'variant_xor(': 'mixed left, mixed right | mixed',
\ 'version_compare(': 'string version1, string version2 [, string operator] | int',
\ 'vfprintf(': 'resource handle, string format, array args | int',
\ 'virtual(': 'string filename | int',
\ 'vpopmail_add_alias_domain(': 'string domain, string aliasdomain | bool',
\ 'vpopmail_add_alias_domain_ex(': 'string olddomain, string newdomain | bool',
\ 'vpopmail_add_domain(': 'string domain, string dir, int uid, int gid | bool',
\ 'vpopmail_add_domain_ex(': 'string domain, string passwd [, string quota [, string bounce [, bool apop]]] | bool',
\ 'vpopmail_add_user(': 'string user, string domain, string password [, string gecos [, bool apop]] | bool',
\ 'vpopmail_alias_add(': 'string user, string domain, string alias | bool',
\ 'vpopmail_alias_del(': 'string user, string domain | bool',
\ 'vpopmail_alias_del_domain(': 'string domain | bool',
\ 'vpopmail_alias_get(': 'string alias, string domain | array',
\ 'vpopmail_alias_get_all(': 'string domain | array',
\ 'vpopmail_auth_user(': 'string user, string domain, string password [, string apop] | bool',
\ 'vpopmail_del_domain(': 'string domain | bool',
\ 'vpopmail_del_domain_ex(': 'string domain | bool',
\ 'vpopmail_del_user(': 'string user, string domain | bool',
\ 'vpopmail_error(': 'void  | string',
\ 'vpopmail_passwd(': 'string user, string domain, string password [, bool apop] | bool',
\ 'vpopmail_set_user_quota(': 'string user, string domain, string quota | bool',
\ 'vprintf(': 'string format, array args | int',
\ 'vsprintf(': 'string format, array args | string',
\ 'w32api_deftype(': 'string typename, string member1_type, string member1_name [, string ... [, string ...]] | bool',
\ 'w32api_init_dtype(': 'string typename, mixed value [, mixed ...] | resource',
\ 'w32api_invoke_function(': 'string funcname, mixed argument [, mixed ...] | mixed',
\ 'w32api_register_function(': 'string library, string function_name, string return_type | bool',
\ 'w32api_set_call_method(': 'int method | void',
\ 'wddx_add_vars(': 'int packet_id, mixed name_var [, mixed ...] | bool',
\ 'wddx_deserialize(': 'string packet | mixed',
\ 'wddx_packet_end(': 'int packet_id | string',
\ 'wddx_packet_start(': '[string comment] | int',
\ 'wddx_serialize_value(': 'mixed var [, string comment] | string',
\ 'wddx_serialize_vars(': 'mixed var_name [, mixed ...] | string',
\ 'wordwrap(': 'string str [, int width [, string break [, bool cut]]] | string',
\ 'xattr_get(': 'string filename, string name [, int flags] | string',
\ 'xattr_list(': 'string filename [, int flags] | array',
\ 'xattr_remove(': 'string filename, string name [, int flags] | bool',
\ 'xattr_set(': 'string filename, string name, string value [, int flags] | bool',
\ 'xattr_supported(': 'string filename [, int flags] | bool',
\ 'xdiff_file_diff(': 'string file1, string file2, string dest [, int context [, bool minimal]] | bool',
\ 'xdiff_file_diff_binary(': 'string file1, string file2, string dest | bool',
\ 'xdiff_file_merge3(': 'string file1, string file2, string file3, string dest | mixed',
\ 'xdiff_file_patch(': 'string file, string patch, string dest [, int flags] | mixed',
\ 'xdiff_file_patch_binary(': 'string file, string patch, string dest | bool',
\ 'xdiff_string_diff(': 'string str1, string str2 [, int context [, bool minimal]] | mixed',
\ 'xdiff_string_diff_binary(': 'string str1, string str2 | mixed',
\ 'xdiff_string_merge3(': 'string str1, string str2, string str3 [, string &error] | string',
\ 'xdiff_string_patch(': 'string str, string patch [, int flags [, string &error]] | string',
\ 'xdiff_string_patch_binary(': 'string str, string patch | string',
\ 'xml_error_string(': 'int code | string',
\ 'xml_get_current_byte_index(': 'resource parser | int',
\ 'xml_get_current_column_number(': 'resource parser | int',
\ 'xml_get_current_line_number(': 'resource parser | int',
\ 'xml_get_error_code(': 'resource parser | int',
\ 'xml_parse(': 'resource parser, string data [, bool is_final] | bool',
\ 'xml_parse_into_struct(': 'resource parser, string data, array &values [, array &index] | int',
\ 'xml_parser_create(': '[string encoding] | resource',
\ 'xml_parser_create_ns(': '[string encoding [, string separator]] | resource',
\ 'xml_parser_free(': 'resource parser | bool',
\ 'xml_parser_get_option(': 'resource parser, int option | mixed',
\ 'xml_parser_set_option(': 'resource parser, int option, mixed value | bool',
\ 'xmlrpc_decode(': 'string xml [, string encoding] | array',
\ 'xmlrpc_decode_request(': 'string xml, string &method [, string encoding] | array',
\ 'xmlrpc_encode(': 'mixed value | string',
\ 'xmlrpc_encode_request(': 'string method, mixed params [, array output_options] | string',
\ 'xmlrpc_get_type(': 'mixed value | string',
\ 'xmlrpc_is_fault(': 'array arg | bool',
\ 'xmlrpc_parse_method_descriptions(': 'string xml | array',
\ 'xmlrpc_server_add_introspection_data(': 'resource server, array desc | int',
\ 'xmlrpc_server_call_method(': 'resource server, string xml, mixed user_data [, array output_options] | mixed',
\ 'xmlrpc_server_create(': 'void  | resource',
\ 'xmlrpc_server_destroy(': 'resource server | int',
\ 'xmlrpc_server_register_introspection_callback(': 'resource server, string function | bool',
\ 'xmlrpc_server_register_method(': 'resource server, string method_name, string function | bool',
\ 'xmlrpc_set_type(': 'string &value, string type | bool',
\ 'xml_set_character_data_handler(': 'resource parser, callback handler | bool',
\ 'xml_set_default_handler(': 'resource parser, callback handler | bool',
\ 'xml_set_element_handler(': 'resource parser, callback start_element_handler, callback end_element_handler | bool',
\ 'xml_set_end_namespace_decl_handler(': 'resource parser, callback handler | bool',
\ 'xml_set_external_entity_ref_handler(': 'resource parser, callback handler | bool',
\ 'xml_set_notation_decl_handler(': 'resource parser, callback handler | bool',
\ 'xml_set_object(': 'resource parser, object &object | void',
\ 'xml_set_processing_instruction_handler(': 'resource parser, callback handler | bool',
\ 'xml_set_start_namespace_decl_handler(': 'resource parser, callback handler | bool',
\ 'xml_set_unparsed_entity_decl_handler(': 'resource parser, callback handler | bool',
\ 'xpath_eval(': 'XPathContext xpath_context, string xpath_expression [, domnode contextnode] | array',
\ 'xpath_eval_expression(': 'XPathContext xpath_context, string expression | XPathObject',
\ 'xpath_new_context(': 'domdocument dom_document | XPathContext',
\ 'xptr_eval(': '[XPathContext xpath_context, string eval_str] | int',
\ 'xptr_new_context(': 'void  | XPathContext',
\ 'xslt_backend_info(': 'void  | string',
\ 'xslt_backend_name(': 'void  | string',
\ 'xslt_backend_version(': 'void  | string',
\ 'xslt_create(': 'void  | resource',
\ 'xslt_errno(': 'resource xh | int',
\ 'xslt_error(': 'resource xh | mixed',
\ 'xslt_free(': 'resource xh | void',
\ 'xslt_getopt(': 'resource processor | int',
\ 'xslt_process(': 'resource xh, string xmlcontainer, string xslcontainer [, string resultcontainer [, array arguments [, array parameters]]] | mixed',
\ 'xslt_set_base(': 'resource xh, string uri | void',
\ 'xslt_set_encoding(': 'resource xh, string encoding | void',
\ 'xslt_set_error_handler(': 'resource xh, mixed handler | void',
\ 'xslt_set_log(': 'resource xh [, mixed log] | void',
\ 'xslt_set_object(': 'resource processor, object &obj | int',
\ 'xslt_setopt(': 'resource processor, int newmask | int',
\ 'xslt_set_sax_handler(': 'resource xh, array handlers | void',
\ 'xslt_set_sax_handlers(': 'resource processor, array handlers | void',
\ 'xslt_set_scheme_handler(': 'resource xh, array handlers | void',
\ 'xslt_set_scheme_handlers(': 'resource processor, array handlers | void',
\ 'yaz_addinfo(': 'resource id | string',
\ 'yaz_ccl_conf(': 'resource id, array config | int',
\ 'yaz_ccl_parse(': 'resource id, string query, array &result | bool',
\ 'yaz_close(': 'resource id | bool',
\ 'yaz_connect(': 'string zurl [, mixed options] | resource',
\ 'yaz_database(': 'resource id, string databases | bool',
\ 'yaz_element(': 'resource id, string elementset | bool',
\ 'yaz_errno(': 'resource id | int',
\ 'yaz_error(': 'resource id | string',
\ 'yaz_es_result(': 'resource id | array',
\ 'yaz_get_option(': 'resource id, string name | string',
\ 'yaz_hits(': 'resource id | int',
\ 'yaz_itemorder(': 'resource id, array args | int',
\ 'yaz_present(': 'resource id | bool',
\ 'yaz_range(': 'resource id, int start, int number | bool',
\ 'yaz_record(': 'resource id, int pos, string type | string',
\ 'yaz_scan(': 'resource id, string type, string startterm [, array flags] | int',
\ 'yaz_scan_result(': 'resource id [, array &result] | array',
\ 'yaz_schema(': 'resource id, string schema | int',
\ 'yaz_search(': 'resource id, string type, string query | int',
\ 'yaz_set_option(': 'resource id, string name, string value | string',
\ 'yaz_sort(': 'resource id, string criteria | int',
\ 'yaz_syntax(': 'resource id, string syntax | int',
\ 'yaz_wait(': '[array &options] | int',
\ 'yp_all(': 'string domain, string map, string callback | void',
\ 'yp_cat(': 'string domain, string map | array',
\ 'yp_errno(': 'void  | int',
\ 'yp_err_string(': 'int errorcode | string',
\ 'yp_first(': 'string domain, string map | array',
\ 'yp_get_default_domain(': 'void  | int',
\ 'yp_master(': 'string domain, string map | string',
\ 'yp_match(': 'string domain, string map, string key | string',
\ 'yp_next(': 'string domain, string map, string key | array',
\ 'yp_order(': 'string domain, string map | int',
\ 'zend_logo_guid(': 'void  | string',
\ 'zend_version(': 'void  | string',
\ 'zip_close(': 'resource zip | void',
\ 'zip_entry_close(': 'resource zip_entry | void',
\ 'zip_entry_compressedsize(': 'resource zip_entry | int',
\ 'zip_entry_compressionmethod(': 'resource zip_entry | string',
\ 'zip_entry_filesize(': 'resource zip_entry | int',
\ 'zip_entry_name(': 'resource zip_entry | string',
\ 'zip_entry_open(': 'resource zip, resource zip_entry [, string mode] | bool',
\ 'zip_entry_read(': 'resource zip_entry [, int length] | string',
\ 'zip_open(': 'string filename | resource',
\ 'zip_read(': 'resource zip | resource',
\ 'zlib_get_coding_type(': 'void  | string'}
endfunction
" }}}
" vim:set foldmethod=marker:
