/*
 * (c) Copyright 2010-2014 Xilinx, Inc. All rights reserved.
 * (c) Copyright 2016 Topic Embedded Products.
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#include <asm/arch/ps7_init_gpl.h>

static unsigned long ps7_pll_init_data_3_0[] = {
	EMIT_MASKWRITE(0xF8000008, 0x0000FFFFU, 0x0000DF0DU),
	EMIT_MASKWRITE(0xF8000110, 0x003FFFF0U, 0x000FA220U),
	EMIT_MASKWRITE(0xF8000100, 0x0007F000U, 0x00028000U),
	EMIT_MASKWRITE(0xF8000100, 0x00000010U, 0x00000010U),
	EMIT_MASKWRITE(0xF8000100, 0x00000001U, 0x00000001U),
	EMIT_MASKWRITE(0xF8000100, 0x00000001U, 0x00000000U),
	EMIT_MASKPOLL(0xF800010C, 0x00000001U),
	EMIT_MASKWRITE(0xF8000100, 0x00000010U, 0x00000000U),
	EMIT_MASKWRITE(0xF8000120, 0x1F003F30U, 0x1F000200U),
	EMIT_MASKWRITE(0xF8000114, 0x003FFFF0U, 0x0012C220U),
	EMIT_MASKWRITE(0xF8000104, 0x0007F000U, 0x00020000U),
	EMIT_MASKWRITE(0xF8000104, 0x00000010U, 0x00000010U),
	EMIT_MASKWRITE(0xF8000104, 0x00000001U, 0x00000001U),
	EMIT_MASKWRITE(0xF8000104, 0x00000001U, 0x00000000U),
	EMIT_MASKPOLL(0xF800010C, 0x00000002U),
	EMIT_MASKWRITE(0xF8000104, 0x00000010U, 0x00000000U),
	EMIT_MASKWRITE(0xF8000124, 0xFFF00003U, 0x0C200003U),
	EMIT_MASKWRITE(0xF8000118, 0x003FFFF0U, 0x00113220U),
	EMIT_MASKWRITE(0xF8000108, 0x0007F000U, 0x00024000U),
	EMIT_MASKWRITE(0xF8000108, 0x00000010U, 0x00000010U),
	EMIT_MASKWRITE(0xF8000108, 0x00000001U, 0x00000001U),
	EMIT_MASKWRITE(0xF8000108, 0x00000001U, 0x00000000U),
	EMIT_MASKPOLL(0xF800010C, 0x00000004U),
	EMIT_MASKWRITE(0xF8000108, 0x00000010U, 0x00000000U),
	EMIT_MASKWRITE(0xF8000004, 0x0000FFFFU, 0x0000767BU),
	EMIT_EXIT(),
};

static unsigned long ps7_clock_init_data_3_0[] = {
	EMIT_MASKWRITE(0xF8000008, 0x0000FFFFU, 0x0000DF0DU),
	EMIT_MASKWRITE(0xF8000128, 0x03F03F01U, 0x00302301U),
	EMIT_MASKWRITE(0xF8000138, 0x00000011U, 0x00000011U),
	EMIT_MASKWRITE(0xF800013C, 0x00000011U, 0x00000011U),
	EMIT_MASKWRITE(0xF8000140, 0x03F03F71U, 0x00100141U),
	EMIT_MASKWRITE(0xF8000144, 0x03F03F71U, 0x00100141U),
	EMIT_MASKWRITE(0xF8000148, 0x00003F31U, 0x00000C01U),
	EMIT_MASKWRITE(0xF800014C, 0x00003F31U, 0x00000601U),
	EMIT_MASKWRITE(0xF8000150, 0x00003F33U, 0x00001803U),
	EMIT_MASKWRITE(0xF8000154, 0x00003F33U, 0x00000C03U),
	EMIT_MASKWRITE(0xF8000158, 0x00003F33U, 0x00000601U),
	EMIT_MASKWRITE(0xF8000168, 0x00003F31U, 0x00000601U),
	EMIT_MASKWRITE(0xF8000170, 0x03F03F30U, 0x00100C00U),
	EMIT_MASKWRITE(0xF8000180, 0x03F03F30U, 0x00100C00U),
	EMIT_MASKWRITE(0xF8000190, 0x03F03F30U, 0x00100600U),
	EMIT_MASKWRITE(0xF80001A0, 0x03F03F30U, 0x00101800U),
	EMIT_MASKWRITE(0xF80001C4, 0x00000001U, 0x00000001U),
	EMIT_MASKWRITE(0xF800012C, 0x01FFCCCDU, 0x01FC4C4DU),
	EMIT_MASKWRITE(0xF8000004, 0x0000FFFFU, 0x0000767BU),
	EMIT_EXIT(),
};

static unsigned long ps7_ddr_init_data_3_0[] = {
	EMIT_MASKWRITE(0xF8006000, 0x0001FFFFU, 0x00000080U),
	EMIT_MASKWRITE(0xF8006004, 0x0007FFFFU, 0x00001081U),
	EMIT_MASKWRITE(0xF8006008, 0x03FFFFFFU, 0x03C0780FU),
	EMIT_MASKWRITE(0xF800600C, 0x03FFFFFFU, 0x02001001U),
	EMIT_MASKWRITE(0xF8006010, 0x03FFFFFFU, 0x00014001U),
	EMIT_MASKWRITE(0xF8006014, 0x001FFFFFU, 0x0004281AU),
	EMIT_MASKWRITE(0xF8006018, 0xF7FFFFFFU, 0x44E458D2U),
	EMIT_MASKWRITE(0xF800601C, 0xFFFFFFFFU, 0x720238E5U),
	EMIT_MASKWRITE(0xF8006020, 0x7FDFFFFCU, 0x270872D0U),
	EMIT_MASKWRITE(0xF8006024, 0x0FFFFFC3U, 0x00000000U),
	EMIT_MASKWRITE(0xF8006028, 0x00003FFFU, 0x00002007U),
	EMIT_MASKWRITE(0xF800602C, 0xFFFFFFFFU, 0x00000008U),
	EMIT_MASKWRITE(0xF8006030, 0xFFFFFFFFU, 0x00040930U),
	EMIT_MASKWRITE(0xF8006034, 0x13FF3FFFU, 0x000116D4U),
	EMIT_MASKWRITE(0xF8006038, 0x00000003U, 0x00000000U),
	EMIT_MASKWRITE(0xF800603C, 0x000FFFFFU, 0x00000777U),
	EMIT_MASKWRITE(0xF8006040, 0xFFFFFFFFU, 0xFFF00000U),
	EMIT_MASKWRITE(0xF8006044, 0x0FFFFFFFU, 0x0F666666U),
	EMIT_MASKWRITE(0xF8006048, 0x0003F03FU, 0x0003C008U),
	EMIT_MASKWRITE(0xF8006050, 0xFF0F8FFFU, 0x77010800U),
	EMIT_MASKWRITE(0xF8006058, 0x00010000U, 0x00000000U),
	EMIT_MASKWRITE(0xF800605C, 0x0000FFFFU, 0x00005003U),
	EMIT_MASKWRITE(0xF8006060, 0x000017FFU, 0x0000003EU),
	EMIT_MASKWRITE(0xF8006064, 0x00021FE0U, 0x00020000U),
	EMIT_MASKWRITE(0xF8006068, 0x03FFFFFFU, 0x00284141U),
	EMIT_MASKWRITE(0xF800606C, 0x0000FFFFU, 0x00001610U),
	EMIT_MASKWRITE(0xF8006078, 0x03FFFFFFU, 0x00466111U),
	EMIT_MASKWRITE(0xF800607C, 0x000FFFFFU, 0x00032222U),
	EMIT_MASKWRITE(0xF80060A4, 0xFFFFFFFFU, 0x10200802U),
	EMIT_MASKWRITE(0xF80060A8, 0x0FFFFFFFU, 0x0690CB73U),
	EMIT_MASKWRITE(0xF80060AC, 0x000001FFU, 0x000001FEU),
	EMIT_MASKWRITE(0xF80060B0, 0x1FFFFFFFU, 0x1CFFFFFFU),
	EMIT_MASKWRITE(0xF80060B4, 0x00000200U, 0x00000200U),
	EMIT_MASKWRITE(0xF80060B8, 0x01FFFFFFU, 0x00200066U),
	EMIT_MASKWRITE(0xF80060C4, 0x00000003U, 0x00000003U),
	EMIT_MASKWRITE(0xF80060C4, 0x00000003U, 0x00000000U),
	EMIT_MASKWRITE(0xF80060C8, 0x000000FFU, 0x00000000U),
	EMIT_MASKWRITE(0xF80060DC, 0x00000001U, 0x00000000U),
	EMIT_MASKWRITE(0xF80060F0, 0x0000FFFFU, 0x00000000U),
	EMIT_MASKWRITE(0xF80060F4, 0x0000000FU, 0x00000008U),
	EMIT_MASKWRITE(0xF8006114, 0x000000FFU, 0x00000000U),
	EMIT_MASKWRITE(0xF8006118, 0x7FFFFFCFU, 0x40000001U),
	EMIT_MASKWRITE(0xF800611C, 0x7FFFFFCFU, 0x40000001U),
	EMIT_MASKWRITE(0xF8006120, 0x7FFFFFCFU, 0x40000001U),
	EMIT_MASKWRITE(0xF8006124, 0x7FFFFFCFU, 0x40000001U),
	EMIT_MASKWRITE(0xF800612C, 0x000FFFFFU, 0x0003482CU),
	EMIT_MASKWRITE(0xF8006130, 0x000FFFFFU, 0x00033032U),
	EMIT_MASKWRITE(0xF8006134, 0x000FFFFFU, 0x0002E81FU),
	EMIT_MASKWRITE(0xF8006138, 0x000FFFFFU, 0x0002F81AU),
	EMIT_MASKWRITE(0xF8006140, 0x000FFFFFU, 0x00000035U),
	EMIT_MASKWRITE(0xF8006144, 0x000FFFFFU, 0x00000035U),
	EMIT_MASKWRITE(0xF8006148, 0x000FFFFFU, 0x00000035U),
	EMIT_MASKWRITE(0xF800614C, 0x000FFFFFU, 0x00000035U),
	EMIT_MASKWRITE(0xF8006154, 0x000FFFFFU, 0x000000ACU),
	EMIT_MASKWRITE(0xF8006158, 0x000FFFFFU, 0x000000B2U),
	EMIT_MASKWRITE(0xF800615C, 0x000FFFFFU, 0x0000009FU),
	EMIT_MASKWRITE(0xF8006160, 0x000FFFFFU, 0x0000009AU),
	EMIT_MASKWRITE(0xF8006168, 0x001FFFFFU, 0x00000127U),
	EMIT_MASKWRITE(0xF800616C, 0x001FFFFFU, 0x00000121U),
	EMIT_MASKWRITE(0xF8006170, 0x001FFFFFU, 0x0000010FU),
	EMIT_MASKWRITE(0xF8006174, 0x001FFFFFU, 0x00000113U),
	EMIT_MASKWRITE(0xF800617C, 0x000FFFFFU, 0x000000ECU),
	EMIT_MASKWRITE(0xF8006180, 0x000FFFFFU, 0x000000F2U),
	EMIT_MASKWRITE(0xF8006184, 0x000FFFFFU, 0x000000DFU),
	EMIT_MASKWRITE(0xF8006188, 0x000FFFFFU, 0x000000DAU),
	EMIT_MASKWRITE(0xF8006190, 0xFFFFFFFFU, 0x1002E080U),
	EMIT_MASKWRITE(0xF8006194, 0x000FFFFFU, 0x0001FC82U),
	EMIT_MASKWRITE(0xF8006204, 0xFFFFFFFFU, 0x00000000U),
	EMIT_MASKWRITE(0xF8006208, 0x000703FFU, 0x000003FFU),
	EMIT_MASKWRITE(0xF800620C, 0x000703FFU, 0x000003FFU),
	EMIT_MASKWRITE(0xF8006210, 0x000703FFU, 0x000003FFU),
	EMIT_MASKWRITE(0xF8006214, 0x000703FFU, 0x000003FFU),
	EMIT_MASKWRITE(0xF8006218, 0x000F03FFU, 0x000003FFU),
	EMIT_MASKWRITE(0xF800621C, 0x000F03FFU, 0x000003FFU),
	EMIT_MASKWRITE(0xF8006220, 0x000F03FFU, 0x000003FFU),
	EMIT_MASKWRITE(0xF8006224, 0x000F03FFU, 0x000003FFU),
	EMIT_MASKWRITE(0xF80062A8, 0x00000FF5U, 0x00000000U),
	EMIT_MASKWRITE(0xF80062AC, 0xFFFFFFFFU, 0x00000000U),
	EMIT_MASKWRITE(0xF80062B0, 0x003FFFFFU, 0x00005125U),
	EMIT_MASKWRITE(0xF80062B4, 0x0003FFFFU, 0x000012A8U),
	EMIT_MASKPOLL(0xF8000B74, 0x00002000U),
	EMIT_MASKWRITE(0xF8006000, 0x0001FFFFU, 0x00000081U),
	EMIT_MASKPOLL(0xF8006054, 0x00000007U),
	EMIT_EXIT(),
};

static unsigned long ps7_mio_init_data_3_0[] = {
	EMIT_MASKWRITE(0xF8000008, 0x0000FFFFU, 0x0000DF0DU),
	EMIT_MASKWRITE(0xF8000B40, 0x00000FFFU, 0x00000600U),
	EMIT_MASKWRITE(0xF8000B44, 0x00000FFFU, 0x00000600U),
	EMIT_MASKWRITE(0xF8000B48, 0x00000FFFU, 0x00000672U),
	EMIT_MASKWRITE(0xF8000B4C, 0x00000FFFU, 0x00000672U),
	EMIT_MASKWRITE(0xF8000B50, 0x00000FFFU, 0x00000674U),
	EMIT_MASKWRITE(0xF8000B54, 0x00000FFFU, 0x00000674U),
	EMIT_MASKWRITE(0xF8000B58, 0x00000FFFU, 0x00000600U),
	EMIT_MASKWRITE(0xF8000B5C, 0xFFFFFFFFU, 0x0018C61CU),
	EMIT_MASKWRITE(0xF8000B60, 0xFFFFFFFFU, 0x00F9861CU),
	EMIT_MASKWRITE(0xF8000B64, 0xFFFFFFFFU, 0x00F9861CU),
	EMIT_MASKWRITE(0xF8000B68, 0xFFFFFFFFU, 0x00F9861CU),
	EMIT_MASKWRITE(0xF8000B6C, 0x00007FFFU, 0x00000E60U),
	EMIT_MASKWRITE(0xF8000B70, 0x00000001U, 0x00000001U),
	EMIT_MASKWRITE(0xF8000B70, 0x00000021U, 0x00000020U),
	EMIT_MASKWRITE(0xF8000B70, 0x07FEFFFFU, 0x00000823U),
	EMIT_MASKWRITE(0xF8000004, 0x0000FFFFU, 0x0000767BU),
	EMIT_EXIT(),
};

static unsigned long ps7_peripherals_init_data_3_0[] = {
	EMIT_MASKWRITE(0xF8000008, 0x0000FFFFU, 0x0000DF0DU),
	EMIT_MASKWRITE(0xF8000B48, 0x00000180U, 0x00000180U),
	EMIT_MASKWRITE(0xF8000B4C, 0x00000180U, 0x00000180U),
	EMIT_MASKWRITE(0xF8000B50, 0x00000180U, 0x00000180U),
	EMIT_MASKWRITE(0xF8000B54, 0x00000180U, 0x00000180U),
	EMIT_MASKWRITE(0xF8000004, 0x0000FFFFU, 0x0000767BU),
	EMIT_MASKWRITE(0xE0001034, 0x000000FFU, 0x00000006U),
	EMIT_MASKWRITE(0xE0001018, 0x0000FFFFU, 0x0000007CU),
	EMIT_MASKWRITE(0xE0001000, 0x000001FFU, 0x00000017U),
	EMIT_MASKWRITE(0xE0001004, 0x000003FFU, 0x00000020U),
	EMIT_MASKWRITE(0xE0000034, 0x000000FFU, 0x00000006U),
	EMIT_MASKWRITE(0xE0000018, 0x0000FFFFU, 0x0000007CU),
	EMIT_MASKWRITE(0xE0000000, 0x000001FFU, 0x00000017U),
	EMIT_MASKWRITE(0xE0000004, 0x000003FFU, 0x00000020U),
	EMIT_MASKWRITE(0xE000D000, 0x000800FFU, 0x000800C1U),
	EMIT_MASKWRITE(0xF8007000, 0x20000000U, 0x00000000U),
	EMIT_MASKDELAY(0xF8F00200, 1),
	EMIT_MASKDELAY(0xF8F00200, 1),
	EMIT_MASKDELAY(0xF8F00200, 1),
	EMIT_EXIT(),
};

static unsigned long ps7_post_config_3_0[] = {
	EMIT_MASKWRITE(0xF8000008, 0x0000FFFFU, 0x0000DF0DU),
	EMIT_MASKWRITE(0xF8000900, 0x0000000FU, 0x0000000FU),
	EMIT_MASKWRITE(0xF8000240, 0xFFFFFFFFU, 0x00000000U),
	EMIT_MASKWRITE(0xF8000004, 0x0000FFFFU, 0x0000767BU),
	EMIT_EXIT(),
};

int ps7_init(void)
{
	int ret;

	ret = ps7_config(ps7_mio_init_data_3_0);
	if (ret != PS7_INIT_SUCCESS)
		return ret;
	ret = ps7_config(ps7_pll_init_data_3_0);
	if (ret != PS7_INIT_SUCCESS)
		return ret;
	ret = ps7_config(ps7_clock_init_data_3_0);
	if (ret != PS7_INIT_SUCCESS)
		return ret;
	ret = ps7_config(ps7_ddr_init_data_3_0);
	if (ret != PS7_INIT_SUCCESS)
		return ret;
	ret = ps7_config(ps7_peripherals_init_data_3_0);
	if (ret != PS7_INIT_SUCCESS)
		return ret;

	return PS7_INIT_SUCCESS;
}

int ps7_post_config(void)
{
	return ps7_config(ps7_post_config_3_0);
}
