/*
 * Copyright (C) 2008 Atmel Corporation
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */
#ifndef __ASM_AVR32_ARCH_HMATRIX_H__
#define __ASM_AVR32_ARCH_HMATRIX_H__

#include <asm/hmatrix-common.h>

/* Bitfields in SFR4 (EBI) */
#define HMATRIX_EBI_SDRAM_ENABLE_OFFSET		1
#define HMATRIX_EBI_SDRAM_ENABLE_SIZE		1
#define HMATRIX_EBI_NAND_ENABLE_OFFSET		3
#define HMATRIX_EBI_NAND_ENABLE_SIZE		1
#define HMATRIX_EBI_CF0_ENABLE_OFFSET		4
#define HMATRIX_EBI_CF0_ENABLE_SIZE		1
#define HMATRIX_EBI_CF1_ENABLE_OFFSET		5
#define HMATRIX_EBI_CF1_ENABLE_SIZE		1
#define HMATRIX_EBI_PULLUP_DISABLE_OFFSET	8
#define HMATRIX_EBI_PULLUP_DISABLE_SIZE		1

/* HSB masters */
#define HMATRIX_MASTER_CPU_DCACHE		0
#define HMATRIX_MASTER_CPU_ICACHE		1
#define HMATRIX_MASTER_PDC			2
#define HMATRIX_MASTER_ISI			3
#define HMATRIX_MASTER_USBA			4
#define HMATRIX_MASTER_LCDC			5
#define HMATRIX_MASTER_MACB0			6
#define HMATRIX_MASTER_MACB1			7
#define HMATRIX_MASTER_DMACA_M0			8
#define HMATRIX_MASTER_DMACA_M1			9

/* HSB slaves */
#define HMATRIX_SLAVE_SRAM0			0
#define HMATRIX_SLAVE_SRAM1			1
#define HMATRIX_SLAVE_PBA			2
#define HMATRIX_SLAVE_PBB			3
#define HMATRIX_SLAVE_EBI			4
#define HMATRIX_SLAVE_USBA			5
#define HMATRIX_SLAVE_LCDC			6
#define HMATRIX_SLAVE_DMACA			7

#endif /* __ASM_AVR32_ARCH_HMATRIX_H__ */
