/*
 * Copyright (C) 2014 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef __ASM_ARCH_MX6_MX6_PINS_H__
#define __ASM_ARCH_MX6_MX6_PINS_H__

#include <asm/imx-common/iomux-v3.h>

enum {
	 MX6_PAD_GPIO1_IO00__I2C1_SCL                           = IOMUX_PAD(0x035C, 0x0014, IOMUX_CONFIG_SION | 0, 0x07A8, 1, 0),
	 MX6_PAD_GPIO1_IO00__USDHC1_VSELECT                     = IOMUX_PAD(0x035C, 0x0014, 1, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO00__SPDIF_LOCK                         = IOMUX_PAD(0x035C, 0x0014, 2, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO00__CCM_WAIT                           = IOMUX_PAD(0x035C, 0x0014, 3, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO00__WDOG1_WDOG_ANY                     = IOMUX_PAD(0x035C, 0x0014, 4, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO00__GPIO1_IO_0                         = IOMUX_PAD(0x035C, 0x0014, 5, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO00__SNVS_HP_WRAPPER_VIO_5              = IOMUX_PAD(0x035C, 0x0014, 6, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO00__PHY_DTB_1                          = IOMUX_PAD(0x035C, 0x0014, 7, 0x0000, 0, 0),

	 MX6_PAD_GPIO1_IO01__I2C1_SDA                           = IOMUX_PAD(0x0360, 0x0018, IOMUX_CONFIG_SION | 0, 0x07AC, 1, 0),
	 MX6_PAD_GPIO1_IO01__USDHC1_RESET_B                     = IOMUX_PAD(0x0360, 0x0018, 1, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO01__SPDIF_SR_CLK                       = IOMUX_PAD(0x0360, 0x0018, 2, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO01__CCM_STOP                           = IOMUX_PAD(0x0360, 0x0018, 3, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO01__WDOG3_WDOG_B                       = IOMUX_PAD(0x0360, 0x0018, 4, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO01__GPIO1_IO_1                         = IOMUX_PAD(0x0360, 0x0018, 5, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO01__SNVS_HP_WRAPPER_VIO_5_CTL          = IOMUX_PAD(0x0360, 0x0018, 6, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO01__PHY_DTB_0                          = IOMUX_PAD(0x0360, 0x0018, 7, 0x0000, 0, 0),

	 MX6_PAD_GPIO1_IO02__I2C2_SCL                           = IOMUX_PAD(0x0364, 0x001C, IOMUX_CONFIG_SION | 0, 0x07B0, 1, 0),
	 MX6_PAD_GPIO1_IO02__USDHC1_CD_B                        = IOMUX_PAD(0x0364, 0x001C, 1, 0x0864, 1, 0),
	 MX6_PAD_GPIO1_IO02__CSI2_MCLK                          = IOMUX_PAD(0x0364, 0x001C, 2, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO02__CCM_DI0_EXT_CLK                    = IOMUX_PAD(0x0364, 0x001C, 3, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO02__WDOG1_WDOG_B                       = IOMUX_PAD(0x0364, 0x001C, 4, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO02__GPIO1_IO_2                         = IOMUX_PAD(0x0364, 0x001C, 5, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO02__CCM_REF_EN_B                       = IOMUX_PAD(0x0364, 0x001C, 6, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO02__PHY_TDI                            = IOMUX_PAD(0x0364, 0x001C, 7, 0x0000, 0, 0),

	 MX6_PAD_GPIO1_IO03__I2C2_SDA                           = IOMUX_PAD(0x0368, 0x0020, IOMUX_CONFIG_SION | 0, 0x07B4, 1, 0),
	 MX6_PAD_GPIO1_IO03__USDHC1_WP                          = IOMUX_PAD(0x0368, 0x0020, 1, 0x0868, 1, 0),
	 MX6_PAD_GPIO1_IO03__ENET1_REF_CLK_25M                  = IOMUX_PAD(0x0368, 0x0020, 2, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO03__CCM_DI1_EXT_CLK                    = IOMUX_PAD(0x0368, 0x0020, 3, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO03__WDOG2_WDOG_B                       = IOMUX_PAD(0x0368, 0x0020, 4, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO03__GPIO1_IO_3                         = IOMUX_PAD(0x0368, 0x0020, 5, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO03__CCM_PLL3_BYP                       = IOMUX_PAD(0x0368, 0x0020, 6, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO03__PHY_TCK                            = IOMUX_PAD(0x0368, 0x0020, 7, 0x0000, 0, 0),

	 MX6_PAD_GPIO1_IO04__UART1_TX                           = IOMUX_PAD(0x036C, 0x0024, 0, 0x0830, 0, 0),
	 MX6_PAD_GPIO1_IO04__USDHC2_RESET_B                     = IOMUX_PAD(0x036C, 0x0024, 1, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO04__ENET1_MDC                          = IOMUX_PAD(0x036C, 0x0024, 2, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO04__OSC32K_32K_OUT                     = IOMUX_PAD(0x036C, 0x0024, 3, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO04__ENET2_REF_CLK2                     = IOMUX_PAD(0x036C, 0x0024, 4, 0x076C, 0, 0),
	 MX6_PAD_GPIO1_IO04__GPIO1_IO_4                         = IOMUX_PAD(0x036C, 0x0024, 5, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO04__CCM_PLL2_BYP                       = IOMUX_PAD(0x036C, 0x0024, 6, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO04__PHY_TMS                            = IOMUX_PAD(0x036C, 0x0024, 7, 0x0000, 0, 0),

	 MX6_PAD_GPIO1_IO05__UART1_RX                           = IOMUX_PAD(0x0370, 0x0028, 0, 0x0830, 1, 0),
	 MX6_PAD_GPIO1_IO05__USDHC2_VSELECT                     = IOMUX_PAD(0x0370, 0x0028, 1, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO05__ENET1_MDIO                         = IOMUX_PAD(0x0370, 0x0028, 2, 0x0764, 0, 0),
	 MX6_PAD_GPIO1_IO05__ASRC_ASRC_EXT_CLK                  = IOMUX_PAD(0x0370, 0x0028, 3, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO05__ENET1_REF_CLK1                     = IOMUX_PAD(0x0370, 0x0028, 4, 0x0760, 0, 0),
	 MX6_PAD_GPIO1_IO05__GPIO1_IO_5                         = IOMUX_PAD(0x0370, 0x0028, 5, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO05__SRC_TESTER_ACK                     = IOMUX_PAD(0x0370, 0x0028, 6, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO05__PHY_TDO                            = IOMUX_PAD(0x0370, 0x0028, 7, 0x0000, 0, 0),

	 MX6_PAD_GPIO1_IO06__UART2_TX                           = IOMUX_PAD(0x0374, 0x002C, 0, 0x0838, 0, 0),
	 MX6_PAD_GPIO1_IO06__USDHC2_CD_B                        = IOMUX_PAD(0x0374, 0x002C, 1, 0x086C, 1, 0),
	 MX6_PAD_GPIO1_IO06__ENET2_MDC                          = IOMUX_PAD(0x0374, 0x002C, 2, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO06__CSI1_MCLK                          = IOMUX_PAD(0x0374, 0x002C, 3, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO06__UART1_RTS_B                        = IOMUX_PAD(0x0374, 0x002C, 4, 0x082C, 0, 0),
	 MX6_PAD_GPIO1_IO06__GPIO1_IO_6                         = IOMUX_PAD(0x0374, 0x002C, 5, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO06__SRC_ANY_PU_RESET                   = IOMUX_PAD(0x0374, 0x002C, 6, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO06__OCOTP_CTRL_WRAPPER_FUSE_LATCHED    = IOMUX_PAD(0x0374, 0x002C, 7, 0x0000, 0, 0),

	 MX6_PAD_GPIO1_IO07__UART2_RX                           = IOMUX_PAD(0x0378, 0x0030, 0, 0x0838, 1, 0),
	 MX6_PAD_GPIO1_IO07__USDHC2_WP                          = IOMUX_PAD(0x0378, 0x0030, 1, 0x0870, 1, 0),
	 MX6_PAD_GPIO1_IO07__ENET2_MDIO                         = IOMUX_PAD(0x0378, 0x0030, 2, 0x0770, 0, 0),
	 MX6_PAD_GPIO1_IO07__AUDMUX_MCLK                        = IOMUX_PAD(0x0378, 0x0030, 3, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO07__UART1_CTS_B                        = IOMUX_PAD(0x0378, 0x0030, 4, 0x082C, 1, 0),
	 MX6_PAD_GPIO1_IO07__GPIO1_IO_7                         = IOMUX_PAD(0x0378, 0x0030, 5, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO07__SRC_EARLY_RESET                    = IOMUX_PAD(0x0378, 0x0030, 6, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO07__DCIC2_OUT                          = IOMUX_PAD(0x0378, 0x0030, 7, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO07__VDEC_DEBUG_44                      = IOMUX_PAD(0x0378, 0x0030, 8, 0x0000, 0, 0),

	 MX6_PAD_GPIO1_IO08__USB_OTG1_OC                        = IOMUX_PAD(0x037C, 0x0034, 0, 0x0860, 0, 0),
	 MX6_PAD_GPIO1_IO08__WDOG1_WDOG_B                       = IOMUX_PAD(0x037C, 0x0034, 1, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO08__SDMA_EXT_EVENT_0                   = IOMUX_PAD(0x037C, 0x0034, 2, 0x081C, 0, 0),
	 MX6_PAD_GPIO1_IO08__CCM_PMIC_RDY                       = IOMUX_PAD(0x037C, 0x0034, 3, 0x069C, 1, 0),
	 MX6_PAD_GPIO1_IO08__UART2_RTS_B                        = IOMUX_PAD(0x037C, 0x0034, 4, 0x0834, 0, 0),
	 MX6_PAD_GPIO1_IO08__GPIO1_IO_8                         = IOMUX_PAD(0x037C, 0x0034, 5, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO08__SRC_SYSTEM_RESET                   = IOMUX_PAD(0x037C, 0x0034, 6, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO08__DCIC1_OUT                          = IOMUX_PAD(0x037C, 0x0034, 7, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO08__VDEC_DEBUG_43                      = IOMUX_PAD(0x037C, 0x0034, 8, 0x0000, 0, 0),

	 MX6_PAD_GPIO1_IO09__USB_OTG1_PWR                       = IOMUX_PAD(0x0380, 0x0038, 0, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO09__WDOG2_WDOG_B                       = IOMUX_PAD(0x0380, 0x0038, 1, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO09__SDMA_EXT_EVENT_1                   = IOMUX_PAD(0x0380, 0x0038, 2, 0x0820, 0, 0),
	 MX6_PAD_GPIO1_IO09__CCM_OUT0                           = IOMUX_PAD(0x0380, 0x0038, 3, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO09__UART2_CTS_B                        = IOMUX_PAD(0x0380, 0x0038, 4, 0x0834, 1, 0),
	 MX6_PAD_GPIO1_IO09__GPIO1_IO_9                         = IOMUX_PAD(0x0380, 0x0038, 5, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO09__SRC_INT_BOOT                       = IOMUX_PAD(0x0380, 0x0038, 6, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO09__OBSERVE_MUX_OUT_4                  = IOMUX_PAD(0x0380, 0x0038, 7, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO09__VDEC_DEBUG_42                      = IOMUX_PAD(0x0380, 0x0038, 8, 0x0000, 0, 0),

	 MX6_PAD_GPIO1_IO10__ANATOP_OTG1_ID                     = IOMUX_PAD(0x0384, 0x003C, 0, 0x0624, 0, 0),
	 MX6_PAD_GPIO1_IO10__SPDIF_EXT_CLK                      = IOMUX_PAD(0x0384, 0x003C, 1, 0x0828, 0, 0),
	 MX6_PAD_GPIO1_IO10__PWM1_OUT                           = IOMUX_PAD(0x0384, 0x003C, 2, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO10__CCM_OUT1                           = IOMUX_PAD(0x0384, 0x003C, 3, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO10__CSI1_FIELD                         = IOMUX_PAD(0x0384, 0x003C, 4, 0x070C, 1, 0),
	 MX6_PAD_GPIO1_IO10__GPIO1_IO_10                        = IOMUX_PAD(0x0384, 0x003C, 5, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO10__CSU_CSU_INT_DEB                    = IOMUX_PAD(0x0384, 0x003C, 6, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO10__OBSERVE_MUX_OUT_3                  = IOMUX_PAD(0x0384, 0x003C, 7, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO10__VDEC_DEBUG_41                      = IOMUX_PAD(0x0384, 0x003C, 8, 0x0000, 0, 0),

	 MX6_PAD_GPIO1_IO11__USB_OTG2_OC                        = IOMUX_PAD(0x0388, 0x0040, 0, 0x085C, 0, 0),
	 MX6_PAD_GPIO1_IO11__SPDIF_IN                           = IOMUX_PAD(0x0388, 0x0040, 1, 0x0824, 2, 0),
	 MX6_PAD_GPIO1_IO11__PWM2_OUT                           = IOMUX_PAD(0x0388, 0x0040, 2, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO11__CCM_CLKO1                          = IOMUX_PAD(0x0388, 0x0040, 3, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO11__MLB_DATA                           = IOMUX_PAD(0x0388, 0x0040, 4, 0x07EC, 0, 0),
	 MX6_PAD_GPIO1_IO11__GPIO1_IO_11                        = IOMUX_PAD(0x0388, 0x0040, 5, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO11__CSU_CSU_ALARM_AUT_0                = IOMUX_PAD(0x0388, 0x0040, 6, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO11__OBSERVE_MUX_OUT_2                  = IOMUX_PAD(0x0388, 0x0040, 7, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO11__VDEC_DEBUG_40                      = IOMUX_PAD(0x0388, 0x0040, 8, 0x0000, 0, 0),

	 MX6_PAD_GPIO1_IO12__USB_OTG2_PWR                       = IOMUX_PAD(0x038C, 0x0044, 0, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO12__SPDIF_OUT                          = IOMUX_PAD(0x038C, 0x0044, 1, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO12__PWM3_OUT                           = IOMUX_PAD(0x038C, 0x0044, 2, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO12__CCM_CLKO2                          = IOMUX_PAD(0x038C, 0x0044, 3, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO12__MLB_CLK                            = IOMUX_PAD(0x038C, 0x0044, 4, 0x07E8, 0, 0),
	 MX6_PAD_GPIO1_IO12__GPIO1_IO_12                        = IOMUX_PAD(0x038C, 0x0044, 5, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO12__CSU_CSU_ALARM_AUT_1                = IOMUX_PAD(0x038C, 0x0044, 6, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO12__OBSERVE_MUX_OUT_1                  = IOMUX_PAD(0x038C, 0x0044, 7, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO12__VDEC_DEBUG_39                      = IOMUX_PAD(0x038C, 0x0044, 8, 0x0000, 0, 0),

	 MX6_PAD_GPIO1_IO13__WDOG1_WDOG_ANY                     = IOMUX_PAD(0x0390, 0x0048, 0, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO13__ANATOP_OTG2_ID                     = IOMUX_PAD(0x0390, 0x0048, 1, 0x0628, 0, 0),
	 MX6_PAD_GPIO1_IO13__PWM4_OUT                           = IOMUX_PAD(0x0390, 0x0048, 2, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO13__CCM_OUT2                           = IOMUX_PAD(0x0390, 0x0048, 3, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO13__MLB_SIG                            = IOMUX_PAD(0x0390, 0x0048, 4, 0x07F0, 0, 0),
	 MX6_PAD_GPIO1_IO13__GPIO1_IO_13                        = IOMUX_PAD(0x0390, 0x0048, 5, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO13__CSU_CSU_ALARM_AUT_2                = IOMUX_PAD(0x0390, 0x0048, 6, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO13__OBSERVE_MUX_OUT_0                  = IOMUX_PAD(0x0390, 0x0048, 7, 0x0000, 0, 0),
	 MX6_PAD_GPIO1_IO13__VDEC_DEBUG_38                      = IOMUX_PAD(0x0390, 0x0048, 8, 0x0000, 0, 0),

	 MX6_PAD_CSI_DATA00__CSI1_DATA_2                        = IOMUX_PAD(0x0394, 0x004C, 0, 0x06A8, 0, 0),
	 MX6_PAD_CSI_DATA00__ESAI_TX_CLK                        = IOMUX_PAD(0x0394, 0x004C, 1, 0x078C, 1, 0),
	 MX6_PAD_CSI_DATA00__AUDMUX_AUD6_TXC                    = IOMUX_PAD(0x0394, 0x004C, 2, 0x0684, 1, 0),
	 MX6_PAD_CSI_DATA00__I2C1_SCL                           = IOMUX_PAD(0x0394, 0x004C, 3, 0x07A8, 0, 0),
	 MX6_PAD_CSI_DATA00__UART6_RI_B                         = IOMUX_PAD(0x0394, 0x004C, 4, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA00__GPIO1_IO_14                        = IOMUX_PAD(0x0394, 0x004C, 5, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA00__WEIM_DATA_23                       = IOMUX_PAD(0x0394, 0x004C, 6, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA00__SAI1_TX_BCLK                       = IOMUX_PAD(0x0394, 0x004C, 7, 0x0800, 0, 0),
	 MX6_PAD_CSI_DATA00__VADC_DATA_4                        = IOMUX_PAD(0x0394, 0x004C, 8, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA00__MMDC_DEBUG_37                      = IOMUX_PAD(0x0394, 0x004C, 9, 0x0000, 0, 0),

	 MX6_PAD_CSI_DATA01__CSI1_DATA_3                        = IOMUX_PAD(0x0398, 0x0050, 0, 0x06AC, 0, 0),
	 MX6_PAD_CSI_DATA01__ESAI_TX_FS                         = IOMUX_PAD(0x0398, 0x0050, 1, 0x077C, 1, 0),
	 MX6_PAD_CSI_DATA01__AUDMUX_AUD6_TXFS                   = IOMUX_PAD(0x0398, 0x0050, 2, 0x0688, 1, 0),
	 MX6_PAD_CSI_DATA01__I2C1_SDA                           = IOMUX_PAD(0x0398, 0x0050, 3, 0x07AC, 0, 0),
	 MX6_PAD_CSI_DATA01__UART6_DSR_B                        = IOMUX_PAD(0x0398, 0x0050, 4, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA01__GPIO1_IO_15                        = IOMUX_PAD(0x0398, 0x0050, 5, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA01__WEIM_DATA_22                       = IOMUX_PAD(0x0398, 0x0050, 6, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA01__SAI1_TX_SYNC                       = IOMUX_PAD(0x0398, 0x0050, 7, 0x0804, 0, 0),
	 MX6_PAD_CSI_DATA01__VADC_DATA_5                        = IOMUX_PAD(0x0398, 0x0050, 8, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA01__MMDC_DEBUG_38                      = IOMUX_PAD(0x0398, 0x0050, 9, 0x0000, 0, 0),

	 MX6_PAD_CSI_DATA02__CSI1_DATA_4                        = IOMUX_PAD(0x039C, 0x0054, 0, 0x06B0, 0, 0),
	 MX6_PAD_CSI_DATA02__ESAI_RX_CLK                        = IOMUX_PAD(0x039C, 0x0054, 1, 0x0788, 1, 0),
	 MX6_PAD_CSI_DATA02__AUDMUX_AUD6_RXC                    = IOMUX_PAD(0x039C, 0x0054, 2, 0x067C, 1, 0),
	 MX6_PAD_CSI_DATA02__KPP_COL_5                          = IOMUX_PAD(0x039C, 0x0054, 3, 0x07C8, 0, 0),
	 MX6_PAD_CSI_DATA02__UART6_DTR_B                        = IOMUX_PAD(0x039C, 0x0054, 4, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA02__GPIO1_IO_16                        = IOMUX_PAD(0x039C, 0x0054, 5, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA02__WEIM_DATA_21                       = IOMUX_PAD(0x039C, 0x0054, 6, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA02__SAI1_RX_BCLK                       = IOMUX_PAD(0x039C, 0x0054, 7, 0x07F4, 0, 0),
	 MX6_PAD_CSI_DATA02__VADC_DATA_6                        = IOMUX_PAD(0x039C, 0x0054, 8, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA02__MMDC_DEBUG_39                      = IOMUX_PAD(0x039C, 0x0054, 9, 0x0000, 0, 0),

	 MX6_PAD_CSI_DATA03__CSI1_DATA_5                        = IOMUX_PAD(0x03A0, 0x0058, 0, 0x06B4, 0, 0),
	 MX6_PAD_CSI_DATA03__ESAI_RX_FS                         = IOMUX_PAD(0x03A0, 0x0058, 1, 0x0778, 1, 0),
	 MX6_PAD_CSI_DATA03__AUDMUX_AUD6_RXFS                   = IOMUX_PAD(0x03A0, 0x0058, 2, 0x0680, 1, 0),
	 MX6_PAD_CSI_DATA03__KPP_ROW_5                          = IOMUX_PAD(0x03A0, 0x0058, 3, 0x07D4, 0, 0),
	 MX6_PAD_CSI_DATA03__UART6_DCD_B                        = IOMUX_PAD(0x03A0, 0x0058, 4, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA03__GPIO1_IO_17                        = IOMUX_PAD(0x03A0, 0x0058, 5, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA03__WEIM_DATA_20                       = IOMUX_PAD(0x03A0, 0x0058, 6, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA03__SAI1_RX_SYNC                       = IOMUX_PAD(0x03A0, 0x0058, 7, 0x07FC, 0, 0),
	 MX6_PAD_CSI_DATA03__VADC_DATA_7                        = IOMUX_PAD(0x03A0, 0x0058, 8, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA03__MMDC_DEBUG_40                      = IOMUX_PAD(0x03A0, 0x0058, 9, 0x0000, 0, 0),

	 MX6_PAD_CSI_DATA04__CSI1_DATA_6                        = IOMUX_PAD(0x03A4, 0x005C, 0, 0x06B8, 0, 0),
	 MX6_PAD_CSI_DATA04__ESAI_TX1                           = IOMUX_PAD(0x03A4, 0x005C, 1, 0x0794, 1, 0),
	 MX6_PAD_CSI_DATA04__SPDIF_OUT                          = IOMUX_PAD(0x03A4, 0x005C, 2, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA04__KPP_COL_6                          = IOMUX_PAD(0x03A4, 0x005C, 3, 0x07CC, 0, 0),
	 MX6_PAD_CSI_DATA04__UART6_RX                           = IOMUX_PAD(0x03A4, 0x005C, 4, 0x0858, 0, 0),
	 MX6_PAD_CSI_DATA04__GPIO1_IO_18                        = IOMUX_PAD(0x03A4, 0x005C, 5, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA04__WEIM_DATA_19                       = IOMUX_PAD(0x03A4, 0x005C, 6, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA04__PWM5_OUT                           = IOMUX_PAD(0x03A4, 0x005C, 7, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA04__VADC_DATA_8                        = IOMUX_PAD(0x03A4, 0x005C, 8, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA04__MMDC_DEBUG_41                      = IOMUX_PAD(0x03A4, 0x005C, 9, 0x0000, 0, 0),

	 MX6_PAD_CSI_DATA05__CSI1_DATA_7                        = IOMUX_PAD(0x03A8, 0x0060, 0, 0x06BC, 0, 0),
	 MX6_PAD_CSI_DATA05__ESAI_TX4_RX1                       = IOMUX_PAD(0x03A8, 0x0060, 1, 0x07A0, 1, 0),
	 MX6_PAD_CSI_DATA05__SPDIF_IN                           = IOMUX_PAD(0x03A8, 0x0060, 2, 0x0824, 1, 0),
	 MX6_PAD_CSI_DATA05__KPP_ROW_6                          = IOMUX_PAD(0x03A8, 0x0060, 3, 0x07D8, 0, 0),
	 MX6_PAD_CSI_DATA05__UART6_TX                           = IOMUX_PAD(0x03A8, 0x0060, 4, 0x0858, 1, 0),
	 MX6_PAD_CSI_DATA05__GPIO1_IO_19                        = IOMUX_PAD(0x03A8, 0x0060, 5, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA05__WEIM_DATA_18                       = IOMUX_PAD(0x03A8, 0x0060, 6, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA05__PWM6_OUT                           = IOMUX_PAD(0x03A8, 0x0060, 7, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA05__VADC_DATA_9                        = IOMUX_PAD(0x03A8, 0x0060, 8, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA05__MMDC_DEBUG_42                      = IOMUX_PAD(0x03A8, 0x0060, 9, 0x0000, 0, 0),

	 MX6_PAD_CSI_DATA06__CSI1_DATA_8                        = IOMUX_PAD(0x03AC, 0x0064, 0, 0x06C0, 0, 0),
	 MX6_PAD_CSI_DATA06__ESAI_TX2_RX3                       = IOMUX_PAD(0x03AC, 0x0064, 1, 0x0798, 1, 0),
	 MX6_PAD_CSI_DATA06__I2C4_SCL                           = IOMUX_PAD(0x03AC, 0x0064, 2, 0x07C0, 2, 0),
	 MX6_PAD_CSI_DATA06__KPP_COL_7                          = IOMUX_PAD(0x03AC, 0x0064, 3, 0x07D0, 0, 0),
	 MX6_PAD_CSI_DATA06__UART6_RTS_B                        = IOMUX_PAD(0x03AC, 0x0064, 4, 0x0854, 0, 0),
	 MX6_PAD_CSI_DATA06__GPIO1_IO_20                        = IOMUX_PAD(0x03AC, 0x0064, 5, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA06__WEIM_DATA_17                       = IOMUX_PAD(0x03AC, 0x0064, 6, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA06__DCIC2_OUT                          = IOMUX_PAD(0x03AC, 0x0064, 7, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA06__VADC_DATA_10                       = IOMUX_PAD(0x03AC, 0x0064, 8, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA06__MMDC_DEBUG_43                      = IOMUX_PAD(0x03AC, 0x0064, 9, 0x0000, 0, 0),

	 MX6_PAD_CSI_DATA07__CSI1_DATA_9                        = IOMUX_PAD(0x03B0, 0x0068, 0, 0x06C4, 0, 0),
	 MX6_PAD_CSI_DATA07__ESAI_TX3_RX2                       = IOMUX_PAD(0x03B0, 0x0068, 1, 0x079C, 1, 0),
	 MX6_PAD_CSI_DATA07__I2C4_SDA                           = IOMUX_PAD(0x03B0, 0x0068, 2, 0x07C4, 2, 0),
	 MX6_PAD_CSI_DATA07__KPP_ROW_7                          = IOMUX_PAD(0x03B0, 0x0068, 3, 0x07DC, 0, 0),
	 MX6_PAD_CSI_DATA07__UART6_CTS_B                        = IOMUX_PAD(0x03B0, 0x0068, 4, 0x0854, 1, 0),
	 MX6_PAD_CSI_DATA07__GPIO1_IO_21                        = IOMUX_PAD(0x03B0, 0x0068, 5, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA07__WEIM_DATA_16                       = IOMUX_PAD(0x03B0, 0x0068, 6, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA07__DCIC1_OUT                          = IOMUX_PAD(0x03B0, 0x0068, 7, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA07__VADC_DATA_11                       = IOMUX_PAD(0x03B0, 0x0068, 8, 0x0000, 0, 0),
	 MX6_PAD_CSI_DATA07__MMDC_DEBUG_44                      = IOMUX_PAD(0x03B0, 0x0068, 9, 0x0000, 0, 0),

	 MX6_PAD_CSI_HSYNC__CSI1_HSYNC                          = IOMUX_PAD(0x03B4, 0x006C, 0, 0x0700, 0, 0),
	 MX6_PAD_CSI_HSYNC__ESAI_TX0                            = IOMUX_PAD(0x03B4, 0x006C, 1, 0x0790, 1, 0),
	 MX6_PAD_CSI_HSYNC__AUDMUX_AUD6_TXD                     = IOMUX_PAD(0x03B4, 0x006C, 2, 0x0678, 1, 0),
	 MX6_PAD_CSI_HSYNC__UART4_RTS_B                         = IOMUX_PAD(0x03B4, 0x006C, 3, 0x0844, 2, 0),
	 MX6_PAD_CSI_HSYNC__MQS_LEFT                            = IOMUX_PAD(0x03B4, 0x006C, 4, 0x0000, 0, 0),
	 MX6_PAD_CSI_HSYNC__GPIO1_IO_22                         = IOMUX_PAD(0x03B4, 0x006C, 5, 0x0000, 0, 0),
	 MX6_PAD_CSI_HSYNC__WEIM_DATA_25                        = IOMUX_PAD(0x03B4, 0x006C, 6, 0x0000, 0, 0),
	 MX6_PAD_CSI_HSYNC__SAI1_TX_DATA_0                      = IOMUX_PAD(0x03B4, 0x006C, 7, 0x0000, 0, 0),
	 MX6_PAD_CSI_HSYNC__VADC_DATA_2                         = IOMUX_PAD(0x03B4, 0x006C, 8, 0x0000, 0, 0),
	 MX6_PAD_CSI_HSYNC__MMDC_DEBUG_35                       = IOMUX_PAD(0x03B4, 0x006C, 9, 0x0000, 0, 0),

	 MX6_PAD_CSI_MCLK__CSI1_MCLK                            = IOMUX_PAD(0x03B8, 0x0070, 0, 0x0000, 0, 0),
	 MX6_PAD_CSI_MCLK__ESAI_TX_HF_CLK                       = IOMUX_PAD(0x03B8, 0x0070, 1, 0x0784, 1, 0),
	 MX6_PAD_CSI_MCLK__OSC32K_32K_OUT                       = IOMUX_PAD(0x03B8, 0x0070, 2, 0x0000, 0, 0),
	 MX6_PAD_CSI_MCLK__UART4_RX                             = IOMUX_PAD(0x03B8, 0x0070, 3, 0x0848, 2, 0),
	 MX6_PAD_CSI_MCLK__ANATOP_32K_OUT                       = IOMUX_PAD(0x03B8, 0x0070, 4, 0x0000, 0, 0),
	 MX6_PAD_CSI_MCLK__GPIO1_IO_23                          = IOMUX_PAD(0x03B8, 0x0070, 5, 0x0000, 0, 0),
	 MX6_PAD_CSI_MCLK__WEIM_DATA_26                         = IOMUX_PAD(0x03B8, 0x0070, 6, 0x0000, 0, 0),
	 MX6_PAD_CSI_MCLK__CSI1_FIELD                           = IOMUX_PAD(0x03B8, 0x0070, 7, 0x070C, 0, 0),
	 MX6_PAD_CSI_MCLK__VADC_DATA_1                          = IOMUX_PAD(0x03B8, 0x0070, 8, 0x0000, 0, 0),
	 MX6_PAD_CSI_MCLK__MMDC_DEBUG_34                        = IOMUX_PAD(0x03B8, 0x0070, 9, 0x0000, 0, 0),

	 MX6_PAD_CSI_PIXCLK__CSI1_PIXCLK                        = IOMUX_PAD(0x03BC, 0x0074, 0, 0x0704, 0, 0),
	 MX6_PAD_CSI_PIXCLK__ESAI_RX_HF_CLK                     = IOMUX_PAD(0x03BC, 0x0074, 1, 0x0780, 1, 0),
	 MX6_PAD_CSI_PIXCLK__AUDMUX_MCLK                        = IOMUX_PAD(0x03BC, 0x0074, 2, 0x0000, 0, 0),
	 MX6_PAD_CSI_PIXCLK__UART4_TX                           = IOMUX_PAD(0x03BC, 0x0074, 3, 0x0848, 3, 0),
	 MX6_PAD_CSI_PIXCLK__ANATOP_24M_OUT                     = IOMUX_PAD(0x03BC, 0x0074, 4, 0x0000, 0, 0),
	 MX6_PAD_CSI_PIXCLK__GPIO1_IO_24                        = IOMUX_PAD(0x03BC, 0x0074, 5, 0x0000, 0, 0),
	 MX6_PAD_CSI_PIXCLK__WEIM_DATA_27                       = IOMUX_PAD(0x03BC, 0x0074, 6, 0x0000, 0, 0),
	 MX6_PAD_CSI_PIXCLK__ESAI_TX_HF_CLK                     = IOMUX_PAD(0x03BC, 0x0074, 7, 0x0784, 2, 0),
	 MX6_PAD_CSI_PIXCLK__VADC_CLK                           = IOMUX_PAD(0x03BC, 0x0074, 8, 0x0000, 0, 0),
	 MX6_PAD_CSI_PIXCLK__MMDC_DEBUG_33                      = IOMUX_PAD(0x03BC, 0x0074, 9, 0x0000, 0, 0),

	 MX6_PAD_CSI_VSYNC__CSI1_VSYNC                          = IOMUX_PAD(0x03C0, 0x0078, 0, 0x0708, 0, 0),
	 MX6_PAD_CSI_VSYNC__ESAI_TX5_RX0                        = IOMUX_PAD(0x03C0, 0x0078, 1, 0x07A4, 1, 0),
	 MX6_PAD_CSI_VSYNC__AUDMUX_AUD6_RXD                     = IOMUX_PAD(0x03C0, 0x0078, 2, 0x0674, 1, 0),
	 MX6_PAD_CSI_VSYNC__UART4_CTS_B                         = IOMUX_PAD(0x03C0, 0x0078, 3, 0x0844, 3, 0),
	 MX6_PAD_CSI_VSYNC__MQS_RIGHT                           = IOMUX_PAD(0x03C0, 0x0078, 4, 0x0000, 0, 0),
	 MX6_PAD_CSI_VSYNC__GPIO1_IO_25                         = IOMUX_PAD(0x03C0, 0x0078, 5, 0x0000, 0, 0),
	 MX6_PAD_CSI_VSYNC__WEIM_DATA_24                        = IOMUX_PAD(0x03C0, 0x0078, 6, 0x0000, 0, 0),
	 MX6_PAD_CSI_VSYNC__SAI1_RX_DATA_0                      = IOMUX_PAD(0x03C0, 0x0078, 7, 0x07F8, 0, 0),
	 MX6_PAD_CSI_VSYNC__VADC_DATA_3                         = IOMUX_PAD(0x03C0, 0x0078, 8, 0x0000, 0, 0),
	 MX6_PAD_CSI_VSYNC__MMDC_DEBUG_36                       = IOMUX_PAD(0x03C0, 0x0078, 9, 0x0000, 0, 0),

	 MX6_PAD_ENET1_COL__ENET1_COL                           = IOMUX_PAD(0x03C4, 0x007C, 0, 0x0000, 0, 0),
	 MX6_PAD_ENET1_COL__ENET2_MDC                           = IOMUX_PAD(0x03C4, 0x007C, 1, 0x0000, 0, 0),
	 MX6_PAD_ENET1_COL__AUDMUX_AUD4_TXC                     = IOMUX_PAD(0x03C4, 0x007C, 2, 0x0654, 1, 0),
	 MX6_PAD_ENET1_COL__UART1_RI_B                          = IOMUX_PAD(0x03C4, 0x007C, 3, 0x0000, 0, 0),
	 MX6_PAD_ENET1_COL__SPDIF_EXT_CLK                       = IOMUX_PAD(0x03C4, 0x007C, 4, 0x0828, 1, 0),
	 MX6_PAD_ENET1_COL__GPIO2_IO_0                          = IOMUX_PAD(0x03C4, 0x007C, 5, 0x0000, 0, 0),
	 MX6_PAD_ENET1_COL__CSI2_DATA_23                        = IOMUX_PAD(0x03C4, 0x007C, 6, 0x0000, 0, 0),
	 MX6_PAD_ENET1_COL__LCDIF2_DATA_16                      = IOMUX_PAD(0x03C4, 0x007C, 7, 0x0000, 0, 0),
	 MX6_PAD_ENET1_COL__VDEC_DEBUG_37                       = IOMUX_PAD(0x03C4, 0x007C, 8, 0x0000, 0, 0),
	 MX6_PAD_ENET1_COL__PCIE_CTRL_DEBUG_31                  = IOMUX_PAD(0x03C4, 0x007C, 9, 0x0000, 0, 0),

	 MX6_PAD_ENET1_CRS__ENET1_CRS                           = IOMUX_PAD(0x03C8, 0x0080, 0, 0x0000, 0, 0),
	 MX6_PAD_ENET1_CRS__ENET2_MDIO                          = IOMUX_PAD(0x03C8, 0x0080, 1, 0x0770, 1, 0),
	 MX6_PAD_ENET1_CRS__AUDMUX_AUD4_TXD                     = IOMUX_PAD(0x03C8, 0x0080, 2, 0x0648, 1, 0),
	 MX6_PAD_ENET1_CRS__UART1_DCD_B                         = IOMUX_PAD(0x03C8, 0x0080, 3, 0x0000, 0, 0),
	 MX6_PAD_ENET1_CRS__SPDIF_LOCK                          = IOMUX_PAD(0x03C8, 0x0080, 4, 0x0000, 0, 0),
	 MX6_PAD_ENET1_CRS__GPIO2_IO_1                          = IOMUX_PAD(0x03C8, 0x0080, 5, 0x0000, 0, 0),
	 MX6_PAD_ENET1_CRS__CSI2_DATA_22                        = IOMUX_PAD(0x03C8, 0x0080, 6, 0x0000, 0, 0),
	 MX6_PAD_ENET1_CRS__LCDIF2_DATA_17                      = IOMUX_PAD(0x03C8, 0x0080, 7, 0x0000, 0, 0),
	 MX6_PAD_ENET1_CRS__VDEC_DEBUG_36                       = IOMUX_PAD(0x03C8, 0x0080, 8, 0x0000, 0, 0),
	 MX6_PAD_ENET1_CRS__PCIE_CTRL_DEBUG_30                  = IOMUX_PAD(0x03C8, 0x0080, 9, 0x0000, 0, 0),

	 MX6_PAD_ENET1_MDC__ENET1_MDC                           = IOMUX_PAD(0x03CC, 0x0084, 0, 0x0000, 0, 0),
	 MX6_PAD_ENET1_MDC__ENET2_MDC                           = IOMUX_PAD(0x03CC, 0x0084, 1, 0x0000, 0, 0),
	 MX6_PAD_ENET1_MDC__AUDMUX_AUD3_RXFS                    = IOMUX_PAD(0x03CC, 0x0084, 2, 0x0638, 1, 0),
	 MX6_PAD_ENET1_MDC__ANATOP_24M_OUT                      = IOMUX_PAD(0x03CC, 0x0084, 3, 0x0000, 0, 0),
	 MX6_PAD_ENET1_MDC__EPIT2_OUT                           = IOMUX_PAD(0x03CC, 0x0084, 4, 0x0000, 0, 0),
	 MX6_PAD_ENET1_MDC__GPIO2_IO_2                          = IOMUX_PAD(0x03CC, 0x0084, 5, 0x0000, 0, 0),
	 MX6_PAD_ENET1_MDC__USB_OTG1_PWR                        = IOMUX_PAD(0x03CC, 0x0084, 6, 0x0000, 0, 0),
	 MX6_PAD_ENET1_MDC__PWM7_OUT                            = IOMUX_PAD(0x03CC, 0x0084, 7, 0x0000, 0, 0),

	 MX6_PAD_ENET1_MDIO__ENET1_MDIO                         = IOMUX_PAD(0x03D0, 0x0088, 0, 0x0764, 1, 0),
	 MX6_PAD_ENET1_MDIO__ENET2_MDIO                         = IOMUX_PAD(0x03D0, 0x0088, 1, 0x0770, 2, 0),
	 MX6_PAD_ENET1_MDIO__AUDMUX_MCLK                        = IOMUX_PAD(0x03D0, 0x0088, 2, 0x0000, 0, 0),
	 MX6_PAD_ENET1_MDIO__OSC32K_32K_OUT                     = IOMUX_PAD(0x03D0, 0x0088, 3, 0x0000, 0, 0),
	 MX6_PAD_ENET1_MDIO__EPIT1_OUT                          = IOMUX_PAD(0x03D0, 0x0088, 4, 0x0000, 0, 0),
	 MX6_PAD_ENET1_MDIO__GPIO2_IO_3                         = IOMUX_PAD(0x03D0, 0x0088, 5, 0x0000, 0, 0),
	 MX6_PAD_ENET1_MDIO__USB_OTG1_OC                        = IOMUX_PAD(0x03D0, 0x0088, 6, 0x0860, 1, 0),
	 MX6_PAD_ENET1_MDIO__PWM8_OUT                           = IOMUX_PAD(0x03D0, 0x0088, 7, 0x0000, 0, 0),

	 MX6_PAD_ENET1_RX_CLK__ENET1_RX_CLK                     = IOMUX_PAD(0x03D4, 0x008C, 0, 0x0768, 0, 0),
	 MX6_PAD_ENET1_RX_CLK__ENET1_REF_CLK_25M                = IOMUX_PAD(0x03D4, 0x008C, 1, 0x0000, 0, 0),
	 MX6_PAD_ENET1_RX_CLK__AUDMUX_AUD4_TXFS                 = IOMUX_PAD(0x03D4, 0x008C, 2, 0x0658, 1, 0),
	 MX6_PAD_ENET1_RX_CLK__UART1_DSR_B                      = IOMUX_PAD(0x03D4, 0x008C, 3, 0x0000, 0, 0),
	 MX6_PAD_ENET1_RX_CLK__SPDIF_OUT                        = IOMUX_PAD(0x03D4, 0x008C, 4, 0x0000, 0, 0),
	 MX6_PAD_ENET1_RX_CLK__GPIO2_IO_4                       = IOMUX_PAD(0x03D4, 0x008C, 5, 0x0000, 0, 0),
	 MX6_PAD_ENET1_RX_CLK__CSI2_DATA_21                     = IOMUX_PAD(0x03D4, 0x008C, 6, 0x0000, 0, 0),
	 MX6_PAD_ENET1_RX_CLK__LCDIF2_DATA_18                   = IOMUX_PAD(0x03D4, 0x008C, 7, 0x0000, 0, 0),
	 MX6_PAD_ENET1_RX_CLK__VDEC_DEBUG_35                    = IOMUX_PAD(0x03D4, 0x008C, 8, 0x0000, 0, 0),
	 MX6_PAD_ENET1_RX_CLK__PCIE_CTRL_DEBUG_29               = IOMUX_PAD(0x03D4, 0x008C, 9, 0x0000, 0, 0),

	 MX6_PAD_ENET1_TX_CLK__ENET1_TX_CLK                     = IOMUX_PAD(0x03D8, 0x0090, 0, 0x0000, 0, 0),
	 MX6_PAD_ENET1_TX_CLK__ENET1_REF_CLK1                   = IOMUX_PAD(0x03D8, 0x0090, 1, 0x0760, 1, 0),
	 MX6_PAD_ENET1_TX_CLK__AUDMUX_AUD4_RXD                  = IOMUX_PAD(0x03D8, 0x0090, 2, 0x0644, 1, 0),
	 MX6_PAD_ENET1_TX_CLK__UART1_DTR_B                      = IOMUX_PAD(0x03D8, 0x0090, 3, 0x0000, 0, 0),
	 MX6_PAD_ENET1_TX_CLK__SPDIF_SR_CLK                     = IOMUX_PAD(0x03D8, 0x0090, 4, 0x0000, 0, 0),
	 MX6_PAD_ENET1_TX_CLK__GPIO2_IO_5                       = IOMUX_PAD(0x03D8, 0x0090, 5, 0x0000, 0, 0),
	 MX6_PAD_ENET1_TX_CLK__CSI2_DATA_20                     = IOMUX_PAD(0x03D8, 0x0090, 6, 0x0000, 0, 0),
	 MX6_PAD_ENET1_TX_CLK__LCDIF2_DATA_19                   = IOMUX_PAD(0x03D8, 0x0090, 7, 0x0000, 0, 0),
	 MX6_PAD_ENET1_TX_CLK__VDEC_DEBUG_34                    = IOMUX_PAD(0x03D8, 0x0090, 8, 0x0000, 0, 0),
	 MX6_PAD_ENET1_TX_CLK__PCIE_CTRL_DEBUG_28               = IOMUX_PAD(0x03D8, 0x0090, 9, 0x0000, 0, 0),

	 MX6_PAD_ENET2_COL__ENET2_COL                           = IOMUX_PAD(0x03DC, 0x0094, 0, 0x0000, 0, 0),
	 MX6_PAD_ENET2_COL__ENET1_MDC                           = IOMUX_PAD(0x03DC, 0x0094, 1, 0x0000, 0, 0),
	 MX6_PAD_ENET2_COL__AUDMUX_AUD4_RXC                     = IOMUX_PAD(0x03DC, 0x0094, 2, 0x064C, 1, 0),
	 MX6_PAD_ENET2_COL__UART1_RX                            = IOMUX_PAD(0x03DC, 0x0094, 3, 0x0830, 2, 0),
	 MX6_PAD_ENET2_COL__SPDIF_IN                            = IOMUX_PAD(0x03DC, 0x0094, 4, 0x0824, 3, 0),
	 MX6_PAD_ENET2_COL__GPIO2_IO_6                          = IOMUX_PAD(0x03DC, 0x0094, 5, 0x0000, 0, 0),
	 MX6_PAD_ENET2_COL__ANATOP_OTG1_ID                      = IOMUX_PAD(0x03DC, 0x0094, 6, 0x0624, 1, 0),
	 MX6_PAD_ENET2_COL__LCDIF2_DATA_20                      = IOMUX_PAD(0x03DC, 0x0094, 7, 0x0000, 0, 0),
	 MX6_PAD_ENET2_COL__VDEC_DEBUG_33                       = IOMUX_PAD(0x03DC, 0x0094, 8, 0x0000, 0, 0),
	 MX6_PAD_ENET2_COL__PCIE_CTRL_DEBUG_27                  = IOMUX_PAD(0x03DC, 0x0094, 9, 0x0000, 0, 0),

	 MX6_PAD_ENET2_CRS__ENET2_CRS                           = IOMUX_PAD(0x03E0, 0x0098, 0, 0x0000, 0, 0),
	 MX6_PAD_ENET2_CRS__ENET1_MDIO                          = IOMUX_PAD(0x03E0, 0x0098, 1, 0x0764, 2, 0),
	 MX6_PAD_ENET2_CRS__AUDMUX_AUD4_RXFS                    = IOMUX_PAD(0x03E0, 0x0098, 2, 0x0650, 1, 0),
	 MX6_PAD_ENET2_CRS__UART1_TX                            = IOMUX_PAD(0x03E0, 0x0098, 3, 0x0830, 3, 0),
	 MX6_PAD_ENET2_CRS__MLB_SIG                             = IOMUX_PAD(0x03E0, 0x0098, 4, 0x07F0, 1, 0),
	 MX6_PAD_ENET2_CRS__GPIO2_IO_7                          = IOMUX_PAD(0x03E0, 0x0098, 5, 0x0000, 0, 0),
	 MX6_PAD_ENET2_CRS__ANATOP_OTG2_ID                      = IOMUX_PAD(0x03E0, 0x0098, 6, 0x0628, 1, 0),
	 MX6_PAD_ENET2_CRS__LCDIF2_DATA_21                      = IOMUX_PAD(0x03E0, 0x0098, 7, 0x0000, 0, 0),
	 MX6_PAD_ENET2_CRS__VDEC_DEBUG_32                       = IOMUX_PAD(0x03E0, 0x0098, 8, 0x0000, 0, 0),
	 MX6_PAD_ENET2_CRS__PCIE_CTRL_DEBUG_26                  = IOMUX_PAD(0x03E0, 0x0098, 9, 0x0000, 0, 0),

	 MX6_PAD_ENET2_RX_CLK__ENET2_RX_CLK                     = IOMUX_PAD(0x03E4, 0x009C, 0, 0x0774, 0, 0),
	 MX6_PAD_ENET2_RX_CLK__ENET2_REF_CLK_25M                = IOMUX_PAD(0x03E4, 0x009C, 1, 0x0000, 0, 0),
	 MX6_PAD_ENET2_RX_CLK__I2C3_SCL                         = IOMUX_PAD(0x03E4, 0x009C, 2, 0x07B8, 1, 0),
	 MX6_PAD_ENET2_RX_CLK__UART1_RTS_B                      = IOMUX_PAD(0x03E4, 0x009C, 3, 0x082C, 2, 0),
	 MX6_PAD_ENET2_RX_CLK__MLB_DATA                         = IOMUX_PAD(0x03E4, 0x009C, 4, 0x07EC, 1, 0),
	 MX6_PAD_ENET2_RX_CLK__GPIO2_IO_8                       = IOMUX_PAD(0x03E4, 0x009C, 5, 0x0000, 0, 0),
	 MX6_PAD_ENET2_RX_CLK__USB_OTG2_OC                      = IOMUX_PAD(0x03E4, 0x009C, 6, 0x085C, 1, 0),
	 MX6_PAD_ENET2_RX_CLK__LCDIF2_DATA_22                   = IOMUX_PAD(0x03E4, 0x009C, 7, 0x0000, 0, 0),
	 MX6_PAD_ENET2_RX_CLK__VDEC_DEBUG_31                    = IOMUX_PAD(0x03E4, 0x009C, 8, 0x0000, 0, 0),
	 MX6_PAD_ENET2_RX_CLK__PCIE_CTRL_DEBUG_25               = IOMUX_PAD(0x03E4, 0x009C, 9, 0x0000, 0, 0),

	 MX6_PAD_ENET2_TX_CLK__ENET2_TX_CLK                     = IOMUX_PAD(0x03E8, 0x00A0, 0, 0x0000, 0, 0),
	 MX6_PAD_ENET2_TX_CLK__ENET2_REF_CLK2                   = IOMUX_PAD(0x03E8, 0x00A0, 1, 0x076C, 1, 0),
	 MX6_PAD_ENET2_TX_CLK__I2C3_SDA                         = IOMUX_PAD(0x03E8, 0x00A0, 2, 0x07BC, 1, 0),
	 MX6_PAD_ENET2_TX_CLK__UART1_CTS_B                      = IOMUX_PAD(0x03E8, 0x00A0, 3, 0x082C, 3, 0),
	 MX6_PAD_ENET2_TX_CLK__MLB_CLK                          = IOMUX_PAD(0x03E8, 0x00A0, 4, 0x07E8, 1, 0),
	 MX6_PAD_ENET2_TX_CLK__GPIO2_IO_9                       = IOMUX_PAD(0x03E8, 0x00A0, 5, 0x0000, 0, 0),
	 MX6_PAD_ENET2_TX_CLK__USB_OTG2_PWR                     = IOMUX_PAD(0x03E8, 0x00A0, 6, 0x0000, 0, 0),
	 MX6_PAD_ENET2_TX_CLK__LCDIF2_DATA_23                   = IOMUX_PAD(0x03E8, 0x00A0, 7, 0x0000, 0, 0),
	 MX6_PAD_ENET2_TX_CLK__VDEC_DEBUG_30                    = IOMUX_PAD(0x03E8, 0x00A0, 8, 0x0000, 0, 0),
	 MX6_PAD_ENET2_TX_CLK__PCIE_CTRL_DEBUG_24               = IOMUX_PAD(0x03E8, 0x00A0, 9, 0x0000, 0, 0),

	 MX6_PAD_KEY_COL0__KPP_COL_0                            = IOMUX_PAD(0x03EC, 0x00A4, 0, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL0__USDHC3_CD_B                          = IOMUX_PAD(0x03EC, 0x00A4, 1, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL0__UART6_RTS_B                          = IOMUX_PAD(0x03EC, 0x00A4, 2, 0x0854, 2, 0),
	 MX6_PAD_KEY_COL0__ECSPI1_SCLK                          = IOMUX_PAD(0x03EC, 0x00A4, 3, 0x0710, 0, 0),
	 MX6_PAD_KEY_COL0__AUDMUX_AUD5_TXC                      = IOMUX_PAD(0x03EC, 0x00A4, 4, 0x066C, 0, 0),
	 MX6_PAD_KEY_COL0__GPIO2_IO_10                          = IOMUX_PAD(0x03EC, 0x00A4, 5, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL0__SDMA_EXT_EVENT_1                     = IOMUX_PAD(0x03EC, 0x00A4, 6, 0x0820, 1, 0),
	 MX6_PAD_KEY_COL0__SAI2_TX_BCLK                         = IOMUX_PAD(0x03EC, 0x00A4, 7, 0x0814, 0, 0),
	 MX6_PAD_KEY_COL0__VADC_DATA_0                          = IOMUX_PAD(0x03EC, 0x00A4, 8, 0x0000, 0, 0),

	 MX6_PAD_KEY_COL1__KPP_COL_1                            = IOMUX_PAD(0x03F0, 0x00A8, 0, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL1__USDHC3_RESET_B                       = IOMUX_PAD(0x03F0, 0x00A8, 1, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL1__UART6_TX                             = IOMUX_PAD(0x03F0, 0x00A8, 2, 0x0858, 2, 0),
	 MX6_PAD_KEY_COL1__ECSPI1_MISO                          = IOMUX_PAD(0x03F0, 0x00A8, 3, 0x0714, 0, 0),
	 MX6_PAD_KEY_COL1__AUDMUX_AUD5_TXFS                     = IOMUX_PAD(0x03F0, 0x00A8, 4, 0x0670, 0, 0),
	 MX6_PAD_KEY_COL1__GPIO2_IO_11                          = IOMUX_PAD(0x03F0, 0x00A8, 5, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL1__USDHC3_RESET                         = IOMUX_PAD(0x03F0, 0x00A8, 6, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL1__SAI2_TX_SYNC                         = IOMUX_PAD(0x03F0, 0x00A8, 7, 0x0818, 0, 0),

	 MX6_PAD_KEY_COL2__KPP_COL_2                            = IOMUX_PAD(0x03F4, 0x00AC, 0, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL2__USDHC4_CD_B                          = IOMUX_PAD(0x03F4, 0x00AC, 1, 0x0874, 1, 0),
	 MX6_PAD_KEY_COL2__UART5_RTS_B                          = IOMUX_PAD(0x03F4, 0x00AC, 2, 0x084C, 2, 0),
	 MX6_PAD_KEY_COL2__CAN1_TX                              = IOMUX_PAD(0x03F4, 0x00AC, 3, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL2__CANFD_TX1                            = IOMUX_PAD(0x03F4, 0x00AC, 4, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL2__GPIO2_IO_12                          = IOMUX_PAD(0x03F4, 0x00AC, 5, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL2__WEIM_DATA_30                         = IOMUX_PAD(0x03F4, 0x00AC, 6, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL2__ECSPI1_RDY                           = IOMUX_PAD(0x03F4, 0x00AC, 7, 0x0000, 0, 0),

	 MX6_PAD_KEY_COL3__KPP_COL_3                            = IOMUX_PAD(0x03F8, 0x00B0, 0, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL3__USDHC4_LCTL                          = IOMUX_PAD(0x03F8, 0x00B0, 1, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL3__UART5_TX                             = IOMUX_PAD(0x03F8, 0x00B0, 2, 0x0850, 2, 0),
	 MX6_PAD_KEY_COL3__CAN2_TX                              = IOMUX_PAD(0x03F8, 0x00B0, 3, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL3__CANFD_TX2                            = IOMUX_PAD(0x03F8, 0x00B0, 4, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL3__GPIO2_IO_13                          = IOMUX_PAD(0x03F8, 0x00B0, 5, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL3__WEIM_DATA_28                         = IOMUX_PAD(0x03F8, 0x00B0, 6, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL3__ECSPI1_SS2                           = IOMUX_PAD(0x03F8, 0x00B0, 7, 0x0000, 0, 0),

	 MX6_PAD_KEY_COL4__KPP_COL_4                            = IOMUX_PAD(0x03FC, 0x00B4, 0, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL4__ENET2_MDC                            = IOMUX_PAD(0x03FC, 0x00B4, 1, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL4__I2C3_SCL                             = IOMUX_PAD(0x03FC, 0x00B4, 2, 0x07B8, 2, 0),
	 MX6_PAD_KEY_COL4__USDHC2_LCTL                          = IOMUX_PAD(0x03FC, 0x00B4, 3, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL4__AUDMUX_AUD5_RXC                      = IOMUX_PAD(0x03FC, 0x00B4, 4, 0x0664, 0, 0),
	 MX6_PAD_KEY_COL4__GPIO2_IO_14                          = IOMUX_PAD(0x03FC, 0x00B4, 5, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL4__WEIM_CRE                             = IOMUX_PAD(0x03FC, 0x00B4, 6, 0x0000, 0, 0),
	 MX6_PAD_KEY_COL4__SAI2_RX_BCLK                         = IOMUX_PAD(0x03FC, 0x00B4, 7, 0x0808, 0, 0),

	 MX6_PAD_KEY_ROW0__KPP_ROW_0                            = IOMUX_PAD(0x0400, 0x00B8, 0, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW0__USDHC3_WP                            = IOMUX_PAD(0x0400, 0x00B8, 1, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW0__UART6_CTS_B                          = IOMUX_PAD(0x0400, 0x00B8, 2, 0x0854, 3, 0),
	 MX6_PAD_KEY_ROW0__ECSPI1_MOSI                          = IOMUX_PAD(0x0400, 0x00B8, 3, 0x0718, 0, 0),
	 MX6_PAD_KEY_ROW0__AUDMUX_AUD5_TXD                      = IOMUX_PAD(0x0400, 0x00B8, 4, 0x0660, 0, 0),
	 MX6_PAD_KEY_ROW0__GPIO2_IO_15                          = IOMUX_PAD(0x0400, 0x00B8, 5, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW0__SDMA_EXT_EVENT_0                     = IOMUX_PAD(0x0400, 0x00B8, 6, 0x081C, 1, 0),
	 MX6_PAD_KEY_ROW0__SAI2_TX_DATA_0                       = IOMUX_PAD(0x0400, 0x00B8, 7, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW0__GPU_IDLE                             = IOMUX_PAD(0x0400, 0x00B8, 8, 0x0000, 0, 0),

	 MX6_PAD_KEY_ROW1__KPP_ROW_1                            = IOMUX_PAD(0x0404, 0x00BC, 0, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW1__USDHC4_VSELECT                       = IOMUX_PAD(0x0404, 0x00BC, 1, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW1__UART6_RX                             = IOMUX_PAD(0x0404, 0x00BC, 2, 0x0858, 3, 0),
	 MX6_PAD_KEY_ROW1__ECSPI1_SS0                           = IOMUX_PAD(0x0404, 0x00BC, 3, 0x071C, 0, 0),
	 MX6_PAD_KEY_ROW1__AUDMUX_AUD5_RXD                      = IOMUX_PAD(0x0404, 0x00BC, 4, 0x065C, 0, 0),
	 MX6_PAD_KEY_ROW1__GPIO2_IO_16                          = IOMUX_PAD(0x0404, 0x00BC, 5, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW1__WEIM_DATA_31                         = IOMUX_PAD(0x0404, 0x00BC, 6, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW1__SAI2_RX_DATA_0                       = IOMUX_PAD(0x0404, 0x00BC, 7, 0x080C, 0, 0),
	 MX6_PAD_KEY_ROW1__M4_NMI                               = IOMUX_PAD(0x0404, 0x00BC, 8, 0x0000, 0, 0),

	 MX6_PAD_KEY_ROW2__KPP_ROW_2                            = IOMUX_PAD(0x0408, 0x00C0, 0, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW2__USDHC4_WP                            = IOMUX_PAD(0x0408, 0x00C0, 1, 0x0878, 1, 0),
	 MX6_PAD_KEY_ROW2__UART5_CTS_B                          = IOMUX_PAD(0x0408, 0x00C0, 2, 0x084C, 3, 0),
	 MX6_PAD_KEY_ROW2__CAN1_RX                              = IOMUX_PAD(0x0408, 0x00C0, 3, 0x068C, 1, 0),
	 MX6_PAD_KEY_ROW2__CANFD_RX1                            = IOMUX_PAD(0x0408, 0x00C0, 4, 0x0694, 1, 0),
	 MX6_PAD_KEY_ROW2__GPIO2_IO_17                          = IOMUX_PAD(0x0408, 0x00C0, 5, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW2__WEIM_DATA_29                         = IOMUX_PAD(0x0408, 0x00C0, 6, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW2__ECSPI1_SS3                           = IOMUX_PAD(0x0408, 0x00C0, 7, 0x0000, 0, 0),

	 MX6_PAD_KEY_ROW3__KPP_ROW_3                            = IOMUX_PAD(0x040C, 0x00C4, 0, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW3__USDHC3_LCTL                          = IOMUX_PAD(0x040C, 0x00C4, 1, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW3__UART5_RX                             = IOMUX_PAD(0x040C, 0x00C4, 2, 0x0850, 3, 0),
	 MX6_PAD_KEY_ROW3__CAN2_RX                              = IOMUX_PAD(0x040C, 0x00C4, 3, 0x0690, 1, 0),
	 MX6_PAD_KEY_ROW3__CANFD_RX2                            = IOMUX_PAD(0x040C, 0x00C4, 4, 0x0698, 1, 0),
	 MX6_PAD_KEY_ROW3__GPIO2_IO_18                          = IOMUX_PAD(0x040C, 0x00C4, 5, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW3__WEIM_DTACK_B                         = IOMUX_PAD(0x040C, 0x00C4, 6, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW3__ECSPI1_SS1                           = IOMUX_PAD(0x040C, 0x00C4, 7, 0x0000, 0, 0),

	 MX6_PAD_KEY_ROW4__KPP_ROW_4                            = IOMUX_PAD(0x0410, 0x00C8, 0, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW4__ENET2_MDIO                           = IOMUX_PAD(0x0410, 0x00C8, 1, 0x0770, 3, 0),
	 MX6_PAD_KEY_ROW4__I2C3_SDA                             = IOMUX_PAD(0x0410, 0x00C8, 2, 0x07BC, 2, 0),
	 MX6_PAD_KEY_ROW4__USDHC1_LCTL                          = IOMUX_PAD(0x0410, 0x00C8, 3, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW4__AUDMUX_AUD5_RXFS                     = IOMUX_PAD(0x0410, 0x00C8, 4, 0x0668, 0, 0),
	 MX6_PAD_KEY_ROW4__GPIO2_IO_19                          = IOMUX_PAD(0x0410, 0x00C8, 5, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW4__WEIM_ACLK_FREERUN                    = IOMUX_PAD(0x0410, 0x00C8, 6, 0x0000, 0, 0),
	 MX6_PAD_KEY_ROW4__SAI2_RX_SYNC                         = IOMUX_PAD(0x0410, 0x00C8, 7, 0x0810, 0, 0),

	 MX6_PAD_LCD1_CLK__LCDIF1_CLK                           = IOMUX_PAD(0x0414, 0x00CC, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_CLK__LCDIF1_WR_RWN                        = IOMUX_PAD(0x0414, 0x00CC, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_CLK__AUDMUX_AUD3_RXC                      = IOMUX_PAD(0x0414, 0x00CC, 2, 0x0634, 1, 0),
	 MX6_PAD_LCD1_CLK__ENET1_1588_EVENT2_IN                 = IOMUX_PAD(0x0414, 0x00CC, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_CLK__CSI1_DATA_16                         = IOMUX_PAD(0x0414, 0x00CC, 4, 0x06DC, 0, 0),
	 MX6_PAD_LCD1_CLK__GPIO3_IO_0                           = IOMUX_PAD(0x0414, 0x00CC, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_CLK__USDHC1_WP                            = IOMUX_PAD(0x0414, 0x00CC, 6, 0x0868, 0, 0),
	 MX6_PAD_LCD1_CLK__SIM_M_HADDR_16                       = IOMUX_PAD(0x0414, 0x00CC, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_CLK__VADC_TEST_0                          = IOMUX_PAD(0x0414, 0x00CC, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_CLK__MMDC_DEBUG_0                         = IOMUX_PAD(0x0414, 0x00CC, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA00__LCDIF1_DATA_0                     = IOMUX_PAD(0x0418, 0x00D0, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA00__WEIM_CS1_B                        = IOMUX_PAD(0x0418, 0x00D0, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA00__M4_TRACE_0                        = IOMUX_PAD(0x0418, 0x00D0, 2, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA00__KITTEN_TRACE_0                    = IOMUX_PAD(0x0418, 0x00D0, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA00__CSI1_DATA_20                      = IOMUX_PAD(0x0418, 0x00D0, 4, 0x06EC, 0, 0),
	 MX6_PAD_LCD1_DATA00__GPIO3_IO_1                        = IOMUX_PAD(0x0418, 0x00D0, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA00__SRC_BT_CFG_0                      = IOMUX_PAD(0x0418, 0x00D0, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA00__SIM_M_HADDR_21                    = IOMUX_PAD(0x0418, 0x00D0, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA00__VADC_TEST_5                       = IOMUX_PAD(0x0418, 0x00D0, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA00__MMDC_DEBUG_5                      = IOMUX_PAD(0x0418, 0x00D0, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA01__LCDIF1_DATA_1                     = IOMUX_PAD(0x041C, 0x00D4, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA01__WEIM_CS2_B                        = IOMUX_PAD(0x041C, 0x00D4, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA01__M4_TRACE_1                        = IOMUX_PAD(0x041C, 0x00D4, 2, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA01__KITTEN_TRACE_1                    = IOMUX_PAD(0x041C, 0x00D4, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA01__CSI1_DATA_21                      = IOMUX_PAD(0x041C, 0x00D4, 4, 0x06F0, 0, 0),
	 MX6_PAD_LCD1_DATA01__GPIO3_IO_2                        = IOMUX_PAD(0x041C, 0x00D4, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA01__SRC_BT_CFG_1                      = IOMUX_PAD(0x041C, 0x00D4, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA01__SIM_M_HADDR_22                    = IOMUX_PAD(0x041C, 0x00D4, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA01__VADC_TEST_6                       = IOMUX_PAD(0x041C, 0x00D4, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA01__MMDC_DEBUG_6                      = IOMUX_PAD(0x041C, 0x00D4, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA02__LCDIF1_DATA_2                     = IOMUX_PAD(0x0420, 0x00D8, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA02__WEIM_CS3_B                        = IOMUX_PAD(0x0420, 0x00D8, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA02__M4_TRACE_2                        = IOMUX_PAD(0x0420, 0x00D8, 2, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA02__KITTEN_TRACE_2                    = IOMUX_PAD(0x0420, 0x00D8, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA02__CSI1_DATA_22                      = IOMUX_PAD(0x0420, 0x00D8, 4, 0x06F4, 0, 0),
	 MX6_PAD_LCD1_DATA02__GPIO3_IO_3                        = IOMUX_PAD(0x0420, 0x00D8, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA02__SRC_BT_CFG_2                      = IOMUX_PAD(0x0420, 0x00D8, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA02__SIM_M_HADDR_23                    = IOMUX_PAD(0x0420, 0x00D8, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA02__VADC_TEST_7                       = IOMUX_PAD(0x0420, 0x00D8, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA02__MMDC_DEBUG_7                      = IOMUX_PAD(0x0420, 0x00D8, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA03__LCDIF1_DATA_3                     = IOMUX_PAD(0x0424, 0x00DC, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA03__WEIM_ADDR_24                      = IOMUX_PAD(0x0424, 0x00DC, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA03__M4_TRACE_3                        = IOMUX_PAD(0x0424, 0x00DC, 2, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA03__KITTEN_TRACE_3                    = IOMUX_PAD(0x0424, 0x00DC, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA03__CSI1_DATA_23                      = IOMUX_PAD(0x0424, 0x00DC, 4, 0x06F8, 0, 0),
	 MX6_PAD_LCD1_DATA03__GPIO3_IO_4                        = IOMUX_PAD(0x0424, 0x00DC, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA03__SRC_BT_CFG_3                      = IOMUX_PAD(0x0424, 0x00DC, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA03__SIM_M_HADDR_24                    = IOMUX_PAD(0x0424, 0x00DC, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA03__VADC_TEST_8                       = IOMUX_PAD(0x0424, 0x00DC, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA03__MMDC_DEBUG_8                      = IOMUX_PAD(0x0424, 0x00DC, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA04__LCDIF1_DATA_4                     = IOMUX_PAD(0x0428, 0x00E0, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA04__WEIM_ADDR_25                      = IOMUX_PAD(0x0428, 0x00E0, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA04__KITTEN_TRACE_4                    = IOMUX_PAD(0x0428, 0x00E0, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA04__CSI1_VSYNC                        = IOMUX_PAD(0x0428, 0x00E0, 4, 0x0708, 1, 0),
	 MX6_PAD_LCD1_DATA04__GPIO3_IO_5                        = IOMUX_PAD(0x0428, 0x00E0, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA04__SRC_BT_CFG_4                      = IOMUX_PAD(0x0428, 0x00E0, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA04__SIM_M_HADDR_25                    = IOMUX_PAD(0x0428, 0x00E0, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA04__VADC_TEST_9                       = IOMUX_PAD(0x0428, 0x00E0, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA04__MMDC_DEBUG_9                      = IOMUX_PAD(0x0428, 0x00E0, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA05__LCDIF1_DATA_5                     = IOMUX_PAD(0x042C, 0x00E4, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA05__WEIM_ADDR_26                      = IOMUX_PAD(0x042C, 0x00E4, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA05__KITTEN_TRACE_5                    = IOMUX_PAD(0x042C, 0x00E4, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA05__CSI1_HSYNC                        = IOMUX_PAD(0x042C, 0x00E4, 4, 0x0700, 1, 0),
	 MX6_PAD_LCD1_DATA05__GPIO3_IO_6                        = IOMUX_PAD(0x042C, 0x00E4, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA05__SRC_BT_CFG_5                      = IOMUX_PAD(0x042C, 0x00E4, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA05__SIM_M_HADDR_26                    = IOMUX_PAD(0x042C, 0x00E4, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA05__VADC_TEST_10                      = IOMUX_PAD(0x042C, 0x00E4, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA05__MMDC_DEBUG_10                     = IOMUX_PAD(0x042C, 0x00E4, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA06__LCDIF1_DATA_6                     = IOMUX_PAD(0x0430, 0x00E8, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA06__WEIM_EB_B_2                       = IOMUX_PAD(0x0430, 0x00E8, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA06__KITTEN_TRACE_6                    = IOMUX_PAD(0x0430, 0x00E8, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA06__CSI1_PIXCLK                       = IOMUX_PAD(0x0430, 0x00E8, 4, 0x0704, 1, 0),
	 MX6_PAD_LCD1_DATA06__GPIO3_IO_7                        = IOMUX_PAD(0x0430, 0x00E8, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA06__SRC_BT_CFG_6                      = IOMUX_PAD(0x0430, 0x00E8, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA06__SIM_M_HADDR_27                    = IOMUX_PAD(0x0430, 0x00E8, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA06__VADC_TEST_11                      = IOMUX_PAD(0x0430, 0x00E8, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA06__MMDC_DEBUG_11                     = IOMUX_PAD(0x0430, 0x00E8, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA07__LCDIF1_DATA_7                     = IOMUX_PAD(0x0434, 0x00EC, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA07__WEIM_EB_B_3                       = IOMUX_PAD(0x0434, 0x00EC, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA07__KITTEN_TRACE_7                    = IOMUX_PAD(0x0434, 0x00EC, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA07__CSI1_MCLK                         = IOMUX_PAD(0x0434, 0x00EC, 4, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA07__GPIO3_IO_8                        = IOMUX_PAD(0x0434, 0x00EC, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA07__SRC_BT_CFG_7                      = IOMUX_PAD(0x0434, 0x00EC, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA07__SIM_M_HADDR_28                    = IOMUX_PAD(0x0434, 0x00EC, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA07__VADC_TEST_12                      = IOMUX_PAD(0x0434, 0x00EC, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA07__MMDC_DEBUG_12                     = IOMUX_PAD(0x0434, 0x00EC, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA08__LCDIF1_DATA_8                     = IOMUX_PAD(0x0438, 0x00F0, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA08__WEIM_AD_8                         = IOMUX_PAD(0x0438, 0x00F0, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA08__KITTEN_TRACE_8                    = IOMUX_PAD(0x0438, 0x00F0, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA08__CSI1_DATA_9                       = IOMUX_PAD(0x0438, 0x00F0, 4, 0x06C4, 1, 0),
	 MX6_PAD_LCD1_DATA08__GPIO3_IO_9                        = IOMUX_PAD(0x0438, 0x00F0, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA08__SRC_BT_CFG_8                      = IOMUX_PAD(0x0438, 0x00F0, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA08__SIM_M_HADDR_29                    = IOMUX_PAD(0x0438, 0x00F0, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA08__VADC_TEST_13                      = IOMUX_PAD(0x0438, 0x00F0, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA08__MMDC_DEBUG_13                     = IOMUX_PAD(0x0438, 0x00F0, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA09__LCDIF1_DATA_9                     = IOMUX_PAD(0x043C, 0x00F4, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA09__WEIM_AD_9                         = IOMUX_PAD(0x043C, 0x00F4, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA09__KITTEN_TRACE_9                    = IOMUX_PAD(0x043C, 0x00F4, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA09__CSI1_DATA_8                       = IOMUX_PAD(0x043C, 0x00F4, 4, 0x06C0, 1, 0),
	 MX6_PAD_LCD1_DATA09__GPIO3_IO_10                       = IOMUX_PAD(0x043C, 0x00F4, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA09__SRC_BT_CFG_9                      = IOMUX_PAD(0x043C, 0x00F4, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA09__SIM_M_HADDR_30                    = IOMUX_PAD(0x043C, 0x00F4, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA09__VADC_TEST_14                      = IOMUX_PAD(0x043C, 0x00F4, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA09__MMDC_DEBUG_14                     = IOMUX_PAD(0x043C, 0x00F4, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA10__LCDIF1_DATA_10                    = IOMUX_PAD(0x0440, 0x00F8, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA10__WEIM_AD_10                        = IOMUX_PAD(0x0440, 0x00F8, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA10__KITTEN_TRACE_10                   = IOMUX_PAD(0x0440, 0x00F8, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA10__CSI1_DATA_7                       = IOMUX_PAD(0x0440, 0x00F8, 4, 0x06BC, 1, 0),
	 MX6_PAD_LCD1_DATA10__GPIO3_IO_11                       = IOMUX_PAD(0x0440, 0x00F8, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA10__SRC_BT_CFG_10                     = IOMUX_PAD(0x0440, 0x00F8, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA10__SIM_M_HADDR_31                    = IOMUX_PAD(0x0440, 0x00F8, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA10__VADC_TEST_15                      = IOMUX_PAD(0x0440, 0x00F8, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA10__MMDC_DEBUG_15                     = IOMUX_PAD(0x0440, 0x00F8, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA11__LCDIF1_DATA_11                    = IOMUX_PAD(0x0444, 0x00FC, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA11__WEIM_AD_11                        = IOMUX_PAD(0x0444, 0x00FC, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA11__KITTEN_TRACE_11                   = IOMUX_PAD(0x0444, 0x00FC, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA11__CSI1_DATA_6                       = IOMUX_PAD(0x0444, 0x00FC, 4, 0x06B8, 1, 0),
	 MX6_PAD_LCD1_DATA11__GPIO3_IO_12                       = IOMUX_PAD(0x0444, 0x00FC, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA11__SRC_BT_CFG_11                     = IOMUX_PAD(0x0444, 0x00FC, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA11__SIM_M_HBURST_0                    = IOMUX_PAD(0x0444, 0x00FC, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA11__VADC_TEST_16                      = IOMUX_PAD(0x0444, 0x00FC, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA11__MMDC_DEBUG_16                     = IOMUX_PAD(0x0444, 0x00FC, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA12__LCDIF1_DATA_12                    = IOMUX_PAD(0x0448, 0x0100, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA12__WEIM_AD_12                        = IOMUX_PAD(0x0448, 0x0100, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA12__KITTEN_TRACE_12                   = IOMUX_PAD(0x0448, 0x0100, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA12__CSI1_DATA_5                       = IOMUX_PAD(0x0448, 0x0100, 4, 0x06B4, 1, 0),
	 MX6_PAD_LCD1_DATA12__GPIO3_IO_13                       = IOMUX_PAD(0x0448, 0x0100, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA12__SRC_BT_CFG_12                     = IOMUX_PAD(0x0448, 0x0100, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA12__SIM_M_HBURST_1                    = IOMUX_PAD(0x0448, 0x0100, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA12__VADC_TEST_17                      = IOMUX_PAD(0x0448, 0x0100, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA12__MMDC_DEBUG_17                     = IOMUX_PAD(0x0448, 0x0100, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA13__LCDIF1_DATA_13                    = IOMUX_PAD(0x044C, 0x0104, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA13__WEIM_AD_13                        = IOMUX_PAD(0x044C, 0x0104, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA13__KITTEN_TRACE_13                   = IOMUX_PAD(0x044C, 0x0104, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA13__CSI1_DATA_4                       = IOMUX_PAD(0x044C, 0x0104, 4, 0x06B0, 1, 0),
	 MX6_PAD_LCD1_DATA13__GPIO3_IO_14                       = IOMUX_PAD(0x044C, 0x0104, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA13__SRC_BT_CFG_13                     = IOMUX_PAD(0x044C, 0x0104, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA13__SIM_M_HBURST_2                    = IOMUX_PAD(0x044C, 0x0104, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA13__VADC_TEST_18                      = IOMUX_PAD(0x044C, 0x0104, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA13__MMDC_DEBUG_18                     = IOMUX_PAD(0x044C, 0x0104, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA14__LCDIF1_DATA_14                    = IOMUX_PAD(0x0450, 0x0108, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA14__WEIM_AD_14                        = IOMUX_PAD(0x0450, 0x0108, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA14__KITTEN_TRACE_14                   = IOMUX_PAD(0x0450, 0x0108, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA14__CSI1_DATA_3                       = IOMUX_PAD(0x0450, 0x0108, 4, 0x06AC, 1, 0),
	 MX6_PAD_LCD1_DATA14__GPIO3_IO_15                       = IOMUX_PAD(0x0450, 0x0108, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA14__SRC_BT_CFG_14                     = IOMUX_PAD(0x0450, 0x0108, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA14__SIM_M_HMASTLOCK                   = IOMUX_PAD(0x0450, 0x0108, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA14__VADC_TEST_19                      = IOMUX_PAD(0x0450, 0x0108, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA14__MMDC_DEBUG_19                     = IOMUX_PAD(0x0450, 0x0108, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA15__LCDIF1_DATA_15                    = IOMUX_PAD(0x0454, 0x010C, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA15__WEIM_AD_15                        = IOMUX_PAD(0x0454, 0x010C, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA15__KITTEN_TRACE_15                   = IOMUX_PAD(0x0454, 0x010C, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA15__CSI1_DATA_2                       = IOMUX_PAD(0x0454, 0x010C, 4, 0x06A8, 1, 0),
	 MX6_PAD_LCD1_DATA15__GPIO3_IO_16                       = IOMUX_PAD(0x0454, 0x010C, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA15__SRC_BT_CFG_15                     = IOMUX_PAD(0x0454, 0x010C, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA15__SIM_M_HPROT_0                     = IOMUX_PAD(0x0454, 0x010C, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA15__VDEC_DEBUG_0                      = IOMUX_PAD(0x0454, 0x010C, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA15__MMDC_DEBUG_20                     = IOMUX_PAD(0x0454, 0x010C, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA16__LCDIF1_DATA_16                    = IOMUX_PAD(0x0458, 0x0110, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA16__WEIM_ADDR_16                      = IOMUX_PAD(0x0458, 0x0110, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA16__M4_TRACE_CLK                      = IOMUX_PAD(0x0458, 0x0110, 2, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA16__KITTEN_TRACE_CLK                  = IOMUX_PAD(0x0458, 0x0110, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA16__CSI1_DATA_1                       = IOMUX_PAD(0x0458, 0x0110, 4, 0x06A4, 0, 0),
	 MX6_PAD_LCD1_DATA16__GPIO3_IO_17                       = IOMUX_PAD(0x0458, 0x0110, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA16__SRC_BT_CFG_24                     = IOMUX_PAD(0x0458, 0x0110, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA16__SIM_M_HPROT_1                     = IOMUX_PAD(0x0458, 0x0110, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA16__VDEC_DEBUG_1                      = IOMUX_PAD(0x0458, 0x0110, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA16__MMDC_DEBUG_21                     = IOMUX_PAD(0x0458, 0x0110, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA17__LCDIF1_DATA_17                    = IOMUX_PAD(0x045C, 0x0114, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA17__WEIM_ADDR_17                      = IOMUX_PAD(0x045C, 0x0114, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA17__KITTEN_TRACE_CTL                  = IOMUX_PAD(0x045C, 0x0114, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA17__CSI1_DATA_0                       = IOMUX_PAD(0x045C, 0x0114, 4, 0x06A0, 0, 0),
	 MX6_PAD_LCD1_DATA17__GPIO3_IO_18                       = IOMUX_PAD(0x045C, 0x0114, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA17__SRC_BT_CFG_25                     = IOMUX_PAD(0x045C, 0x0114, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA17__SIM_M_HPROT_2                     = IOMUX_PAD(0x045C, 0x0114, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA17__VDEC_DEBUG_2                      = IOMUX_PAD(0x045C, 0x0114, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA17__MMDC_DEBUG_22                     = IOMUX_PAD(0x045C, 0x0114, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA18__LCDIF1_DATA_18                    = IOMUX_PAD(0x0460, 0x0118, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA18__WEIM_ADDR_18                      = IOMUX_PAD(0x0460, 0x0118, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA18__M4_EVENTO                         = IOMUX_PAD(0x0460, 0x0118, 2, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA18__KITTEN_EVENTO                     = IOMUX_PAD(0x0460, 0x0118, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA18__CSI1_DATA_15                      = IOMUX_PAD(0x0460, 0x0118, 4, 0x06D8, 0, 0),
	 MX6_PAD_LCD1_DATA18__GPIO3_IO_19                       = IOMUX_PAD(0x0460, 0x0118, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA18__SRC_BT_CFG_26                     = IOMUX_PAD(0x0460, 0x0118, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA18__SIM_M_HPROT_3                     = IOMUX_PAD(0x0460, 0x0118, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA18__VDEC_DEBUG_3                      = IOMUX_PAD(0x0460, 0x0118, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA18__MMDC_DEBUG_23                     = IOMUX_PAD(0x0460, 0x0118, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA19__LCDIF1_DATA_19                    = IOMUX_PAD(0x0464, 0x011C, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA19__WEIM_ADDR_19                      = IOMUX_PAD(0x0464, 0x011C, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA19__M4_TRACE_SWO                      = IOMUX_PAD(0x0464, 0x011C, 2, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA19__CSI1_DATA_14                      = IOMUX_PAD(0x0464, 0x011C, 4, 0x06D4, 0, 0),
	 MX6_PAD_LCD1_DATA19__GPIO3_IO_20                       = IOMUX_PAD(0x0464, 0x011C, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA19__SRC_BT_CFG_27                     = IOMUX_PAD(0x0464, 0x011C, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA19__SIM_M_HREADYOUT                   = IOMUX_PAD(0x0464, 0x011C, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA19__VDEC_DEBUG_4                      = IOMUX_PAD(0x0464, 0x011C, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA19__MMDC_DEBUG_24                     = IOMUX_PAD(0x0464, 0x011C, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA20__LCDIF1_DATA_20                    = IOMUX_PAD(0x0468, 0x0120, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA20__WEIM_ADDR_20                      = IOMUX_PAD(0x0468, 0x0120, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA20__PWM8_OUT                          = IOMUX_PAD(0x0468, 0x0120, 2, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA20__ENET1_1588_EVENT2_OUT             = IOMUX_PAD(0x0468, 0x0120, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA20__CSI1_DATA_13                      = IOMUX_PAD(0x0468, 0x0120, 4, 0x06D0, 0, 0),
	 MX6_PAD_LCD1_DATA20__GPIO3_IO_21                       = IOMUX_PAD(0x0468, 0x0120, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA20__SRC_BT_CFG_28                     = IOMUX_PAD(0x0468, 0x0120, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA20__SIM_M_HRESP                       = IOMUX_PAD(0x0468, 0x0120, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA20__VDEC_DEBUG_5                      = IOMUX_PAD(0x0468, 0x0120, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA20__MMDC_DEBUG_25                     = IOMUX_PAD(0x0468, 0x0120, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA21__LCDIF1_DATA_21                    = IOMUX_PAD(0x046C, 0x0124, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA21__WEIM_ADDR_21                      = IOMUX_PAD(0x046C, 0x0124, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA21__PWM7_OUT                          = IOMUX_PAD(0x046C, 0x0124, 2, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA21__ENET1_1588_EVENT3_OUT             = IOMUX_PAD(0x046C, 0x0124, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA21__CSI1_DATA_12                      = IOMUX_PAD(0x046C, 0x0124, 4, 0x06CC, 0, 0),
	 MX6_PAD_LCD1_DATA21__GPIO3_IO_22                       = IOMUX_PAD(0x046C, 0x0124, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA21__SRC_BT_CFG_29                     = IOMUX_PAD(0x046C, 0x0124, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA21__SIM_M_HSIZE_0                     = IOMUX_PAD(0x046C, 0x0124, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA21__VDEC_DEBUG_6                      = IOMUX_PAD(0x046C, 0x0124, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA21__MMDC_DEBUG_26                     = IOMUX_PAD(0x046C, 0x0124, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA22__LCDIF1_DATA_22                    = IOMUX_PAD(0x0470, 0x0128, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA22__WEIM_ADDR_22                      = IOMUX_PAD(0x0470, 0x0128, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA22__PWM6_OUT                          = IOMUX_PAD(0x0470, 0x0128, 2, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA22__ENET2_1588_EVENT2_OUT             = IOMUX_PAD(0x0470, 0x0128, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA22__CSI1_DATA_11                      = IOMUX_PAD(0x0470, 0x0128, 4, 0x06C8, 0, 0),
	 MX6_PAD_LCD1_DATA22__GPIO3_IO_23                       = IOMUX_PAD(0x0470, 0x0128, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA22__SRC_BT_CFG_30                     = IOMUX_PAD(0x0470, 0x0128, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA22__SIM_M_HSIZE_1                     = IOMUX_PAD(0x0470, 0x0128, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA22__VDEC_DEBUG_7                      = IOMUX_PAD(0x0470, 0x0128, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA22__MMDC_DEBUG_27                     = IOMUX_PAD(0x0470, 0x0128, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_DATA23__LCDIF1_DATA_23                    = IOMUX_PAD(0x0474, 0x012C, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA23__WEIM_ADDR_23                      = IOMUX_PAD(0x0474, 0x012C, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA23__PWM5_OUT                          = IOMUX_PAD(0x0474, 0x012C, 2, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA23__ENET2_1588_EVENT3_OUT             = IOMUX_PAD(0x0474, 0x012C, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA23__CSI1_DATA_10                      = IOMUX_PAD(0x0474, 0x012C, 4, 0x06FC, 0, 0),
	 MX6_PAD_LCD1_DATA23__GPIO3_IO_24                       = IOMUX_PAD(0x0474, 0x012C, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA23__SRC_BT_CFG_31                     = IOMUX_PAD(0x0474, 0x012C, 6, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA23__SIM_M_HSIZE_2                     = IOMUX_PAD(0x0474, 0x012C, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA23__VDEC_DEBUG_8                      = IOMUX_PAD(0x0474, 0x012C, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_DATA23__MMDC_DEBUG_28                     = IOMUX_PAD(0x0474, 0x012C, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_ENABLE__LCDIF1_ENABLE                     = IOMUX_PAD(0x0478, 0x0130, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_ENABLE__LCDIF1_RD_E                       = IOMUX_PAD(0x0478, 0x0130, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_ENABLE__AUDMUX_AUD3_TXC                   = IOMUX_PAD(0x0478, 0x0130, 2, 0x063C, 1, 0),
	 MX6_PAD_LCD1_ENABLE__ENET1_1588_EVENT3_IN              = IOMUX_PAD(0x0478, 0x0130, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_ENABLE__CSI1_DATA_17                      = IOMUX_PAD(0x0478, 0x0130, 4, 0x06E0, 0, 0),
	 MX6_PAD_LCD1_ENABLE__GPIO3_IO_25                       = IOMUX_PAD(0x0478, 0x0130, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_ENABLE__USDHC1_CD_B                       = IOMUX_PAD(0x0478, 0x0130, 6, 0x0864, 0, 0),
	 MX6_PAD_LCD1_ENABLE__SIM_M_HADDR_17                    = IOMUX_PAD(0x0478, 0x0130, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_ENABLE__VADC_TEST_1                       = IOMUX_PAD(0x0478, 0x0130, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_ENABLE__MMDC_DEBUG_1                      = IOMUX_PAD(0x0478, 0x0130, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_HSYNC__LCDIF1_HSYNC                       = IOMUX_PAD(0x047C, 0x0134, 0, 0x07E0, 0, 0),
	 MX6_PAD_LCD1_HSYNC__LCDIF1_RS                          = IOMUX_PAD(0x047C, 0x0134, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_HSYNC__AUDMUX_AUD3_TXD                    = IOMUX_PAD(0x047C, 0x0134, 2, 0x0630, 1, 0),
	 MX6_PAD_LCD1_HSYNC__ENET2_1588_EVENT2_IN               = IOMUX_PAD(0x047C, 0x0134, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_HSYNC__CSI1_DATA_18                       = IOMUX_PAD(0x047C, 0x0134, 4, 0x06E4, 0, 0),
	 MX6_PAD_LCD1_HSYNC__GPIO3_IO_26                        = IOMUX_PAD(0x047C, 0x0134, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_HSYNC__USDHC2_WP                          = IOMUX_PAD(0x047C, 0x0134, 6, 0x0870, 0, 0),
	 MX6_PAD_LCD1_HSYNC__SIM_M_HADDR_18                     = IOMUX_PAD(0x047C, 0x0134, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_HSYNC__VADC_TEST_2                        = IOMUX_PAD(0x047C, 0x0134, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_HSYNC__MMDC_DEBUG_2                       = IOMUX_PAD(0x047C, 0x0134, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_RESET__LCDIF1_RESET                       = IOMUX_PAD(0x0480, 0x0138, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_RESET__LCDIF1_CS                          = IOMUX_PAD(0x0480, 0x0138, 1, 0x0000, 0, 0),
	 MX6_PAD_LCD1_RESET__AUDMUX_AUD3_RXD                    = IOMUX_PAD(0x0480, 0x0138, 2, 0x062C, 1, 0),
	 MX6_PAD_LCD1_RESET__KITTEN_EVENTI                      = IOMUX_PAD(0x0480, 0x0138, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_RESET__M4_EVENTI                          = IOMUX_PAD(0x0480, 0x0138, 4, 0x0000, 0, 0),
	 MX6_PAD_LCD1_RESET__GPIO3_IO_27                        = IOMUX_PAD(0x0480, 0x0138, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_RESET__CCM_PMIC_RDY                       = IOMUX_PAD(0x0480, 0x0138, 6, 0x069C, 0, 0),
	 MX6_PAD_LCD1_RESET__SIM_M_HADDR_20                     = IOMUX_PAD(0x0480, 0x0138, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_RESET__VADC_TEST_4                        = IOMUX_PAD(0x0480, 0x0138, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_RESET__MMDC_DEBUG_4                       = IOMUX_PAD(0x0480, 0x0138, 9, 0x0000, 0, 0),

	 MX6_PAD_LCD1_VSYNC__LCDIF1_VSYNC                       = IOMUX_PAD(0x0484, 0x013C, 0, 0x0000, 0, 0),
	 MX6_PAD_LCD1_VSYNC__LCDIF1_BUSY                        = IOMUX_PAD(0x0484, 0x013C, 1, 0x07E0, 1, 0),
	 MX6_PAD_LCD1_VSYNC__AUDMUX_AUD3_TXFS                   = IOMUX_PAD(0x0484, 0x013C, 2, 0x0640, 1, 0),
	 MX6_PAD_LCD1_VSYNC__ENET2_1588_EVENT3_IN               = IOMUX_PAD(0x0484, 0x013C, 3, 0x0000, 0, 0),
	 MX6_PAD_LCD1_VSYNC__CSI1_DATA_19                       = IOMUX_PAD(0x0484, 0x013C, 4, 0x06E8, 0, 0),
	 MX6_PAD_LCD1_VSYNC__GPIO3_IO_28                        = IOMUX_PAD(0x0484, 0x013C, 5, 0x0000, 0, 0),
	 MX6_PAD_LCD1_VSYNC__USDHC2_CD_B                        = IOMUX_PAD(0x0484, 0x013C, 6, 0x086C, 0, 0),
	 MX6_PAD_LCD1_VSYNC__SIM_M_HADDR_19                     = IOMUX_PAD(0x0484, 0x013C, 7, 0x0000, 0, 0),
	 MX6_PAD_LCD1_VSYNC__VADC_TEST_3                        = IOMUX_PAD(0x0484, 0x013C, 8, 0x0000, 0, 0),
	 MX6_PAD_LCD1_VSYNC__MMDC_DEBUG_3                       = IOMUX_PAD(0x0484, 0x013C, 9, 0x0000, 0, 0),

	 MX6_PAD_NAND_ALE__RAWNAND_ALE                          = IOMUX_PAD(0x0488, 0x0140, 0, 0x0000, 0, 0),
	 MX6_PAD_NAND_ALE__I2C3_SDA                             = IOMUX_PAD(0x0488, 0x0140, 1, 0x07BC, 0, 0),
	 MX6_PAD_NAND_ALE__QSPI2_A_SS0_B                        = IOMUX_PAD(0x0488, 0x0140, 2, 0x0000, 0, 0),
	 MX6_PAD_NAND_ALE__ECSPI2_SS0                           = IOMUX_PAD(0x0488, 0x0140, 3, 0x072C, 0, 0),
	 MX6_PAD_NAND_ALE__ESAI_TX3_RX2                         = IOMUX_PAD(0x0488, 0x0140, 4, 0x079C, 0, 0),
	 MX6_PAD_NAND_ALE__GPIO4_IO_0                           = IOMUX_PAD(0x0488, 0x0140, 5, 0x0000, 0, 0),
	 MX6_PAD_NAND_ALE__WEIM_CS0_B                           = IOMUX_PAD(0x0488, 0x0140, 6, 0x0000, 0, 0),
	 MX6_PAD_NAND_ALE__TPSMP_HDATA_0                        = IOMUX_PAD(0x0488, 0x0140, 7, 0x0000, 0, 0),
	 MX6_PAD_NAND_ALE__ANATOP_USBPHY1_TSTI_TX_EN            = IOMUX_PAD(0x0488, 0x0140, 8, 0x0000, 0, 0),
	 MX6_PAD_NAND_ALE__SDMA_DEBUG_PC_12                     = IOMUX_PAD(0x0488, 0x0140, 9, 0x0000, 0, 0),

	 MX6_PAD_NAND_CE0_B__RAWNAND_CE0_B                      = IOMUX_PAD(0x048C, 0x0144, 0, 0x0000, 0, 0),
	 MX6_PAD_NAND_CE0_B__USDHC2_VSELECT                     = IOMUX_PAD(0x048C, 0x0144, 1, 0x0000, 0, 0),
	 MX6_PAD_NAND_CE0_B__QSPI2_A_DATA_2                     = IOMUX_PAD(0x048C, 0x0144, 2, 0x0000, 0, 0),
	 MX6_PAD_NAND_CE0_B__AUDMUX_AUD4_TXC                    = IOMUX_PAD(0x048C, 0x0144, 3, 0x0654, 0, 0),
	 MX6_PAD_NAND_CE0_B__ESAI_TX_CLK                        = IOMUX_PAD(0x048C, 0x0144, 4, 0x078C, 0, 0),
	 MX6_PAD_NAND_CE0_B__GPIO4_IO_1                         = IOMUX_PAD(0x048C, 0x0144, 5, 0x0000, 0, 0),
	 MX6_PAD_NAND_CE0_B__WEIM_LBA_B                         = IOMUX_PAD(0x048C, 0x0144, 6, 0x0000, 0, 0),
	 MX6_PAD_NAND_CE0_B__TPSMP_HDATA_3                      = IOMUX_PAD(0x048C, 0x0144, 7, 0x0000, 0, 0),
	 MX6_PAD_NAND_CE0_B__ANATOP_USBPHY1_TSTI_TX_HIZ         = IOMUX_PAD(0x048C, 0x0144, 8, 0x0000, 0, 0),
	 MX6_PAD_NAND_CE0_B__SDMA_DEBUG_PC_9                    = IOMUX_PAD(0x048C, 0x0144, 9, 0x0000, 0, 0),

	 MX6_PAD_NAND_CE1_B__RAWNAND_CE1_B                      = IOMUX_PAD(0x0490, 0x0148, 0, 0x0000, 0, 0),
	 MX6_PAD_NAND_CE1_B__USDHC3_RESET_B                     = IOMUX_PAD(0x0490, 0x0148, 1, 0x0000, 0, 0),
	 MX6_PAD_NAND_CE1_B__QSPI2_A_DATA_3                     = IOMUX_PAD(0x0490, 0x0148, 2, 0x0000, 0, 0),
	 MX6_PAD_NAND_CE1_B__AUDMUX_AUD4_TXD                    = IOMUX_PAD(0x0490, 0x0148, 3, 0x0648, 0, 0),
	 MX6_PAD_NAND_CE1_B__ESAI_TX0                           = IOMUX_PAD(0x0490, 0x0148, 4, 0x0790, 0, 0),
	 MX6_PAD_NAND_CE1_B__GPIO4_IO_2                         = IOMUX_PAD(0x0490, 0x0148, 5, 0x0000, 0, 0),
	 MX6_PAD_NAND_CE1_B__WEIM_OE                            = IOMUX_PAD(0x0490, 0x0148, 6, 0x0000, 0, 0),
	 MX6_PAD_NAND_CE1_B__TPSMP_HDATA_4                      = IOMUX_PAD(0x0490, 0x0148, 7, 0x0000, 0, 0),
	 MX6_PAD_NAND_CE1_B__ANATOP_USBPHY1_TSTI_TX_LS_MODE     = IOMUX_PAD(0x0490, 0x0148, 8, 0x0000, 0, 0),
	 MX6_PAD_NAND_CE1_B__SDMA_DEBUG_PC_8                    = IOMUX_PAD(0x0490, 0x0148, 9, 0x0000, 0, 0),

	 MX6_PAD_NAND_CLE__RAWNAND_CLE                          = IOMUX_PAD(0x0494, 0x014C, 0, 0x0000, 0, 0),
	 MX6_PAD_NAND_CLE__I2C3_SCL                             = IOMUX_PAD(0x0494, 0x014C, 1, 0x07B8, 0, 0),
	 MX6_PAD_NAND_CLE__QSPI2_A_SCLK                         = IOMUX_PAD(0x0494, 0x014C, 2, 0x0000, 0, 0),
	 MX6_PAD_NAND_CLE__ECSPI2_SCLK                          = IOMUX_PAD(0x0494, 0x014C, 3, 0x0720, 0, 0),
	 MX6_PAD_NAND_CLE__ESAI_TX2_RX3                         = IOMUX_PAD(0x0494, 0x014C, 4, 0x0798, 0, 0),
	 MX6_PAD_NAND_CLE__GPIO4_IO_3                           = IOMUX_PAD(0x0494, 0x014C, 5, 0x0000, 0, 0),
	 MX6_PAD_NAND_CLE__WEIM_BCLK                            = IOMUX_PAD(0x0494, 0x014C, 6, 0x0000, 0, 0),
	 MX6_PAD_NAND_CLE__TPSMP_CLK                            = IOMUX_PAD(0x0494, 0x014C, 7, 0x0000, 0, 0),
	 MX6_PAD_NAND_CLE__ANATOP_USBPHY1_TSTI_TX_DP            = IOMUX_PAD(0x0494, 0x014C, 8, 0x0000, 0, 0),
	 MX6_PAD_NAND_CLE__SDMA_DEBUG_PC_13                     = IOMUX_PAD(0x0494, 0x014C, 9, 0x0000, 0, 0),

	 MX6_PAD_NAND_DATA00__RAWNAND_DATA00                    = IOMUX_PAD(0x0498, 0x0150, 0, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA00__USDHC1_DATA4                      = IOMUX_PAD(0x0498, 0x0150, 1, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA00__QSPI2_B_DATA_1                    = IOMUX_PAD(0x0498, 0x0150, 2, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA00__ECSPI5_MISO                       = IOMUX_PAD(0x0498, 0x0150, 3, 0x0754, 0, 0),
	 MX6_PAD_NAND_DATA00__ESAI_RX_CLK                       = IOMUX_PAD(0x0498, 0x0150, 4, 0x0788, 0, 0),
	 MX6_PAD_NAND_DATA00__GPIO4_IO_4                        = IOMUX_PAD(0x0498, 0x0150, 5, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA00__WEIM_AD_0                         = IOMUX_PAD(0x0498, 0x0150, 6, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA00__TPSMP_HDATA_7                     = IOMUX_PAD(0x0498, 0x0150, 7, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA00__ANATOP_USBPHY1_TSTO_RX_DISCON_DET = IOMUX_PAD(0x0498, 0x0150, 8, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA00__SDMA_DEBUG_EVT_CHN_LINES_5        = IOMUX_PAD(0x0498, 0x0150, 9, 0x0000, 0, 0),

	 MX6_PAD_NAND_DATA01__RAWNAND_DATA01                    = IOMUX_PAD(0x049C, 0x0154, 0, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA01__USDHC1_DATA5                      = IOMUX_PAD(0x049C, 0x0154, 1, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA01__QSPI2_B_DATA_0                    = IOMUX_PAD(0x049C, 0x0154, 2, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA01__ECSPI5_MOSI                       = IOMUX_PAD(0x049C, 0x0154, 3, 0x0758, 0, 0),
	 MX6_PAD_NAND_DATA01__ESAI_RX_FS                        = IOMUX_PAD(0x049C, 0x0154, 4, 0x0778, 0, 0),
	 MX6_PAD_NAND_DATA01__GPIO4_IO_5                        = IOMUX_PAD(0x049C, 0x0154, 5, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA01__WEIM_AD_1                         = IOMUX_PAD(0x049C, 0x0154, 6, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA01__TPSMP_HDATA_8                     = IOMUX_PAD(0x049C, 0x0154, 7, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA01__ANATOP_USBPHY1_TSTO_RX_HS_RXD     = IOMUX_PAD(0x049C, 0x0154, 8, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA01__SDMA_DEBUG_EVT_CHN_LINES_4        = IOMUX_PAD(0x049C, 0x0154, 9, 0x0000, 0, 0),

	 MX6_PAD_NAND_DATA02__RAWNAND_DATA02                    = IOMUX_PAD(0x04A0, 0x0158, 0, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA02__USDHC1_DATA6                      = IOMUX_PAD(0x04A0, 0x0158, 1, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA02__QSPI2_B_SCLK                      = IOMUX_PAD(0x04A0, 0x0158, 2, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA02__ECSPI5_SCLK                       = IOMUX_PAD(0x04A0, 0x0158, 3, 0x0750, 0, 0),
	 MX6_PAD_NAND_DATA02__ESAI_TX_HF_CLK                    = IOMUX_PAD(0x04A0, 0x0158, 4, 0x0784, 0, 0),
	 MX6_PAD_NAND_DATA02__GPIO4_IO_6                        = IOMUX_PAD(0x04A0, 0x0158, 5, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA02__WEIM_AD_2                         = IOMUX_PAD(0x04A0, 0x0158, 6, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA02__TPSMP_HDATA_9                     = IOMUX_PAD(0x04A0, 0x0158, 7, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA02__ANATOP_USBPHY2_TSTO_PLL_CLK20DIV  = IOMUX_PAD(0x04A0, 0x0158, 8, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA02__SDMA_DEBUG_EVT_CHN_LINES_3        = IOMUX_PAD(0x04A0, 0x0158, 9, 0x0000, 0, 0),

	 MX6_PAD_NAND_DATA03__RAWNAND_DATA03                    = IOMUX_PAD(0x04A4, 0x015C, 0, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA03__USDHC1_DATA7                      = IOMUX_PAD(0x04A4, 0x015C, 1, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA03__QSPI2_B_SS0_B                     = IOMUX_PAD(0x04A4, 0x015C, 2, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA03__ECSPI5_SS0                        = IOMUX_PAD(0x04A4, 0x015C, 3, 0x075C, 0, 0),
	 MX6_PAD_NAND_DATA03__ESAI_RX_HF_CLK                    = IOMUX_PAD(0x04A4, 0x015C, 4, 0x0780, 0, 0),
	 MX6_PAD_NAND_DATA03__GPIO4_IO_7                        = IOMUX_PAD(0x04A4, 0x015C, 5, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA03__WEIM_AD_3                         = IOMUX_PAD(0x04A4, 0x015C, 6, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA03__TPSMP_HDATA_10                    = IOMUX_PAD(0x04A4, 0x015C, 7, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA03__ANATOP_USBPHY1_TSTO_RX_SQUELCH    = IOMUX_PAD(0x04A4, 0x015C, 8, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA03__SDMA_DEBUG_EVT_CHN_LINES_6        = IOMUX_PAD(0x04A4, 0x015C, 9, 0x0000, 0, 0),

	 MX6_PAD_NAND_DATA04__RAWNAND_DATA04                    = IOMUX_PAD(0x04A8, 0x0160, 0, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA04__USDHC2_DATA4                      = IOMUX_PAD(0x04A8, 0x0160, 1, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA04__QSPI2_B_SS1_B                     = IOMUX_PAD(0x04A8, 0x0160, 2, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA04__UART3_RTS_B                       = IOMUX_PAD(0x04A8, 0x0160, 3, 0x083C, 0, 0),
	 MX6_PAD_NAND_DATA04__AUDMUX_AUD4_RXFS                  = IOMUX_PAD(0x04A8, 0x0160, 4, 0x0650, 0, 0),
	 MX6_PAD_NAND_DATA04__GPIO4_IO_8                        = IOMUX_PAD(0x04A8, 0x0160, 5, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA04__WEIM_AD_4                         = IOMUX_PAD(0x04A8, 0x0160, 6, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA04__TPSMP_HDATA_11                    = IOMUX_PAD(0x04A8, 0x0160, 7, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA04__ANATOP_USBPHY2_TSTO_RX_SQUELCH    = IOMUX_PAD(0x04A8, 0x0160, 8, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA04__SDMA_DEBUG_CORE_STATE_0           = IOMUX_PAD(0x04A8, 0x0160, 9, 0x0000, 0, 0),

	 MX6_PAD_NAND_DATA05__RAWNAND_DATA05                    = IOMUX_PAD(0x04AC, 0x0164, 0, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA05__USDHC2_DATA5                      = IOMUX_PAD(0x04AC, 0x0164, 1, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA05__QSPI2_B_DQS                       = IOMUX_PAD(0x04AC, 0x0164, 2, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA05__UART3_CTS_B                       = IOMUX_PAD(0x04AC, 0x0164, 3, 0x083C, 1, 0),
	 MX6_PAD_NAND_DATA05__AUDMUX_AUD4_RXC                   = IOMUX_PAD(0x04AC, 0x0164, 4, 0x064C, 0, 0),
	 MX6_PAD_NAND_DATA05__GPIO4_IO_9                        = IOMUX_PAD(0x04AC, 0x0164, 5, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA05__WEIM_AD_5                         = IOMUX_PAD(0x04AC, 0x0164, 6, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA05__TPSMP_HDATA_12                    = IOMUX_PAD(0x04AC, 0x0164, 7, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA05__ANATOP_USBPHY2_TSTO_RX_DISCON_DET = IOMUX_PAD(0x04AC, 0x0164, 8, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA05__SDMA_DEBUG_CORE_STATE_1           = IOMUX_PAD(0x04AC, 0x0164, 9, 0x0000, 0, 0),

	 MX6_PAD_NAND_DATA06__RAWNAND_DATA06                    = IOMUX_PAD(0x04B0, 0x0168, 0, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA06__USDHC2_DATA6                      = IOMUX_PAD(0x04B0, 0x0168, 1, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA06__QSPI2_A_SS1_B                     = IOMUX_PAD(0x04B0, 0x0168, 2, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA06__UART3_RX                          = IOMUX_PAD(0x04B0, 0x0168, 3, 0x0840, 0, 0),
	 MX6_PAD_NAND_DATA06__PWM3_OUT                          = IOMUX_PAD(0x04B0, 0x0168, 4, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA06__GPIO4_IO_10                       = IOMUX_PAD(0x04B0, 0x0168, 5, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA06__WEIM_AD_6                         = IOMUX_PAD(0x04B0, 0x0168, 6, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA06__TPSMP_HDATA_13                    = IOMUX_PAD(0x04B0, 0x0168, 7, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA06__ANATOP_USBPHY2_TSTO_RX_FS_RXD     = IOMUX_PAD(0x04B0, 0x0168, 8, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA06__SDMA_DEBUG_CORE_STATE_2           = IOMUX_PAD(0x04B0, 0x0168, 9, 0x0000, 0, 0),

	 MX6_PAD_NAND_DATA07__RAWNAND_DATA07                    = IOMUX_PAD(0x04B4, 0x016C, 0, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA07__USDHC2_DATA7                      = IOMUX_PAD(0x04B4, 0x016C, 1, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA07__QSPI2_A_DQS                       = IOMUX_PAD(0x04B4, 0x016C, 2, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA07__UART3_TX                          = IOMUX_PAD(0x04B4, 0x016C, 3, 0x0840, 1, 0),
	 MX6_PAD_NAND_DATA07__PWM4_OUT                          = IOMUX_PAD(0x04B4, 0x016C, 4, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA07__GPIO4_IO_11                       = IOMUX_PAD(0x04B4, 0x016C, 5, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA07__WEIM_AD_7                         = IOMUX_PAD(0x04B4, 0x016C, 6, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA07__TPSMP_HDATA_14                    = IOMUX_PAD(0x04B4, 0x016C, 7, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA07__ANATOP_USBPHY1_TSTO_RX_FS_RXD     = IOMUX_PAD(0x04B4, 0x016C, 8, 0x0000, 0, 0),
	 MX6_PAD_NAND_DATA07__SDMA_DEBUG_CORE_STATE_3           = IOMUX_PAD(0x04B4, 0x016C, 9, 0x0000, 0, 0),

	 MX6_PAD_NAND_RE_B__RAWNAND_RE_B                        = IOMUX_PAD(0x04B8, 0x0170, 0, 0x0000, 0, 0),
	 MX6_PAD_NAND_RE_B__USDHC2_RESET_B                      = IOMUX_PAD(0x04B8, 0x0170, 1, 0x0000, 0, 0),
	 MX6_PAD_NAND_RE_B__QSPI2_B_DATA_3                      = IOMUX_PAD(0x04B8, 0x0170, 2, 0x0000, 0, 0),
	 MX6_PAD_NAND_RE_B__AUDMUX_AUD4_TXFS                    = IOMUX_PAD(0x04B8, 0x0170, 3, 0x0658, 0, 0),
	 MX6_PAD_NAND_RE_B__ESAI_TX_FS                          = IOMUX_PAD(0x04B8, 0x0170, 4, 0x077C, 0, 0),
	 MX6_PAD_NAND_RE_B__GPIO4_IO_12                         = IOMUX_PAD(0x04B8, 0x0170, 5, 0x0000, 0, 0),
	 MX6_PAD_NAND_RE_B__WEIM_RW                             = IOMUX_PAD(0x04B8, 0x0170, 6, 0x0000, 0, 0),
	 MX6_PAD_NAND_RE_B__TPSMP_HDATA_5                       = IOMUX_PAD(0x04B8, 0x0170, 7, 0x0000, 0, 0),
	 MX6_PAD_NAND_RE_B__ANATOP_USBPHY2_TSTO_RX_HS_RXD       = IOMUX_PAD(0x04B8, 0x0170, 8, 0x0000, 0, 0),
	 MX6_PAD_NAND_RE_B__SDMA_DEBUG_PC_7                     = IOMUX_PAD(0x04B8, 0x0170, 9, 0x0000, 0, 0),

	 MX6_PAD_NAND_READY_B__RAWNAND_READY_B                  = IOMUX_PAD(0x04BC, 0x0174, 0, 0x0000, 0, 0),
	 MX6_PAD_NAND_READY_B__USDHC1_VSELECT                   = IOMUX_PAD(0x04BC, 0x0174, 1, 0x0000, 0, 0),
	 MX6_PAD_NAND_READY_B__QSPI2_A_DATA_1                   = IOMUX_PAD(0x04BC, 0x0174, 2, 0x0000, 0, 0),
	 MX6_PAD_NAND_READY_B__ECSPI2_MISO                      = IOMUX_PAD(0x04BC, 0x0174, 3, 0x0724, 0, 0),
	 MX6_PAD_NAND_READY_B__ESAI_TX1                         = IOMUX_PAD(0x04BC, 0x0174, 4, 0x0794, 0, 0),
	 MX6_PAD_NAND_READY_B__GPIO4_IO_13                      = IOMUX_PAD(0x04BC, 0x0174, 5, 0x0000, 0, 0),
	 MX6_PAD_NAND_READY_B__WEIM_EB_B_1                      = IOMUX_PAD(0x04BC, 0x0174, 6, 0x0000, 0, 0),
	 MX6_PAD_NAND_READY_B__TPSMP_HDATA_2                    = IOMUX_PAD(0x04BC, 0x0174, 7, 0x0000, 0, 0),
	 MX6_PAD_NAND_READY_B__ANATOP_USBPHY1_TSTI_TX_DN        = IOMUX_PAD(0x04BC, 0x0174, 8, 0x0000, 0, 0),
	 MX6_PAD_NAND_READY_B__SDMA_DEBUG_PC_10                 = IOMUX_PAD(0x04BC, 0x0174, 9, 0x0000, 0, 0),

	 MX6_PAD_NAND_WE_B__RAWNAND_WE_B                        = IOMUX_PAD(0x04C0, 0x0178, 0, 0x0000, 0, 0),
	 MX6_PAD_NAND_WE_B__USDHC4_VSELECT                      = IOMUX_PAD(0x04C0, 0x0178, 1, 0x0000, 0, 0),
	 MX6_PAD_NAND_WE_B__QSPI2_B_DATA_2                      = IOMUX_PAD(0x04C0, 0x0178, 2, 0x0000, 0, 0),
	 MX6_PAD_NAND_WE_B__AUDMUX_AUD4_RXD                     = IOMUX_PAD(0x04C0, 0x0178, 3, 0x0644, 0, 0),
	 MX6_PAD_NAND_WE_B__ESAI_TX5_RX0                        = IOMUX_PAD(0x04C0, 0x0178, 4, 0x07A4, 0, 0),
	 MX6_PAD_NAND_WE_B__GPIO4_IO_14                         = IOMUX_PAD(0x04C0, 0x0178, 5, 0x0000, 0, 0),
	 MX6_PAD_NAND_WE_B__WEIM_WAIT                           = IOMUX_PAD(0x04C0, 0x0178, 6, 0x0000, 0, 0),
	 MX6_PAD_NAND_WE_B__TPSMP_HDATA_6                       = IOMUX_PAD(0x04C0, 0x0178, 7, 0x0000, 0, 0),
	 MX6_PAD_NAND_WE_B__ANATOP_USBPHY1_TSTO_PLL_CLK20DIV    = IOMUX_PAD(0x04C0, 0x0178, 8, 0x0000, 0, 0),
	 MX6_PAD_NAND_WE_B__SDMA_DEBUG_PC_6                     = IOMUX_PAD(0x04C0, 0x0178, 9, 0x0000, 0, 0),

	 MX6_PAD_NAND_WP_B__RAWNAND_WP_B                        = IOMUX_PAD(0x04C4, 0x017C, 0, 0x0000, 0, 0),
	 MX6_PAD_NAND_WP_B__USDHC1_RESET_B                      = IOMUX_PAD(0x04C4, 0x017C, 1, 0x0000, 0, 0),
	 MX6_PAD_NAND_WP_B__QSPI2_A_DATA_0                      = IOMUX_PAD(0x04C4, 0x017C, 2, 0x0000, 0, 0),
	 MX6_PAD_NAND_WP_B__ECSPI2_MOSI                         = IOMUX_PAD(0x04C4, 0x017C, 3, 0x0728, 0, 0),
	 MX6_PAD_NAND_WP_B__ESAI_TX4_RX1                        = IOMUX_PAD(0x04C4, 0x017C, 4, 0x07A0, 0, 0),
	 MX6_PAD_NAND_WP_B__GPIO4_IO_15                         = IOMUX_PAD(0x04C4, 0x017C, 5, 0x0000, 0, 0),
	 MX6_PAD_NAND_WP_B__WEIM_EB_B_0                         = IOMUX_PAD(0x04C4, 0x017C, 6, 0x0000, 0, 0),
	 MX6_PAD_NAND_WP_B__TPSMP_HDATA_1                       = IOMUX_PAD(0x04C4, 0x017C, 7, 0x0000, 0, 0),
	 MX6_PAD_NAND_WP_B__ANATOP_USBPHY1_TSTI_TX_HS_MODE      = IOMUX_PAD(0x04C4, 0x017C, 8, 0x0000, 0, 0),
	 MX6_PAD_NAND_WP_B__SDMA_DEBUG_PC_11                    = IOMUX_PAD(0x04C4, 0x017C, 9, 0x0000, 0, 0),

	 MX6_PAD_QSPI1A_DATA0__QSPI1_A_DATA_0                   = IOMUX_PAD(0x04C8, 0x0180, 0, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA0__USB_OTG2_OC                      = IOMUX_PAD(0x04C8, 0x0180, 1, 0x085C, 2, 0),
	 MX6_PAD_QSPI1A_DATA0__ECSPI1_MOSI                      = IOMUX_PAD(0x04C8, 0x0180, 2, 0x0718, 1, 0),
	 MX6_PAD_QSPI1A_DATA0__ESAI_TX4_RX1                     = IOMUX_PAD(0x04C8, 0x0180, 3, 0x07A0, 2, 0),
	 MX6_PAD_QSPI1A_DATA0__CSI1_DATA_14                     = IOMUX_PAD(0x04C8, 0x0180, 4, 0x06D4, 1, 0),
	 MX6_PAD_QSPI1A_DATA0__GPIO4_IO_16                      = IOMUX_PAD(0x04C8, 0x0180, 5, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA0__WEIM_DATA_6                      = IOMUX_PAD(0x04C8, 0x0180, 6, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA0__SIM_M_HADDR_3                    = IOMUX_PAD(0x04C8, 0x0180, 7, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA0__SDMA_DEBUG_BUS_DEVICE_3          = IOMUX_PAD(0x04C8, 0x0180, 9, 0x0000, 0, 0),

	 MX6_PAD_QSPI1A_DATA1__QSPI1_A_DATA_1                   = IOMUX_PAD(0x04CC, 0x0184, 0, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA1__ANATOP_OTG1_ID                   = IOMUX_PAD(0x04CC, 0x0184, 1, 0x0624, 2, 0),
	 MX6_PAD_QSPI1A_DATA1__ECSPI1_MISO                      = IOMUX_PAD(0x04CC, 0x0184, 2, 0x0714, 1, 0),
	 MX6_PAD_QSPI1A_DATA1__ESAI_TX1                         = IOMUX_PAD(0x04CC, 0x0184, 3, 0x0794, 2, 0),
	 MX6_PAD_QSPI1A_DATA1__CSI1_DATA_13                     = IOMUX_PAD(0x04CC, 0x0184, 4, 0x06D0, 1, 0),
	 MX6_PAD_QSPI1A_DATA1__GPIO4_IO_17                      = IOMUX_PAD(0x04CC, 0x0184, 5, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA1__WEIM_DATA_5                      = IOMUX_PAD(0x04CC, 0x0184, 6, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA1__SIM_M_HADDR_4                    = IOMUX_PAD(0x04CC, 0x0184, 7, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA1__SDMA_DEBUG_PC_0                  = IOMUX_PAD(0x04CC, 0x0184, 9, 0x0000, 0, 0),

	 MX6_PAD_QSPI1A_DATA2__QSPI1_A_DATA_2                   = IOMUX_PAD(0x04D0, 0x0188, 0, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA2__USB_OTG1_PWR                     = IOMUX_PAD(0x04D0, 0x0188, 1, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA2__ECSPI5_SS1                       = IOMUX_PAD(0x04D0, 0x0188, 2, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA2__ESAI_TX_CLK                      = IOMUX_PAD(0x04D0, 0x0188, 3, 0x078C, 2, 0),
	 MX6_PAD_QSPI1A_DATA2__CSI1_DATA_12                     = IOMUX_PAD(0x04D0, 0x0188, 4, 0x06CC, 1, 0),
	 MX6_PAD_QSPI1A_DATA2__GPIO4_IO_18                      = IOMUX_PAD(0x04D0, 0x0188, 5, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA2__WEIM_DATA_4                      = IOMUX_PAD(0x04D0, 0x0188, 6, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA2__SIM_M_HADDR_6                    = IOMUX_PAD(0x04D0, 0x0188, 7, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA2__SDMA_DEBUG_PC_1                  = IOMUX_PAD(0x04D0, 0x0188, 9, 0x0000, 0, 0),

	 MX6_PAD_QSPI1A_DATA3__QSPI1_A_DATA_3                   = IOMUX_PAD(0x04D4, 0x018C, 0, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA3__USB_OTG1_OC                      = IOMUX_PAD(0x04D4, 0x018C, 1, 0x0860, 2, 0),
	 MX6_PAD_QSPI1A_DATA3__ECSPI5_SS2                       = IOMUX_PAD(0x04D4, 0x018C, 2, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA3__ESAI_TX0                         = IOMUX_PAD(0x04D4, 0x018C, 3, 0x0790, 2, 0),
	 MX6_PAD_QSPI1A_DATA3__CSI1_DATA_11                     = IOMUX_PAD(0x04D4, 0x018C, 4, 0x06C8, 1, 0),
	 MX6_PAD_QSPI1A_DATA3__GPIO4_IO_19                      = IOMUX_PAD(0x04D4, 0x018C, 5, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA3__WEIM_DATA_3                      = IOMUX_PAD(0x04D4, 0x018C, 6, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA3__SIM_M_HADDR_7                    = IOMUX_PAD(0x04D4, 0x018C, 7, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DATA3__SDMA_DEBUG_PC_2                  = IOMUX_PAD(0x04D4, 0x018C, 9, 0x0000, 0, 0),

	 MX6_PAD_QSPI1A_DQS__QSPI1_A_DQS                        = IOMUX_PAD(0x04D8, 0x0190, 0, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DQS__CAN2_TX                            = IOMUX_PAD(0x04D8, 0x0190, 1, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DQS__CANFD_TX2                          = IOMUX_PAD(0x04D8, 0x0190, 2, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DQS__ECSPI5_MOSI                        = IOMUX_PAD(0x04D8, 0x0190, 3, 0x0758, 1, 0),
	 MX6_PAD_QSPI1A_DQS__CSI1_DATA_15                       = IOMUX_PAD(0x04D8, 0x0190, 4, 0x06D8, 1, 0),
	 MX6_PAD_QSPI1A_DQS__GPIO4_IO_20                        = IOMUX_PAD(0x04D8, 0x0190, 5, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DQS__WEIM_DATA_7                        = IOMUX_PAD(0x04D8, 0x0190, 6, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DQS__SIM_M_HADDR_13                     = IOMUX_PAD(0x04D8, 0x0190, 7, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_DQS__SDMA_DEBUG_BUS_DEVICE_4            = IOMUX_PAD(0x04D8, 0x0190, 9, 0x0000, 0, 0),

	 MX6_PAD_QSPI1A_SCLK__QSPI1_A_SCLK                      = IOMUX_PAD(0x04DC, 0x0194, 0, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_SCLK__ANATOP_OTG2_ID                    = IOMUX_PAD(0x04DC, 0x0194, 1, 0x0628, 2, 0),
	 MX6_PAD_QSPI1A_SCLK__ECSPI1_SCLK                       = IOMUX_PAD(0x04DC, 0x0194, 2, 0x0710, 1, 0),
	 MX6_PAD_QSPI1A_SCLK__ESAI_TX2_RX3                      = IOMUX_PAD(0x04DC, 0x0194, 3, 0x0798, 2, 0),
	 MX6_PAD_QSPI1A_SCLK__CSI1_DATA_1                       = IOMUX_PAD(0x04DC, 0x0194, 4, 0x06A4, 1, 0),
	 MX6_PAD_QSPI1A_SCLK__GPIO4_IO_21                       = IOMUX_PAD(0x04DC, 0x0194, 5, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_SCLK__WEIM_DATA_0                       = IOMUX_PAD(0x04DC, 0x0194, 6, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_SCLK__SIM_M_HADDR_0                     = IOMUX_PAD(0x04DC, 0x0194, 7, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_SCLK__SDMA_DEBUG_PC_5                   = IOMUX_PAD(0x04DC, 0x0194, 9, 0x0000, 0, 0),

	 MX6_PAD_QSPI1A_SS0_B__QSPI1_A_SS0_B                    = IOMUX_PAD(0x04E0, 0x0198, 0, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_SS0_B__USB_OTG2_PWR                     = IOMUX_PAD(0x04E0, 0x0198, 1, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_SS0_B__ECSPI1_SS0                       = IOMUX_PAD(0x04E0, 0x0198, 2, 0x071C, 1, 0),
	 MX6_PAD_QSPI1A_SS0_B__ESAI_TX3_RX2                     = IOMUX_PAD(0x04E0, 0x0198, 3, 0x079C, 2, 0),
	 MX6_PAD_QSPI1A_SS0_B__CSI1_DATA_0                      = IOMUX_PAD(0x04E0, 0x0198, 4, 0x06A0, 1, 0),
	 MX6_PAD_QSPI1A_SS0_B__GPIO4_IO_22                      = IOMUX_PAD(0x04E0, 0x0198, 5, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_SS0_B__WEIM_DATA_1                      = IOMUX_PAD(0x04E0, 0x0198, 6, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_SS0_B__SIM_M_HADDR_1                    = IOMUX_PAD(0x04E0, 0x0198, 7, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_SS0_B__SDMA_DEBUG_PC_4                  = IOMUX_PAD(0x04E0, 0x0198, 9, 0x0000, 0, 0),

	 MX6_PAD_QSPI1A_SS1_B__QSPI1_A_SS1_B                    = IOMUX_PAD(0x04E4, 0x019C, 0, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_SS1_B__CAN1_RX                          = IOMUX_PAD(0x04E4, 0x019C, 1, 0x068C, 2, 0),
	 MX6_PAD_QSPI1A_SS1_B__CANFD_RX1                        = IOMUX_PAD(0x04E4, 0x019C, 2, 0x0694, 2, 0),
	 MX6_PAD_QSPI1A_SS1_B__ECSPI5_MISO                      = IOMUX_PAD(0x04E4, 0x019C, 3, 0x0754, 1, 0),
	 MX6_PAD_QSPI1A_SS1_B__CSI1_DATA_10                     = IOMUX_PAD(0x04E4, 0x019C, 4, 0x06FC, 1, 0),
	 MX6_PAD_QSPI1A_SS1_B__GPIO4_IO_23                      = IOMUX_PAD(0x04E4, 0x019C, 5, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_SS1_B__WEIM_DATA_2                      = IOMUX_PAD(0x04E4, 0x019C, 6, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_SS1_B__SIM_M_HADDR_12                   = IOMUX_PAD(0x04E4, 0x019C, 7, 0x0000, 0, 0),
	 MX6_PAD_QSPI1A_SS1_B__SDMA_DEBUG_PC_3                  = IOMUX_PAD(0x04E4, 0x019C, 9, 0x0000, 0, 0),

	 MX6_PAD_QSPI1B_DATA0__QSPI1_B_DATA_0                   = IOMUX_PAD(0x04E8, 0x01A0, 0, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DATA0__UART3_CTS_B                      = IOMUX_PAD(0x04E8, 0x01A0, 1, 0x083C, 4, 0),
	 MX6_PAD_QSPI1B_DATA0__ECSPI3_MOSI                      = IOMUX_PAD(0x04E8, 0x01A0, 2, 0x0738, 1, 0),
	 MX6_PAD_QSPI1B_DATA0__ESAI_RX_FS                       = IOMUX_PAD(0x04E8, 0x01A0, 3, 0x0778, 2, 0),
	 MX6_PAD_QSPI1B_DATA0__CSI1_DATA_22                     = IOMUX_PAD(0x04E8, 0x01A0, 4, 0x06F4, 1, 0),
	 MX6_PAD_QSPI1B_DATA0__GPIO4_IO_24                      = IOMUX_PAD(0x04E8, 0x01A0, 5, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DATA0__WEIM_DATA_14                     = IOMUX_PAD(0x04E8, 0x01A0, 6, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DATA0__SIM_M_HADDR_9                    = IOMUX_PAD(0x04E8, 0x01A0, 7, 0x0000, 0, 0),

	 MX6_PAD_QSPI1B_DATA1__QSPI1_B_DATA_1                   = IOMUX_PAD(0x04EC, 0x01A4, 0, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DATA1__UART3_RTS_B                      = IOMUX_PAD(0x04EC, 0x01A4, 1, 0x083C, 5, 0),
	 MX6_PAD_QSPI1B_DATA1__ECSPI3_MISO                      = IOMUX_PAD(0x04EC, 0x01A4, 2, 0x0734, 1, 0),
	 MX6_PAD_QSPI1B_DATA1__ESAI_RX_CLK                      = IOMUX_PAD(0x04EC, 0x01A4, 3, 0x0788, 2, 0),
	 MX6_PAD_QSPI1B_DATA1__CSI1_DATA_21                     = IOMUX_PAD(0x04EC, 0x01A4, 4, 0x06F0, 1, 0),
	 MX6_PAD_QSPI1B_DATA1__GPIO4_IO_25                      = IOMUX_PAD(0x04EC, 0x01A4, 5, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DATA1__WEIM_DATA_13                     = IOMUX_PAD(0x04EC, 0x01A4, 6, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DATA1__SIM_M_HADDR_8                    = IOMUX_PAD(0x04EC, 0x01A4, 7, 0x0000, 0, 0),

	 MX6_PAD_QSPI1B_DATA2__QSPI1_B_DATA_2                   = IOMUX_PAD(0x04F0, 0x01A8, 0, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DATA2__I2C2_SDA                         = IOMUX_PAD(0x04F0, 0x01A8, 1, 0x07B4, 2, 0),
	 MX6_PAD_QSPI1B_DATA2__ECSPI5_RDY                       = IOMUX_PAD(0x04F0, 0x01A8, 2, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DATA2__ESAI_TX5_RX0                     = IOMUX_PAD(0x04F0, 0x01A8, 3, 0x07A4, 2, 0),
	 MX6_PAD_QSPI1B_DATA2__CSI1_DATA_20                     = IOMUX_PAD(0x04F0, 0x01A8, 4, 0x06EC, 1, 0),
	 MX6_PAD_QSPI1B_DATA2__GPIO4_IO_26                      = IOMUX_PAD(0x04F0, 0x01A8, 5, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DATA2__WEIM_DATA_12                     = IOMUX_PAD(0x04F0, 0x01A8, 6, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DATA2__SIM_M_HADDR_5                    = IOMUX_PAD(0x04F0, 0x01A8, 7, 0x0000, 0, 0),

	 MX6_PAD_QSPI1B_DATA3__QSPI1_B_DATA_3                   = IOMUX_PAD(0x04F4, 0x01AC, 0, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DATA3__I2C2_SCL                         = IOMUX_PAD(0x04F4, 0x01AC, 1, 0x07B0, 2, 0),
	 MX6_PAD_QSPI1B_DATA3__ECSPI5_SS3                       = IOMUX_PAD(0x04F4, 0x01AC, 2, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DATA3__ESAI_TX_FS                       = IOMUX_PAD(0x04F4, 0x01AC, 3, 0x077C, 2, 0),
	 MX6_PAD_QSPI1B_DATA3__CSI1_DATA_19                     = IOMUX_PAD(0x04F4, 0x01AC, 4, 0x06E8, 1, 0),
	 MX6_PAD_QSPI1B_DATA3__GPIO4_IO_27                      = IOMUX_PAD(0x04F4, 0x01AC, 5, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DATA3__WEIM_DATA_11                     = IOMUX_PAD(0x04F4, 0x01AC, 6, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DATA3__SIM_M_HADDR_2                    = IOMUX_PAD(0x04F4, 0x01AC, 7, 0x0000, 0, 0),

	 MX6_PAD_QSPI1B_DQS__QSPI1_B_DQS                        = IOMUX_PAD(0x04F8, 0x01B0, 0, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DQS__CAN1_TX                            = IOMUX_PAD(0x04F8, 0x01B0, 1, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DQS__CANFD_TX1                          = IOMUX_PAD(0x04F8, 0x01B0, 2, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DQS__ECSPI5_SS0                         = IOMUX_PAD(0x04F8, 0x01B0, 3, 0x075C, 1, 0),
	 MX6_PAD_QSPI1B_DQS__CSI1_DATA_23                       = IOMUX_PAD(0x04F8, 0x01B0, 4, 0x06F8, 1, 0),
	 MX6_PAD_QSPI1B_DQS__GPIO4_IO_28                        = IOMUX_PAD(0x04F8, 0x01B0, 5, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DQS__WEIM_DATA_15                       = IOMUX_PAD(0x04F8, 0x01B0, 6, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_DQS__SIM_M_HADDR_15                     = IOMUX_PAD(0x04F8, 0x01B0, 7, 0x0000, 0, 0),

	 MX6_PAD_QSPI1B_SCLK__QSPI1_B_SCLK                      = IOMUX_PAD(0x04FC, 0x01B4, 0, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_SCLK__UART3_RX                          = IOMUX_PAD(0x04FC, 0x01B4, 1, 0x0840, 4, 0),
	 MX6_PAD_QSPI1B_SCLK__ECSPI3_SCLK                       = IOMUX_PAD(0x04FC, 0x01B4, 2, 0x0730, 1, 0),
	 MX6_PAD_QSPI1B_SCLK__ESAI_RX_HF_CLK                    = IOMUX_PAD(0x04FC, 0x01B4, 3, 0x0780, 2, 0),
	 MX6_PAD_QSPI1B_SCLK__CSI1_DATA_16                      = IOMUX_PAD(0x04FC, 0x01B4, 4, 0x06DC, 1, 0),
	 MX6_PAD_QSPI1B_SCLK__GPIO4_IO_29                       = IOMUX_PAD(0x04FC, 0x01B4, 5, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_SCLK__WEIM_DATA_8                       = IOMUX_PAD(0x04FC, 0x01B4, 6, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_SCLK__SIM_M_HADDR_11                    = IOMUX_PAD(0x04FC, 0x01B4, 7, 0x0000, 0, 0),

	 MX6_PAD_QSPI1B_SS0_B__QSPI1_B_SS0_B                    = IOMUX_PAD(0x0500, 0x01B8, 0, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_SS0_B__UART3_TX                         = IOMUX_PAD(0x0500, 0x01B8, 1, 0x0840, 5, 0),
	 MX6_PAD_QSPI1B_SS0_B__ECSPI3_SS0                       = IOMUX_PAD(0x0500, 0x01B8, 2, 0x073C, 1, 0),
	 MX6_PAD_QSPI1B_SS0_B__ESAI_TX_HF_CLK                   = IOMUX_PAD(0x0500, 0x01B8, 3, 0x0784, 3, 0),
	 MX6_PAD_QSPI1B_SS0_B__CSI1_DATA_17                     = IOMUX_PAD(0x0500, 0x01B8, 4, 0x06E0, 1, 0),
	 MX6_PAD_QSPI1B_SS0_B__GPIO4_IO_30                      = IOMUX_PAD(0x0500, 0x01B8, 5, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_SS0_B__WEIM_DATA_9                      = IOMUX_PAD(0x0500, 0x01B8, 6, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_SS0_B__SIM_M_HADDR_10                   = IOMUX_PAD(0x0500, 0x01B8, 7, 0x0000, 0, 0),

	 MX6_PAD_QSPI1B_SS1_B__QSPI1_B_SS1_B                    = IOMUX_PAD(0x0504, 0x01BC, 0, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_SS1_B__CAN2_RX                          = IOMUX_PAD(0x0504, 0x01BC, 1, 0x0690, 2, 0),
	 MX6_PAD_QSPI1B_SS1_B__CANFD_RX2                        = IOMUX_PAD(0x0504, 0x01BC, 2, 0x0698, 2, 0),
	 MX6_PAD_QSPI1B_SS1_B__ECSPI5_SCLK                      = IOMUX_PAD(0x0504, 0x01BC, 3, 0x0750, 1, 0),
	 MX6_PAD_QSPI1B_SS1_B__CSI1_DATA_18                     = IOMUX_PAD(0x0504, 0x01BC, 4, 0x06E4, 1, 0),
	 MX6_PAD_QSPI1B_SS1_B__GPIO4_IO_31                      = IOMUX_PAD(0x0504, 0x01BC, 5, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_SS1_B__WEIM_DATA_10                     = IOMUX_PAD(0x0504, 0x01BC, 6, 0x0000, 0, 0),
	 MX6_PAD_QSPI1B_SS1_B__SIM_M_HADDR_14                   = IOMUX_PAD(0x0504, 0x01BC, 7, 0x0000, 0, 0),

	 MX6_PAD_RGMII1_RD0__ENET1_RX_DATA_0                    = IOMUX_PAD(0x0508, 0x01C0, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD0__GPIO5_IO_0                         = IOMUX_PAD(0x0508, 0x01C0, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD0__CSI2_DATA_10                       = IOMUX_PAD(0x0508, 0x01C0, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD0__ANATOP_TESTI_0                     = IOMUX_PAD(0x0508, 0x01C0, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD0__RAWNAND_TESTER_TRIGGER             = IOMUX_PAD(0x0508, 0x01C0, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD0__PCIE_CTRL_DEBUG_0                  = IOMUX_PAD(0x0508, 0x01C0, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII1_RD1__ENET1_RX_DATA_1                    = IOMUX_PAD(0x050C, 0x01C4, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD1__GPIO5_IO_1                         = IOMUX_PAD(0x050C, 0x01C4, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD1__CSI2_DATA_11                       = IOMUX_PAD(0x050C, 0x01C4, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD1__ANATOP_TESTI_1                     = IOMUX_PAD(0x050C, 0x01C4, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD1__USDHC1_TESTER_TRIGGER              = IOMUX_PAD(0x050C, 0x01C4, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD1__PCIE_CTRL_DEBUG_1                  = IOMUX_PAD(0x050C, 0x01C4, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII1_RD2__ENET1_RX_DATA_2                    = IOMUX_PAD(0x0510, 0x01C8, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD2__GPIO5_IO_2                         = IOMUX_PAD(0x0510, 0x01C8, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD2__CSI2_DATA_12                       = IOMUX_PAD(0x0510, 0x01C8, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD2__ANATOP_TESTI_2                     = IOMUX_PAD(0x0510, 0x01C8, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD2__USDHC2_TESTER_TRIGGER              = IOMUX_PAD(0x0510, 0x01C8, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD2__PCIE_CTRL_DEBUG_2                  = IOMUX_PAD(0x0510, 0x01C8, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII1_RD3__ENET1_RX_DATA_3                    = IOMUX_PAD(0x0514, 0x01CC, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD3__GPIO5_IO_3                         = IOMUX_PAD(0x0514, 0x01CC, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD3__CSI2_DATA_13                       = IOMUX_PAD(0x0514, 0x01CC, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD3__ANATOP_TESTI_3                     = IOMUX_PAD(0x0514, 0x01CC, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD3__USDHC3_TESTER_TRIGGER              = IOMUX_PAD(0x0514, 0x01CC, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RD3__PCIE_CTRL_DEBUG_3                  = IOMUX_PAD(0x0514, 0x01CC, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII1_RX_CTL__ENET1_RX_EN                     = IOMUX_PAD(0x0518, 0x01D0, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RX_CTL__GPIO5_IO_4                      = IOMUX_PAD(0x0518, 0x01D0, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RX_CTL__CSI2_DATA_14                    = IOMUX_PAD(0x0518, 0x01D0, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RX_CTL__ANATOP_TESTO_0                  = IOMUX_PAD(0x0518, 0x01D0, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RX_CTL__USDHC4_TESTER_TRIGGER           = IOMUX_PAD(0x0518, 0x01D0, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RX_CTL__PCIE_CTRL_DEBUG_4               = IOMUX_PAD(0x0518, 0x01D0, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII1_RXC__ENET1_RX_CLK                       = IOMUX_PAD(0x051C, 0x01D4, 0, 0x0768, 1, 0),
	 MX6_PAD_RGMII1_RXC__ENET1_RX_ER                        = IOMUX_PAD(0x051C, 0x01D4, 1, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RXC__GPIO5_IO_5                         = IOMUX_PAD(0x051C, 0x01D4, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RXC__CSI2_DATA_15                       = IOMUX_PAD(0x051C, 0x01D4, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RXC__ANATOP_TESTO_1                     = IOMUX_PAD(0x051C, 0x01D4, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RXC__ECSPI1_TESTER_TRIGGER              = IOMUX_PAD(0x051C, 0x01D4, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_RXC__PCIE_CTRL_DEBUG_5                  = IOMUX_PAD(0x051C, 0x01D4, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII1_TD0__ENET1_TX_DATA_0                    = IOMUX_PAD(0x0520, 0x01D8, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD0__SAI2_RX_SYNC                       = IOMUX_PAD(0x0520, 0x01D8, 2, 0x0810, 1, 0),
	 MX6_PAD_RGMII1_TD0__GPIO5_IO_6                         = IOMUX_PAD(0x0520, 0x01D8, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD0__CSI2_DATA_16                       = IOMUX_PAD(0x0520, 0x01D8, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD0__ANATOP_TESTO_2                     = IOMUX_PAD(0x0520, 0x01D8, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD0__ECSPI2_TESTER_TRIGGER              = IOMUX_PAD(0x0520, 0x01D8, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD0__PCIE_CTRL_DEBUG_6                  = IOMUX_PAD(0x0520, 0x01D8, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII1_TD1__ENET1_TX_DATA_1                    = IOMUX_PAD(0x0524, 0x01DC, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD1__SAI2_RX_BCLK                       = IOMUX_PAD(0x0524, 0x01DC, 2, 0x0808, 1, 0),
	 MX6_PAD_RGMII1_TD1__GPIO5_IO_7                         = IOMUX_PAD(0x0524, 0x01DC, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD1__CSI2_DATA_17                       = IOMUX_PAD(0x0524, 0x01DC, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD1__ANATOP_TESTO_3                     = IOMUX_PAD(0x0524, 0x01DC, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD1__ECSPI3_TESTER_TRIGGER              = IOMUX_PAD(0x0524, 0x01DC, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD1__PCIE_CTRL_DEBUG_7                  = IOMUX_PAD(0x0524, 0x01DC, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII1_TD2__ENET1_TX_DATA_2                    = IOMUX_PAD(0x0528, 0x01E0, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD2__SAI2_TX_SYNC                       = IOMUX_PAD(0x0528, 0x01E0, 2, 0x0818, 1, 0),
	 MX6_PAD_RGMII1_TD2__GPIO5_IO_8                         = IOMUX_PAD(0x0528, 0x01E0, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD2__CSI2_DATA_18                       = IOMUX_PAD(0x0528, 0x01E0, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD2__ANATOP_TESTO_4                     = IOMUX_PAD(0x0528, 0x01E0, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD2__ECSPI4_TESTER_TRIGGER              = IOMUX_PAD(0x0528, 0x01E0, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD2__PCIE_CTRL_DEBUG_8                  = IOMUX_PAD(0x0528, 0x01E0, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII1_TD3__ENET1_TX_DATA_3                    = IOMUX_PAD(0x052C, 0x01E4, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD3__SAI2_TX_BCLK                       = IOMUX_PAD(0x052C, 0x01E4, 2, 0x0814, 1, 0),
	 MX6_PAD_RGMII1_TD3__GPIO5_IO_9                         = IOMUX_PAD(0x052C, 0x01E4, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD3__CSI2_DATA_19                       = IOMUX_PAD(0x052C, 0x01E4, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD3__ANATOP_TESTO_5                     = IOMUX_PAD(0x052C, 0x01E4, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD3__ECSPI5_TESTER_TRIGGER              = IOMUX_PAD(0x052C, 0x01E4, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TD3__PCIE_CTRL_DEBUG_9                  = IOMUX_PAD(0x052C, 0x01E4, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII1_TX_CTL__ENET1_TX_EN                     = IOMUX_PAD(0x0530, 0x01E8, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TX_CTL__SAI2_RX_DATA_0                  = IOMUX_PAD(0x0530, 0x01E8, 2, 0x080C, 1, 0),
	 MX6_PAD_RGMII1_TX_CTL__GPIO5_IO_10                     = IOMUX_PAD(0x0530, 0x01E8, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TX_CTL__CSI2_DATA_0                     = IOMUX_PAD(0x0530, 0x01E8, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TX_CTL__ANATOP_TESTO_6                  = IOMUX_PAD(0x0530, 0x01E8, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TX_CTL__QSPI1_TESTER_TRIGGER            = IOMUX_PAD(0x0530, 0x01E8, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TX_CTL__PCIE_CTRL_DEBUG_10              = IOMUX_PAD(0x0530, 0x01E8, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII1_TXC__ENET1_RGMII_TXC                    = IOMUX_PAD(0x0534, 0x01EC, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TXC__ENET1_TX_ER                        = IOMUX_PAD(0x0534, 0x01EC, 1, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TXC__SAI2_TX_DATA_0                     = IOMUX_PAD(0x0534, 0x01EC, 2, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TXC__GPIO5_IO_11                        = IOMUX_PAD(0x0534, 0x01EC, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TXC__CSI2_DATA_1                        = IOMUX_PAD(0x0534, 0x01EC, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TXC__ANATOP_TESTO_7                     = IOMUX_PAD(0x0534, 0x01EC, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TXC__QSPI2_TESTER_TRIGGER               = IOMUX_PAD(0x0534, 0x01EC, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII1_TXC__PCIE_CTRL_DEBUG_11                 = IOMUX_PAD(0x0534, 0x01EC, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII2_RD0__ENET2_RX_DATA_0                    = IOMUX_PAD(0x0538, 0x01F0, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD0__PWM4_OUT                           = IOMUX_PAD(0x0538, 0x01F0, 2, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD0__GPIO5_IO_12                        = IOMUX_PAD(0x0538, 0x01F0, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD0__CSI2_DATA_2                        = IOMUX_PAD(0x0538, 0x01F0, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD0__ANATOP_TESTO_8                     = IOMUX_PAD(0x0538, 0x01F0, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD0__VDEC_DEBUG_18                      = IOMUX_PAD(0x0538, 0x01F0, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD0__PCIE_CTRL_DEBUG_12                 = IOMUX_PAD(0x0538, 0x01F0, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII2_RD1__ENET2_RX_DATA_1                    = IOMUX_PAD(0x053C, 0x01F4, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD1__PWM3_OUT                           = IOMUX_PAD(0x053C, 0x01F4, 2, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD1__GPIO5_IO_13                        = IOMUX_PAD(0x053C, 0x01F4, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD1__CSI2_DATA_3                        = IOMUX_PAD(0x053C, 0x01F4, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD1__ANATOP_TESTO_9                     = IOMUX_PAD(0x053C, 0x01F4, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD1__VDEC_DEBUG_19                      = IOMUX_PAD(0x053C, 0x01F4, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD1__PCIE_CTRL_DEBUG_13                 = IOMUX_PAD(0x053C, 0x01F4, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII2_RD2__ENET2_RX_DATA_2                    = IOMUX_PAD(0x0540, 0x01F8, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD2__PWM2_OUT                           = IOMUX_PAD(0x0540, 0x01F8, 2, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD2__GPIO5_IO_14                        = IOMUX_PAD(0x0540, 0x01F8, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD2__CSI2_DATA_4                        = IOMUX_PAD(0x0540, 0x01F8, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD2__ANATOP_TESTO_10                    = IOMUX_PAD(0x0540, 0x01F8, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD2__VDEC_DEBUG_20                      = IOMUX_PAD(0x0540, 0x01F8, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD2__PCIE_CTRL_DEBUG_14                 = IOMUX_PAD(0x0540, 0x01F8, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII2_RD3__ENET2_RX_DATA_3                    = IOMUX_PAD(0x0544, 0x01FC, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD3__PWM1_OUT                           = IOMUX_PAD(0x0544, 0x01FC, 2, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD3__GPIO5_IO_15                        = IOMUX_PAD(0x0544, 0x01FC, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD3__CSI2_DATA_5                        = IOMUX_PAD(0x0544, 0x01FC, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD3__ANATOP_TESTO_11                    = IOMUX_PAD(0x0544, 0x01FC, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD3__VDEC_DEBUG_21                      = IOMUX_PAD(0x0544, 0x01FC, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RD3__PCIE_CTRL_DEBUG_15                 = IOMUX_PAD(0x0544, 0x01FC, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII2_RX_CTL__ENET2_RX_EN                     = IOMUX_PAD(0x0548, 0x0200, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RX_CTL__GPIO5_IO_16                     = IOMUX_PAD(0x0548, 0x0200, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RX_CTL__CSI2_DATA_6                     = IOMUX_PAD(0x0548, 0x0200, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RX_CTL__ANATOP_TESTO_12                 = IOMUX_PAD(0x0548, 0x0200, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RX_CTL__VDEC_DEBUG_22                   = IOMUX_PAD(0x0548, 0x0200, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RX_CTL__PCIE_CTRL_DEBUG_16              = IOMUX_PAD(0x0548, 0x0200, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII2_RXC__ENET2_RX_CLK                       = IOMUX_PAD(0x054C, 0x0204, 0, 0x0774, 1, 0),
	 MX6_PAD_RGMII2_RXC__ENET2_RX_ER                        = IOMUX_PAD(0x054C, 0x0204, 1, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RXC__GPIO5_IO_17                        = IOMUX_PAD(0x054C, 0x0204, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RXC__CSI2_DATA_7                        = IOMUX_PAD(0x054C, 0x0204, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RXC__ANATOP_TESTO_13                    = IOMUX_PAD(0x054C, 0x0204, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RXC__VDEC_DEBUG_23                      = IOMUX_PAD(0x054C, 0x0204, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_RXC__PCIE_CTRL_DEBUG_17                 = IOMUX_PAD(0x054C, 0x0204, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII2_TD0__ENET2_TX_DATA_0                    = IOMUX_PAD(0x0550, 0x0208, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD0__SAI1_RX_SYNC                       = IOMUX_PAD(0x0550, 0x0208, 2, 0x07FC, 1, 0),
	 MX6_PAD_RGMII2_TD0__PWM8_OUT                           = IOMUX_PAD(0x0550, 0x0208, 3, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD0__GPIO5_IO_18                        = IOMUX_PAD(0x0550, 0x0208, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD0__CSI2_DATA_8                        = IOMUX_PAD(0x0550, 0x0208, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD0__ANATOP_TESTO_14                    = IOMUX_PAD(0x0550, 0x0208, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD0__VDEC_DEBUG_24                      = IOMUX_PAD(0x0550, 0x0208, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD0__PCIE_CTRL_DEBUG_18                 = IOMUX_PAD(0x0550, 0x0208, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII2_TD1__ENET2_TX_DATA_1                    = IOMUX_PAD(0x0554, 0x020C, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD1__SAI1_RX_BCLK                       = IOMUX_PAD(0x0554, 0x020C, 2, 0x07F4, 1, 0),
	 MX6_PAD_RGMII2_TD1__PWM7_OUT                           = IOMUX_PAD(0x0554, 0x020C, 3, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD1__GPIO5_IO_19                        = IOMUX_PAD(0x0554, 0x020C, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD1__CSI2_DATA_9                        = IOMUX_PAD(0x0554, 0x020C, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD1__ANATOP_TESTO_15                    = IOMUX_PAD(0x0554, 0x020C, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD1__VDEC_DEBUG_25                      = IOMUX_PAD(0x0554, 0x020C, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD1__PCIE_CTRL_DEBUG_19                 = IOMUX_PAD(0x0554, 0x020C, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII2_TD2__ENET2_TX_DATA_2                    = IOMUX_PAD(0x0558, 0x0210, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD2__SAI1_TX_SYNC                       = IOMUX_PAD(0x0558, 0x0210, 2, 0x0804, 1, 0),
	 MX6_PAD_RGMII2_TD2__PWM6_OUT                           = IOMUX_PAD(0x0558, 0x0210, 3, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD2__GPIO5_IO_20                        = IOMUX_PAD(0x0558, 0x0210, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD2__CSI2_VSYNC                         = IOMUX_PAD(0x0558, 0x0210, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD2__SJC_FAIL                           = IOMUX_PAD(0x0558, 0x0210, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD2__VDEC_DEBUG_26                      = IOMUX_PAD(0x0558, 0x0210, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD2__PCIE_CTRL_DEBUG_20                 = IOMUX_PAD(0x0558, 0x0210, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII2_TD3__ENET2_TX_DATA_3                    = IOMUX_PAD(0x055C, 0x0214, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD3__SAI1_TX_BCLK                       = IOMUX_PAD(0x055C, 0x0214, 2, 0x0800, 1, 0),
	 MX6_PAD_RGMII2_TD3__PWM5_OUT                           = IOMUX_PAD(0x055C, 0x0214, 3, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD3__GPIO5_IO_21                        = IOMUX_PAD(0x055C, 0x0214, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD3__CSI2_HSYNC                         = IOMUX_PAD(0x055C, 0x0214, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD3__SJC_JTAG_ACT                       = IOMUX_PAD(0x055C, 0x0214, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD3__VDEC_DEBUG_27                      = IOMUX_PAD(0x055C, 0x0214, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TD3__PCIE_CTRL_DEBUG_21                 = IOMUX_PAD(0x055C, 0x0214, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII2_TX_CTL__ENET2_TX_EN                     = IOMUX_PAD(0x0560, 0x0218, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TX_CTL__SAI1_RX_DATA_0                  = IOMUX_PAD(0x0560, 0x0218, 2, 0x07F8, 1, 0),
	 MX6_PAD_RGMII2_TX_CTL__GPIO5_IO_22                     = IOMUX_PAD(0x0560, 0x0218, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TX_CTL__CSI2_FIELD                      = IOMUX_PAD(0x0560, 0x0218, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TX_CTL__SJC_DE_B                        = IOMUX_PAD(0x0560, 0x0218, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TX_CTL__VDEC_DEBUG_28                   = IOMUX_PAD(0x0560, 0x0218, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TX_CTL__PCIE_CTRL_DEBUG_22              = IOMUX_PAD(0x0560, 0x0218, 9, 0x0000, 0, 0),

	 MX6_PAD_RGMII2_TXC__ENET2_RGMII_TXC                    = IOMUX_PAD(0x0564, 0x021C, 0, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TXC__ENET2_TX_ER                        = IOMUX_PAD(0x0564, 0x021C, 1, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TXC__SAI1_TX_DATA_0                     = IOMUX_PAD(0x0564, 0x021C, 2, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TXC__GPIO5_IO_23                        = IOMUX_PAD(0x0564, 0x021C, 5, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TXC__CSI2_PIXCLK                        = IOMUX_PAD(0x0564, 0x021C, 6, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TXC__SJC_DONE                           = IOMUX_PAD(0x0564, 0x021C, 7, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TXC__VDEC_DEBUG_29                      = IOMUX_PAD(0x0564, 0x021C, 8, 0x0000, 0, 0),
	 MX6_PAD_RGMII2_TXC__PCIE_CTRL_DEBUG_23                 = IOMUX_PAD(0x0564, 0x021C, 9, 0x0000, 0, 0),

	 MX6_PAD_SD1_CLK__USDHC1_CLK                            = IOMUX_PAD(0x0568, 0x0220, 0, 0x0000, 0, 0),
	 MX6_PAD_SD1_CLK__AUDMUX_AUD5_RXFS                      = IOMUX_PAD(0x0568, 0x0220, 1, 0x0668, 1, 0),
	 MX6_PAD_SD1_CLK__WDOG2_WDOG_B                          = IOMUX_PAD(0x0568, 0x0220, 2, 0x0000, 0, 0),
	 MX6_PAD_SD1_CLK__GPT_CLK                               = IOMUX_PAD(0x0568, 0x0220, 3, 0x0000, 0, 0),
	 MX6_PAD_SD1_CLK__WDOG2_WDOG_RST_B_DEB                  = IOMUX_PAD(0x0568, 0x0220, 4, 0x0000, 0, 0),
	 MX6_PAD_SD1_CLK__GPIO6_IO_0                            = IOMUX_PAD(0x0568, 0x0220, 5, 0x0000, 0, 0),
	 MX6_PAD_SD1_CLK__ENET2_1588_EVENT1_OUT                 = IOMUX_PAD(0x0568, 0x0220, 6, 0x0000, 0, 0),
	 MX6_PAD_SD1_CLK__CCM_OUT1                              = IOMUX_PAD(0x0568, 0x0220, 7, 0x0000, 0, 0),
	 MX6_PAD_SD1_CLK__VADC_ADC_PROC_CLK                     = IOMUX_PAD(0x0568, 0x0220, 8, 0x0000, 0, 0),
	 MX6_PAD_SD1_CLK__MMDC_DEBUG_45                         = IOMUX_PAD(0x0568, 0x0220, 9, 0x0000, 0, 0),

	 MX6_PAD_SD1_CMD__USDHC1_CMD                            = IOMUX_PAD(0x056C, 0x0224, 0, 0x0000, 0, 0),
	 MX6_PAD_SD1_CMD__AUDMUX_AUD5_RXC                       = IOMUX_PAD(0x056C, 0x0224, 1, 0x0664, 1, 0),
	 MX6_PAD_SD1_CMD__WDOG1_WDOG_B                          = IOMUX_PAD(0x056C, 0x0224, 2, 0x0000, 0, 0),
	 MX6_PAD_SD1_CMD__GPT_COMPARE1                          = IOMUX_PAD(0x056C, 0x0224, 3, 0x0000, 0, 0),
	 MX6_PAD_SD1_CMD__WDOG1_WDOG_RST_B_DEB                  = IOMUX_PAD(0x056C, 0x0224, 4, 0x0000, 0, 0),
	 MX6_PAD_SD1_CMD__GPIO6_IO_1                            = IOMUX_PAD(0x056C, 0x0224, 5, 0x0000, 0, 0),
	 MX6_PAD_SD1_CMD__ENET2_1588_EVENT1_IN                  = IOMUX_PAD(0x056C, 0x0224, 6, 0x0000, 0, 0),
	 MX6_PAD_SD1_CMD__CCM_CLKO1                             = IOMUX_PAD(0x056C, 0x0224, 7, 0x0000, 0, 0),
	 MX6_PAD_SD1_CMD__VADC_EXT_SYSCLK                       = IOMUX_PAD(0x056C, 0x0224, 8, 0x0000, 0, 0),
	 MX6_PAD_SD1_CMD__MMDC_DEBUG_46                         = IOMUX_PAD(0x056C, 0x0224, 9, 0x0000, 0, 0),

	 MX6_PAD_SD1_DATA0__USDHC1_DATA0                        = IOMUX_PAD(0x0570, 0x0228, 0, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA0__AUDMUX_AUD5_RXD                     = IOMUX_PAD(0x0570, 0x0228, 1, 0x065C, 1, 0),
	 MX6_PAD_SD1_DATA0__CAAM_WRAPPER_RNG_OSC_OBS            = IOMUX_PAD(0x0570, 0x0228, 2, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA0__GPT_CAPTURE1                        = IOMUX_PAD(0x0570, 0x0228, 3, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA0__UART2_RX                            = IOMUX_PAD(0x0570, 0x0228, 4, 0x0838, 2, 0),
	 MX6_PAD_SD1_DATA0__GPIO6_IO_2                          = IOMUX_PAD(0x0570, 0x0228, 5, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA0__ENET1_1588_EVENT1_IN                = IOMUX_PAD(0x0570, 0x0228, 6, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA0__CCM_OUT2                            = IOMUX_PAD(0x0570, 0x0228, 7, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA0__VADC_CLAMP_UP                       = IOMUX_PAD(0x0570, 0x0228, 8, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA0__MMDC_DEBUG_48                       = IOMUX_PAD(0x0570, 0x0228, 9, 0x0000, 0, 0),

	 MX6_PAD_SD1_DATA1__USDHC1_DATA1                        = IOMUX_PAD(0x0574, 0x022C, 0, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA1__AUDMUX_AUD5_TXC                     = IOMUX_PAD(0x0574, 0x022C, 1, 0x066C, 1, 0),
	 MX6_PAD_SD1_DATA1__PWM4_OUT                            = IOMUX_PAD(0x0574, 0x022C, 2, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA1__GPT_CAPTURE2                        = IOMUX_PAD(0x0574, 0x022C, 3, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA1__UART2_TX                            = IOMUX_PAD(0x0574, 0x022C, 4, 0x0838, 3, 0),
	 MX6_PAD_SD1_DATA1__GPIO6_IO_3                          = IOMUX_PAD(0x0574, 0x022C, 5, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA1__ENET1_1588_EVENT1_OUT               = IOMUX_PAD(0x0574, 0x022C, 6, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA1__CCM_CLKO2                           = IOMUX_PAD(0x0574, 0x022C, 7, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA1__VADC_CLAMP_DOWN                     = IOMUX_PAD(0x0574, 0x022C, 8, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA1__MMDC_DEBUG_47                       = IOMUX_PAD(0x0574, 0x022C, 9, 0x0000, 0, 0),

	 MX6_PAD_SD1_DATA2__USDHC1_DATA2                        = IOMUX_PAD(0x0578, 0x0230, 0, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA2__AUDMUX_AUD5_TXFS                    = IOMUX_PAD(0x0578, 0x0230, 1, 0x0670, 1, 0),
	 MX6_PAD_SD1_DATA2__PWM3_OUT                            = IOMUX_PAD(0x0578, 0x0230, 2, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA2__GPT_COMPARE2                        = IOMUX_PAD(0x0578, 0x0230, 3, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA2__UART2_CTS_B                         = IOMUX_PAD(0x0578, 0x0230, 4, 0x0834, 2, 0),
	 MX6_PAD_SD1_DATA2__GPIO6_IO_4                          = IOMUX_PAD(0x0578, 0x0230, 5, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA2__ECSPI4_RDY                          = IOMUX_PAD(0x0578, 0x0230, 6, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA2__CCM_OUT0                            = IOMUX_PAD(0x0578, 0x0230, 7, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA2__VADC_EXT_PD_N                       = IOMUX_PAD(0x0578, 0x0230, 8, 0x0000, 0, 0),

	 MX6_PAD_SD1_DATA3__USDHC1_DATA3                        = IOMUX_PAD(0x057C, 0x0234, 0, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA3__AUDMUX_AUD5_TXD                     = IOMUX_PAD(0x057C, 0x0234, 1, 0x0660, 1, 0),
	 MX6_PAD_SD1_DATA3__AUDMUX_AUD5_RXD                     = IOMUX_PAD(0x057C, 0x0234, 2, 0x065C, 2, 0),
	 MX6_PAD_SD1_DATA3__GPT_COMPARE3                        = IOMUX_PAD(0x057C, 0x0234, 3, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA3__UART2_RTS_B                         = IOMUX_PAD(0x057C, 0x0234, 4, 0x0834, 3, 0),
	 MX6_PAD_SD1_DATA3__GPIO6_IO_5                          = IOMUX_PAD(0x057C, 0x0234, 5, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA3__ECSPI4_SS1                          = IOMUX_PAD(0x057C, 0x0234, 6, 0x0000, 0, 0),
	 MX6_PAD_SD1_DATA3__CCM_PMIC_RDY                        = IOMUX_PAD(0x057C, 0x0234, 7, 0x069C, 2, 0),
	 MX6_PAD_SD1_DATA3__VADC_RST_N                          = IOMUX_PAD(0x057C, 0x0234, 8, 0x0000, 0, 0),

	 MX6_PAD_SD2_CLK__USDHC2_CLK                            = IOMUX_PAD(0x0580, 0x0238, 0, 0x0000, 0, 0),
	 MX6_PAD_SD2_CLK__AUDMUX_AUD6_RXFS                      = IOMUX_PAD(0x0580, 0x0238, 1, 0x0680, 2, 0),
	 MX6_PAD_SD2_CLK__KPP_COL_5                             = IOMUX_PAD(0x0580, 0x0238, 2, 0x07C8, 1, 0),
	 MX6_PAD_SD2_CLK__ECSPI4_SCLK                           = IOMUX_PAD(0x0580, 0x0238, 3, 0x0740, 1, 0),
	 MX6_PAD_SD2_CLK__MLB_SIG                               = IOMUX_PAD(0x0580, 0x0238, 4, 0x07F0, 2, 0),
	 MX6_PAD_SD2_CLK__GPIO6_IO_6                            = IOMUX_PAD(0x0580, 0x0238, 5, 0x0000, 0, 0),
	 MX6_PAD_SD2_CLK__MQS_RIGHT                             = IOMUX_PAD(0x0580, 0x0238, 6, 0x0000, 0, 0),
	 MX6_PAD_SD2_CLK__WDOG1_WDOG_ANY                        = IOMUX_PAD(0x0580, 0x0238, 7, 0x0000, 0, 0),
	 MX6_PAD_SD2_CLK__VADC_CLAMP_CURRENT_5                  = IOMUX_PAD(0x0580, 0x0238, 8, 0x0000, 0, 0),
	 MX6_PAD_SD2_CLK__MMDC_DEBUG_29                         = IOMUX_PAD(0x0580, 0x0238, 9, 0x0000, 0, 0),

	 MX6_PAD_SD2_CMD__USDHC2_CMD                            = IOMUX_PAD(0x0584, 0x023C, 0, 0x0000, 0, 0),
	 MX6_PAD_SD2_CMD__AUDMUX_AUD6_RXC                       = IOMUX_PAD(0x0584, 0x023C, 1, 0x067C, 2, 0),
	 MX6_PAD_SD2_CMD__KPP_ROW_5                             = IOMUX_PAD(0x0584, 0x023C, 2, 0x07D4, 1, 0),
	 MX6_PAD_SD2_CMD__ECSPI4_MOSI                           = IOMUX_PAD(0x0584, 0x023C, 3, 0x0748, 1, 0),
	 MX6_PAD_SD2_CMD__MLB_CLK                               = IOMUX_PAD(0x0584, 0x023C, 4, 0x07E8, 2, 0),
	 MX6_PAD_SD2_CMD__GPIO6_IO_7                            = IOMUX_PAD(0x0584, 0x023C, 5, 0x0000, 0, 0),
	 MX6_PAD_SD2_CMD__MQS_LEFT                              = IOMUX_PAD(0x0584, 0x023C, 6, 0x0000, 0, 0),
	 MX6_PAD_SD2_CMD__WDOG3_WDOG_B                          = IOMUX_PAD(0x0584, 0x023C, 7, 0x0000, 0, 0),
	 MX6_PAD_SD2_CMD__VADC_CLAMP_CURRENT_4                  = IOMUX_PAD(0x0584, 0x023C, 8, 0x0000, 0, 0),
	 MX6_PAD_SD2_CMD__MMDC_DEBUG_30                         = IOMUX_PAD(0x0584, 0x023C, 9, 0x0000, 0, 0),

	 MX6_PAD_SD2_DATA0__USDHC2_DATA0                        = IOMUX_PAD(0x0588, 0x0240, 0, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA0__AUDMUX_AUD6_RXD                     = IOMUX_PAD(0x0588, 0x0240, 1, 0x0674, 2, 0),
	 MX6_PAD_SD2_DATA0__KPP_ROW_7                           = IOMUX_PAD(0x0588, 0x0240, 2, 0x07DC, 1, 0),
	 MX6_PAD_SD2_DATA0__PWM1_OUT                            = IOMUX_PAD(0x0588, 0x0240, 3, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA0__I2C4_SDA                            = IOMUX_PAD(0x0588, 0x0240, 4, 0x07C4, 3, 0),
	 MX6_PAD_SD2_DATA0__GPIO6_IO_8                          = IOMUX_PAD(0x0588, 0x0240, 5, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA0__ECSPI4_SS3                          = IOMUX_PAD(0x0588, 0x0240, 6, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA0__UART4_RX                            = IOMUX_PAD(0x0588, 0x0240, 7, 0x0848, 4, 0),
	 MX6_PAD_SD2_DATA0__VADC_CLAMP_CURRENT_0                = IOMUX_PAD(0x0588, 0x0240, 8, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA0__MMDC_DEBUG_50                       = IOMUX_PAD(0x0588, 0x0240, 9, 0x0000, 0, 0),

	 MX6_PAD_SD2_DATA1__USDHC2_DATA1                        = IOMUX_PAD(0x058C, 0x0244, 0, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA1__AUDMUX_AUD6_TXC                     = IOMUX_PAD(0x058C, 0x0244, 1, 0x0684, 2, 0),
	 MX6_PAD_SD2_DATA1__KPP_COL_7                           = IOMUX_PAD(0x058C, 0x0244, 2, 0x07D0, 1, 0),
	 MX6_PAD_SD2_DATA1__PWM2_OUT                            = IOMUX_PAD(0x058C, 0x0244, 3, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA1__I2C4_SCL                            = IOMUX_PAD(0x058C, 0x0244, 4, 0x07C0, 3, 0),
	 MX6_PAD_SD2_DATA1__GPIO6_IO_9                          = IOMUX_PAD(0x058C, 0x0244, 5, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA1__ECSPI4_SS2                          = IOMUX_PAD(0x058C, 0x0244, 6, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA1__UART4_TX                            = IOMUX_PAD(0x058C, 0x0244, 7, 0x0848, 5, 0),
	 MX6_PAD_SD2_DATA1__VADC_CLAMP_CURRENT_1                = IOMUX_PAD(0x058C, 0x0244, 8, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA1__MMDC_DEBUG_49                       = IOMUX_PAD(0x058C, 0x0244, 9, 0x0000, 0, 0),

	 MX6_PAD_SD2_DATA2__USDHC2_DATA2                        = IOMUX_PAD(0x0590, 0x0248, 0, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA2__AUDMUX_AUD6_TXFS                    = IOMUX_PAD(0x0590, 0x0248, 1, 0x0688, 2, 0),
	 MX6_PAD_SD2_DATA2__KPP_ROW_6                           = IOMUX_PAD(0x0590, 0x0248, 2, 0x07D8, 1, 0),
	 MX6_PAD_SD2_DATA2__ECSPI4_SS0                          = IOMUX_PAD(0x0590, 0x0248, 3, 0x074C, 1, 0),
	 MX6_PAD_SD2_DATA2__SDMA_EXT_EVENT_0                    = IOMUX_PAD(0x0590, 0x0248, 4, 0x081C, 2, 0),
	 MX6_PAD_SD2_DATA2__GPIO6_IO_10                         = IOMUX_PAD(0x0590, 0x0248, 5, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA2__SPDIF_OUT                           = IOMUX_PAD(0x0590, 0x0248, 6, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA2__UART6_RX                            = IOMUX_PAD(0x0590, 0x0248, 7, 0x0858, 4, 0),
	 MX6_PAD_SD2_DATA2__VADC_CLAMP_CURRENT_2                = IOMUX_PAD(0x0590, 0x0248, 8, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA2__MMDC_DEBUG_32                       = IOMUX_PAD(0x0590, 0x0248, 9, 0x0000, 0, 0),

	 MX6_PAD_SD2_DATA3__USDHC2_DATA3                        = IOMUX_PAD(0x0594, 0x024C, 0, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA3__AUDMUX_AUD6_TXD                     = IOMUX_PAD(0x0594, 0x024C, 1, 0x0678, 2, 0),
	 MX6_PAD_SD2_DATA3__KPP_COL_6                           = IOMUX_PAD(0x0594, 0x024C, 2, 0x07CC, 1, 0),
	 MX6_PAD_SD2_DATA3__ECSPI4_MISO                         = IOMUX_PAD(0x0594, 0x024C, 3, 0x0744, 1, 0),
	 MX6_PAD_SD2_DATA3__MLB_DATA                            = IOMUX_PAD(0x0594, 0x024C, 4, 0x07EC, 2, 0),
	 MX6_PAD_SD2_DATA3__GPIO6_IO_11                         = IOMUX_PAD(0x0594, 0x024C, 5, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA3__SPDIF_IN                            = IOMUX_PAD(0x0594, 0x024C, 6, 0x0824, 4, 0),
	 MX6_PAD_SD2_DATA3__UART6_TX                            = IOMUX_PAD(0x0594, 0x024C, 7, 0x0858, 5, 0),
	 MX6_PAD_SD2_DATA3__VADC_CLAMP_CURRENT_3                = IOMUX_PAD(0x0594, 0x024C, 8, 0x0000, 0, 0),
	 MX6_PAD_SD2_DATA3__MMDC_DEBUG_31                       = IOMUX_PAD(0x0594, 0x024C, 9, 0x0000, 0, 0),

	 MX6_PAD_SD3_CLK__USDHC3_CLK                            = IOMUX_PAD(0x0598, 0x0250, 0, 0x0000, 0, 0),
	 MX6_PAD_SD3_CLK__UART4_CTS_B                           = IOMUX_PAD(0x0598, 0x0250, 1, 0x0844, 0, 0),
	 MX6_PAD_SD3_CLK__ECSPI4_SCLK                           = IOMUX_PAD(0x0598, 0x0250, 2, 0x0740, 0, 0),
	 MX6_PAD_SD3_CLK__AUDMUX_AUD6_RXFS                      = IOMUX_PAD(0x0598, 0x0250, 3, 0x0680, 0, 0),
	 MX6_PAD_SD3_CLK__LCDIF2_VSYNC                          = IOMUX_PAD(0x0598, 0x0250, 4, 0x0000, 0, 0),
	 MX6_PAD_SD3_CLK__GPIO7_IO_0                            = IOMUX_PAD(0x0598, 0x0250, 5, 0x0000, 0, 0),
	 MX6_PAD_SD3_CLK__LCDIF2_BUSY                           = IOMUX_PAD(0x0598, 0x0250, 6, 0x07E4, 0, 0),
	 MX6_PAD_SD3_CLK__TPSMP_HDATA_29                        = IOMUX_PAD(0x0598, 0x0250, 7, 0x0000, 0, 0),
	 MX6_PAD_SD3_CLK__SDMA_DEBUG_EVENT_CHANNEL_5            = IOMUX_PAD(0x0598, 0x0250, 9, 0x0000, 0, 0),

	 MX6_PAD_SD3_CMD__USDHC3_CMD                            = IOMUX_PAD(0x059C, 0x0254, 0, 0x0000, 0, 0),
	 MX6_PAD_SD3_CMD__UART4_TX                              = IOMUX_PAD(0x059C, 0x0254, 1, 0x0848, 0, 0),
	 MX6_PAD_SD3_CMD__ECSPI4_MOSI                           = IOMUX_PAD(0x059C, 0x0254, 2, 0x0748, 0, 0),
	 MX6_PAD_SD3_CMD__AUDMUX_AUD6_RXC                       = IOMUX_PAD(0x059C, 0x0254, 3, 0x067C, 0, 0),
	 MX6_PAD_SD3_CMD__LCDIF2_HSYNC                          = IOMUX_PAD(0x059C, 0x0254, 4, 0x07E4, 1, 0),
	 MX6_PAD_SD3_CMD__GPIO7_IO_1                            = IOMUX_PAD(0x059C, 0x0254, 5, 0x0000, 0, 0),
	 MX6_PAD_SD3_CMD__LCDIF2_RS                             = IOMUX_PAD(0x059C, 0x0254, 6, 0x0000, 0, 0),
	 MX6_PAD_SD3_CMD__TPSMP_HDATA_28                        = IOMUX_PAD(0x059C, 0x0254, 7, 0x0000, 0, 0),
	 MX6_PAD_SD3_CMD__SDMA_DEBUG_EVENT_CHANNEL_4            = IOMUX_PAD(0x059C, 0x0254, 9, 0x0000, 0, 0),

	 MX6_PAD_SD3_DATA0__USDHC3_DATA0                        = IOMUX_PAD(0x05A0, 0x0258, 0, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA0__I2C4_SCL                            = IOMUX_PAD(0x05A0, 0x0258, 1, 0x07C0, 0, 0),
	 MX6_PAD_SD3_DATA0__ECSPI2_SS1                          = IOMUX_PAD(0x05A0, 0x0258, 2, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA0__AUDMUX_AUD6_RXD                     = IOMUX_PAD(0x05A0, 0x0258, 3, 0x0674, 0, 0),
	 MX6_PAD_SD3_DATA0__LCDIF2_DATA_1                       = IOMUX_PAD(0x05A0, 0x0258, 4, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA0__GPIO7_IO_2                          = IOMUX_PAD(0x05A0, 0x0258, 5, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA0__DCIC1_OUT                           = IOMUX_PAD(0x05A0, 0x0258, 6, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA0__TPSMP_HDATA_30                      = IOMUX_PAD(0x05A0, 0x0258, 7, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA0__GPU_DEBUG_0                         = IOMUX_PAD(0x05A0, 0x0258, 8, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA0__SDMA_DEBUG_EVT_CHN_LINES_0          = IOMUX_PAD(0x05A0, 0x0258, 9, 0x0000, 0, 0),

	 MX6_PAD_SD3_DATA1__USDHC3_DATA1                        = IOMUX_PAD(0x05A4, 0x025C, 0, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA1__I2C4_SDA                            = IOMUX_PAD(0x05A4, 0x025C, 1, 0x07C4, 0, 0),
	 MX6_PAD_SD3_DATA1__ECSPI2_SS2                          = IOMUX_PAD(0x05A4, 0x025C, 2, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA1__AUDMUX_AUD6_TXC                     = IOMUX_PAD(0x05A4, 0x025C, 3, 0x0684, 0, 0),
	 MX6_PAD_SD3_DATA1__LCDIF2_DATA_0                       = IOMUX_PAD(0x05A4, 0x025C, 4, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA1__GPIO7_IO_3                          = IOMUX_PAD(0x05A4, 0x025C, 5, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA1__DCIC2_OUT                           = IOMUX_PAD(0x05A4, 0x025C, 6, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA1__TPSMP_HDATA_31                      = IOMUX_PAD(0x05A4, 0x025C, 7, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA1__GPU_DEBUG_1                         = IOMUX_PAD(0x05A4, 0x025C, 8, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA1__SDMA_DEBUG_EVT_CHN_LINES_1          = IOMUX_PAD(0x05A4, 0x025C, 9, 0x0000, 0, 0),

	 MX6_PAD_SD3_DATA2__USDHC3_DATA2                        = IOMUX_PAD(0x05A8, 0x0260, 0, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA2__UART4_RTS_B                         = IOMUX_PAD(0x05A8, 0x0260, 1, 0x0844, 1, 0),
	 MX6_PAD_SD3_DATA2__ECSPI4_SS0                          = IOMUX_PAD(0x05A8, 0x0260, 2, 0x074C, 0, 0),
	 MX6_PAD_SD3_DATA2__AUDMUX_AUD6_TXFS                    = IOMUX_PAD(0x05A8, 0x0260, 3, 0x0688, 0, 0),
	 MX6_PAD_SD3_DATA2__LCDIF2_CLK                          = IOMUX_PAD(0x05A8, 0x0260, 4, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA2__GPIO7_IO_4                          = IOMUX_PAD(0x05A8, 0x0260, 5, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA2__LCDIF2_WR_RWN                       = IOMUX_PAD(0x05A8, 0x0260, 6, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA2__TPSMP_HDATA_26                      = IOMUX_PAD(0x05A8, 0x0260, 7, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA2__GPU_DEBUG_2                         = IOMUX_PAD(0x05A8, 0x0260, 8, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA2__SDMA_DEBUG_EVENT_CHANNEL_2          = IOMUX_PAD(0x05A8, 0x0260, 9, 0x0000, 0, 0),

	 MX6_PAD_SD3_DATA3__USDHC3_DATA3                        = IOMUX_PAD(0x05AC, 0x0264, 0, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA3__UART4_RX                            = IOMUX_PAD(0x05AC, 0x0264, 1, 0x0848, 1, 0),
	 MX6_PAD_SD3_DATA3__ECSPI4_MISO                         = IOMUX_PAD(0x05AC, 0x0264, 2, 0x0744, 0, 0),
	 MX6_PAD_SD3_DATA3__AUDMUX_AUD6_TXD                     = IOMUX_PAD(0x05AC, 0x0264, 3, 0x0678, 0, 0),
	 MX6_PAD_SD3_DATA3__LCDIF2_ENABLE                       = IOMUX_PAD(0x05AC, 0x0264, 4, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA3__GPIO7_IO_5                          = IOMUX_PAD(0x05AC, 0x0264, 5, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA3__LCDIF2_RD_E                         = IOMUX_PAD(0x05AC, 0x0264, 6, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA3__TPSMP_HDATA_27                      = IOMUX_PAD(0x05AC, 0x0264, 7, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA3__GPU_DEBUG_3                         = IOMUX_PAD(0x05AC, 0x0264, 8, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA3__SDMA_DEBUG_EVENT_CHANNEL_3          = IOMUX_PAD(0x05AC, 0x0264, 9, 0x0000, 0, 0),

	 MX6_PAD_SD3_DATA4__USDHC3_DATA4                        = IOMUX_PAD(0x05B0, 0x0268, 0, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA4__CAN2_RX                             = IOMUX_PAD(0x05B0, 0x0268, 1, 0x0690, 0, 0),
	 MX6_PAD_SD3_DATA4__CANFD_RX2                           = IOMUX_PAD(0x05B0, 0x0268, 2, 0x0698, 0, 0),
	 MX6_PAD_SD3_DATA4__UART3_RX                            = IOMUX_PAD(0x05B0, 0x0268, 3, 0x0840, 2, 0),
	 MX6_PAD_SD3_DATA4__LCDIF2_DATA_3                       = IOMUX_PAD(0x05B0, 0x0268, 4, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA4__GPIO7_IO_6                          = IOMUX_PAD(0x05B0, 0x0268, 5, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA4__ENET2_1588_EVENT0_IN                = IOMUX_PAD(0x05B0, 0x0268, 6, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA4__TPSMP_HTRANS_1                      = IOMUX_PAD(0x05B0, 0x0268, 7, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA4__GPU_DEBUG_4                         = IOMUX_PAD(0x05B0, 0x0268, 8, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA4__SDMA_DEBUG_BUS_DEVICE_0             = IOMUX_PAD(0x05B0, 0x0268, 9, 0x0000, 0, 0),

	 MX6_PAD_SD3_DATA5__USDHC3_DATA5                        = IOMUX_PAD(0x05B4, 0x026C, 0, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA5__CAN1_TX                             = IOMUX_PAD(0x05B4, 0x026C, 1, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA5__CANFD_TX1                           = IOMUX_PAD(0x05B4, 0x026C, 2, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA5__UART3_TX                            = IOMUX_PAD(0x05B4, 0x026C, 3, 0x0840, 3, 0),
	 MX6_PAD_SD3_DATA5__LCDIF2_DATA_2                       = IOMUX_PAD(0x05B4, 0x026C, 4, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA5__GPIO7_IO_7                          = IOMUX_PAD(0x05B4, 0x026C, 5, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA5__ENET2_1588_EVENT0_OUT               = IOMUX_PAD(0x05B4, 0x026C, 6, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA5__SIM_M_HWRITE                        = IOMUX_PAD(0x05B4, 0x026C, 7, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA5__GPU_DEBUG_5                         = IOMUX_PAD(0x05B4, 0x026C, 8, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA5__SDMA_DEBUG_BUS_DEVICE_1             = IOMUX_PAD(0x05B4, 0x026C, 9, 0x0000, 0, 0),

	 MX6_PAD_SD3_DATA6__USDHC3_DATA6                        = IOMUX_PAD(0x05B8, 0x0270, 0, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA6__CAN2_TX                             = IOMUX_PAD(0x05B8, 0x0270, 1, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA6__CANFD_TX2                           = IOMUX_PAD(0x05B8, 0x0270, 2, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA6__UART3_RTS_B                         = IOMUX_PAD(0x05B8, 0x0270, 3, 0x083C, 2, 0),
	 MX6_PAD_SD3_DATA6__LCDIF2_DATA_4                       = IOMUX_PAD(0x05B8, 0x0270, 4, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA6__GPIO7_IO_8                          = IOMUX_PAD(0x05B8, 0x0270, 5, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA6__ENET1_1588_EVENT0_OUT               = IOMUX_PAD(0x05B8, 0x0270, 6, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA6__TPSMP_HTRANS_0                      = IOMUX_PAD(0x05B8, 0x0270, 7, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA6__GPU_DEBUG_7                         = IOMUX_PAD(0x05B8, 0x0270, 8, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA6__SDMA_DEBUG_EVT_CHN_LINES_7          = IOMUX_PAD(0x05B8, 0x0270, 9, 0x0000, 0, 0),

	 MX6_PAD_SD3_DATA7__USDHC3_DATA7                        = IOMUX_PAD(0x05BC, 0x0274, 0, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA7__CAN1_RX                             = IOMUX_PAD(0x05BC, 0x0274, 1, 0x068C, 0, 0),
	 MX6_PAD_SD3_DATA7__CANFD_RX1                           = IOMUX_PAD(0x05BC, 0x0274, 2, 0x0694, 0, 0),
	 MX6_PAD_SD3_DATA7__UART3_CTS_B                         = IOMUX_PAD(0x05BC, 0x0274, 3, 0x083C, 3, 0),
	 MX6_PAD_SD3_DATA7__LCDIF2_DATA_5                       = IOMUX_PAD(0x05BC, 0x0274, 4, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA7__GPIO7_IO_9                          = IOMUX_PAD(0x05BC, 0x0274, 5, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA7__ENET1_1588_EVENT0_IN                = IOMUX_PAD(0x05BC, 0x0274, 6, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA7__TPSMP_HDATA_DIR                     = IOMUX_PAD(0x05BC, 0x0274, 7, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA7__GPU_DEBUG_6                         = IOMUX_PAD(0x05BC, 0x0274, 8, 0x0000, 0, 0),
	 MX6_PAD_SD3_DATA7__SDMA_DEBUG_EVT_CHN_LINES_2          = IOMUX_PAD(0x05BC, 0x0274, 9, 0x0000, 0, 0),

	 MX6_PAD_SD4_CLK__USDHC4_CLK                            = IOMUX_PAD(0x05C0, 0x0278, 0, 0x0000, 0, 0),
	 MX6_PAD_SD4_CLK__RAWNAND_DATA15                        = IOMUX_PAD(0x05C0, 0x0278, 1, 0x0000, 0, 0),
	 MX6_PAD_SD4_CLK__ECSPI2_MISO                           = IOMUX_PAD(0x05C0, 0x0278, 2, 0x0724, 1, 0),
	 MX6_PAD_SD4_CLK__AUDMUX_AUD3_RXFS                      = IOMUX_PAD(0x05C0, 0x0278, 3, 0x0638, 0, 0),
	 MX6_PAD_SD4_CLK__LCDIF2_DATA_13                        = IOMUX_PAD(0x05C0, 0x0278, 4, 0x0000, 0, 0),
	 MX6_PAD_SD4_CLK__GPIO6_IO_12                           = IOMUX_PAD(0x05C0, 0x0278, 5, 0x0000, 0, 0),
	 MX6_PAD_SD4_CLK__ECSPI3_SS2                            = IOMUX_PAD(0x05C0, 0x0278, 6, 0x0000, 0, 0),
	 MX6_PAD_SD4_CLK__TPSMP_HDATA_20                        = IOMUX_PAD(0x05C0, 0x0278, 7, 0x0000, 0, 0),
	 MX6_PAD_SD4_CLK__VDEC_DEBUG_12                         = IOMUX_PAD(0x05C0, 0x0278, 8, 0x0000, 0, 0),
	 MX6_PAD_SD4_CLK__SDMA_DEBUG_EVENT_CHANNEL_SEL          = IOMUX_PAD(0x05C0, 0x0278, 9, 0x0000, 0, 0),

	 MX6_PAD_SD4_CMD__USDHC4_CMD                            = IOMUX_PAD(0x05C4, 0x027C, 0, 0x0000, 0, 0),
	 MX6_PAD_SD4_CMD__RAWNAND_DATA14                        = IOMUX_PAD(0x05C4, 0x027C, 1, 0x0000, 0, 0),
	 MX6_PAD_SD4_CMD__ECSPI2_MOSI                           = IOMUX_PAD(0x05C4, 0x027C, 2, 0x0728, 1, 0),
	 MX6_PAD_SD4_CMD__AUDMUX_AUD3_RXC                       = IOMUX_PAD(0x05C4, 0x027C, 3, 0x0634, 0, 0),
	 MX6_PAD_SD4_CMD__LCDIF2_DATA_14                        = IOMUX_PAD(0x05C4, 0x027C, 4, 0x0000, 0, 0),
	 MX6_PAD_SD4_CMD__GPIO6_IO_13                           = IOMUX_PAD(0x05C4, 0x027C, 5, 0x0000, 0, 0),
	 MX6_PAD_SD4_CMD__ECSPI3_SS1                            = IOMUX_PAD(0x05C4, 0x027C, 6, 0x0000, 0, 0),
	 MX6_PAD_SD4_CMD__TPSMP_HDATA_19                        = IOMUX_PAD(0x05C4, 0x027C, 7, 0x0000, 0, 0),
	 MX6_PAD_SD4_CMD__VDEC_DEBUG_11                         = IOMUX_PAD(0x05C4, 0x027C, 8, 0x0000, 0, 0),
	 MX6_PAD_SD4_CMD__SDMA_DEBUG_CORE_RUN                   = IOMUX_PAD(0x05C4, 0x027C, 9, 0x0000, 0, 0),

	 MX6_PAD_SD4_DATA0__USDHC4_DATA0                        = IOMUX_PAD(0x05C8, 0x0280, 0, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA0__RAWNAND_DATA10                      = IOMUX_PAD(0x05C8, 0x0280, 1, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA0__ECSPI2_SS0                          = IOMUX_PAD(0x05C8, 0x0280, 2, 0x072C, 1, 0),
	 MX6_PAD_SD4_DATA0__AUDMUX_AUD3_RXD                     = IOMUX_PAD(0x05C8, 0x0280, 3, 0x062C, 0, 0),
	 MX6_PAD_SD4_DATA0__LCDIF2_DATA_12                      = IOMUX_PAD(0x05C8, 0x0280, 4, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA0__GPIO6_IO_14                         = IOMUX_PAD(0x05C8, 0x0280, 5, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA0__ECSPI3_SS3                          = IOMUX_PAD(0x05C8, 0x0280, 6, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA0__TPSMP_HDATA_21                      = IOMUX_PAD(0x05C8, 0x0280, 7, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA0__VDEC_DEBUG_13                       = IOMUX_PAD(0x05C8, 0x0280, 8, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA0__SDMA_DEBUG_MODE                     = IOMUX_PAD(0x05C8, 0x0280, 9, 0x0000, 0, 0),

	 MX6_PAD_SD4_DATA1__USDHC4_DATA1                        = IOMUX_PAD(0x05CC, 0x0284, 0, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA1__RAWNAND_DATA11                      = IOMUX_PAD(0x05CC, 0x0284, 1, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA1__ECSPI2_SCLK                         = IOMUX_PAD(0x05CC, 0x0284, 2, 0x0720, 1, 0),
	 MX6_PAD_SD4_DATA1__AUDMUX_AUD3_TXC                     = IOMUX_PAD(0x05CC, 0x0284, 3, 0x063C, 0, 0),
	 MX6_PAD_SD4_DATA1__LCDIF2_DATA_11                      = IOMUX_PAD(0x05CC, 0x0284, 4, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA1__GPIO6_IO_15                         = IOMUX_PAD(0x05CC, 0x0284, 5, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA1__ECSPI3_RDY                          = IOMUX_PAD(0x05CC, 0x0284, 6, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA1__TPSMP_HDATA_22                      = IOMUX_PAD(0x05CC, 0x0284, 7, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA1__VDEC_DEBUG_14                       = IOMUX_PAD(0x05CC, 0x0284, 8, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA1__SDMA_DEBUG_BUS_ERROR                = IOMUX_PAD(0x05CC, 0x0284, 9, 0x0000, 0, 0),

	 MX6_PAD_SD4_DATA2__USDHC4_DATA2                        = IOMUX_PAD(0x05D0, 0x0288, 0, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA2__RAWNAND_DATA12                      = IOMUX_PAD(0x05D0, 0x0288, 1, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA2__I2C2_SDA                            = IOMUX_PAD(0x05D0, 0x0288, 2, 0x07B4, 0, 0),
	 MX6_PAD_SD4_DATA2__AUDMUX_AUD3_TXFS                    = IOMUX_PAD(0x05D0, 0x0288, 3, 0x0640, 0, 0),
	 MX6_PAD_SD4_DATA2__LCDIF2_DATA_10                      = IOMUX_PAD(0x05D0, 0x0288, 4, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA2__GPIO6_IO_16                         = IOMUX_PAD(0x05D0, 0x0288, 5, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA2__ECSPI2_SS3                          = IOMUX_PAD(0x05D0, 0x0288, 6, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA2__TPSMP_HDATA_23                      = IOMUX_PAD(0x05D0, 0x0288, 7, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA2__VDEC_DEBUG_15                       = IOMUX_PAD(0x05D0, 0x0288, 8, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA2__SDMA_DEBUG_BUS_RWB                  = IOMUX_PAD(0x05D0, 0x0288, 9, 0x0000, 0, 0),

	 MX6_PAD_SD4_DATA3__USDHC4_DATA3                        = IOMUX_PAD(0x05D4, 0x028C, 0, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA3__RAWNAND_DATA13                      = IOMUX_PAD(0x05D4, 0x028C, 1, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA3__I2C2_SCL                            = IOMUX_PAD(0x05D4, 0x028C, 2, 0x07B0, 0, 0),
	 MX6_PAD_SD4_DATA3__AUDMUX_AUD3_TXD                     = IOMUX_PAD(0x05D4, 0x028C, 3, 0x0630, 0, 0),
	 MX6_PAD_SD4_DATA3__LCDIF2_DATA_9                       = IOMUX_PAD(0x05D4, 0x028C, 4, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA3__GPIO6_IO_17                         = IOMUX_PAD(0x05D4, 0x028C, 5, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA3__ECSPI2_RDY                          = IOMUX_PAD(0x05D4, 0x028C, 6, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA3__TPSMP_HDATA_24                      = IOMUX_PAD(0x05D4, 0x028C, 7, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA3__VDEC_DEBUG_16                       = IOMUX_PAD(0x05D4, 0x028C, 8, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA3__SDMA_DEBUG_MATCHED_DMBUS            = IOMUX_PAD(0x05D4, 0x028C, 9, 0x0000, 0, 0),

	 MX6_PAD_SD4_DATA4__USDHC4_DATA4                        = IOMUX_PAD(0x05D8, 0x0290, 0, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA4__RAWNAND_DATA09                      = IOMUX_PAD(0x05D8, 0x0290, 1, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA4__UART5_RX                            = IOMUX_PAD(0x05D8, 0x0290, 2, 0x0850, 0, 0),
	 MX6_PAD_SD4_DATA4__ECSPI3_SCLK                         = IOMUX_PAD(0x05D8, 0x0290, 3, 0x0730, 0, 0),
	 MX6_PAD_SD4_DATA4__LCDIF2_DATA_8                       = IOMUX_PAD(0x05D8, 0x0290, 4, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA4__GPIO6_IO_18                         = IOMUX_PAD(0x05D8, 0x0290, 5, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA4__SPDIF_OUT                           = IOMUX_PAD(0x05D8, 0x0290, 6, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA4__TPSMP_HDATA_16                      = IOMUX_PAD(0x05D8, 0x0290, 7, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA4__USB_OTG_HOST_MODE                   = IOMUX_PAD(0x05D8, 0x0290, 8, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA4__SDMA_DEBUG_RTBUFFER_WRITE           = IOMUX_PAD(0x05D8, 0x0290, 9, 0x0000, 0, 0),

	 MX6_PAD_SD4_DATA5__USDHC4_DATA5                        = IOMUX_PAD(0x05DC, 0x0294, 0, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA5__RAWNAND_CE2_B                       = IOMUX_PAD(0x05DC, 0x0294, 1, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA5__UART5_TX                            = IOMUX_PAD(0x05DC, 0x0294, 2, 0x0850, 1, 0),
	 MX6_PAD_SD4_DATA5__ECSPI3_MOSI                         = IOMUX_PAD(0x05DC, 0x0294, 3, 0x0738, 0, 0),
	 MX6_PAD_SD4_DATA5__LCDIF2_DATA_7                       = IOMUX_PAD(0x05DC, 0x0294, 4, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA5__GPIO6_IO_19                         = IOMUX_PAD(0x05DC, 0x0294, 5, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA5__SPDIF_IN                            = IOMUX_PAD(0x05DC, 0x0294, 6, 0x0824, 0, 0),
	 MX6_PAD_SD4_DATA5__TPSMP_HDATA_17                      = IOMUX_PAD(0x05DC, 0x0294, 7, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA5__VDEC_DEBUG_9                        = IOMUX_PAD(0x05DC, 0x0294, 8, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA5__SDMA_DEBUG_EVENT_CHANNEL_0          = IOMUX_PAD(0x05DC, 0x0294, 9, 0x0000, 0, 0),

	 MX6_PAD_SD4_DATA6__USDHC4_DATA6                        = IOMUX_PAD(0x05E0, 0x0298, 0, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA6__RAWNAND_CE3_B                       = IOMUX_PAD(0x05E0, 0x0298, 1, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA6__UART5_RTS_B                         = IOMUX_PAD(0x05E0, 0x0298, 2, 0x084C, 0, 0),
	 MX6_PAD_SD4_DATA6__ECSPI3_MISO                         = IOMUX_PAD(0x05E0, 0x0298, 3, 0x0734, 0, 0),
	 MX6_PAD_SD4_DATA6__LCDIF2_DATA_6                       = IOMUX_PAD(0x05E0, 0x0298, 4, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA6__GPIO6_IO_20                         = IOMUX_PAD(0x05E0, 0x0298, 5, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA6__USDHC4_WP                           = IOMUX_PAD(0x05E0, 0x0298, 6, 0x0878, 0, 0),
	 MX6_PAD_SD4_DATA6__TPSMP_HDATA_18                      = IOMUX_PAD(0x05E0, 0x0298, 7, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA6__VDEC_DEBUG_10                       = IOMUX_PAD(0x05E0, 0x0298, 8, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA6__SDMA_DEBUG_EVENT_CHANNEL_1          = IOMUX_PAD(0x05E0, 0x0298, 9, 0x0000, 0, 0),

	 MX6_PAD_SD4_DATA7__USDHC4_DATA7                        = IOMUX_PAD(0x05E4, 0x029C, 0, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA7__RAWNAND_DATA08                      = IOMUX_PAD(0x05E4, 0x029C, 1, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA7__UART5_CTS_B                         = IOMUX_PAD(0x05E4, 0x029C, 2, 0x084C, 1, 0),
	 MX6_PAD_SD4_DATA7__ECSPI3_SS0                          = IOMUX_PAD(0x05E4, 0x029C, 3, 0x073C, 0, 0),
	 MX6_PAD_SD4_DATA7__LCDIF2_DATA_15                      = IOMUX_PAD(0x05E4, 0x029C, 4, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA7__GPIO6_IO_21                         = IOMUX_PAD(0x05E4, 0x029C, 5, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA7__USDHC4_CD_B                         = IOMUX_PAD(0x05E4, 0x029C, 6, 0x0874, 0, 0),
	 MX6_PAD_SD4_DATA7__TPSMP_HDATA_15                      = IOMUX_PAD(0x05E4, 0x029C, 7, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA7__USB_OTG_PWR_WAKE                    = IOMUX_PAD(0x05E4, 0x029C, 8, 0x0000, 0, 0),
	 MX6_PAD_SD4_DATA7__SDMA_DEBUG_YIELD                    = IOMUX_PAD(0x05E4, 0x029C, 9, 0x0000, 0, 0),

	 MX6_PAD_SD4_RESET_B__USDHC4_RESET_B                    = IOMUX_PAD(0x05E8, 0x02A0, 0, 0x0000, 0, 0),
	 MX6_PAD_SD4_RESET_B__RAWNAND_DQS                       = IOMUX_PAD(0x05E8, 0x02A0, 1, 0x0000, 0, 0),
	 MX6_PAD_SD4_RESET_B__USDHC4_RESET                      = IOMUX_PAD(0x05E8, 0x02A0, 2, 0x0000, 0, 0),
	 MX6_PAD_SD4_RESET_B__AUDMUX_MCLK                       = IOMUX_PAD(0x05E8, 0x02A0, 3, 0x0000, 0, 0),
	 MX6_PAD_SD4_RESET_B__LCDIF2_RESET                      = IOMUX_PAD(0x05E8, 0x02A0, 4, 0x0000, 0, 0),
	 MX6_PAD_SD4_RESET_B__GPIO6_IO_22                       = IOMUX_PAD(0x05E8, 0x02A0, 5, 0x0000, 0, 0),
	 MX6_PAD_SD4_RESET_B__LCDIF2_CS                         = IOMUX_PAD(0x05E8, 0x02A0, 6, 0x0000, 0, 0),
	 MX6_PAD_SD4_RESET_B__TPSMP_HDATA_25                    = IOMUX_PAD(0x05E8, 0x02A0, 7, 0x0000, 0, 0),
	 MX6_PAD_SD4_RESET_B__VDEC_DEBUG_17                     = IOMUX_PAD(0x05E8, 0x02A0, 8, 0x0000, 0, 0),
	 MX6_PAD_SD4_RESET_B__SDMA_DEBUG_BUS_DEVICE_2           = IOMUX_PAD(0x05E8, 0x02A0, 9, 0x0000, 0, 0),

	 MX6_PAD_USB_H_DATA__USB_H_DATA                         = IOMUX_PAD(0x05EC, 0x02A4, 0, 0x0000, 0, 0),
	 MX6_PAD_USB_H_DATA__PWM2_OUT                           = IOMUX_PAD(0x05EC, 0x02A4, 1, 0x0000, 0, 0),
	 MX6_PAD_USB_H_DATA__ANATOP_24M_OUT                     = IOMUX_PAD(0x05EC, 0x02A4, 2, 0x0000, 0, 0),
	 MX6_PAD_USB_H_DATA__I2C4_SDA                           = IOMUX_PAD(0x05EC, 0x02A4, 3, 0x07C4, 1, 0),
	 MX6_PAD_USB_H_DATA__WDOG3_WDOG_B                       = IOMUX_PAD(0x05EC, 0x02A4, 4, 0x0000, 0, 0),
	 MX6_PAD_USB_H_DATA__GPIO7_IO_10                        = IOMUX_PAD(0x05EC, 0x02A4, 5, 0x0000, 0, 0),

	 MX6_PAD_USB_H_STROBE__USB_H_STROBE                     = IOMUX_PAD(0x05F0, 0x02A8, 0, 0x0000, 0, 0),
	 MX6_PAD_USB_H_STROBE__PWM1_OUT                         = IOMUX_PAD(0x05F0, 0x02A8, 1, 0x0000, 0, 0),
	 MX6_PAD_USB_H_STROBE__ANATOP_32K_OUT                   = IOMUX_PAD(0x05F0, 0x02A8, 2, 0x0000, 0, 0),
	 MX6_PAD_USB_H_STROBE__I2C4_SCL                         = IOMUX_PAD(0x05F0, 0x02A8, 3, 0x07C0, 1, 0),
	 MX6_PAD_USB_H_STROBE__WDOG3_WDOG_RST_B_DEB             = IOMUX_PAD(0x05F0, 0x02A8, 4, 0x0000, 0, 0),
	 MX6_PAD_USB_H_STROBE__GPIO7_IO_11                      = IOMUX_PAD(0x05F0, 0x02A8, 5, 0x0000, 0, 0),
};
#endif  /* __ASM_ARCH_MX6_ MX6_PINS_H__ */
