/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;

public class DefaultParser
implements Parser {
    private char[] quoteChars = new char[]{'\'', '\"'};
    private char[] escapeChars = new char[]{'\\'};

    public void setQuoteChars(char[] chars) {
        this.quoteChars = chars;
    }

    public char[] getQuoteChars() {
        return this.quoteChars;
    }

    public void setEscapeChars(char[] chars) {
        this.escapeChars = chars;
    }

    public char[] getEscapeChars() {
        return this.escapeChars;
    }

    @Override
    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) {
        LinkedList<String> words = new LinkedList<String>();
        StringBuilder current = new StringBuilder();
        int wordCursor = -1;
        int wordIndex = -1;
        int quoteStart = -1;
        for (int i = 0; line != null && i < line.length(); ++i) {
            if (i == cursor) {
                wordIndex = words.size();
                wordCursor = current.length();
            }
            if (quoteStart < 0 && this.isQuoteChar(line, i)) {
                quoteStart = i;
                continue;
            }
            if (quoteStart >= 0) {
                if (line.charAt(quoteStart) == line.charAt(i) && !this.isEscaped(line, i)) {
                    words.add(current.toString());
                    current.setLength(0);
                    quoteStart = -1;
                    continue;
                }
                if (this.isEscapeChar(line, i)) continue;
                current.append(line.charAt(i));
                continue;
            }
            if (this.isDelimiter(line, i)) {
                if (current.length() <= 0) continue;
                words.add(current.toString());
                current.setLength(0);
                continue;
            }
            if (this.isEscapeChar(line, i)) continue;
            current.append(line.charAt(i));
        }
        if (current.length() > 0 || cursor == line.length()) {
            words.add(current.toString());
        }
        if (cursor == line.length()) {
            wordIndex = words.size() - 1;
            wordCursor = ((String)words.get(words.size() - 1)).length();
        }
        return new ArgumentList(line, words, wordIndex, wordCursor, cursor);
    }

    public boolean isDelimiter(CharSequence buffer, int pos) {
        return !this.isQuoted(buffer, pos) && !this.isEscaped(buffer, pos) && this.isDelimiterChar(buffer, pos);
    }

    public boolean isQuoted(CharSequence buffer, int pos) {
        return false;
    }

    public boolean isQuoteChar(CharSequence buffer, int pos) {
        if (pos < 0) {
            return false;
        }
        for (int i = 0; this.quoteChars != null && i < this.quoteChars.length; ++i) {
            if (buffer.charAt(pos) != this.quoteChars[i]) continue;
            return !this.isEscaped(buffer, pos);
        }
        return false;
    }

    public boolean isEscapeChar(CharSequence buffer, int pos) {
        if (pos < 0) {
            return false;
        }
        for (int i = 0; this.escapeChars != null && i < this.escapeChars.length; ++i) {
            if (buffer.charAt(pos) != this.escapeChars[i]) continue;
            return !this.isEscaped(buffer, pos);
        }
        return false;
    }

    public boolean isEscaped(CharSequence buffer, int pos) {
        if (pos <= 0) {
            return false;
        }
        return this.isEscapeChar(buffer, pos - 1);
    }

    public boolean isDelimiterChar(CharSequence buffer, int pos) {
        return Character.isWhitespace(buffer.charAt(pos));
    }

    public static class ArgumentList
    implements ParsedLine {
        private final String line;
        private final List<String> words;
        private final int wordIndex;
        private final int wordCursor;
        private final int cursor;

        public ArgumentList(String line, List<String> words, int wordIndex, int wordCursor, int cursor) {
            this.line = line;
            this.words = Collections.unmodifiableList(Objects.requireNonNull(words));
            this.wordIndex = wordIndex;
            this.wordCursor = wordCursor;
            this.cursor = cursor;
        }

        @Override
        public int wordIndex() {
            return this.wordIndex;
        }

        @Override
        public String word() {
            if (this.wordIndex < 0 || this.wordIndex >= this.words.size()) {
                return "";
            }
            return this.words.get(this.wordIndex);
        }

        @Override
        public int wordCursor() {
            return this.wordCursor;
        }

        @Override
        public List<String> words() {
            return this.words;
        }

        @Override
        public int cursor() {
            return this.cursor;
        }

        @Override
        public String line() {
            return this.line;
        }
    }
}

