/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.bytecode.ObjectType;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleManager;
import gnu.expr.ScopeExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.SimpleSymbol;
import gnu.mapping.Symbol;
import java.util.LinkedHashMap;
import java.util.Map;
import kawa.lang.Syntax;
import kawa.lang.Translator;
import kawa.standard.module_name;
import kawa.standard.require;

public class ImportFromLibrary
extends Syntax {
    public static final ImportFromLibrary instance = new ImportFromLibrary();
    public String[] classPrefixPath = new String[]{"", "kawa.lib."};
    private static final String BUILTIN = "<builtin>";
    private static final String MISSING = null;
    static final String[][] SRFI97Map = new String[][]{{"1", "lists", "gnu.kawa.slib.srfi1"}, {"2", "and-let*", "gnu.kawa.slib.srfi2"}, {"5", "let", MISSING}, {"6", "basic-string-ports", "<builtin>"}, {"8", "receive", "<builtin>"}, {"9", "records", "<builtin>"}, {"11", "let-values", "<builtin>"}, {"13", "strings", "gnu.kawa.slib.srfi13"}, {"14", "char-sets", "gnu.kawa.slib.srfi14"}, {"16", "case-lambda", "<builtin>"}, {"17", "generalized-set!", "<builtin>"}, {"18", "multithreading", MISSING}, {"19", "time", MISSING}, {"21", "real-time-multithreading", MISSING}, {"23", "error", "<builtin>"}, {"25", "multi-dimensional-arrays", "<builtin>"}, {"26", "cut", "<builtin>"}, {"27", "random-bits", MISSING}, {"28", "basic-format-strings", "<builtin>"}, {"29", "localization", MISSING}, {"31", "rec", MISSING}, {"38", "with-shared-structure", MISSING}, {"39", "parameters", "<builtin>"}, {"41", "streams.primitive", "gnu.kawa.slib.StreamsPrimitive"}, {"41", "streams.derived", "gnu.kawa.slib.StreamsDerived"}, {"41", "streams", "gnu.kawa.slib.Streams"}, {"42", "eager-comprehensions", MISSING}, {"43", "vectors", MISSING}, {"44", "collections", MISSING}, {"45", "lazy", MISSING}, {"46", "syntax-rules", MISSING}, {"47", "arrays", MISSING}, {"48", "intermediate-format-strings", MISSING}, {"51", "rest-values", MISSING}, {"54", "cat", MISSING}, {"57", "records", MISSING}, {"59", "vicinities", MISSING}, {"60", "integer-bits", "gnu.kawa.slib.srfi60"}, {"61", "cond", MISSING}, {"63", "arrays", MISSING}, {"64", "testing", "gnu.kawa.slib.testing"}, {"66", "octet-vectors", MISSING}, {"67", "compare-procedures", MISSING}, {"69", "basic-hash-tables", "gnu.kawa.slib.srfi69"}, {"71", "let", MISSING}, {"74", "blobs", MISSING}, {"78", "lightweight-testing", MISSING}, {"86", "mu-and-nu", MISSING}, {"87", "case", "<builtin>"}, {"95", "sorting-and-merging", "kawa.lib.srfi95"}, {"98", "os-environment-variables", "<builtin>"}, {"101", "random-access-lists", "gnu.kawa.slib.ralists"}};
    public static final SimpleSymbol exceptSymbol = Symbol.valueOf("except");
    public static final SimpleSymbol librarySymbol = Symbol.valueOf("library");
    public static final SimpleSymbol onlySymbol = Symbol.valueOf("only");
    public static final SimpleSymbol prefixSymbol = Symbol.valueOf("prefix");
    public static final SimpleSymbol renameSymbol = Symbol.valueOf("rename");

    @Override
    public void scanForm(Pair st, ScopeExp defs2, Translator tr) {
        Object obj = st.getCdr();
        while (obj instanceof Pair) {
            Pair pair = (Pair)obj;
            Object save1 = tr.pushPositionOf(pair);
            this.scanImportSet(pair.getCar(), defs2, tr, null);
            tr.popPositionOf(save1);
            obj = pair.getCdr();
        }
        if (obj != LList.Empty) {
            tr.error('e', "improper list");
        }
    }

    public static String checkSrfi(String lname, Translator tr) {
        block13: {
            String srfiClass;
            String srfiNameExpected;
            String srfiName;
            if (!lname.startsWith("srfi.")) break block13;
            String demangled = Compilation.demangleName(lname.substring(5));
            int dot = demangled.indexOf(46);
            StringBuilder badNameBuffer = null;
            if (dot < 0) {
                srfiName = null;
                dot = demangled.length();
            } else {
                srfiName = demangled.substring(dot + 1);
            }
            String srfiNumber = null;
            if (dot >= 2 || demangled.charAt(0) == ':') {
                int i = 1;
                while (true) {
                    if (i == dot) {
                        srfiNumber = demangled.substring(1, dot);
                        break;
                    }
                    if (Character.digit(demangled.charAt(i), 10) < 0) break;
                    ++i;
                }
            }
            if (srfiNumber == null) {
                tr.error('e', "SRFI library reference must have the form: (srfi :NNN [name])");
                return lname;
            }
            int srfiIndex = SRFI97Map.length;
            while (true) {
                if (--srfiIndex < 0) {
                    tr.error('e', badNameBuffer != null ? badNameBuffer.toString() : "unknown SRFI number '" + srfiNumber + "' in SRFI library reference");
                    return lname;
                }
                if (!SRFI97Map[srfiIndex][0].equals(srfiNumber)) continue;
                srfiNameExpected = SRFI97Map[srfiIndex][1];
                srfiClass = SRFI97Map[srfiIndex][2];
                if (srfiName == null || srfiName.equals(srfiNameExpected)) break;
                if (badNameBuffer == null) {
                    badNameBuffer = new StringBuilder("the name of SRFI ");
                    badNameBuffer.append(srfiNumber);
                    badNameBuffer.append(" should be '");
                } else {
                    badNameBuffer.append(" or '");
                }
                badNameBuffer.append(srfiNameExpected);
                badNameBuffer.append('\'');
            }
            if (srfiClass == BUILTIN) {
                return BUILTIN;
            }
            if (srfiClass == MISSING) {
                tr.error('e', "sorry - Kawa does not support SRFI " + srfiNumber + " (" + srfiNameExpected + ')');
            } else {
                lname = srfiClass;
            }
        }
        return lname;
    }

    void scanImportSet(Object imports, ScopeExp defs2, Translator tr, require.DeclSetMapper mapper) {
        int specLength = Translator.listLength(imports);
        if (specLength <= 0) {
            Object save1 = tr.pushPositionOf(imports);
            tr.error('e', "import specifier is not a proper list");
            tr.popPositionOf(save1);
            return;
        }
        Pair pimport = (Pair)imports;
        Object first = pimport.getCar();
        Object rest = pimport.getCdr();
        Pair cdrPair = specLength >= 2 ? (Pair)rest : null;
        char kind = '\u0000';
        if (first == onlySymbol) {
            kind = 'O';
        } else if (first == exceptSymbol) {
            kind = 'E';
        } else if (first == renameSymbol) {
            kind = 'R';
        } else if (first == prefixSymbol) {
            kind = 'P';
        } else if (first == librarySymbol && specLength == 2 && cdrPair.getCar() instanceof Pair) {
            pimport = (Pair)cdrPair.getCar();
        }
        if (specLength >= 2 && kind != '\u0000' && cdrPair.getCar() instanceof LList) {
            ImportSetMapper nmapper = new ImportSetMapper(kind, cdrPair.getCdr(), specLength - 2);
            nmapper.chain = mapper;
            this.scanImportSet(cdrPair.getCar(), defs2, tr, nmapper);
            return;
        }
        Object versionSpec = null;
        String sourcePath = null;
        StringBuffer sbuf = new StringBuffer();
        Object libref = pimport;
        while (libref instanceof Pair) {
            Pair pair = libref;
            Object car = pair.getCar();
            Object cdr = pair.getCdr();
            if (car instanceof Pair) {
                if (versionSpec != null) {
                    tr.error('e', "duplicate version reference - was " + versionSpec);
                }
                versionSpec = car;
                System.err.println("import version " + car);
            } else if (car instanceof String) {
                if (cdr instanceof Pair) {
                    tr.error('e', "source specifier must be last element in library reference");
                }
                sourcePath = (String)car;
            } else {
                if (sbuf.length() > 0) {
                    sbuf.append('.');
                }
                sbuf.append(Compilation.mangleNameIfNeeded(car.toString()));
            }
            libref = cdr;
        }
        ModuleInfo minfo = null;
        if (sourcePath != null && (minfo = require.lookupModuleFromSourcePath(sourcePath, defs2)) == null) {
            tr.error('e', "malformed URL: " + sourcePath);
            return;
        }
        String lname = sbuf.toString();
        if ((lname = ImportFromLibrary.checkSrfi(lname, tr)) == BUILTIN) {
            return;
        }
        int classPrefixPathLength = this.classPrefixPath.length;
        for (int i = 0; i < classPrefixPathLength; ++i) {
            String tname = this.classPrefixPath[i] + lname;
            try {
                minfo = ModuleManager.getInstance().findWithClassName(tname);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (minfo == null) {
            tr.error('e', "unknown class " + lname);
            return;
        }
        require.importDefinitions(null, minfo, mapper, tr.formStack, defs2, tr);
    }

    @Override
    public Expression rewriteForm(Pair form, Translator tr) {
        return null;
    }

    public String libraryExists(Object list, Translator tr) {
        String lname = module_name.listToModuleName(list, tr);
        if ((lname = ImportFromLibrary.checkSrfi(lname, tr)) == BUILTIN) {
            return lname;
        }
        int classPrefixPathLength = this.classPrefixPath.length;
        for (int i = 0; i < classPrefixPathLength; ++i) {
            String className = this.classPrefixPath[i] + lname;
            try {
                ObjectType.getContextClass(className);
                return className;
            }
            catch (Exception ex) {
                continue;
            }
        }
        return null;
    }

    static class ImportSetMapper
    implements require.DeclSetMapper {
        char kind;
        Object list;
        int listLength;
        require.DeclSetMapper chain;

        public ImportSetMapper(char kind, Object list, int listLength) {
            this.kind = kind;
            this.list = list;
            this.listLength = listLength;
        }

        @Override
        public Map<Symbol, Declaration> map(Map<Symbol, Declaration> decls, Compilation comp) {
            Translator tr = (Translator)comp;
            Object lst = this.list;
            Map<Symbol, Declaration> nmap = decls;
            switch (this.kind) {
                case 'E': 
                case 'O': {
                    if (this.kind == 'O') {
                        nmap = new LinkedHashMap<Symbol, Declaration>();
                    }
                    while (lst instanceof Pair) {
                        Pair pair = (Pair)lst;
                        Object save1 = tr.pushPositionOf(pair);
                        Object name = Translator.stripSyntax(pair.getCar());
                        if (name instanceof Symbol) {
                            Symbol sym = (Symbol)name;
                            Declaration old = decls.get(sym);
                            if (old == null) {
                                tr.error('e', "unknown symbol in import set: " + sym);
                            } else if (this.kind == 'E') {
                                nmap.remove(sym);
                            } else {
                                nmap.put(sym, old);
                            }
                        } else {
                            tr.error('e', "non-symbol in name list");
                        }
                        tr.popPositionOf(save1);
                        lst = pair.getCdr();
                    }
                    break;
                }
                case 'R': {
                    Symbol[] pendingSymbols = new Symbol[this.listLength];
                    Declaration[] pendingDecls = new Declaration[this.listLength];
                    int npending = 0;
                    while (lst instanceof Pair) {
                        Pair pair = (Pair)lst;
                        Object save1 = tr.pushPositionOf(pair);
                        Object entry = pair.getCar();
                        int entryLen = Translator.listLength(entry);
                        if (entryLen == 2) {
                            Pair p1 = (Pair)entry;
                            Object oldname = p1.getCar();
                            Object newname = ((Pair)p1.getCdr()).getCar();
                            if (oldname instanceof Symbol && newname instanceof Symbol) {
                                Symbol oldSymbol = (Symbol)oldname;
                                Symbol newSymbol = (Symbol)newname;
                                Declaration oldDecl = decls.remove(oldSymbol);
                                if (oldDecl == null) {
                                    tr.error('e', "missing binding " + oldSymbol);
                                } else {
                                    pendingSymbols[npending] = newSymbol;
                                    pendingDecls[npending] = oldDecl;
                                    ++npending;
                                }
                            } else {
                                entryLen = -1;
                            }
                        }
                        if (entryLen != 2) {
                            tr.error('e', "entry is not a pair of names");
                        }
                        tr.popPositionOf(save1);
                        lst = pair.getCdr();
                    }
                    for (int i = 0; i < npending; ++i) {
                        Symbol newSymbol = pendingSymbols[i];
                        Declaration decl = pendingDecls[i];
                        if (decls.put(newSymbol, decl) == null) continue;
                        tr.error('e', "duplicate binding for " + newSymbol);
                    }
                    break;
                }
                case 'P': {
                    nmap = new LinkedHashMap<Symbol, Declaration>();
                    if (this.listLength != 1 || !(((Pair)this.list).getCar() instanceof SimpleSymbol)) {
                        tr.error('e', "bad syntax for prefix import specifier");
                        break;
                    }
                    String prefix = ((SimpleSymbol)((Pair)this.list).getCar()).getName();
                    for (Map.Entry<Symbol, Declaration> entry : decls.entrySet()) {
                        Symbol aname = entry.getKey();
                        Declaration decl = entry.getValue();
                        SimpleSymbol nname = Symbol.valueOf(prefix + aname);
                        nmap.put(nname, decl);
                    }
                    break;
                }
            }
            if (this.chain != null) {
                nmap = this.chain.map(nmap, tr);
            }
            return nmap;
        }
    }
}

