/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.expr.Compilation;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleSet;
import gnu.text.Path;
import gnu.text.URLPath;
import java.io.File;
import java.net.URL;

public class ModuleManager {
    public ClassLoader defaultClassLoader = ClassLoader.getSystemClassLoader();
    private String compilationDirectory = "";
    static ModuleManager instance = new ModuleManager();
    public static final long LAST_MODIFIED_CACHE_TIME = 1000L;
    public long lastModifiedCacheTime = 1000L;
    ModuleInfo modules;
    ModuleSet packageInfoChain;

    public void setCompilationDirectory(String path) {
        int plen;
        if (path == null) {
            path = "";
        }
        if ((plen = path.length()) > 0) {
            char sep = File.separatorChar;
            if (path.charAt(plen - 1) != sep) {
                path = path + sep;
            }
        }
        this.compilationDirectory = path;
    }

    public String getCompilationDirectory() {
        return this.compilationDirectory;
    }

    public static ModuleManager getInstance() {
        return instance;
    }

    public ModuleInfo firstModule() {
        return this.modules;
    }

    public ModuleInfo find(Compilation comp) {
        ModuleExp mexp = comp.getModule();
        ClassType ctype = mexp.classFor(comp);
        ModuleInfo info = this.findWithClassName(ctype.getName());
        info.setCompilation(comp);
        return info;
    }

    public void add(ModuleInfo info) {
        info.next = this.modules;
        this.modules = info;
    }

    public ModuleInfo searchWithClassName(String className) {
        ModuleInfo info = this.modules;
        while (info != null) {
            if (className.equals(info.className)) {
                return info;
            }
            info = info.next;
        }
        return null;
    }

    public synchronized ModuleInfo findWithClassName(String className) {
        ModuleInfo info = this.searchWithClassName(className);
        if (info == null) {
            info = new ModuleInfo();
            info.className = className;
            this.add(info);
        }
        return info;
    }

    private ModuleInfo searchWithAbsSourcePath(String sourcePath) {
        ModuleInfo info = this.modules;
        while (info != null) {
            if (sourcePath.equals(info.getSourceAbsPathname())) {
                return info;
            }
            info = info.next;
        }
        return null;
    }

    public synchronized ModuleInfo findWithSourcePath(String sourcePath) {
        Path sourceAbsPath = ModuleInfo.absPath(sourcePath);
        String sourceAbsPathname = sourceAbsPath.toString();
        ModuleInfo info = this.searchWithAbsSourcePath(sourceAbsPathname);
        if (info == null) {
            info = new ModuleInfo();
            info.sourcePath = sourcePath;
            info.sourceAbsPath = sourceAbsPath;
            info.sourceAbsPathname = sourceAbsPathname;
            this.add(info);
        }
        return info;
    }

    public ModuleInfo findWithURL(URL url) {
        return this.findWithSourcePath(url.toExternalForm());
    }

    public void register(String moduleClass, String moduleSource, String moduleUri) {
        if (this.searchWithClassName(moduleClass) != null) {
            return;
        }
        Path sourcePath = Path.valueOf(moduleSource);
        Path sourceAbsPath = sourcePath.getCanonical();
        String sourceAbsPathname = sourceAbsPath.toString();
        if (this.searchWithAbsSourcePath(sourceAbsPathname) != null) {
            return;
        }
        ModuleInfo info = new ModuleInfo();
        if (sourcePath.isAbsolute()) {
            info.sourceAbsPath = sourcePath;
            info.sourceAbsPathname = sourceAbsPathname;
        } else {
            try {
                Class<?> setClass = this.packageInfoChain.getClass();
                String setClassName = setClass.getName().replace('.', '/') + ".class";
                URL setClassURL = setClass.getClassLoader().getResource(setClassName);
                info.sourceAbsPath = sourceAbsPath = URLPath.valueOf(setClassURL).resolve(moduleSource);
                info.sourceAbsPathname = sourceAbsPath.toString();
            }
            catch (Throwable ex) {
                return;
            }
        }
        info.className = moduleClass;
        info.sourcePath = moduleSource;
        info.uri = moduleUri;
        this.add(info);
    }

    public synchronized void loadPackageInfo(String packageName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String moduleSetClassName = packageName + "." + "$ModulesMap$";
        ModuleSet set = this.packageInfoChain;
        while (set != null) {
            String setName = set.getClass().getName();
            if (setName.equals(moduleSetClassName)) {
                // empty if block
            }
            set = set.next;
        }
        Class<?> setClass = Class.forName(moduleSetClassName);
        ModuleSet instance = (ModuleSet)setClass.newInstance();
        instance.next = this.packageInfoChain;
        this.packageInfoChain = instance;
        instance.register(this);
    }

    public void clear() {
        ModuleSet set = this.packageInfoChain;
        while (set != null) {
            ModuleSet next = set.next;
            set.next = null;
            set = next;
        }
        this.packageInfoChain = null;
        ModuleInfo module = this.modules;
        while (module != null) {
            ModuleInfo next = module.next;
            module.next = null;
            module = next;
        }
        this.modules = null;
    }
}

