/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.FluidBinding;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;

public class Future
extends Thread {
    Object result;
    CallContext context;
    Environment environment;
    InPort in;
    OutPort out;
    OutPort err;
    Throwable exception;
    FluidBinding initBindings;
    Procedure action;

    public Future(Procedure procedure, Environment environment) {
        this(procedure, environment, InPort.inDefault(), OutPort.outDefault(), OutPort.errDefault());
    }

    public Future(Procedure procedure, Environment environment, InPort inPort, OutPort outPort, OutPort outPort2) {
        this.action = procedure;
        this.environment = environment;
        this.in = inPort;
        this.out = outPort;
        this.err = outPort2;
        this.initBindings = Future.getFluids();
    }

    public Future(Procedure procedure) {
        this(procedure, Environment.getCurrent());
    }

    public final CallContext getCallContext() {
        return this.context;
    }

    public void run() {
        try {
            this.context = CallContext.getInstance();
            this.context.fluidBindings = this.initBindings;
            this.result = this.action.apply0();
        }
        catch (Throwable throwable) {
            this.exception = throwable;
        }
    }

    public Object waitForResult() {
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("thread join [force] was interrupted");
        }
        if (this.exception != null) {
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            throw new RuntimeException(this.exception.toString());
        }
        return this.result;
    }

    public final void setFluids(FluidBinding fluidBinding) {
        this.context.setFluids(fluidBinding);
    }

    public final void resetFluids(FluidBinding fluidBinding) {
        this.context.resetFluids(fluidBinding);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#<future ");
        stringBuffer.append(this.getName());
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public static FluidBinding getFluids() {
        return CallContext.getInstance().fluidBindings;
    }
}

