/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ui.ExplorerTreeModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JobTree
extends DefaultMutableTreeNode {
    private static final String jobNodeName = "JOBS";
    private static final JobTree jobTree = new JobTree();
    private static final TreePath jobPath = new TreePath("Explorer").pathByAddingChild(jobTree);
    private final Vector<JobTreeNode> jobNodes = new Vector();
    private int[] indices = new int[1];
    private int indicesCount = 0;

    private JobTree() {
        super(jobNodeName);
        this.children = this.jobNodes;
    }

    public static DefaultMutableTreeNode getExplorerTree() {
        return jobTree;
    }

    public static void update(List<Job.Inform> jobs) {
        jobTree.updateJobs(jobs);
    }

    public static JPopupMenu getPopupStatus(JobTreeNode jobNode) {
        JPopupMenu popup = new JPopupMenu();
        JobMenuActionListener a = new JobMenuActionListener(jobNode);
        JMenuItem m = new JMenuItem("Get Info");
        m.addActionListener(a);
        popup.add(m);
        m = new JMenuItem("Abort");
        m.addActionListener(a);
        popup.add(m);
        m = new JMenuItem("Delete");
        m.addActionListener(a);
        popup.add(m);
        return popup;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(int childIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIndex(TreeNode aChild) {
        try {
            JobTreeNode tn = (JobTreeNode)aChild;
            return this.jobNodes.indexOf(tn);
        }
        catch (Exception e) {
            if (aChild == null) {
                throw new IllegalArgumentException("argument is null");
            }
            return -1;
        }
    }

    public List<Job.Inform> getChangeJobs() {
        ArrayList<Job.Inform> jobs = new ArrayList<Job.Inform>();
        for (int i = 0; i < this.jobNodes.size(); ++i) {
            JobTreeNode jtn = this.jobNodes.get(i);
            Job.Inform ji = jtn.jobInfo;
            if (!ji.isChangeJobQueuedOrRunning()) continue;
            jobs.add(ji);
        }
        return jobs;
    }

    private void updateJobs(List<Job.Inform> newJobs) {
        int i;
        Object[] children2;
        Job.Key jobKey;
        assert (SwingUtilities.isEventDispatchThread());
        this.indicesClear();
        int newJ = 0;
        for (int oldJ = 0; oldJ < this.jobNodes.size(); ++oldJ) {
            int k;
            jobKey = this.jobNodes.get(oldJ).getKey();
            for (k = newJ; k < newJobs.size() && !newJobs.get(k).getKey().equals(jobKey); ++k) {
            }
            if (k == newJobs.size()) {
                this.indicesAdd(oldJ);
                continue;
            }
            newJ = k + 1;
        }
        if (this.indicesCount != 0) {
            int[] childIndices = new int[this.indicesCount];
            children2 = new Object[this.indicesCount];
            for (i = this.indicesCount - 1; i >= 0; --i) {
                childIndices[i] = this.indices[i];
                children2[i] = this.jobNodes.remove(this.indices[i]);
            }
            ExplorerTreeModel.fireTreeNodesRemoved(jobTree, jobPath, childIndices, children2);
        }
        this.indicesClear();
        for (int i2 = 0; i2 < newJobs.size(); ++i2) {
            jobKey = newJobs.get(i2).getKey();
            if (i2 < this.jobNodes.size() && this.jobNodes.get(i2).getKey().equals(jobKey)) continue;
            this.jobNodes.add(i2, new JobTreeNode(newJobs.get(i2)));
            this.indicesAdd(i2);
        }
        if (this.indicesCount != 0) {
            int[] childIndices = new int[this.indicesCount];
            children2 = new Object[this.indicesCount];
            for (i = 0; i < this.indicesCount; ++i) {
                childIndices[i] = this.indices[i];
                children2[i] = this.jobNodes.get(this.indices[i]);
            }
            ExplorerTreeModel.fireTreeNodesInserted(jobTree, jobPath, childIndices, children2);
        }
        assert (newJobs.size() == this.jobNodes.size());
        this.indicesClear();
        for (int i3 = 0; i3 < this.jobNodes.size(); ++i3) {
            JobTreeNode node = this.jobNodes.get(i3);
            Job.Inform jobInfo = newJobs.get(i3);
            assert (node.getKey().equals(jobInfo.getKey()));
            if (!node.toString().equals(jobInfo.toString())) {
                this.indicesAdd(i3);
            }
            node.setInfo(jobInfo);
        }
        if (this.indicesCount != 0) {
            int[] childIndices = new int[this.indicesCount];
            children2 = new Object[this.indicesCount];
            for (int i4 = 0; i4 < this.indicesCount; ++i4) {
                childIndices[i4] = this.indices[i4];
                children2[i4] = this.jobNodes.get(this.indices[i4]);
            }
            ExplorerTreeModel.fireTreeNodesChanged(jobTree, jobPath, childIndices, children2);
        }
    }

    void indicesClear() {
        this.indicesCount = 0;
    }

    void indicesAdd(int index) {
        if (this.indicesCount >= this.indices.length) {
            int[] newIndices = new int[this.indices.length * 2];
            System.arraycopy(this.indices, 0, newIndices, 0, this.indices.length);
            this.indices = newIndices;
        }
        this.indices[this.indicesCount++] = index;
    }

    public static class JobTreeNode
    implements TreeNode {
        private Job.Inform jobInfo;

        JobTreeNode(Job.Inform jobInfo) {
            this.jobInfo = jobInfo;
        }

        private void setInfo(Job.Inform jobInfo) {
            assert (this.getKey().equals(jobInfo.getKey()));
            this.jobInfo = jobInfo;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public TreeNode getParent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIndex(TreeNode node) {
            if (node == null) {
                throw new IllegalArgumentException("argument is null");
            }
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        public Enumeration children() {
            return DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }

        public String toString() {
            return this.jobInfo.toString();
        }

        public Job.Key getKey() {
            return this.jobInfo.getKey();
        }

        public String getInfo() {
            return this.jobInfo.getInfo();
        }
    }

    private static class JobMenuActionListener
    implements ActionListener {
        private final JobTreeNode jobNode;

        JobMenuActionListener(JobTreeNode jobNode) {
            this.jobNode = jobNode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            if (source.getText().equals("Get Info")) {
                System.out.println(this.jobNode.getInfo());
            }
            if (source.getText().equals("Abort")) {
                this.jobNode.jobInfo.abort();
            }
            if (source.getText().equals("Delete") && !this.jobNode.jobInfo.remove()) {
                System.out.println("Cannot delete running jobs.  Wait till it is finished, or abort it");
                return;
            }
        }
    }
}

