/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.SpiceExemptedNets;
import com.sun.electric.tool.io.output.SpiceParasiticsGeneral;
import com.sun.electric.tool.io.output.SpiceSegmentedNets;
import com.sun.electric.tool.io.output.Topology;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SpiceParasitic
extends SpiceParasiticsGeneral {
    private List<Network> networkList;
    private List<ArcInst> arcList;
    int tLineCount = 0;
    String n0 = "";
    String n1 = "";
    String preLayer = "";
    ArcInst preAi = null;
    ArcInst currAi = null;
    boolean alreadyPrinted = false;

    SpiceParasitic(Spice.SpicePreferences localPrefs) {
        super(localPrefs);
        this.segmentedParasiticInfo = new ArrayList();
    }

    @Override
    public SpiceSegmentedNets initializeSegments(Cell cell, Topology.CellNetInfo cni, Technology layoutTechnology, SpiceExemptedNets exemptedNets, Topology.MyCellInfo info) {
        boolean verboseSegmentNames = this.localPrefs.parasiticsUseVerboseNaming;
        SimulationTool.SpiceParasitics spLevel = this.localPrefs.parasiticsLevel;
        SpiceSegmentedNets segmentedNets = new SpiceSegmentedNets(cell, verboseSegmentNames, cni, this.localPrefs);
        this.segmentedParasiticInfo.add(segmentedNets);
        this.curSegmentedNets = segmentedNets;
        Netlist netList = cni.getNetList();
        double scale = layoutTechnology.getScale();
        HashMap<Network, Network> exemptedNetsFound = new HashMap<Network, Network>();
        Iterator<ArcInst> ait = cell.getArcs();
        while (ait.hasNext()) {
            ArcInst ai = ait.next();
            boolean extractNet = true;
            if (segmentedNets.isPowerGround(ai.getHeadPortInst())) {
                extractNet = false;
            }
            if (ai.getProto().getFunction() == ArcProto.Function.NONELEC) {
                extractNet = false;
            }
            Network net = netList.getNetwork(ai, 0);
            double cap = 0.0;
            double res = 0.0;
            if (extractNet && this.localPrefs.parasiticsUseExemptedNetsFile) {
                if (this.localPrefs.parasiticsIgnoreExemptedNets) {
                    if (exemptedNets.isExempted(info.getNetID(net))) {
                        extractNet = false;
                        cap = 0.0;
                        if (!exemptedNetsFound.containsKey(net)) {
                            System.out.println("Not extracting net " + cell.describe(false) + " " + net.getName());
                            exemptedNetsFound.put(net, net);
                            cap = exemptedNets.getReplacementCap(cell, net);
                        }
                    }
                } else if (exemptedNets.isExempted(info.getNetID(net))) {
                    if (!exemptedNetsFound.containsKey(net)) {
                        System.out.println("Extracting net " + cell.describe(false) + " " + net.getName());
                        exemptedNetsFound.put(net, net);
                        extractNet = true;
                    }
                } else {
                    extractNet = false;
                }
            }
            if (!extractNet) continue;
            double length = ai.getLambdaLength() * scale / 1000.0;
            double width = ai.getLambdaBaseWidth() * scale / 1000.0;
            double area = length * width;
            double fringe = length * 2.0;
            Technology tech = ai.getProto().getTechnology();
            for (Poly poly : tech.getShapeOfArc(ai)) {
                Layer layer;
                if (poly.getStyle().isText() || poly.isPseudoLayer() || (layer = poly.getLayer()).getTechnology() != layoutTechnology || layer.isDiffusionLayer()) continue;
                if (this.localPrefs.parasiticsExtractsC) {
                    double areacap = area * layer.getCapacitance();
                    double fringecap = fringe * layer.getEdgeCapacitance();
                    cap = areacap + fringecap;
                }
                if (!this.localPrefs.parasiticsExtractsR) continue;
                res = length / width * layer.getResistance();
            }
            int arcPImodels = SpiceSegmentedNets.getNumPISegments(res, layoutTechnology.getMaxSeriesResistance());
            segmentedNets.putSegment(ai.getHeadPortInst(), cap / (double)(arcPImodels + 1));
            segmentedNets.putSegment(ai.getTailPortInst(), cap / (double)(arcPImodels + 1));
            segmentedNets.addArcRes(ai, res);
            segmentedNets.addArcCap(ai, cap);
            segmentedNets.addExtractedNet(net);
        }
        Iterator<NodeInst> aIt = cell.getNodes();
        while (aIt.hasNext()) {
            NodeInst ni = aIt.next();
            if (!ni.isCellInstance()) {
                if (((PrimitiveNode)ni.getProto()).getGroupFunction() != PrimitiveNode.Function.TRANS) continue;
                PortInst gate0 = ni.getTransistorGatePort();
                PortInst gate1 = ni.getTransistorAltGatePort();
                Network gateNet0 = netList.getNetwork(gate0);
                if (gate0 == gate1 || !segmentedNets.isExtractedNet(gateNet0)) continue;
                segmentedNets.shortSegments(gate0, gate1);
                continue;
            }
            Cell subCell = (Cell)ni.getProto();
            SpiceSegmentedNets subNets = this.getSegmentedNets(subCell);
            if (subNets == null) continue;
            Iterator<List<String>> it = subNets.getShortedExports();
            while (it.hasNext()) {
                List<String> exports = it.next();
                PortInst pi1 = null;
                for (String exportName : exports) {
                    PortInst pi = ni.findPortInst(exportName);
                    if (pi1 == null) {
                        pi1 = pi;
                        continue;
                    }
                    Network net = netList.getNetwork(pi);
                    if (!segmentedNets.isExtractedNet(net)) continue;
                    segmentedNets.shortSegments(pi1, pi);
                }
            }
        }
        return segmentedNets;
    }

    @Override
    public void writeSubcircuitHeader(Topology.CellSignal cs, StringBuffer infstr) {
        Network net = cs.getNetwork();
        HashMap<String, ArrayList<String>> shortedExportsMap = new HashMap<String, ArrayList<String>>();
        Iterator<Export> it = net.getExports();
        while (it.hasNext()) {
            Export e = it.next();
            PortInst pi = e.getOriginalPort();
            String name = this.curSegmentedNets.getNetName(pi);
            ArrayList<String> shortedExports = (ArrayList<String>)shortedExportsMap.get(name);
            if (shortedExports == null) {
                shortedExports = new ArrayList<String>();
                shortedExportsMap.put(name, shortedExports);
                infstr.append(" " + name);
            }
            shortedExports.add(e.getName());
        }
        for (List shortedExports : shortedExportsMap.values()) {
            if (shortedExports.size() <= 1) continue;
            this.curSegmentedNets.addShortedExports(shortedExports);
        }
    }

    @Override
    public void getParasiticName(Nodable no, Network subNet, SpiceSegmentedNets subSegmentedNets, StringBuffer infstr) {
        ArrayList<String> exportNames = new ArrayList<String>();
        Iterator<Export> it = subNet.getExports();
        while (it.hasNext()) {
            Export e = it.next();
            PortInst pi = e.getOriginalPort();
            String name = subSegmentedNets.getNetName(pi);
            if (exportNames.contains(name)) continue;
            exportNames.add(name);
            pi = no.getNodeInst().findPortInstFromEquivalentProto(no.getProto().findPortProto(e.getNameKey()));
            name = this.curSegmentedNets.getNetName(pi);
            infstr.append(" " + name);
        }
    }

    @Override
    public SpiceSegmentedNets getSegmentedNets(Cell cell) {
        for (SpiceSegmentedNets seg : this.segmentedParasiticInfo) {
            if (seg.getCell() != cell) continue;
            return seg;
        }
        return null;
    }

    @Override
    public void backAnnotate() {
        HashSet<Cell> cellsToClear = new HashSet<Cell>();
        ArrayList<PortInst> capsOnPorts = new ArrayList<PortInst>();
        ArrayList<String> valsOnPorts = new ArrayList<String>();
        ArrayList<ArcInst> resOnArcs = new ArrayList<ArcInst>();
        ArrayList<Double> valsOnArcs = new ArrayList<Double>();
        for (SpiceSegmentedNets segmentedNets : this.segmentedParasiticInfo) {
            Cell cell = segmentedNets.getCell();
            if (cell.getView() != View.LAYOUT) continue;
            cellsToClear.add(cell);
            for (SpiceSegmentedNets.NetInfo info : segmentedNets.getUniqueSegments()) {
                PortInst pi = info.getPortIterator().next();
                if (!(info.getCap() > cell.getTechnology().getMinCapacitance())) continue;
                capsOnPorts.add(pi);
                valsOnPorts.add(TextUtils.formatDouble(info.getCap(), 2) + "fF");
            }
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                Double res = segmentedNets.getRes(ai);
                resOnArcs.add(ai);
                valsOnArcs.add(res);
            }
        }
        new BackAnnotateJob(cellsToClear, capsOnPorts, valsOnPorts, resOnArcs, valsOnArcs);
    }

    @Override
    public void writeNewSpiceCode(Cell cell, Topology.CellNetInfo cni, Technology layoutTechnology, Spice out) {
        double scale = layoutTechnology.getScale();
        this.networkList = new ArrayList<Network>();
        this.arcList = new ArrayList<ArcInst>();
        for (SpiceSegmentedNets segmentedNets : this.segmentedParasiticInfo) {
            if (segmentedNets.getCell() != cell) continue;
            Iterator<Network> itNet = cni.getNetList().getNetworks();
            while (itNet.hasNext()) {
                ArcInst MainAi;
                Network net = itNet.next();
                Iterator<ArcInst> itArc = net.getArcs();
                ArcInst FirstAi = itArc.next();
                double sqrs = 0.0;
                double cap = 0.0;
                double res = 0.0;
                boolean startAgain = false;
                ArcInst CurrAi = MainAi = FirstAi;
                Iterator<Connection> ConIT = MainAi.getHeadPortInst().getConnections();
                PortInst MainPI = MainAi.getHeadPortInst();
                this.n0 = segmentedNets.getNetName(MainAi.getHeadPortInst());
                if (this.networkList != null && this.networkList.contains(net)) continue;
                this.networkList.add(net);
                while (ConIT.hasNext()) {
                    Connection conn = ConIT.next();
                    CurrAi = conn.getArc();
                    if (!this.arcList.contains(CurrAi)) {
                        double length = CurrAi.getLambdaLength() * scale / 1000.0;
                        double width = CurrAi.getLambdaBaseWidth() * scale / 1000.0;
                        Poly[] polya = layoutTechnology.getShapeOfArc(CurrAi);
                        Poly poly = polya[0];
                        if (poly.isPseudoLayer()) continue;
                        String curLayer = poly.getLayer().getName();
                        if (this.preLayer == curLayer || this.preLayer == "") {
                            this.preLayer = curLayer;
                            this.arcList.add(CurrAi);
                            sqrs += length / width;
                            res += segmentedNets.getRes(CurrAi).doubleValue();
                            cap += segmentedNets.getArcCap(CurrAi);
                        } else {
                            this.preLayer = curLayer;
                            this.arcList.add(null);
                            this.arcList.add(CurrAi);
                            if (sqrs > 3.0) {
                                out.multiLinePrint(false, "XP" + this.tLineCount + " " + this.n0 + " " + this.n1 + " RCLINE R=" + TextUtils.formatDouble(res / sqrs, 2) + " C=" + TextUtils.formatDouble(cap / sqrs, 2) + "fF len=" + TextUtils.formatDouble(sqrs, 2) + "\n");
                                ++this.tLineCount;
                                this.n0 = this.n1;
                            }
                            sqrs = 0.0;
                            res = 0.0;
                            cap = 0.0;
                            sqrs += length / width;
                            res += segmentedNets.getRes(CurrAi).doubleValue();
                            cap += segmentedNets.getArcCap(CurrAi);
                        }
                        if (MainPI == CurrAi.getHeadPortInst()) {
                            MainAi = CurrAi;
                            MainPI = MainAi.getTailPortInst();
                            ConIT = MainAi.getTailPortInst().getConnections();
                            this.n1 = segmentedNets.getNetName(MainAi.getTailPortInst());
                        } else {
                            MainAi = CurrAi;
                            MainPI = MainAi.getHeadPortInst();
                            ConIT = MainAi.getHeadPortInst().getConnections();
                            this.n1 = segmentedNets.getNetName(MainAi.getHeadPortInst());
                        }
                    }
                    if (ConIT.hasNext() || startAgain) continue;
                    ConIT = FirstAi.getHeadPortInst().getConnections();
                    MainPI = FirstAi.getHeadPortInst();
                    startAgain = true;
                    if (sqrs > 3.0) {
                        out.multiLinePrint(false, "XP" + this.tLineCount + " " + this.n0 + " " + this.n1 + " RCLINE R=" + TextUtils.formatDouble(res / sqrs, 2) + " C=" + TextUtils.formatDouble(cap / sqrs, 2) + "fF len=" + TextUtils.formatDouble(sqrs, 2) + "\n");
                        ++this.tLineCount;
                    }
                    this.preLayer = "";
                    sqrs = 0.0;
                    res = 0.0;
                    cap = 0.0;
                    this.n0 = segmentedNets.getNetName(FirstAi.getHeadPortInst());
                }
                if (!(sqrs > 3.0) || !(res > 0.0) || !(cap > 0.0)) continue;
                out.multiLinePrint(false, "XP" + this.tLineCount + " " + this.n0 + " " + this.n1 + " RCLINE R=" + TextUtils.formatDouble(res / sqrs, 2) + " C=" + TextUtils.formatDouble(cap / sqrs, 2) + "fF len=" + TextUtils.formatDouble(sqrs, 2) + "\n");
                ++this.tLineCount;
            }
        }
        if (!this.alreadyPrinted) {
            out.multiLinePrint(false, ".subckt RCLINE n1 n2 \n");
            out.multiLinePrint(false, "o1 n1 0 n2 0 TRC \n");
            out.multiLinePrint(false, ".model TRC ltra R={R} C={C} len={len} \n");
            out.multiLinePrint(false, ".ends RCLINE \n");
            this.alreadyPrinted = true;
        }
    }

    private static class BackAnnotateJob
    extends Job {
        private Set<Cell> cellsToClear;
        private List<PortInst> capsOnPorts;
        private List<String> valsOnPorts;
        private List<ArcInst> resOnArcs;
        private List<Double> valsOnArcs;

        private BackAnnotateJob(Set<Cell> cellsToClear, List<PortInst> capsOnPorts, List<String> valsOnPorts, List<ArcInst> resOnArcs, List<Double> valsOnArcs) {
            super("Spice Layout Back Annotate", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.capsOnPorts = capsOnPorts;
            this.valsOnPorts = valsOnPorts;
            this.resOnArcs = resOnArcs;
            this.valsOnArcs = valsOnArcs;
            this.cellsToClear = cellsToClear;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            int i;
            EditingPreferences ep = this.getEditingPreferences();
            TextDescriptor ctd = ep.getPortInstTextDescriptor().withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
            TextDescriptor rtd = ep.getArcTextDescriptor().withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
            int capCount = 0;
            int resCount = 0;
            for (Cell cell : this.cellsToClear) {
                Iterator<NodeInst> it = cell.getNodes();
                while (it.hasNext()) {
                    NodeInst ni = it.next();
                    Iterator<PortInst> pit = ni.getPortInsts();
                    while (pit.hasNext()) {
                        PortInst pi = pit.next();
                        Variable var = pi.getVar(SpiceParasiticsGeneral.ATTR_C);
                        if (var == null) continue;
                        pi.delVar(var.getKey());
                    }
                }
            }
            for (i = 0; i < this.capsOnPorts.size(); ++i) {
                PortInst pi = this.capsOnPorts.get(i);
                String str = this.valsOnPorts.get(i);
                pi.newVar(SpiceParasiticsGeneral.ATTR_C, (Object)str, ctd);
                ++resCount;
            }
            for (i = 0; i < this.resOnArcs.size(); ++i) {
                ArcInst ai = this.resOnArcs.get(i);
                Double res = this.valsOnArcs.get(i);
                Variable var = ai.getVar(SpiceParasiticsGeneral.ATTR_R);
                if (res == null && var != null) {
                    ai.delVar(SpiceParasiticsGeneral.ATTR_R);
                }
                if (res == null) continue;
                ai.newVar(SpiceParasiticsGeneral.ATTR_R, (Object)res, rtd);
                ++resCount;
            }
            System.out.println("Back-annotated " + resCount + " Resistors and " + capCount + " Capacitors");
            return true;
        }
    }
}

