/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;
import com.sun.electric.tool.generator.layout.gates.Inv;
import com.sun.electric.tool.generator.layout.gates.Nms1;
import java.util.ArrayList;
import java.util.Iterator;

public class KeeperLow {
    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    public static Cell makePart(Cell schem, VarContext context, StdCellParams stdCell) {
        TechType tech = stdCell.getTechType();
        EditingPreferences ep = stdCell.getEditingPreferences();
        Iterator<NodeInst> nodes = schem.getNodes();
        double szNmos = -1.0;
        double szK = -1.0;
        double szI = -1.0;
        while (nodes.hasNext()) {
            NodeInst ni = nodes.next();
            String nm = ni.getProto().getName();
            if (nm.equals("nms1K{ic}")) {
                szNmos = StdCellParams.getSize(ni, context);
                continue;
            }
            if (nm.equals("invK{ic}")) {
                szK = StdCellParams.getSize(ni, context);
                continue;
            }
            if (!nm.equals("inv{ic}")) continue;
            szI = StdCellParams.getSize(ni, context);
        }
        KeeperLow.error(szNmos == -1.0, "KeeperLow: nmos not found");
        KeeperLow.error(szK == -1.0, "KeeperLow: invK not found");
        KeeperLow.error(szI == -1.0, "KeeperLow: inv not found");
        double sz = stdCell.roundSize(szK);
        Cell keep = stdCell.findPart("keeper_low", sz);
        if (keep != null) {
            return keep;
        }
        keep = stdCell.newPart("keeper_low", sz);
        Cell invKProto = Inv.makePart(szK, stdCell);
        NodeInst invK = LayoutLib.newNodeInst(invKProto, ep, 0.0, 0.0, 0.0, 0.0, 0.0, keep);
        Cell invIProto = Inv.makePart(szI, stdCell);
        NodeInst invI = LayoutLib.newNodeInst(invIProto, ep, 0.0, 0.0, 0.0, 0.0, 0.0, keep);
        Cell nmosProto = Nms1.makePart(szNmos, stdCell);
        NodeInst nmos = LayoutLib.newNodeInst(nmosProto, ep, 0.0, 0.0, 0.0, 0.0, 0.0, keep);
        ArrayList<NodeInst> l = new ArrayList<NodeInst>();
        l.add(nmos);
        l.add(invK);
        l.add(invI);
        LayoutLib.abutLeftRight(l);
        TrackRouterH vdd = new TrackRouterH(tech.m2(), 10.0, tech, ep, keep);
        vdd.connect(new NodeInst[]{invK, invI}, "vdd");
        TrackRouterH gnd = new TrackRouterH(tech.m2(), 10.0, tech, ep, keep);
        gnd.connect(new NodeInst[]{nmos, invK, invI}, "gnd");
        TrackRouterH d = new TrackRouterH(tech.m2(), 4.0, LayoutLib.roundCenterY(nmos.findPortInst("d")), tech, ep, keep);
        d.connect(new PortInst[]{nmos.findPortInst("d"), invK.findPortInst("out"), invI.findPortInst("in")});
        double trackY = stdCell.getTrackY(-1);
        TrackRouterH d_bar = new TrackRouterH(tech.m2(), 4.0, trackY, tech, ep, keep);
        d_bar.connect(new PortInst[]{invK.findPortInst("in"), invI.findPortInst("out")});
        Export.newInstance(keep, nmos.findPortInst("g"), "mc", ep).setCharacteristic(PortCharacteristic.IN);
        Export.newInstance(keep, nmos.findPortInst("d"), "d", ep).setCharacteristic(PortCharacteristic.BIDIR);
        Export.newInstance(keep, invK.findPortInst("vdd"), "vdd", ep).setCharacteristic(PortCharacteristic.PWR);
        Export.newInstance(keep, invK.findPortInst("gnd"), "gnd", ep).setCharacteristic(PortCharacteristic.GND);
        stdCell.addPmosWell(0.0, nmos.getBounds().getWidth(), keep);
        stdCell.addEssentialBounds(0.0, invI.getBounds().getMaxX(), keep);
        return keep;
    }
}

