/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3.machine;

import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStar;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarGoalBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarMapBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarMapVisitorBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarNode;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarRegionNode;
import com.sun.electric.tool.routing.experimentalAStar3.machine.AStarMachine;
import com.sun.electric.tool.routing.experimentalAStar3.memorymanager.ObjectPool;
import com.sun.electric.tool.routing.experimentalAStar3.storage.AStarClosedListReferencing;
import com.sun.electric.tool.routing.experimentalAStar3.storage.AStarOpenListCheapList;
import java.util.List;

public class AStarRegionMachine
implements AStarMachine<AStarRegionNode>,
AStarMapVisitorBase<AStarRegionNode> {
    private ObjectPool<AStarRegionNode> nodePool;
    private AStarOpenListCheapList<AStarRegionNode> openList;
    private AStarClosedListReferencing<AStarRegionNode> closedList;
    private AStarMapBase<AStarRegionNode> map = null;
    private AStarGoalBase<AStarRegionNode> goal = null;

    public AStarRegionMachine(ObjectPool<AStarRegionNode> nodePool) {
        this.nodePool = nodePool;
        this.openList = new AStarOpenListCheapList();
        this.closedList = new AStarClosedListReferencing();
    }

    @Override
    public List<AStarRegionNode> findPath(int startX, int startY, int startZ, int goalX, int goalY, int goalZ) {
        if (this.map == null) {
            throw new IllegalStateException("The searched map must be specified before path search can be done.");
        }
        if (this.goal == null) {
            throw new IllegalStateException("The goal object must be specified before path search can be done.");
        }
        AStarRegionNode startRegion = this.map.nodeAt(startX, startY, startZ);
        AStarRegionNode goalRegion = this.map.nodeAt(goalX, goalY, goalZ);
        assert (startRegion != null);
        assert (goalRegion != null);
        this.goal.setGoalNode(goalRegion);
        int goalDistance = this.goal.distanceToGoal(startX, startY, startZ);
        goalRegion.initialize(null, goalDistance, 0, goalDistance, goalX, goalY, goalZ);
        startRegion.initialize(null, 0, goalDistance, goalDistance, startX, startY, startZ);
        this.openList.addNodeToOpenList(startRegion);
        return AStar.findPath(this.openList, this.closedList, this.map, this.goal, this.nodePool, this);
    }

    @Override
    public void setUpSearchSpace(AStarMapBase<AStarRegionNode> newMap, AStarGoalBase<AStarRegionNode> newGoal) {
        if (newMap == null) {
            throw new IllegalArgumentException("The map to search may not be null.");
        }
        if (newGoal == null) {
            throw new IllegalArgumentException("The goal object may not be null.");
        }
        this.map = newMap;
        this.openList.setMap(this.map);
        this.closedList.setMap(this.map);
        this.goal = newGoal;
        this.goal.setNodeStorage(this.openList);
    }

    @Override
    public void visitNeighbour(AStarRegionNode origin, int x2, int y, int z) {
        if (origin.getX() == x2 && (!origin.isTerminalRegion() && origin.getVerticalCapacity() == 0 || !this.map.nodeAt(x2, y, z).isTerminalRegion() && this.map.nodeAt(x2, y, z).getVerticalCapacity() == 0)) {
            return;
        }
        if (origin.getY() == y && (!origin.isTerminalRegion() && origin.getHorizontalCapacity() == 0 || !this.map.nodeAt(x2, y, z).isTerminalRegion() && this.map.nodeAt(x2, y, z).getHorizontalCapacity() == 0)) {
            return;
        }
        int costFromStart = origin.getCostFromStart() + this.goal.getNodeCost(origin, x2, y, z);
        int costToGoal = this.goal.distanceToGoal(x2, y, z);
        int totalCost = costFromStart + costToGoal;
        AStarRegionNode foundNode = this.openList.findOpenNode(x2, y, z);
        AStarNode portal = null;
        boolean foundCheaperPath = false;
        if (foundNode != null) {
            if (totalCost < foundNode.getTotalCost() && (portal = this.findPortal(origin, foundNode)) != null) {
                foundCheaperPath = true;
                this.openList.removeNodeFromOpenList(foundNode);
            }
        } else {
            foundNode = this.closedList.findClosedNode(x2, y, z);
            if (foundNode != null) {
                if (totalCost < foundNode.getTotalCost() && (portal = this.findPortal(origin, foundNode)) != null) {
                    foundCheaperPath = true;
                    this.closedList.removeNodeFromClosedList(foundNode);
                }
            } else {
                foundNode = this.map.nodeAt(x2, y, z);
                portal = this.findPortal(origin, foundNode);
                if (portal != null) {
                    foundCheaperPath = true;
                }
            }
        }
        if (foundCheaperPath) {
            foundNode.initialize(origin, costFromStart, costToGoal, totalCost, x2, y, z);
            foundNode.setEntryPoint(portal);
            this.openList.addNodeToOpenList(foundNode);
        }
    }

    public AStarNode findPortal(AStarRegionNode originRegion, AStarRegionNode targetRegion) {
        AStarNode result2;
        block19: {
            int fy;
            int oy;
            block21: {
                block20: {
                    int fx;
                    int ox;
                    block18: {
                        result2 = null;
                        int viaX = originRegion.getEntryPoint().getX();
                        int viaY = originRegion.getEntryPoint().getY();
                        if (originRegion.getZ() != targetRegion.getZ()) {
                            int count2 = 0;
                            while (viaY + count2 < originRegion.height || viaY - count2 >= 0 || viaX + count2 < originRegion.width || viaX - count2 >= 0) {
                                if (viaX + count2 < originRegion.width && !originRegion.isTileBlocked(viaX + count2, viaY) && !targetRegion.isTileBlocked(viaX + count2, viaY) && originRegion.routingMap.nodeAt(viaX + count2, viaY, 0).getTerminalCount() == 0 && targetRegion.routingMap.nodeAt(viaX + count2, viaY, 0).getTerminalCount() == 0) {
                                    return targetRegion.routingMap.nodeAt(viaX + count2, viaY, 0);
                                }
                                if (viaX - count2 >= 0 && !originRegion.isTileBlocked(viaX - count2, viaY) && !targetRegion.isTileBlocked(viaX - count2, viaY) && originRegion.routingMap.nodeAt(viaX - count2, viaY, 0).getTerminalCount() == 0 && targetRegion.routingMap.nodeAt(viaX - count2, viaY, 0).getTerminalCount() == 0) {
                                    return targetRegion.routingMap.nodeAt(viaX - count2, viaY, 0);
                                }
                                if (viaY + count2 < originRegion.height && !originRegion.isTileBlocked(viaX, viaY + count2) && !targetRegion.isTileBlocked(viaX, viaY + count2) && originRegion.routingMap.nodeAt(viaX, viaY + count2, 0).getTerminalCount() == 0 && targetRegion.routingMap.nodeAt(viaX, viaY + count2, 0).getTerminalCount() == 0) {
                                    return targetRegion.routingMap.nodeAt(viaX, viaY + count2, 0);
                                }
                                if (viaY - count2 >= 0 && !originRegion.isTileBlocked(viaX, viaY - count2) && !targetRegion.isTileBlocked(viaX, viaY - count2) && originRegion.routingMap.nodeAt(viaX, viaY - count2, 0).getTerminalCount() == 0 && targetRegion.routingMap.nodeAt(viaX, viaY - count2, 0).getTerminalCount() == 0) {
                                    return targetRegion.routingMap.nodeAt(viaX, viaY - count2, 0);
                                }
                                ++count2;
                            }
                            return null;
                        }
                        ox = originRegion.getX();
                        fx = targetRegion.getX();
                        oy = originRegion.getY();
                        fy = targetRegion.getY();
                        if (ox != fx - 1) break block18;
                        int targetX = 0;
                        int originX = originRegion.width - 1;
                        int y = originRegion.getEntryPoint().getY();
                        int count3 = 0;
                        while (y + count3 < originRegion.height || y - count3 >= 0) {
                            if (y + count3 < originRegion.height && originRegion.isPortalWithPath(originX, y + count3, false) && targetRegion.isPortalWithPath(targetX, y + count3, false)) {
                                return targetRegion.getMap(false).nodeAt(targetX, y + count3, 0);
                            }
                            if (y - count3 >= 0 && originRegion.isPortalWithPath(originX, y - count3, false) && targetRegion.isPortalWithPath(targetX, y - count3, false)) {
                                return targetRegion.getMap(false).nodeAt(targetX, y - count3, 0);
                            }
                            ++count3;
                        }
                        break block19;
                    }
                    if (ox != fx + 1) break block20;
                    int targetX = originRegion.width - 1;
                    int originX = 0;
                    int y = originRegion.getEntryPoint().getY();
                    int count4 = 0;
                    while (y + count4 < originRegion.height || y - count4 >= 0) {
                        if (y + count4 < originRegion.height && originRegion.isPortalWithPath(originX, y + count4, false) && targetRegion.isPortalWithPath(targetX, y + count4, false)) {
                            return targetRegion.getMap(false).nodeAt(targetX, y + count4, 0);
                        }
                        if (y - count4 >= 0 && originRegion.isPortalWithPath(originX, y - count4, false) && targetRegion.isPortalWithPath(targetX, y - count4, false)) {
                            return targetRegion.getMap(false).nodeAt(targetX, y - count4, 0);
                        }
                        ++count4;
                    }
                    break block19;
                }
                if (oy != fy + 1) break block21;
                int targetY = originRegion.height - 1;
                int originY = 0;
                int x2 = originRegion.getEntryPoint().getX();
                int count5 = 0;
                while (x2 + count5 < originRegion.width || x2 - count5 >= 0) {
                    if (x2 + count5 < originRegion.width && originRegion.isPortalWithPath(x2 + count5, originY, true) && targetRegion.isPortalWithPath(x2 + count5, targetY, true)) {
                        return targetRegion.getMap(false).nodeAt(x2 + count5, targetY, 0);
                    }
                    if (x2 - count5 >= 0 && originRegion.isPortalWithPath(x2 - count5, originY, true) && targetRegion.isPortalWithPath(x2 - count5, targetY, true)) {
                        return targetRegion.getMap(false).nodeAt(x2 - count5, targetY, 0);
                    }
                    ++count5;
                }
                break block19;
            }
            if (oy != fy - 1) break block19;
            int targetY = 0;
            int originY = originRegion.height - 1;
            int x3 = originRegion.getEntryPoint().getX();
            int count6 = 0;
            while (x3 + count6 < originRegion.width || x3 - count6 >= 0) {
                if (x3 + count6 < originRegion.width && originRegion.isPortalWithPath(x3 + count6, originY, true) && targetRegion.isPortalWithPath(x3 + count6, targetY, true)) {
                    return targetRegion.getMap(false).nodeAt(x3 + count6, targetY, 0);
                }
                if (x3 - count6 >= 0 && originRegion.isPortalWithPath(x3 - count6, originY, true) && targetRegion.isPortalWithPath(x3 - count6, targetY, true)) {
                    return targetRegion.getMap(false).nodeAt(x3 - count6, targetY, 0);
                }
                ++count6;
            }
        }
        return result2;
    }
}

