/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.PowerChannel;
import com.sun.electric.tool.simulation.test.VoltageReadable;

public class PowerChannelResistorVoltageReadable
extends PowerChannel {
    private boolean fastConvergence;
    private PowerChannel pc;
    private double ohms;
    private VoltageReadable vr;
    private static float EPSILON_VOLTS = 0.01f;

    public void setCurrent(float amps) {
        this.pc.setCurrent(amps);
    }

    public float getCurrentSetpoint() {
        return this.pc.getCurrentSetpoint();
    }

    public float readCurrent() {
        double vr_current;
        double pc_current = this.pc.readCurrent();
        if (Math.abs(pc_current - (vr_current = (double)this.vr.readVoltage() / this.ohms)) > (double)EPSILON_VOLTS * this.ohms) {
            throw new RuntimeException("PowerChannel and VoltageReadable disagree on current; perhaps you gave the wrong resistor value?\n  PowerChannel    says: " + pc_current + "\n" + "  VoltageReadable says: " + vr_current);
        }
        return (float)vr_current;
    }

    public float readVoltage() {
        this.readCurrent();
        return this.pc.readVoltage() - this.vr.readVoltage();
    }

    public void setVoltageNoWait(float volts) {
        throw new RuntimeException("cannot do this in a " + this.getClass().getName());
    }

    public void waitForVoltage(float setVolts) {
        throw new RuntimeException("cannot do this in a " + this.getClass().getName());
    }

    public float getVoltageSetpoint() {
        throw new RuntimeException("cannot do this in a " + this.getClass().getName());
    }

    public void setVoltageWait(float v) {
        this.readCurrent();
        while (true) {
            double vs = this.pc.readVoltage();
            double vread = this.vr.readVoltage();
            double i = vread / 1000.0;
            double vl = vs - this.ohms * i;
            System.err.print("\r\u001b[0K\r");
            System.err.print(this.getClass().getSimpleName() + ".setVoltageWait():" + " desired/actual=" + v + "/" + vl);
            if (!(vl + (double)EPSILON_VOLTS < (double)v) && !(vl - (double)EPSILON_VOLTS > (double)v)) break;
            if (this.fastConvergence) {
                double delta = (double)v + i * this.ohms - vs;
                vs += (delta *= 1.5);
            } else {
                vs = (double)v + i * this.ohms;
            }
            this.pc.setVoltageWait((float)vs);
        }
        this.readCurrent();
        System.err.print("\r\u001b[0K\r");
    }

    public PowerChannelResistorVoltageReadable(PowerChannel pc, float ohmsOfResistor, VoltageReadable voltMeterAcrossResistor, boolean fastConvergence) {
        this.pc = pc;
        this.ohms = ohmsOfResistor;
        this.vr = voltMeterAcrossResistor;
        this.fastConvergence = fastConvergence;
    }
}

