/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.CellId;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.XMLRules;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.erc.ERC;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tecEdit.ArcInfo;
import com.sun.electric.tool.user.tecEdit.GeneralInfo;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import com.sun.electric.tool.user.tecEdit.NodeInfo;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class TechToLib {
    public static void makeLibFromTech() {
        ArrayList<Technology> techs = new ArrayList<Technology>();
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            techs.add(tech);
        }
        Object[] techChoices = new String[techs.size()];
        for (int i = 0; i < techs.size(); ++i) {
            techChoices[i] = ((Technology)techs.get(i)).getTechName();
        }
        String chosen = (String)JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Technology to Edit", "Choose a technology to edit", 3, null, techChoices, Technology.getCurrent().getTechName());
        if (chosen == null) {
            return;
        }
        Technology tech = Technology.findTechnology(chosen);
        Library already = Library.findLibrary(tech.getTechName());
        if (already != null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "There is already a library called '" + tech.getTechName() + "'.  Delete it first.", "Cannot Convert Technology", 0);
            System.out.println();
            return;
        }
        new LibFromTechJob(tech, false);
    }

    public static Library makeLibFromTech(Technology tech) {
        Library lib = Library.newInstance(tech.getTechName(), null);
        if (lib == null) {
            System.out.println("Cannot create library " + tech.getTechName());
            return null;
        }
        System.out.println("Created library " + tech.getTechName() + "...");
        Cell fNp = Cell.newInstance(lib, "factors");
        if (fNp == null) {
            return null;
        }
        fNp.setInTechnologyLibrary();
        int layerTotal = 0;
        Iterator<Layer> it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            if (layer.isPseudoLayer()) continue;
            ++layerTotal;
        }
        GeneralInfo gi = new GeneralInfo();
        gi.shortName = tech.getTechShortName();
        if (gi.shortName == null) {
            gi.shortName = tech.getTechName();
        }
        gi.nonElectrical = tech.isNonElectrical();
        gi.scale = tech.getScale();
        gi.scaleRelevant = tech.isScaleRelevant();
        gi.resolution = tech.getResolution();
        gi.defaultFoundry = tech.getPrefFoundry();
        gi.defaultNumMetals = tech.getNumMetals();
        gi.description = tech.getTechDesc();
        gi.minRes = tech.getMinResistanceSetting().getDoubleFactoryValue();
        gi.minCap = tech.getMinCapacitanceSetting().getDoubleFactoryValue();
        gi.maxSeriesResistance = tech.getMaxSeriesResistance();
        gi.gateShrinkage = tech.getGateLengthSubtraction();
        gi.includeGateInResistance = tech.isGateIncluded();
        gi.includeGround = tech.isGroundNetIncluded();
        gi.gateCapacitance = tech.getGateCapacitanceSetting().getDoubleFactoryValue();
        gi.wireRatio = tech.getWireRatioSetting().getDoubleFactoryValue();
        gi.diffAlpha = tech.getDiffAlphaSetting().getDoubleFactoryValue();
        Color[] wholeMap = tech.getColorMap();
        int numLayers = tech.getNumTransparentLayers();
        gi.transparentColors = new Color[numLayers];
        for (int i = 0; i < numLayers; ++i) {
            gi.transparentColors[i] = wholeMap[1 << i];
        }
        gi.spiceLevel1Header = tech.getSpiceHeaderLevel1();
        gi.spiceLevel2Header = tech.getSpiceHeaderLevel2();
        gi.spiceLevel3Header = tech.getSpiceHeaderLevel3();
        XMLRules drcRules = tech.getFactoryDesignRules();
        if (drcRules != null) {
            int rulesSize = layerTotal * (layerTotal + 1) / 2;
            gi.conDist = new double[rulesSize];
            gi.unConDist = new double[rulesSize];
            Arrays.fill(gi.conDist, -1.0);
            Arrays.fill(gi.unConDist, -1.0);
            int ruleIndex = 0;
            for (int i1 = 0; i1 < layerTotal; ++i1) {
                for (int i2 = i1; i2 < layerTotal; ++i2) {
                    for (DRCTemplate t : drcRules.getSpacingRules(drcRules.getRuleIndex(i1, i2), DRCTemplate.DRCRuleType.SPACING, false)) {
                        if (t.ruleType == DRCTemplate.DRCRuleType.CONSPA) {
                            gi.conDist[ruleIndex] = t.getValue(0);
                            continue;
                        }
                        if (t.ruleType != DRCTemplate.DRCRuleType.UCONSPA) continue;
                        gi.unConDist[ruleIndex] = t.getValue(0);
                    }
                    ++ruleIndex;
                }
            }
        }
        gi.generate(fNp);
        HashMap<Layer, Cell> layerCells = new HashMap<Layer, Cell>();
        System.out.println("Creating the layers...");
        ArrayList<String> layerSequence = new ArrayList<String>();
        LayerInfo[] lList = new LayerInfo[layerTotal];
        Map<Layer, String> gdsLayers = tech.getGDSLayers();
        int layIndex = 0;
        Iterator<Layer> it2 = tech.getLayers();
        block5: while (it2.hasNext()) {
            Cell lNp;
            Layer layer = it2.next();
            if (layer.isPseudoLayer()) continue;
            EGraphics desc = layer.getGraphics();
            String fName = "layer-" + layer.getName() + "{lay}";
            if (lib.findNodeProto(fName) != null) {
                System.out.println("Warning: already a cell '" + fName + "'.  Creating a new version");
            }
            if ((lNp = Cell.newInstance(lib, fName)) == null) {
                return null;
            }
            lNp.setTechnology(Artwork.tech);
            lNp.setInTechnologyLibrary();
            layerCells.put(layer, lNp);
            LayerInfo li = new LayerInfo();
            lList[layIndex++] = li;
            li.name = layer.getName();
            li.fun = layer.getFunction();
            li.funExtra = layer.getFunctionExtras();
            li.pseudo = layer.isPseudoLayer();
            li.desc = desc;
            if (li.pseudo) {
                String masterName = layer.getNonPseudoLayer().getName();
                for (int j = 0; j < layIndex; ++j) {
                    if (!lList[j].name.equals(masterName)) continue;
                    lList[j].myPseudo = li;
                    continue block5;
                }
                continue;
            }
            li.cif = (String)layer.getCIFLayerSetting().getFactoryValue();
            li.dxf = (String)layer.getDXFLayerSetting().getFactoryValue();
            li.skill = (String)layer.getSkillLayerSetting().getFactoryValue();
            String gdsLayer = gdsLayers.get(layer);
            if (gdsLayer != null) {
                li.gds = gdsLayer;
            }
            li.spiRes = layer.getResistanceSetting().getDoubleFactoryValue();
            li.spiCap = layer.getCapacitanceSetting().getDoubleFactoryValue();
            li.spiECap = layer.getEdgeCapacitanceSetting().getDoubleFactoryValue();
            li.height3d = layer.getDistance();
            li.thick3d = layer.getThickness();
            li.generate(lNp);
            layerSequence.add(lNp.getName().substring(6));
        }
        if (layIndex != layerTotal) {
            System.out.println("INTERNAL ERROR: ");
        }
        String[] layerSequenceArray = layerSequence.toArray(new String[layerSequence.size()]);
        lib.newVar(Info.LAYERSEQUENCE_KEY, (Object)layerSequenceArray);
        System.out.println("Creating the arcs...");
        int arcTotal = 0;
        Iterator<ArcProto> it3 = tech.getArcs();
        while (it3.hasNext()) {
            if (it3.next().isNotUsed()) continue;
            ++arcTotal;
        }
        ArcInfo[] aList = new ArcInfo[arcTotal];
        String[] arcSequence = new String[arcTotal];
        int arcCount = 0;
        HashMap<ArcProto, Cell> arcCells = new HashMap<ArcProto, Cell>();
        Iterator<ArcProto> it4 = tech.getArcs();
        while (it4.hasNext()) {
            Cell aNp;
            ArcInfo aIn;
            ArcProto ap = it4.next();
            if (ap.isNotUsed()) continue;
            aList[arcCount] = aIn = TechToLib.makeArcInfo(ap, lList);
            arcSequence[arcCount] = ap.getName();
            ++arcCount;
            String fName = "arc-" + ap.getName() + "{lay}";
            if (lib.findNodeProto(fName) != null) {
                System.out.println("Warning: already a cell '" + fName + "'.  Creating a new version");
            }
            if ((aNp = Cell.makeInstance(lib, fName)) == null) {
                return null;
            }
            aNp.setTechnology(Artwork.tech);
            aNp.setInTechnologyLibrary();
            arcCells.put(ap, aNp);
            aIn.generate(aNp);
            double wid = ap.getDefaultLambdaBaseWidth();
            double widX4 = wid * 4.0;
            if (widX4 <= 0.0) {
                widX4 = 10.0;
            }
            Poly[] polys = ap.getShapeOfDummyArc(widX4);
            double xOff = wid * 2.0 + wid / 2.0 + ap.getLambdaWidthOffset() / 2.0;
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                Layer arcLayer = poly.getLayer().getNonPseudoLayer();
                if (arcLayer == null) continue;
                EGraphics eGraphics = arcLayer.getGraphics();
                Point2D[] points = poly.getPoints();
                for (int k = 0; k < points.length; ++k) {
                    poly.setPoint(k, points[k].getX() - xOff - 20.0, points[k].getY() - 5.0);
                }
                NodeInst ni = TechToLib.placeGeometry(poly, aNp);
                if (ni == null) continue;
                Manipulate.setPatch(ni, eGraphics);
                Cell layerCell = (Cell)layerCells.get(arcLayer);
                if (layerCell != null) {
                    ni.newVar(Info.LAYER_KEY, (Object)layerCell.getId());
                }
                ni.newVar(Info.OPTION_KEY, (Object)new Integer(8));
            }
            double i = ap.getLambdaWidthOffset() / 2.0;
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.boxNode, new Point2D.Double(-20.0 - wid * 2.5 - i, -5.0), wid * 5.0, wid, aNp);
            if (ni == null) {
                return null;
            }
            ni.newVar(Artwork.ART_COLOR, (Object)new Integer(2));
            ni.newVar(Info.OPTION_KEY, (Object)new Integer(19));
            ArcInfo.compactCell(aNp);
        }
        lib.newVar(Info.ARCSEQUENCE_KEY, (Object)arcSequence);
        System.out.println("Creating the nodes...");
        int nodeTotal = 0;
        Iterator<PrimitiveNode> it5 = tech.getNodes();
        while (it5.hasNext()) {
            if (it5.next().isNotUsed()) continue;
            ++nodeTotal;
        }
        NodeInfo[] nList = new NodeInfo[nodeTotal];
        String[] nodeSequence = new String[nodeTotal];
        int nodeIndex = 0;
        Iterator<PrimitiveNode> it6 = tech.getNodes();
        while (it6.hasNext()) {
            NodeInfo nIn;
            PrimitiveNode pnp = it6.next();
            if (pnp.isNotUsed()) continue;
            nList[nodeIndex] = nIn = TechToLib.makeNodeInfo(pnp, lList, aList);
            nodeSequence[nodeIndex] = pnp.getName();
            ++nodeIndex;
            boolean first = true;
            NodeInst oNi = NodeInst.makeDummyInstance(pnp);
            double xS = pnp.getDefWidth() * 2.0;
            double yS = pnp.getDefHeight() * 2.0;
            if (xS < 3.0) {
                xS = 3.0;
            }
            if (yS < 3.0) {
                yS = 3.0;
            }
            double nodeXPos = -xS * 2.0;
            Point2D[] point2DArray = new Point2D[]{new Point2D.Double(nodeXPos - xS, -5.0 + yS), new Point2D.Double(nodeXPos + xS, -5.0 + yS), new Point2D.Double(nodeXPos - xS, -5.0 - yS), new Point2D.Double(nodeXPos + xS, -5.0 - yS)};
            SizeOffset so = pnp.getProtoSizeOffset();
            xS = pnp.getDefWidth() - so.getLowXOffset() - so.getHighXOffset();
            yS = pnp.getDefHeight() - so.getLowYOffset() - so.getHighYOffset();
            double[] xsc = new double[4];
            double[] ysc = new double[4];
            xsc[0] = xS * 1.0;
            ysc[0] = yS * 1.0;
            xsc[1] = xS * 2.0;
            ysc[1] = yS * 1.0;
            xsc[2] = xS * 1.0;
            ysc[2] = yS * 2.0;
            xsc[3] = xS * 2.0;
            ysc[3] = yS * 2.0;
            if (pnp.isMulticut()) {
                EPoint min2size = pnp.getMulticut2Size();
                double min2X = min2size.getLambdaX();
                double min2Y = min2size.getLambdaY();
                xsc[1] = min2X;
                xsc[3] = min2X;
                ysc[2] = min2Y;
                ysc[3] = min2Y;
            }
            Cell nNp = null;
            Rectangle2D mainBounds = null;
            for (int e = 0; e < 4; ++e) {
                if (e != 0 && first || pnp.isSquare() && (e == 1 || e == 2)) continue;
                double newXSize = xsc[e] + so.getLowXOffset() + so.getHighXOffset();
                double newYSize = ysc[e] + so.getLowYOffset() + so.getHighYOffset();
                EPoint newSize = EPoint.fromLambda(newXSize, newYSize);
                oNi.lowLevelModify(oNi.getD().withAnchor(EPoint.snap(point2DArray[e])).withSize(newSize));
                Poly[] polys = tech.getShapeOfNode(oNi);
                int j = polys.length;
                for (int i = 0; i < j; ++i) {
                    NodeInst ni;
                    Poly poly = polys[i];
                    Layer nodeLayer = poly.getLayer().getNonPseudoLayer();
                    if (nodeLayer == null) continue;
                    EGraphics desc = nodeLayer.getGraphics();
                    if (e == 0) {
                        Rectangle2D polyBounds = poly.getBounds2D();
                        if (i == 0) {
                            mainBounds = polyBounds;
                        } else {
                            Rectangle2D.union(mainBounds, polyBounds, mainBounds);
                        }
                    }
                    if (first) {
                        first = false;
                        String fName = "node-" + pnp.getName() + "{lay}";
                        if (lib.findNodeProto(fName) != null) {
                            System.out.println("Warning: already a cell '" + fName + "'.  Creating a new version");
                        }
                        if ((nNp = Cell.newInstance(lib, fName)) == null) {
                            return null;
                        }
                        nNp.setTechnology(Artwork.tech);
                        nNp.setInTechnologyLibrary();
                        nIn.generate(nNp);
                    }
                    if ((ni = TechToLib.placeGeometry(poly, nNp)) == null) {
                        System.out.println("Error placing geometry " + (Object)((Object)poly.getStyle()) + " on " + nNp);
                        continue;
                    }
                    Manipulate.setPatch(ni, desc);
                    Cell layerCell = (Cell)layerCells.get(nodeLayer);
                    if (layerCell != null) {
                        ni.newVar(Info.LAYER_KEY, (Object)layerCell.getId());
                    }
                    ni.newVar(Info.OPTION_KEY, (Object)new Integer(8));
                }
                if (first) continue;
                xS = pnp.getDefWidth() - so.getLowXOffset() - so.getHighXOffset();
                yS = pnp.getDefHeight() - so.getLowYOffset() - so.getHighYOffset();
                Point2D.Double loc = new Point2D.Double(point2DArray[e].getX() + (so.getLowXOffset() - so.getHighXOffset()) / 2.0, point2DArray[e].getY() + (so.getLowYOffset() - so.getHighYOffset()) / 2.0);
                NodeInst ni = NodeInst.makeInstance(Artwork.tech.boxNode, loc, xsc[e], ysc[e], nNp);
                if (ni == null) {
                    return null;
                }
                ni.newVar(Artwork.ART_COLOR, (Object)new Integer(EGraphics.makeIndex(Color.WHITE)));
                ni.newVar(Info.OPTION_KEY, (Object)new Integer(19));
                HashMap<PrimitivePort, NodeInst> portNodes = new HashMap<PrimitivePort, NodeInst>();
                Iterator<PortProto> pIt = pnp.getPorts();
                block15: while (pIt.hasNext()) {
                    PrimitivePort opp;
                    PrimitivePort pp = (PrimitivePort)pIt.next();
                    Poly poly = tech.getShapeOfPort(oNi, pp);
                    SizeOffset pSo = Generic.tech.portNode.getProtoSizeOffset();
                    double width = poly.getBounds2D().getWidth() + pSo.getLowXOffset() + pSo.getHighXOffset();
                    double height = poly.getBounds2D().getHeight() + pSo.getLowYOffset() + pSo.getHighYOffset();
                    NodeInst pNi = NodeInst.makeInstance(Generic.tech.portNode, new Point2D.Double(poly.getCenterX(), poly.getCenterY()), width, height, nNp);
                    if (pNi == null) {
                        return null;
                    }
                    portNodes.put(pp, pNi);
                    pNi.newVar(Info.OPTION_KEY, (Object)new Integer(8));
                    pNi.newDisplayVar(Info.PORTNAME_KEY, pp.getName());
                    if (e != 0) continue;
                    if (pp.getAngle() != 0 || pp.getAngleRange() != 180) {
                        pNi.newVar(Info.PORTANGLE_KEY, (Object)new Integer(pp.getAngle()));
                        pNi.newVar(Info.PORTRANGE_KEY, (Object)new Integer(pp.getAngleRange()));
                    }
                    ArcProto[] connects = pp.getConnections();
                    ArrayList<Cell> validConns = new ArrayList<Cell>();
                    for (int i = 0; i < connects.length; ++i) {
                        Cell cell;
                        if (connects[i].getTechnology() != tech || (cell = (Cell)arcCells.get(connects[i])) == null) continue;
                        validConns.add(cell);
                    }
                    int meaning = 0;
                    if (validConns.size() > 0) {
                        CellId[] aplist = new CellId[validConns.size()];
                        block17: for (int i = 0; i < validConns.size(); ++i) {
                            Cell cell = (Cell)validConns.get(i);
                            aplist[i] = cell.getId();
                            String arcName = cell.getName().substring(4);
                            for (int k = 0; k < aList.length; ++k) {
                                if (!aList[k].name.equals(arcName)) continue;
                                if (aList[k].func.isDiffusion()) {
                                    meaning = 2;
                                    continue block17;
                                }
                                if (!aList[k].func.isPoly()) continue block17;
                                meaning = 1;
                                continue block17;
                            }
                        }
                        pNi.newVar(Info.CONNECTION_KEY, (Object)aplist);
                    }
                    if (pnp.getFunction().isTransistor()) {
                        pNi.newVar(Info.PORTMEANING_KEY, (Object)new Integer(meaning));
                    }
                    Iterator<PortProto> oPIt = pnp.getPorts();
                    while (oPIt.hasNext() && (opp = (PrimitivePort)oPIt.next()) != pp) {
                        NodeInst nni;
                        if (opp.getTopology() != pp.getTopology() || (nni = (NodeInst)portNodes.get(opp)) == null) continue;
                        PortInst head = nni.getOnlyPortInst();
                        PortInst tail = pNi.getOnlyPortInst();
                        ArcInst.newInstanceBase(Generic.tech.universal_arc, 0.0, head, tail);
                        continue block15;
                    }
                }
            }
            NodeInfo.compactCell(nNp);
        }
        lib.newVar(Info.NODESEQUENCE_KEY, (Object)nodeSequence);
        Object[][] origPalette = tech.getNodesGrouped(null);
        int numRows = origPalette.length;
        int numCols = origPalette[0].length;
        for (Object[] row : origPalette) {
            assert (row.length == numCols);
        }
        gi.menuPalette = new Object[numRows][numCols];
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                Object origEntry = origPalette[row][col];
                Object newEntry = null;
                if (origEntry instanceof ArcProto) {
                    ArcProto ap = (ArcProto)origEntry;
                    for (Info info : aList) {
                        if (!((ArcInfo)info).name.equals(ap.getName())) continue;
                        newEntry = info;
                        break;
                    }
                } else if (origEntry instanceof PrimitiveNode) {
                    PrimitiveNode pnp = (PrimitiveNode)origEntry;
                    for (Info info : nList) {
                        if (!((NodeInfo)info).name.equals(pnp.getName())) continue;
                        newEntry = info;
                        break;
                    }
                } else if (origEntry != null) {
                    newEntry = origEntry.toString();
                }
                gi.menuPalette[row][col] = newEntry;
            }
        }
        System.out.println("Done.");
        return lib;
    }

    private static ArcInfo makeArcInfo(ArcProto ap, LayerInfo[] lList) {
        ArcInfo aIn = new ArcInfo();
        aIn.name = ap.getName();
        aIn.func = ap.getFunction();
        aIn.widthOffset = ap.getLambdaWidthOffset();
        aIn.maxWidth = ap.getDefaultLambdaFullWidth();
        aIn.fixAng = ap.isFixedAngle();
        aIn.wipes = ap.isWipable();
        aIn.noExtend = !ap.isExtended();
        aIn.curvable = ap.isCurvable();
        aIn.special = ap.isSpecialArc();
        aIn.notUsed = ap.isNotUsed();
        aIn.skipSizeInPalette = ap.isSkipSizeInPalette();
        aIn.slidable = ap.isSlidable();
        aIn.angInc = ap.getAngleIncrement();
        aIn.antennaRatio = ERC.getERCTool().getAntennaRatio(ap);
        aIn.arcDetails = new ArcInfo.LayerDetails[ap.getNumArcLayers()];
        for (int i = 0; i < aIn.arcDetails.length; ++i) {
            ArcInfo.LayerDetails ald;
            aIn.arcDetails[i] = ald = new ArcInfo.LayerDetails();
            String layerName = ap.getLayer(i).getName();
            for (int j = 0; j < lList.length; ++j) {
                if (!lList[j].name.equals(layerName)) continue;
                ald.layer = lList[j];
                break;
            }
            ald.style = ap.getLayerStyle(i);
            ald.width = DBMath.gridToLambda(ap.getGridWidthOffset() - 2 * ap.getLayerGridExtend(i));
        }
        return aIn;
    }

    private static NodeInfo makeNodeInfo(PrimitiveNode pnp, LayerInfo[] lList, ArcInfo[] aList) {
        List<Technology.NodeLayer> nodeLayers;
        Technology tech = pnp.getTechnology();
        NodeInfo nIn = new NodeInfo();
        nIn.name = pnp.getName();
        nIn.func = pnp.getFunction();
        nIn.serp = false;
        if ((nIn.func == PrimitiveNode.Function.TRANMOS || nIn.func == PrimitiveNode.Function.TRAPMOS || nIn.func == PrimitiveNode.Function.TRADMOS) && pnp.isHoldsOutline()) {
            nIn.serp = true;
        }
        nIn.arcsShrink = pnp.isArcsShrink();
        assert (pnp.isArcsWipe() == nIn.arcsShrink);
        nIn.square = pnp.isSquare();
        assert (pnp.isHoldsOutline() == (pnp.getSpecialType() == 2 || pnp.getSpecialType() == 1));
        nIn.canBeZeroSize = pnp.isCanBeZeroSize();
        nIn.wipes = pnp.isWipeOn1or2();
        nIn.lockable = pnp.isLockedPrim();
        nIn.edgeSelect = pnp.isEdgeSelect();
        nIn.skipSizeInPalette = pnp.isSkipSizeInPalette();
        nIn.notUsed = pnp.isNotUsed();
        nIn.lowVt = pnp.isNodeBitOn(8);
        nIn.highVt = pnp.isNodeBitOn(16);
        nIn.nativeBit = pnp.isNodeBitOn(32);
        nIn.od18 = pnp.isNodeBitOn(64);
        nIn.od25 = pnp.isNodeBitOn(128);
        nIn.od33 = pnp.isNodeBitOn(256);
        nIn.xSize = pnp.getDefWidth();
        nIn.ySize = pnp.getDefHeight();
        nIn.so = pnp.getProtoSizeOffset();
        if (nIn != null && nIn.so.getLowXOffset() == 0.0 && nIn.so.getHighXOffset() == 0.0 && nIn.so.getLowYOffset() == 0.0 && nIn.so.getHighYOffset() == 0.0) {
            nIn.so = null;
        }
        nIn.nodeSizeRule = pnp.getMinSizeRule();
        nIn.autoGrowth = pnp.getAutoGrowth();
        nIn.specialType = pnp.getSpecialType();
        nIn.specialValues = pnp.getSpecialValues();
        nIn.spiceTemplate = pnp.getSpiceTemplate();
        List<Technology.NodeLayer> electricalNodeLayers = nodeLayers = Arrays.asList(pnp.getLayers());
        if (pnp.getElectricalLayers() != null) {
            electricalNodeLayers = Arrays.asList(pnp.getElectricalLayers());
        }
        ArrayList<NodeInfo.LayerDetails> layerDetails = new ArrayList<NodeInfo.LayerDetails>();
        int m = 0;
        for (Technology.NodeLayer nld : electricalNodeLayers) {
            int j = nodeLayers.indexOf(nld);
            if (j < 0) {
                layerDetails.add(TechToLib.makeNodeLayerDetails(nld, lList, false, true));
                continue;
            }
            while (m < j) {
                layerDetails.add(TechToLib.makeNodeLayerDetails(nodeLayers.get(m++), lList, true, false));
            }
            layerDetails.add(TechToLib.makeNodeLayerDetails(nodeLayers.get(m++), lList, true, true));
        }
        while (m < nodeLayers.size()) {
            layerDetails.add(TechToLib.makeNodeLayerDetails(nodeLayers.get(m++), lList, true, false));
        }
        nIn.nodeLayers = layerDetails.toArray(new NodeInfo.LayerDetails[layerDetails.size()]);
        nIn.nodePortDetails = new NodeInfo.PortDetails[pnp.getNumPorts()];
        for (int i = 0; i < nIn.nodePortDetails.length; ++i) {
            NodeInfo.PortDetails pd;
            PrimitivePort pp = pnp.getPort(i);
            nIn.nodePortDetails[i] = pd = new NodeInfo.PortDetails();
            pd.name = pp.getName();
            pd.netIndex = pp.getTopology();
            pd.angle = pp.getAngle();
            pd.range = pp.getAngleRange();
            pd.values = new Technology.TechPoint[]{new Technology.TechPoint(pp.getLeft(), pp.getBottom()), new Technology.TechPoint(pp.getRight(), pp.getTop())};
            pd.characterisitic = pp.getCharacteristic();
            pd.isolated = pp.isIsolated();
            pd.negatable = pp.isNegatable();
            ArcProto[] connects = pp.getConnections();
            ArrayList<ArcInfo> validArcInfoConns = new ArrayList<ArcInfo>();
            block4: for (int j = 0; j < connects.length; ++j) {
                ArcProto ap = connects[j];
                if (ap.getTechnology() != tech) continue;
                for (int k = 0; k < aList.length; ++k) {
                    if (!aList[k].name.equals(ap.getName())) continue;
                    validArcInfoConns.add(aList[k]);
                    continue block4;
                }
            }
            pd.connections = validArcInfoConns.toArray(new ArcInfo[validArcInfoConns.size()]);
        }
        if (nIn.func == PrimitiveNode.Function.NODE) {
            assert (nIn.nodeLayers.length == 1);
            LayerInfo l = nIn.nodeLayers[0].layer;
            assert (l.pureLayerNode == null);
            l.pureLayerNode = nIn;
        }
        return nIn;
    }

    private static NodeInfo.LayerDetails makeNodeLayerDetails(Technology.NodeLayer nl, LayerInfo[] lList, boolean inLayers, boolean inElectricalLayers) {
        NodeInfo.LayerDetails nld = new NodeInfo.LayerDetails();
        nld.inLayers = inLayers;
        nld.inElectricalLayers = inElectricalLayers;
        nld.style = nl.getStyle();
        nld.portIndex = nl.getPortNum();
        nld.representation = nl.getRepresentation();
        nld.values = nl.getPoints();
        for (int k = 0; k < lList.length; ++k) {
            if (!nl.getLayer().getNonPseudoLayer().getName().equals(lList[k].name)) continue;
            nld.layer = lList[k];
            break;
        }
        nld.multiCut = nld.representation == 3;
        nld.multiXS = nl.getMulticutSizeX();
        nld.multiYS = nl.getMulticutSizeY();
        nld.multiSep = nl.getMulticutSep1D();
        nld.multiSep2D = nl.getMulticutSep2D();
        return nld;
    }

    private static NodeInst placeGeometry(Poly poly, Cell cell) {
        Rectangle2D box = poly.getBox();
        Rectangle2D bounds = poly.getBounds2D();
        Poly.Type style = poly.getStyle();
        if (style == Poly.Type.FILLED) {
            if (box != null) {
                return NodeInst.makeInstance(Artwork.tech.filledBoxNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            }
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.filledPolygonNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            return ni;
        }
        if (style == Poly.Type.CLOSED) {
            if (box != null) {
                return NodeInst.makeInstance(Artwork.tech.boxNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            }
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.closedPolygonNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            return ni;
        }
        if (style == Poly.Type.CROSSED) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.crossedBoxNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            return ni;
        }
        if (style == Poly.Type.OPENED) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.openedPolygonNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            return ni;
        }
        if (style == Poly.Type.OPENEDT1) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.openedDottedPolygonNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            return ni;
        }
        if (style == Poly.Type.OPENEDT2) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.openedDashedPolygonNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            return ni;
        }
        if (style == Poly.Type.OPENEDT3) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.openedThickerPolygonNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            return ni;
        }
        if (style == Poly.Type.CIRCLE) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.circleNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            return ni;
        }
        if (style == Poly.Type.THICKCIRCLE) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.thickCircleNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            return ni;
        }
        if (style == Poly.Type.DISC) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.filledCircleNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            return ni;
        }
        if (style == Poly.Type.CIRCLEARC) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.circleNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setArcDegrees(0.0, 0.7853981633974483);
            return ni;
        }
        if (style == Poly.Type.THICKCIRCLEARC) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.thickCircleNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setArcDegrees(0.0, 0.7853981633974483);
            return ni;
        }
        if (style == Poly.Type.TEXTCENT) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech.invisiblePinNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.newVar(Artwork.ART_MESSAGE, (Object)poly.getString(), TextDescriptor.getNodeTextDescriptor().withPos(AbstractTextDescriptor.Position.CENT));
            return ni;
        }
        if (style == Poly.Type.TEXTBOTLEFT) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech.invisiblePinNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.newVar(Artwork.ART_MESSAGE, (Object)poly.getString(), TextDescriptor.getNodeTextDescriptor().withPos(AbstractTextDescriptor.Position.UPRIGHT));
            return ni;
        }
        if (style == Poly.Type.TEXTBOTRIGHT) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech.invisiblePinNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.newVar(Artwork.ART_MESSAGE, (Object)poly.getString(), TextDescriptor.getNodeTextDescriptor().withPos(AbstractTextDescriptor.Position.UPLEFT));
            return ni;
        }
        if (style == Poly.Type.TEXTBOX) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech.invisiblePinNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.newVar(Artwork.ART_MESSAGE, (Object)poly.getString(), TextDescriptor.getNodeTextDescriptor().withPos(AbstractTextDescriptor.Position.BOXED));
            return ni;
        }
        return null;
    }

    private static class LibFromTechJob
    extends Job {
        private Technology tech;
        private String libraryName;
        private boolean doItNow;

        private LibFromTechJob(Technology tech, boolean doItNow) {
            super("Make Technology Library from Technology", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.tech = tech;
            this.doItNow = doItNow;
            if (!doItNow) {
                this.startJob();
            }
        }

        public String getLibraryName() {
            return this.libraryName;
        }

        public boolean doIt() {
            Library lib = TechToLib.makeLibFromTech(this.tech);
            if (lib == null) {
                return false;
            }
            User.setCurrentLibrary(lib);
            if (!this.doItNow) {
                this.fieldVariableChanged("libraryName");
            }
            this.libraryName = lib.getName();
            return true;
        }
    }
}

