/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.sc;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.tool.sc.GetNetlist;
import com.sun.electric.tool.sc.Place;
import com.sun.electric.tool.sc.SilComp;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Route {
    private static final boolean DEBUG = false;
    private static final int ROUTESEEN = 1;
    private static final int ROUTEUNUSABLE = 2;
    private static final int ROUTETEMPNUSE = 4;
    private static final double DEFAULT_FUZZY_WINDOW_LIMIT = 6400.0;
    private int feedNumber;

    public String routeCells(GetNetlist gnl) {
        RouteChannel channelList;
        RouteRow rowList;
        SCRoute route;
        if (gnl.curSCCell == null) {
            return "No cell selected";
        }
        if (gnl.curSCCell.placement == null) {
            return "No PLACEMENT structure for cell '" + gnl.curSCCell.name + "'";
        }
        gnl.curSCCell.route = route = new SCRoute();
        route.channels = null;
        route.exports = null;
        route.rows = null;
        this.squeezeCells(gnl.curSCCell.placement.theRows);
        route.rows = rowList = this.createRowList(gnl.curSCCell.placement.theRows, gnl.curSCCell);
        route.channels = channelList = this.createChannelList(gnl.curSCCell.placement.numRows + 1);
        this.channelAssign(rowList, channelList, gnl.curSCCell);
        this.createPassThroughs(channelList, gnl.curSCCell.placement.theRows);
        route.exports = this.decideExports(gnl.curSCCell);
        this.tracksInChannels(channelList, gnl.curSCCell);
        return null;
    }

    private void squeezeCells(List<Place.RowList> theRows) {
        for (Place.RowList row : theRows) {
            Place.NBPlace place = row.start;
            while (place != null) {
                if (place.next != null) {
                    GetNetlist.SCCellNums cell1Nums = GetNetlist.getLeafCellNums((Cell)place.cell.np);
                    GetNetlist.SCCellNums cell2Nums = GetNetlist.getLeafCellNums((Cell)place.next.cell.np);
                    double overlap = 0.0;
                    overlap = row.rowNum % 2 != 0 ? (double)(cell2Nums.rightActive + cell1Nums.leftActive) - SilComp.getMinActiveDistance() : (double)(cell1Nums.rightActive + cell2Nums.leftActive) - SilComp.getMinActiveDistance();
                    Place.NBPlace place2 = place.next;
                    while (place2 != null) {
                        place2.xPos -= overlap;
                        place2 = place2.next;
                    }
                }
                place = place.next;
            }
        }
    }

    private RouteRow createRowList(List<Place.RowList> theRows, GetNetlist.SCCell cell) {
        GetNetlist.ExtNode eNode = cell.exNodes;
        while (eNode != null) {
            eNode.ptr = null;
            eNode = eNode.next;
        }
        RouteRow firstRRow = null;
        RouteRow lastRRow = null;
        RouteNode sameNode = null;
        for (Place.RowList row : theRows) {
            RouteRow newRRow = new RouteRow();
            newRRow.number = row.rowNum;
            newRRow.nodes = null;
            newRRow.row = row;
            newRRow.last = lastRRow;
            newRRow.next = null;
            if (lastRRow != null) {
                lastRRow.next = newRRow;
                lastRRow = newRRow;
            } else {
                firstRRow = lastRRow = newRRow;
            }
            RouteNode lastNode = null;
            GetNetlist.ExtNode enode = cell.exNodes;
            while (enode != null) {
                RouteNode newNode = new RouteNode();
                newNode.extNode = enode;
                newNode.row = newRRow;
                newNode.firstPort = null;
                newNode.lastPort = null;
                newNode.sameNext = null;
                newNode.sameLast = sameNode;
                newNode.next = null;
                if (lastNode != null) {
                    lastNode.next = newNode;
                } else {
                    newRRow.nodes = newNode;
                }
                lastNode = newNode;
                if (sameNode != null) {
                    sameNode.sameNext = newNode;
                    sameNode = sameNode.next;
                } else {
                    enode.ptr = newNode;
                }
                enode = enode.next;
            }
            sameNode = newRRow.nodes;
            Place.NBPlace place = row.start;
            while (place != null) {
                GetNetlist.SCNiPort port = place.cell.ports;
                while (port != null) {
                    RouteNode newNode = (RouteNode)port.extNode.ptr;
                    if (newNode != null) {
                        for (int i = 0; i < row.rowNum; ++i) {
                            newNode = newNode.sameNext;
                        }
                        RoutePort newPort = new RoutePort();
                        newPort.place = place;
                        newPort.port = port;
                        newPort.node = newNode;
                        newPort.next = null;
                        newPort.last = newNode.lastPort;
                        if (newNode.lastPort != null) {
                            newNode.lastPort.next = newPort;
                        } else {
                            newNode.firstPort = newPort;
                        }
                        newNode.lastPort = newPort;
                    }
                    port = port.next;
                }
                place = place.next;
            }
        }
        return firstRRow;
    }

    private RouteChannel createChannelList(int number) {
        RouteChannel firstChan = null;
        RouteChannel lastChan = null;
        for (int i = 0; i < number; ++i) {
            RouteChannel newChan = new RouteChannel();
            newChan.number = i;
            newChan.nodes = null;
            newChan.tracks = null;
            newChan.next = null;
            newChan.last = lastChan;
            if (lastChan != null) {
                lastChan.next = newChan;
            } else {
                firstChan = newChan;
            }
            lastChan = newChan;
        }
        return firstChan;
    }

    private void channelAssign(RouteRow rows, RouteChannel channels, GetNetlist.SCCell cell) {
        RouteNode node;
        RouteRow row = rows;
        while (row != null) {
            node = row.nodes;
            while (node != null) {
                RoutePort port = node.firstPort;
                while (port != null) {
                    port.flags &= 0xFFFFFFFE;
                    port = port.next;
                }
                node = node.next;
            }
            row = row.next;
        }
        row = rows;
        while (row != null) {
            node = row.nodes;
            while (node != null) {
                block37: {
                    int direct;
                    RoutePort port;
                    boolean portsBelow;
                    boolean portsAbove;
                    block38: {
                        if (node.firstPort == null) break block37;
                        portsAbove = false;
                        RouteNode node2 = node.sameNext;
                        while (node2 != null) {
                            if (node2.firstPort != null) {
                                portsAbove = true;
                                break;
                            }
                            node2 = node2.sameNext;
                        }
                        if (!portsAbove && node.firstPort != node.lastPort) {
                            RoutePort port2 = node.firstPort;
                            while (port2 != null) {
                                int direct2 = GetNetlist.getLeafPortDirection((PortProto)port2.port.port);
                                if ((direct2 & 1) != 0 && (direct2 & 2) == 0) {
                                    portsAbove = true;
                                    break;
                                }
                                port2 = port2.next;
                            }
                        }
                        portsBelow = false;
                        RouteNode node22 = node.sameLast;
                        while (node22 != null) {
                            if (node22.firstPort != null) {
                                portsBelow = true;
                                break;
                            }
                            node22 = node22.sameLast;
                        }
                        if (!portsBelow && node.firstPort != node.lastPort) {
                            port = node.firstPort;
                            while (port != null) {
                                direct = GetNetlist.getLeafPortDirection((PortProto)port.port.port);
                                if ((direct & 2) != 0 && (direct & 1) == 0) {
                                    portsBelow = true;
                                    break;
                                }
                                port = port.next;
                            }
                        }
                        if (portsAbove || portsBelow || node.firstPort != node.lastPort) break block38;
                        GetNetlist.SCPort xPort = cell.ports;
                        while (xPort != null && xPort.node.ports.extNode != node.extNode) {
                            xPort = xPort.next;
                        }
                        if (xPort == null) break block37;
                        if (row.number != 0 && row.next == null) {
                            portsAbove = true;
                        }
                    }
                    port = node.firstPort;
                    while (port != null) {
                        if ((port.flags & 1) == 0) {
                            direct = GetNetlist.getLeafPortDirection((PortProto)port.port.port);
                            if ((direct & 1) != 0 && (direct & 2) != 0) {
                                if (!portsAbove) {
                                    this.addPortToChannel(port, node.extNode, channels, row.number);
                                } else if (portsBelow) {
                                    int offset = 0;
                                    if (this.nearestPort(port, node, row.number, cell) > 0.0) {
                                        offset = 1;
                                    }
                                    this.addPortToChannel(port, node.extNode, channels, row.number + offset);
                                } else {
                                    this.addPortToChannel(port, node.extNode, channels, row.number + 1);
                                }
                                port.flags |= 1;
                            } else if ((direct & 1) != 0) {
                                this.addPortToChannel(port, node.extNode, channels, row.number + 1);
                                port.flags |= 1;
                            } else if ((direct & 2) != 0) {
                                this.addPortToChannel(port, node.extNode, channels, row.number);
                                port.flags |= 1;
                            } else if ((direct & 8) != 0) {
                                this.addLateralFeed(port, channels, portsAbove, portsBelow, cell);
                            } else if ((direct & 4) != 0) {
                                this.addLateralFeed(port, channels, portsAbove, portsBelow, cell);
                            } else {
                                System.out.println("ERROR - no direction for " + port.place.cell.name + " port " + ((PortProto)port.port.port).getName());
                                port.flags |= 1;
                            }
                        }
                        port = port.next;
                    }
                }
                node = node.next;
            }
            row = row.next;
        }
    }

    private double nearestPort(RoutePort port, RouteNode node, int rowNum, GetNetlist.SCCell cell) {
        double xPos2;
        double dist;
        RoutePort nPort;
        double minDist = Double.MAX_VALUE;
        double whichRow = 0.0;
        double xPos1 = rowNum % 2 != 0 ? port.place.xPos + port.place.cell.size - port.port.xPos : port.place.xPos + port.port.xPos;
        double offset = 0.0;
        RouteNode nNode = node.sameNext;
        while (nNode != null) {
            offset += 1.0;
            nPort = nNode.firstPort;
            while (nPort != null) {
                dist = Math.abs(offset) * (double)cell.placement.avgHeight * 2.0;
                xPos2 = ((double)rowNum + offset) % 2.0 != 0.0 ? nPort.place.xPos + nPort.place.cell.size - nPort.port.xPos : nPort.place.xPos + nPort.port.xPos;
                if ((dist += Math.abs(xPos2 - xPos1)) < minDist) {
                    minDist = dist;
                    whichRow = offset;
                }
                nPort = nPort.next;
            }
            nNode = nNode.sameNext;
        }
        offset = 0.0;
        nNode = node.sameLast;
        while (nNode != null) {
            offset -= 1.0;
            nPort = nNode.firstPort;
            while (nPort != null) {
                dist = Math.abs(offset) * (double)cell.placement.avgHeight * 2.0;
                xPos2 = ((double)rowNum + offset) % 2.0 != 0.0 ? nPort.place.xPos + nPort.place.cell.size - nPort.port.xPos : nPort.place.xPos + nPort.port.xPos;
                if ((dist += Math.abs(xPos2 - xPos1)) < minDist) {
                    minDist = dist;
                    whichRow = offset;
                }
                nPort = nPort.next;
            }
            nNode = nNode.sameLast;
        }
        return whichRow;
    }

    private void addPortToChannel(RoutePort port, GetNetlist.ExtNode extNode, RouteChannel channels, int chanNum) {
        RouteChannel channel = channels;
        for (int i = 0; i < chanNum; ++i) {
            channel = channel.next;
        }
        RouteChNode node = channel.nodes;
        while (node != null && node.extNode != extNode) {
            node = node.next;
        }
        if (node == null) {
            RouteChNode nNode;
            node = new RouteChNode();
            node.extNode = extNode;
            node.number = 0;
            node.firstPort = null;
            node.lastPort = null;
            node.channel = channel;
            node.flags = 1;
            node.sameNext = null;
            node.sameLast = null;
            node.next = channel.nodes;
            channel.nodes = node;
            RouteChannel nchan = channel.last;
            while (nchan != null) {
                nNode = nchan.nodes;
                while (nNode != null) {
                    if (nNode.extNode == extNode) {
                        nNode.sameNext = node;
                        node.sameLast = nNode;
                        break;
                    }
                    nNode = nNode.next;
                }
                if (nNode != null) break;
                nchan = nchan.last;
            }
            nchan = channel.next;
            while (nchan != null) {
                nNode = nchan.nodes;
                while (nNode != null) {
                    if (nNode.extNode == extNode) {
                        nNode.sameLast = node;
                        node.sameNext = nNode;
                        break;
                    }
                    nNode = nNode.next;
                }
                if (nNode != null) break;
                nchan = nchan.next;
            }
        }
        RouteChPort nPort = new RouteChPort();
        nPort.port = port;
        nPort.node = node;
        nPort.xPos = 0.0;
        nPort.flags = 0;
        nPort.next = null;
        nPort.last = node.lastPort;
        if (node.lastPort != null) {
            node.lastPort.next = nPort;
        } else {
            node.firstPort = nPort;
        }
        node.lastPort = nPort;
    }

    private void addLateralFeed(RoutePort port, RouteChannel channels, boolean portsAbove, boolean portsBelow, GetNetlist.SCCell cell) {
        int direct = GetNetlist.getLeafPortDirection((PortProto)port.port.port);
        Place.NBPlace nPlace = null;
        int sDirect = 0;
        if ((direct & 8) != 0) {
            if (port.node.row.number % 2 != 0) {
                nPlace = port.place.next;
                while (nPlace != null && nPlace.cell.type != 0) {
                    nPlace = nPlace.next;
                }
            } else {
                nPlace = port.place.last;
                while (nPlace != null && nPlace.cell.type != 0) {
                    nPlace = nPlace.last;
                }
            }
            sDirect = 4;
        } else {
            if (port.node.row.number % 2 != 0) {
                nPlace = port.place.last;
                while (nPlace != null && nPlace.cell.type != 0) {
                    nPlace = nPlace.last;
                }
            } else {
                nPlace = port.place.next;
                while (nPlace != null && nPlace.cell.type != 0) {
                    nPlace = nPlace.next;
                }
            }
            sDirect = 8;
        }
        if (nPlace != null) {
            RoutePort port2 = port.next;
            while (port2 != null && (port2.place != nPlace || GetNetlist.getLeafPortDirection((PortProto)port2.port.port) != sDirect)) {
                port2 = port2.next;
            }
            if (port2 != null) {
                GetNetlist.SCNiTree sInst;
                port.flags |= 1;
                port2.flags |= 1;
                Place.NBPlace sPlace = new Place.NBPlace();
                sPlace.cell = null;
                sPlace.cell = sInst = new GetNetlist.SCNiTree("Stitch", 4);
                GetNetlist.SCNiPort sPort = new GetNetlist.SCNiPort(sInst);
                sPort.port = port;
                GetNetlist.SCNiPort sPort2 = new GetNetlist.SCNiPort(sInst);
                sPort2.port = port2;
                if ((direct & 8) != 0) {
                    if (port.node.row.number % 2 != 0) {
                        sPlace.last = port.place;
                        sPlace.next = port.place.next;
                        if (sPlace.last != null) {
                            sPlace.last.next = sPlace;
                        }
                        if (sPlace.next != null) {
                            sPlace.next.last = sPlace;
                        }
                    } else {
                        sPlace.last = port.place.last;
                        sPlace.next = port.place;
                        if (sPlace.last != null) {
                            sPlace.last.next = sPlace;
                        }
                        if (sPlace.next != null) {
                            sPlace.next.last = sPlace;
                        }
                    }
                } else if (port.node.row.number % 2 != 0) {
                    sPlace.last = port.place.last;
                    sPlace.next = port.place;
                    if (sPlace.last != null) {
                        sPlace.last.next = sPlace;
                    }
                    if (sPlace.next != null) {
                        sPlace.next.last = sPlace;
                    }
                } else {
                    sPlace.last = port.place;
                    sPlace.next = port.place.next;
                    if (sPlace.last != null) {
                        sPlace.last.next = sPlace;
                    }
                    if (sPlace.next != null) {
                        sPlace.next.last = sPlace;
                    }
                }
                return;
            }
        }
        port.flags |= 1;
        Place.NBPlace sPlace = new Place.NBPlace();
        sPlace.cell = null;
        GetNetlist.SCNiTree sInst = new GetNetlist.SCNiTree("Lateral Feed", 5);
        sInst.size = SilComp.getFeedThruSize();
        sPlace.cell = sInst;
        GetNetlist.SCNiPort sPort = new GetNetlist.SCNiPort(sInst);
        sPort.xPos = SilComp.getFeedThruSize() / 2.0;
        RoutePort nPort = new RoutePort();
        nPort.place = port.place;
        nPort.port = port.port;
        nPort.node = port.node;
        nPort.flags = 0;
        nPort.last = null;
        nPort.next = null;
        sPort.port = nPort;
        if ((direct & 8) != 0) {
            if (port.node.row.number % 2 != 0) {
                sPlace.last = port.place;
                sPlace.next = port.place.next;
            } else {
                sPlace.last = port.place.last;
                sPlace.next = port.place;
            }
        } else if (port.node.row.number % 2 != 0) {
            sPlace.last = port.place.last;
            sPlace.next = port.place;
        } else {
            sPlace.last = port.place;
            sPlace.next = port.place.next;
        }
        if (sPlace.last != null) {
            sPlace.last.next = sPlace;
        } else {
            port.node.row.row.start = sPlace;
        }
        if (sPlace.next != null) {
            sPlace.next.last = sPlace;
        } else {
            port.node.row.row.end = sPlace;
        }
        this.resolveNewXPos(sPlace, port.node.row.row);
        port.place = sPlace;
        port.port = sPort;
        if (!portsAbove) {
            this.addPortToChannel(port, port.node.extNode, channels, port.node.row.number);
        } else if (portsBelow) {
            int offset = 0;
            if (this.nearestPort(port, port.node, port.node.row.number, cell) > 0.0) {
                offset = 1;
            }
            this.addPortToChannel(port, port.node.extNode, channels, port.node.row.number + offset);
        } else {
            this.addPortToChannel(port, port.node.extNode, channels, port.node.row.number + 1);
        }
    }

    private void createPassThroughs(RouteChannel channels, List<Place.RowList> theRows) {
        RouteChNode chNode;
        this.feedNumber = 0;
        RouteChannel chan = channels;
        while (chan != null) {
            chNode = chan.nodes;
            while (chNode != null) {
                chNode.flags &= 0xFFFFFFFE;
                chNode = chNode.next;
            }
            chan = chan.next;
        }
        chan = channels;
        while (chan != null) {
            chNode = chan.nodes;
            while (chNode != null) {
                if ((chNode.flags & 1) == 0) {
                    chNode.flags |= 1;
                    RouteChNode oldChNode = chNode;
                    RouteChNode chNode2 = chNode.sameNext;
                    while (chNode2 != null) {
                        chNode2.flags |= 1;
                        this.betweenChNodes(oldChNode, chNode2, channels, theRows);
                        oldChNode = chNode2;
                        chNode2 = chNode2.sameNext;
                    }
                }
                chNode = chNode.next;
            }
            chan = chan.next;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void betweenChNodes(RouteChNode node1, RouteChNode node2, RouteChannel channels, List<Place.RowList> theRows) {
        GetNetlist.ExtNode extNode = node1.extNode;
        double minX2 = this.minPortPos(node2);
        double maxX2 = this.maxPortPos(node2);
        RouteChannel chan = node1.channel;
        while (true) {
            block19: {
                Place.NBPlace place;
                Place.NBPlace bestPlace;
                double bestPos;
                Place.RowList row;
                double pMaxX;
                double pMinX;
                block22: {
                    RoutePort rPort;
                    block21: {
                        block20: {
                            if (chan == node2.channel) {
                                return;
                            }
                            double minX1 = this.minPortPos(node1);
                            double maxX1 = this.maxPortPos(node1);
                            if (maxX1 <= minX2) {
                                pMinX = maxX1;
                                pMaxX = minX2;
                            } else if (maxX2 <= minX1) {
                                pMinX = maxX2;
                                pMaxX = minX1;
                            } else {
                                pMinX = Math.max(minX1, minX2);
                                pMaxX = Math.min(minX1, minX2);
                            }
                            pMinX -= 6400.0;
                            pMaxX += 6400.0;
                            row = null;
                            Iterator<Place.RowList> i$ = theRows.iterator();
                            while (i$.hasNext()) {
                                Place.RowList r;
                                row = r = i$.next();
                                if (row.rowNum != chan.number) continue;
                            }
                            RouteNode rNode = (RouteNode)extNode.ptr;
                            while (rNode != null && rNode.row.number != row.rowNum) {
                                rNode = rNode.sameNext;
                            }
                            if (rNode == null) break block20;
                            rPort = rNode.firstPort;
                            while (rPort != null) {
                                double pos = this.portPosition(rPort);
                                int direct = GetNetlist.getLeafPortDirection((PortProto)rPort.port.port);
                                if (((direct & 1) != 0 || (direct & 2) == 0) && pos >= pMinX && pos <= pMaxX) break;
                                rPort = rPort.next;
                            }
                            if (rPort != null) break block21;
                        }
                        bestPos = Double.MAX_VALUE;
                        bestPlace = null;
                        place = row.start;
                        break block22;
                    }
                    RouteChPort chPort = null;
                    RouteChNode node = chan.nodes;
                    while (true) {
                        block24: {
                            block25: {
                                block23: {
                                    if (node == null) break block23;
                                    if (node.extNode != node1.extNode) break block24;
                                    chPort = node.firstPort;
                                    break block25;
                                }
                                if (chPort == null) {
                                    this.addPortToChannel(rPort, extNode, channels, chan.number);
                                }
                                break;
                            }
                            while (chPort != null && chPort.port != rPort) {
                                chPort = chPort.next;
                            }
                        }
                        node = node.next;
                    }
                    chPort = null;
                    node = chan.next.nodes;
                    while (true) {
                        block27: {
                            block28: {
                                block26: {
                                    if (node == null) break block26;
                                    if (node.extNode != node1.extNode) break block27;
                                    chPort = node.firstPort;
                                    break block28;
                                }
                                if (chPort == null) {
                                    this.addPortToChannel(rPort, extNode, channels, chan.next.number);
                                }
                                break block19;
                            }
                            while (chPort != null && chPort.port != rPort) {
                                chPort = chPort.next;
                            }
                        }
                        node = node.next;
                    }
                }
                while (place != null) {
                    if (!(place.cell.type == 4 || place.last != null && place.last.cell.type == 4 || place.cell.type == 5 || place.last != null && place.last.cell.type == 5)) {
                        if (place.xPos >= pMinX && place.xPos <= pMaxX) {
                            bestPlace = place;
                            break;
                        }
                        double pos = place.xPos < pMinX ? Math.abs(pMinX - place.xPos) : Math.abs(pMaxX - place.xPos);
                        if (pos < bestPos) {
                            bestPos = pos;
                            bestPlace = place;
                        }
                    }
                    place = place.next;
                }
                this.insertFeedThrough(bestPlace, row, channels, chan.number, node1);
            }
            chan = chan.next;
            node1 = node1.sameNext;
        }
    }

    private double minPortPos(RouteChNode node) {
        double minX = Double.MAX_VALUE;
        RouteChPort chPort = node.firstPort;
        while (chPort != null) {
            double pos = this.portPosition(chPort.port);
            if (pos < minX) {
                minX = pos;
            }
            chPort = chPort.next;
        }
        return minX;
    }

    private double maxPortPos(RouteChNode node) {
        double maxX = Double.MIN_VALUE;
        RouteChPort chPort = node.firstPort;
        while (chPort != null) {
            double pos = this.portPosition(chPort.port);
            if (pos > maxX) {
                maxX = pos;
            }
            chPort = chPort.next;
        }
        return maxX;
    }

    private double portPosition(RoutePort port) {
        double pos = port.place.xPos;
        pos = port.node.row.number % 2 != 0 ? (pos += port.place.cell.size - port.port.xPos) : (pos += port.port.xPos);
        return pos;
    }

    private void insertFeedThrough(Place.NBPlace place, Place.RowList row, RouteChannel channels, int chanNum, RouteChNode node) {
        GetNetlist.SCNiTree inst = new GetNetlist.SCNiTree("Feed_Through", 3);
        inst.size = SilComp.getFeedThruSize();
        GetNetlist.SCNiPort port = new GetNetlist.SCNiPort();
        port.port = new Integer(this.feedNumber++);
        port.extNode = node.extNode;
        port.bits = 0;
        port.xPos = SilComp.getFeedThruSize() / 2.0;
        port.next = null;
        inst.ports = port;
        Place.NBPlace nPlace = new Place.NBPlace();
        nPlace.cell = inst;
        nPlace.last = place.last;
        nPlace.next = place;
        if (nPlace.last != null) {
            nPlace.last.next = nPlace;
        }
        place.last = nPlace;
        if (place == row.start) {
            row.start = nPlace;
        }
        this.resolveNewXPos(nPlace, row);
        RouteNode rNode = (RouteNode)node.extNode.ptr;
        while (rNode != null && rNode.row.number != row.rowNum) {
            rNode = rNode.sameNext;
        }
        RoutePort rPort = new RoutePort();
        rPort.place = nPlace;
        rPort.port = port;
        rPort.node = rNode;
        rPort.flags = 0;
        rPort.next = null;
        rPort.last = rNode.lastPort;
        if (rNode.lastPort != null) {
            rNode.lastPort.next = rPort;
        } else {
            rNode.firstPort = rPort;
        }
        rNode.lastPort = rPort;
        this.addPortToChannel(rPort, node.extNode, channels, chanNum);
        this.addPortToChannel(rPort, node.extNode, channels, chanNum + 1);
    }

    private void resolveNewXPos(Place.NBPlace place, Place.RowList row) {
        double xPos;
        if (place.last != null) {
            if (place.last.cell.type == 0) {
                GetNetlist.SCCellNums cnums = GetNetlist.getLeafCellNums((Cell)place.last.cell.np);
                xPos = place.last.xPos + place.last.cell.size;
                double overlap = 0.0;
                overlap = row.rowNum % 2 != 0 ? (double)cnums.leftActive - SilComp.getMinActiveDistance() : (double)cnums.rightActive - SilComp.getMinActiveDistance();
                if (overlap < 0.0 && place.cell.type != 5) {
                    overlap = 0.0;
                }
                place.xPos = xPos -= overlap;
                xPos += place.cell.size;
            } else {
                place.xPos = xPos = place.last.xPos + place.last.cell.size;
                xPos += place.cell.size;
            }
        } else {
            place.xPos = 0.0;
            xPos = place.cell.size;
        }
        if (place.next != null) {
            double oldXPos = place.next.xPos;
            double nXPos = 0.0;
            if (place.next.cell.type == 0) {
                GetNetlist.SCCellNums cnums = GetNetlist.getLeafCellNums((Cell)place.next.cell.np);
                double overlap = 0.0;
                overlap = row.rowNum % 2 != 0 ? (double)cnums.rightActive - SilComp.getMinActiveDistance() : (double)cnums.leftActive - SilComp.getMinActiveDistance();
                if (overlap < 0.0 && place.cell.type != 5) {
                    overlap = 0.0;
                }
                nXPos = xPos - overlap;
            } else {
                nXPos = xPos;
            }
            place = place.next;
            while (place != null) {
                place.xPos += nXPos - oldXPos;
                place = place.next;
            }
            row.rowSize = (int)((double)row.rowSize + (nXPos - oldXPos));
        }
    }

    private RouteExport decideExports(GetNetlist.SCCell cell) {
        RouteExport lExport = null;
        GetNetlist.SCPort port = cell.ports;
        while (port != null) {
            GetNetlist.ExtNode eNode = port.node.ports.extNode;
            RouteChNode chNode = null;
            RouteChannel chan = cell.route.channels;
            while (chan != null) {
                chNode = chan.nodes;
                while (chNode != null && chNode.extNode != eNode) {
                    chNode = chNode.next;
                }
                if (chNode != null) break;
                chan = chan.next;
            }
            boolean bottom = false;
            boolean top = false;
            boolean left = false;
            boolean right = false;
            double bestDist = Double.MAX_VALUE;
            RouteChPort bestChPort = null;
            RouteChNode chNode2 = chNode;
            while (chNode2 != null) {
                RouteChPort chPort = chNode2.firstPort;
                while (chPort != null) {
                    double maxX;
                    if (chPort.node.channel.number == 0) {
                        bottom = true;
                        bestChPort = chPort;
                        break;
                    }
                    if (chPort.node.channel.number == cell.placement.numRows) {
                        top = true;
                        bestChPort = chPort;
                        break;
                    }
                    double dist = this.portPosition(chPort.port);
                    if (dist < bestDist) {
                        bestDist = dist;
                        left = true;
                        right = false;
                        bestChPort = chPort;
                    }
                    if ((dist = (maxX = chPort.port.node.row.row.end.xPos + chPort.port.node.row.row.end.cell.size) - this.portPosition(chPort.port)) < bestDist) {
                        bestDist = dist;
                        right = true;
                        left = false;
                        bestChPort = chPort;
                    }
                    chPort = chPort.next;
                }
                if (chPort != null) break;
                chNode2 = chNode2.sameNext;
            }
            if (!top && !bottom) {
                if (right) {
                    bestChPort = this.createSpecial(port.node, bestChPort, false, cell);
                } else if (left) {
                    bestChPort = this.createSpecial(port.node, bestChPort, true, cell);
                }
            }
            RouteExport nExport = new RouteExport();
            nExport.xPort = port;
            nExport.chPort = bestChPort;
            nExport.next = lExport;
            lExport = nExport;
            port = port.next;
        }
        return lExport;
    }

    private RouteChPort createSpecial(GetNetlist.SCNiTree inst, RouteChPort chPort, boolean where, GetNetlist.SCCell cell) {
        inst.size = SilComp.getFeedThruSize();
        inst.ports.xPos = SilComp.getFeedThruSize() / 2.0;
        Place.RowList row = chPort.port.node.row.row;
        Place.NBPlace nPlace = new Place.NBPlace();
        nPlace.cell = inst;
        if (where) {
            if (row.start != null) {
                double xpos;
                nPlace.xPos = xpos = row.start.xPos - SilComp.getFeedThruSize();
                row.start.last = nPlace;
            } else {
                nPlace.xPos = 0.0;
            }
            nPlace.last = null;
            nPlace.next = row.start;
            row.start = nPlace;
        } else {
            if (row.end != null) {
                nPlace.xPos = row.end.xPos + row.end.cell.size;
                row.end.next = nPlace;
            } else {
                nPlace.xPos = 0.0;
            }
            nPlace.next = null;
            nPlace.last = row.end;
            row.end = nPlace;
        }
        RouteNode rNode = (RouteNode)chPort.node.extNode.ptr;
        while (rNode != null && rNode.row.number != row.rowNum) {
            rNode = rNode.sameNext;
        }
        RoutePort rPort = new RoutePort();
        rPort.place = nPlace;
        rPort.port = inst.ports;
        rPort.node = rNode;
        rPort.flags = 0;
        rPort.next = null;
        rPort.last = rNode.lastPort;
        if (rNode.lastPort != null) {
            rNode.lastPort.next = rPort;
        } else {
            rNode.firstPort = rPort;
        }
        rNode.lastPort = rPort;
        this.addPortToChannel(rPort, chPort.port.node.extNode, cell.route.channels, chPort.node.channel.number);
        return chPort.node.lastPort;
    }

    private void tracksInChannels(RouteChannel channels, GetNetlist.SCCell cell) {
        RouteChannel chan = channels;
        while (chan != null) {
            RouteTrack tracks;
            RouteVCG vGraph = this.createVCG(chan, cell);
            RouteZRG zrGraph = this.createZRG(chan);
            chan.tracks = tracks = this.trackAssignment(vGraph, zrGraph, chan.nodes);
            chan = chan.next;
        }
    }

    private RouteVCG createVCG(RouteChannel channel, GetNetlist.SCCell cell) {
        int netNumber = 0;
        RouteChNode chNode = channel.nodes;
        while (chNode != null) {
            chNode.number = netNumber++;
            RouteChPort chPort = chNode.firstPort;
            while (chPort != null) {
                chPort.xPos = this.portPosition(chPort.port);
                chPort = chPort.next;
            }
            chPort = chNode.firstPort;
            while (chPort != null) {
                RouteChPort port2 = chPort.last;
                while (port2 != null && !(port2.xPos <= chPort.xPos)) {
                    chPort.last = port2.last;
                    port2.last = chPort;
                    if (chPort.last != null) {
                        chPort.last.next = chPort;
                    }
                    port2.next = chPort.next;
                    chPort.next = port2;
                    if (port2.next != null) {
                        port2.next.last = port2;
                    }
                    if (port2 == chNode.firstPort) {
                        chNode.firstPort = chPort;
                    }
                    if (chPort == chNode.lastPort) {
                        chNode.lastPort = port2;
                    }
                    port2 = chPort.last;
                }
                chPort = chPort.next;
            }
            chNode = chNode.next;
        }
        RouteVCG vcgRoot = new RouteVCG();
        vcgRoot.chNode = null;
        vcgRoot.edges = null;
        RouteChNode chNode2 = channel.nodes;
        while (chNode2 != null) {
            RouteVCG vcgNode = new RouteVCG();
            vcgNode.chNode = chNode2;
            vcgNode.edges = null;
            RouteVCGEdge vcgEdge = new RouteVCGEdge();
            vcgEdge.node = vcgNode;
            vcgEdge.next = vcgRoot.edges;
            vcgRoot.edges = vcgEdge;
            chNode2 = chNode2.next;
        }
        this.vcgCreateDependents(vcgRoot, channel);
        this.createPowerTies(channel, vcgRoot, cell);
        this.createGroundTies(channel, vcgRoot, cell);
        RouteVCGEdge vcgEdge = vcgRoot.edges;
        while (vcgEdge != null) {
            vcgEdge.node.flags &= 0xFFFFFFFE;
            vcgEdge = vcgEdge.next;
        }
        vcgEdge = vcgRoot.edges;
        while (vcgEdge != null) {
            RouteVCGEdge edge1 = vcgEdge.node.edges;
            while (edge1 != null) {
                edge1.node.flags |= 1;
                edge1 = edge1.next;
            }
            vcgEdge = vcgEdge.next;
        }
        RouteVCGEdge edge1 = vcgRoot.edges;
        RouteVCGEdge vcgEdge2 = vcgRoot.edges;
        while (vcgEdge2 != null) {
            if ((vcgEdge2.node.flags & 1) != 0) {
                if (vcgEdge2 == vcgRoot.edges) {
                    vcgRoot.edges = vcgEdge2.next;
                    edge1 = vcgEdge2.next;
                } else {
                    edge1.next = vcgEdge2.next;
                }
            } else {
                edge1 = vcgEdge2;
            }
            vcgEdge2 = vcgEdge2.next;
        }
        return vcgRoot;
    }

    private void vcgCreateDependents(RouteVCG vcgRoot, RouteChannel channel) {
        boolean check = true;
        while (check) {
            check = false;
            this.vcgSetDependents(vcgRoot);
            GenMath.MutableInteger found = new GenMath.MutableInteger(0);
            GenMath.MutableDouble diff = new GenMath.MutableDouble(0.0);
            Place.NBPlace place = this.vcgCyclicCheck(vcgRoot, diff, found);
            if (found.intValue() == 0) continue;
            check = true;
            Place.NBPlace place2 = place;
            while (place2 != null) {
                place2.xPos += diff.doubleValue();
                place2 = place2.next;
            }
            RouteChNode chNode = channel.nodes;
            while (chNode != null) {
                RouteChPort chPort = chNode.firstPort;
                while (chPort != null) {
                    chPort.xPos = this.portPosition(chPort.port);
                    chPort = chPort.next;
                }
                chPort = chNode.firstPort;
                while (chPort != null) {
                    RouteChPort port2 = chPort.last;
                    while (port2 != null && !(port2.xPos <= chPort.xPos)) {
                        chPort.last = port2.last;
                        port2.last = chPort;
                        if (chPort.last != null) {
                            chPort.last.next = chPort;
                        }
                        port2.next = chPort.next;
                        chPort.next = port2;
                        if (port2.next != null) {
                            port2.next.last = port2;
                        }
                        if (port2 == chNode.firstPort) {
                            chNode.firstPort = chPort;
                        }
                        if (chPort == chNode.lastPort) {
                            chNode.lastPort = port2;
                        }
                        port2 = chPort.last;
                    }
                    chPort = chPort.next;
                }
                chNode = chNode.next;
            }
        }
    }

    private void vcgSetDependents(RouteVCG vcgRoot) {
        RouteVCGEdge edge1 = vcgRoot.edges;
        while (edge1 != null) {
            edge1.node.edges = null;
            edge1 = edge1.next;
        }
        edge1 = vcgRoot.edges;
        while (edge1 != null) {
            RouteVCGEdge edge2 = edge1.next;
            while (edge2 != null) {
                RouteVCGEdge vcgEdge;
                boolean depend1 = false;
                boolean depend2 = false;
                RouteChPort port1 = edge1.node.chNode.firstPort;
                while (port1 != null) {
                    RouteChPort port2 = edge2.node.chNode.firstPort;
                    while (port2 != null) {
                        if (Math.abs(port1.xPos - port2.xPos) < SilComp.getMinPortDistance()) {
                            if (port1.port.node.row.number > port2.port.node.row.number) {
                                depend1 = true;
                            } else {
                                depend2 = true;
                            }
                        }
                        port2 = port2.next;
                    }
                    port1 = port1.next;
                }
                if (depend1) {
                    vcgEdge = new RouteVCGEdge();
                    vcgEdge.node = edge2.node;
                    vcgEdge.next = edge1.node.edges;
                    edge1.node.edges = vcgEdge;
                }
                if (depend2) {
                    vcgEdge = new RouteVCGEdge();
                    vcgEdge.node = edge1.node;
                    vcgEdge.next = edge2.node.edges;
                    edge2.node.edges = vcgEdge;
                }
                edge2 = edge2.next;
            }
            edge1 = edge1.next;
        }
    }

    private Place.NBPlace vcgCyclicCheck(RouteVCG vcgRoot, GenMath.MutableDouble diff, GenMath.MutableInteger found) {
        Place.NBPlace place = null;
        RouteVCGEdge edge = vcgRoot.edges;
        while (edge != null) {
            RouteVCGEdge edge3 = vcgRoot.edges;
            while (edge3 != null) {
                edge3.node.flags &= 0xFFFFFFFA;
                edge3 = edge3.next;
            }
            edge.node.flags |= 1;
            RouteVCGEdge edge2 = edge.node.edges;
            while (edge2 != null) {
                RouteVCG lastNode = edge.node;
                GenMath.MutableInteger subFound = new GenMath.MutableInteger(0);
                lastNode = this.vcgSingleCycle(edge2.node, lastNode, subFound);
                if (subFound.intValue() != 0) {
                    RouteChPort port1 = edge.node.chNode.firstPort;
                    while (port1 != null) {
                        RouteChPort port2 = lastNode.chNode.firstPort;
                        while (port2 != null) {
                            if (Math.abs(port1.xPos - port2.xPos) < SilComp.getMinPortDistance()) {
                                if (port1.port.node.row.number > port2.port.node.row.number) {
                                    place = port1.port.place;
                                    if (port1.xPos < port2.xPos) {
                                        diff.setValue(port2.xPos - port1.xPos + SilComp.getMinPortDistance());
                                    } else {
                                        diff.setValue(SilComp.getMinPortDistance() - (port1.xPos - port2.xPos));
                                    }
                                } else if (port2.port.node.row.number > port1.port.node.row.number) {
                                    place = port2.port.place;
                                    if (port2.xPos < port1.xPos) {
                                        diff.setValue(port1.xPos - port2.xPos + SilComp.getMinPortDistance());
                                    } else {
                                        diff.setValue(SilComp.getMinPortDistance() - (port2.xPos - port1.xPos));
                                    }
                                } else {
                                    System.out.println("SEVERE ERROR - Cyclic conflict to same row, check leaf cells.");
                                    System.out.println("At " + port1.port.place.cell.name + " " + ((PortProto)port1.port.port.port).getName() + " to " + port2.port.place.cell.name + " " + ((PortProto)port2.port.port.port).getName());
                                    return null;
                                }
                                found.setValue(1);
                                return place;
                            }
                            port2 = port2.next;
                        }
                        port1 = port1.next;
                    }
                    System.out.println("SEVERE WARNING - Cyclic conflict discovered but cannot find place to resolve.");
                }
                edge2 = edge2.next;
            }
            edge = edge.next;
        }
        found.setValue(0);
        return place;
    }

    private RouteVCG vcgSingleCycle(RouteVCG node, RouteVCG lastNode, GenMath.MutableInteger found) {
        if (node == null) {
            found.setValue(0);
            return lastNode;
        }
        if ((node.flags & 1) != 0) {
            found.setValue(1);
            return lastNode;
        }
        if ((node.flags & 4) != 0) {
            found.setValue(0);
            return lastNode;
        }
        node.flags |= 4;
        RouteVCG saveNode = lastNode;
        RouteVCGEdge edge = node.edges;
        while (edge != null) {
            lastNode = node;
            lastNode = this.vcgSingleCycle(edge.node, lastNode, found);
            if (found.intValue() != 0) {
                return lastNode;
            }
            edge = edge.next;
        }
        lastNode = saveNode;
        found.setValue(0);
        return lastNode;
    }

    private RouteZRG createZRG(RouteChannel channel) {
        RouteChNode leftChNode;
        RouteZRG firstZone = null;
        RouteZRG lastZone = null;
        int zNumber = 0;
        RouteZRG zone = new RouteZRG();
        zone.number = zNumber++;
        zone.chNodes = null;
        zone.next = null;
        zone.last = null;
        firstZone = lastZone = zone;
        int numChNodes = 0;
        RouteChNode chNode = channel.nodes;
        while (chNode != null) {
            chNode.flags &= 0xFFFFFFFE;
            ++numChNodes;
            chNode = chNode.next;
        }
        RouteChNode[] chNodeList = new RouteChNode[numChNodes + 1];
        while ((leftChNode = this.findLeftmostChNode(channel.nodes)) != null) {
            this.createZRGTempList(channel.nodes, leftChNode.firstPort.xPos, chNodeList);
            if (this.zrgListCompatible(chNodeList, zone)) {
                this.zrgAddChNodes(chNodeList, zone);
            } else {
                zone = new RouteZRG();
                zone.number = zNumber++;
                zone.chNodes = null;
                zone.next = null;
                zone.last = lastZone;
                lastZone.next = zone;
                lastZone = zone;
                this.zrgAddChNodes(chNodeList, zone);
            }
            leftChNode.flags |= 1;
        }
        return firstZone;
    }

    private RouteChNode findLeftmostChNode(RouteChNode nodes) {
        RouteChNode leftChNode = null;
        double leftXPos = Double.MAX_VALUE;
        RouteChNode node = nodes;
        while (node != null) {
            if ((node.flags & 1) == 0 && node.firstPort.xPos < leftXPos) {
                leftXPos = node.firstPort.xPos;
                leftChNode = node;
            }
            node = node.next;
        }
        return leftChNode;
    }

    private void createZRGTempList(RouteChNode nodes, double xPos, RouteChNode[] list) {
        int i = 0;
        RouteChNode node = nodes;
        while (node != null) {
            if (xPos > node.firstPort.xPos - SilComp.getMinPortDistance() && xPos < node.lastPort.xPos + SilComp.getMinPortDistance()) {
                list[i++] = node;
            }
            node = node.next;
        }
        list[i] = null;
    }

    private boolean zrgListCompatible(RouteChNode[] list, RouteZRG zone) {
        if (zone.chNodes != null) {
            RouteZRGMem mem = zone.chNodes;
            while (mem != null) {
                int i = 0;
                while (list[i] != null && mem.chNode != list[i]) {
                    ++i;
                }
                if (list[i] == null) {
                    return false;
                }
                mem = mem.next;
            }
            return true;
        }
        return true;
    }

    private void zrgAddChNodes(RouteChNode[] list, RouteZRG zone) {
        int i = 0;
        while (list[i] != null) {
            RouteZRGMem mem = zone.chNodes;
            while (mem != null && mem.chNode != list[i]) {
                mem = mem.next;
            }
            if (mem == null) {
                mem = new RouteZRGMem();
                mem.chNode = list[i];
                mem.next = zone.chNodes;
                zone.chNodes = mem;
            }
            ++i;
        }
    }

    private RouteTrack trackAssignment(RouteVCG vcg, RouteZRG zrg, RouteChNode nodes) {
        RouteChNode node;
        RouteTrack firstTrack = null;
        RouteTrack lastTrack = null;
        int trackNumber = 0;
        RouteTrack track = new RouteTrack();
        track.number = trackNumber++;
        track.nodes = null;
        track.last = null;
        track.next = null;
        firstTrack = lastTrack = track;
        int numberNodes = 0;
        RouteChNode node2 = nodes;
        while (node2 != null) {
            node2.flags = 0;
            ++numberNodes;
            node2 = node2.next;
        }
        RouteChNode[] nList = new RouteChNode[numberNodes + 1];
        while ((node = this.longestVCG(vcg)) != null) {
            RouteChNode node22 = nodes;
            while (node22 != null) {
                node22.flags = 0;
                node22 = node22.next;
            }
            this.addNodeToTrack(node, track);
            this.markZones(node, zrg, 2);
            this.findBestNodes(vcg, zrg, nList, numberNodes + 1);
            int i = 0;
            while (nList[i] != null) {
                this.addNodeToTrack(nList[i], track);
                ++i;
            }
            this.deleteFromVCG(track, vcg);
            track = new RouteTrack();
            track.number = trackNumber++;
            track.nodes = null;
            track.last = lastTrack;
            lastTrack.next = track;
            lastTrack = track;
        }
        if (track.nodes == null) {
            if (track.last != null) {
                track.last.next = null;
            } else {
                firstTrack = null;
            }
        }
        return firstTrack;
    }

    private void markZones(RouteChNode node, RouteZRG zrg, int bits) {
        RouteZRG zone = zrg;
        while (zone != null) {
            RouteZRGMem zMem = zone.chNodes;
            while (zMem != null && zMem.chNode != node) {
                zMem = zMem.next;
            }
            if (zMem != null) {
                zMem = zone.chNodes;
                while (zMem != null) {
                    zMem.chNode.flags |= bits;
                    zMem = zMem.next;
                }
            }
            zone = zone.next;
        }
    }

    private RouteChNode longestVCG(RouteVCG vcg) {
        RouteChNode node = null;
        double longestPath = 0.0;
        RouteVCGEdge edge = vcg.edges;
        while (edge != null) {
            double path = this.pathLength(edge.node);
            if (path > longestPath) {
                longestPath = path;
                node = edge.node.chNode;
            }
            edge = edge.next;
        }
        return node;
    }

    private double pathLength(RouteVCG vcgNode) {
        if (vcgNode.edges == null) {
            return 1.0;
        }
        double longest = 0.0;
        RouteVCGEdge edge = vcgNode.edges;
        while (edge != null) {
            double path = this.pathLength(edge.node);
            if (path > longest) {
                longest = path;
            }
            edge = edge.next;
        }
        return longest + 1.0;
    }

    private void addNodeToTrack(RouteChNode node, RouteTrack track) {
        RouteTrackMem mem = new RouteTrackMem();
        mem.node = node;
        mem.next = null;
        if (track.nodes == null) {
            track.nodes = mem;
        } else {
            RouteTrackMem oldMem = track.nodes;
            RouteTrackMem mem2 = track.nodes;
            while (mem2 != null && mem.node.firstPort.xPos > mem2.node.firstPort.xPos) {
                oldMem = mem2;
                mem2 = mem2.next;
            }
            mem.next = mem2;
            if (mem2 == track.nodes) {
                track.nodes = mem;
            } else {
                oldMem.next = mem;
            }
        }
        node.flags |= 1;
    }

    private void findBestNodes(RouteVCG vcg, RouteZRG zrg, RouteChNode[] nList, int num) {
        int i = 0;
        nList[i] = null;
        while (true) {
            RouteVCGEdge edge2 = null;
            double maxLength = 0.0;
            RouteVCGEdge edge = vcg.edges;
            while (edge != null) {
                double length;
                if ((edge.node.chNode.flags & 3) == 0 && (length = edge.node.chNode.lastPort.xPos - edge.node.chNode.firstPort.xPos) >= maxLength) {
                    maxLength = length;
                    edge2 = edge;
                }
                edge = edge.next;
            }
            if (edge2 == null) break;
            nList[i++] = edge2.node.chNode;
            nList[i] = null;
            this.markZones(edge2.node.chNode, zrg, 2);
        }
    }

    private void deleteFromVCG(RouteTrack track, RouteVCG vcg) {
        RouteTrackMem mem = track.nodes;
        while (mem != null) {
            RouteVCGEdge edge2 = vcg.edges;
            RouteVCGEdge edge = vcg.edges;
            while (edge != null) {
                if (edge.node.chNode == mem.node) {
                    if (edge == vcg.edges) {
                        vcg.edges = edge.next;
                    } else {
                        edge2.next = edge.next;
                    }
                    edge2 = edge.node.edges;
                    while (edge2 != null) {
                        edge2.node.flags &= 0xFFFFFFFE;
                        edge2 = edge2.next;
                    }
                    edge2 = edge.node.edges;
                    while (edge2 != null) {
                        this.markVCG(edge2.node.edges);
                        edge2 = edge2.next;
                    }
                    this.markVCG(vcg.edges);
                    RouteVCGEdge edge3 = null;
                    edge2 = edge.node.edges;
                    while (edge2 != null) {
                        edge3 = edge2.next;
                        if ((edge2.node.flags & 1) == 0) {
                            edge2.next = vcg.edges;
                            vcg.edges = edge2;
                        }
                        edge2 = edge3;
                    }
                    break;
                }
                edge2 = edge;
                edge = edge.next;
            }
            mem = mem.next;
        }
    }

    private void markVCG(RouteVCGEdge edges) {
        if (edges == null) {
            return;
        }
        while (edges != null) {
            edges.node.flags |= 1;
            this.markVCG(edges.node.edges);
            edges = edges.next;
        }
    }

    private void createPowerTies(RouteChannel chan, RouteVCG vcg, GetNetlist.SCCell cell) {
        if (chan.number == 0) {
            return;
        }
        int rowIndex = 0;
        Place.RowList row = cell.placement.theRows.get(rowIndex);
        for (int num = 1; num < chan.number && row != null; ++num) {
            row = cell.placement.theRows.get(++rowIndex);
        }
        if (row == null) {
            return;
        }
        RouteRow rRow = cell.route.rows;
        for (int num = 1; num < chan.number; ++num) {
            rRow = rRow.next;
        }
        Place.NBPlace place = row.start;
        while (place != null) {
            if (place.cell.type == 0) {
                GetNetlist.SCNiPort port = place.cell.ports;
                while (port != null) {
                    if (port.extNode == cell.power) {
                        if (place.cell.power == null) {
                            System.out.println("WARNING - Cannot find power on " + place.cell.name);
                        } else {
                            RouteNode rNode = new RouteNode();
                            rNode.extNode = port.extNode;
                            rNode.row = rRow;
                            rNode.firstPort = null;
                            rNode.lastPort = null;
                            rNode.sameNext = null;
                            rNode.sameLast = null;
                            rNode.next = rRow.nodes;
                            rRow.nodes = rNode;
                            RoutePort rPort1 = new RoutePort();
                            rPort1.place = place;
                            rPort1.port = port;
                            rPort1.node = rNode;
                            rNode.firstPort = rPort1;
                            rPort1.flags = 0;
                            rPort1.last = null;
                            rPort1.next = null;
                            RoutePort rPort2 = new RoutePort();
                            rPort2.place = place;
                            rPort2.port = place.cell.power;
                            rPort2.node = rNode;
                            rNode.lastPort = rPort2;
                            rPort2.flags = 0;
                            rPort2.last = rPort1;
                            rPort1.next = rPort2;
                            rPort2.next = null;
                            RouteChNode chNode = new RouteChNode();
                            chNode.extNode = port.extNode;
                            chNode.number = 0;
                            chNode.firstPort = null;
                            chNode.lastPort = null;
                            chNode.channel = chan;
                            chNode.flags = 0;
                            chNode.sameNext = null;
                            chNode.sameLast = null;
                            chNode.next = chan.nodes;
                            chan.nodes = chNode;
                            RouteChPort chPort1 = new RouteChPort();
                            chPort1.port = rPort1;
                            chPort1.node = chNode;
                            chPort1.xPos = this.portPosition(rPort1);
                            chPort1.flags = 0;
                            chPort1.last = null;
                            chPort1.next = null;
                            RouteChPort chPort2 = new RouteChPort();
                            chPort2.port = rPort2;
                            chPort2.node = chNode;
                            chPort2.xPos = this.portPosition(rPort2);
                            chPort2.flags = 0;
                            chPort2.last = null;
                            chPort2.next = null;
                            if (chPort1.xPos <= chPort2.xPos) {
                                chNode.firstPort = chPort1;
                                chNode.lastPort = chPort2;
                                chPort1.next = chPort2;
                                chPort2.last = chPort1;
                            } else {
                                chNode.firstPort = chPort2;
                                chNode.lastPort = chPort1;
                                chPort2.next = chPort1;
                                chPort1.last = chPort2;
                            }
                            RouteVCG vNode = new RouteVCG();
                            vNode.chNode = chNode;
                            vNode.flags = 0;
                            vNode.edges = null;
                            RouteVCGEdge vEdge = new RouteVCGEdge();
                            vEdge.node = vNode;
                            vEdge.next = vcg.edges;
                            vcg.edges = vEdge;
                            RouteVCGEdge edge1 = vEdge.next;
                            while (edge1 != null) {
                                double minX = edge1.node.chNode.firstPort.xPos - SilComp.getMinPortDistance();
                                double maxX = edge1.node.chNode.lastPort.xPos + SilComp.getMinPortDistance();
                                if (chPort2.xPos > minX && chPort2.xPos < maxX) {
                                    RouteVCGEdge edge2 = new RouteVCGEdge();
                                    edge2.node = vNode;
                                    edge2.next = edge1.node.edges;
                                    edge1.node.edges = edge2;
                                }
                                edge1 = edge1.next;
                            }
                        }
                    }
                    port = port.next;
                }
            }
            place = place.next;
        }
    }

    private void createGroundTies(RouteChannel chan, RouteVCG vcg, GetNetlist.SCCell cell) {
        if (chan.number == cell.placement.numRows) {
            return;
        }
        int rowIndex = 0;
        Place.RowList row = cell.placement.theRows.get(rowIndex);
        for (int num = 0; num < chan.number && row != null; ++num) {
            row = cell.placement.theRows.get(++rowIndex);
        }
        if (row == null) {
            return;
        }
        RouteRow rRow = cell.route.rows;
        for (int num = 0; num < chan.number; ++num) {
            rRow = rRow.next;
        }
        Place.NBPlace place = row.start;
        while (place != null) {
            if (place.cell.type == 0) {
                GetNetlist.SCNiPort port = place.cell.ports;
                while (port != null) {
                    if (port.extNode == cell.ground) {
                        if (place.cell.ground == null) {
                            System.out.println("WARNING - Cannot find ground on " + place.cell.name);
                        } else {
                            RouteNode rNode = new RouteNode();
                            rNode.extNode = port.extNode;
                            rNode.row = rRow;
                            rNode.firstPort = null;
                            rNode.lastPort = null;
                            rNode.sameNext = null;
                            rNode.sameLast = null;
                            rNode.next = rRow.nodes;
                            rRow.nodes = rNode;
                            RoutePort rPort1 = new RoutePort();
                            rPort1.place = place;
                            rPort1.port = port;
                            rPort1.node = rNode;
                            rNode.firstPort = rPort1;
                            rPort1.flags = 0;
                            rPort1.last = null;
                            rPort1.next = null;
                            RoutePort rPort2 = new RoutePort();
                            rPort2.place = place;
                            rPort2.port = place.cell.ground;
                            rPort2.node = rNode;
                            rNode.lastPort = rPort2;
                            rPort2.flags = 0;
                            rPort2.last = rPort1;
                            rPort1.next = rPort2;
                            rPort2.next = null;
                            RouteChNode chNode = new RouteChNode();
                            chNode.extNode = port.extNode;
                            chNode.number = 0;
                            chNode.firstPort = null;
                            chNode.lastPort = null;
                            chNode.channel = chan;
                            chNode.flags = 0;
                            chNode.sameNext = null;
                            chNode.sameLast = null;
                            chNode.next = chan.nodes;
                            chan.nodes = chNode;
                            RouteChPort chPort1 = new RouteChPort();
                            chPort1.port = rPort1;
                            chPort1.node = chNode;
                            chPort1.xPos = this.portPosition(rPort1);
                            chPort1.flags = 0;
                            chPort1.last = null;
                            chPort1.next = null;
                            RouteChPort chPort2 = new RouteChPort();
                            chPort2.port = rPort2;
                            chPort2.node = chNode;
                            chPort2.xPos = this.portPosition(rPort2);
                            chPort2.flags = 0;
                            chPort2.last = null;
                            chPort2.next = null;
                            if (chPort1.xPos <= chPort2.xPos) {
                                chNode.firstPort = chPort1;
                                chNode.lastPort = chPort2;
                                chPort1.next = chPort2;
                                chPort2.last = chPort1;
                            } else {
                                chNode.firstPort = chPort2;
                                chNode.lastPort = chPort1;
                                chPort2.next = chPort1;
                                chPort1.last = chPort2;
                            }
                            RouteVCG vNode = new RouteVCG();
                            vNode.chNode = chNode;
                            vNode.flags = 0;
                            vNode.edges = null;
                            RouteVCGEdge vEdge = new RouteVCGEdge();
                            vEdge.node = vNode;
                            vEdge.next = vcg.edges;
                            vcg.edges = vEdge;
                            RouteVCGEdge edge1 = vEdge.next;
                            while (edge1 != null) {
                                double minX = edge1.node.chNode.firstPort.xPos - SilComp.getMinPortDistance();
                                double maxX = edge1.node.chNode.lastPort.xPos + SilComp.getMinPortDistance();
                                if (chPort2.xPos > minX && chPort2.xPos < maxX) {
                                    RouteVCGEdge edge2 = new RouteVCGEdge();
                                    edge2.node = edge1.node;
                                    edge2.next = vNode.edges;
                                    vNode.edges = edge2;
                                }
                                edge1 = edge1.next;
                            }
                        }
                    }
                    port = port.next;
                }
            }
            place = place.next;
        }
    }

    private void printVCG(RouteVCGEdge edges, int level) {
        if (edges == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int i = level << 2;
        for (int j = 0; j < i; ++j) {
            sb.append(" ");
        }
        while (edges != null) {
            System.out.println(sb.toString() + "before Net " + edges.node.chNode.number);
            this.printVCG(edges.node.edges, level + 1);
            edges = edges.next;
        }
    }

    public static class RouteExport {
        GetNetlist.SCPort xPort;
        RouteChPort chPort;
        RouteExport next;
    }

    public static class RouteTrackMem {
        RouteChNode node;
        RouteTrackMem next;
    }

    public static class RouteTrack {
        int number;
        RouteTrackMem nodes;
        RouteTrack last;
        RouteTrack next;
    }

    private static class RouteZRGMem {
        RouteChNode chNode;
        RouteZRGMem next;

        private RouteZRGMem() {
        }
    }

    private static class RouteZRG {
        int number;
        RouteZRGMem chNodes;
        RouteZRG last;
        RouteZRG next;

        private RouteZRG() {
        }
    }

    private static class RouteVCGEdge {
        RouteVCG node;
        RouteVCGEdge next;

        private RouteVCGEdge() {
        }
    }

    private static class RouteVCG {
        RouteChNode chNode;
        int flags;
        RouteVCGEdge edges;

        private RouteVCG() {
        }
    }

    public static class RouteChPort {
        RoutePort port;
        RouteChNode node;
        double xPos;
        int flags;
        RouteChPort last;
        RouteChPort next;
    }

    public static class RouteChNode {
        GetNetlist.ExtNode extNode;
        int number;
        RouteChPort firstPort;
        RouteChPort lastPort;
        RouteChannel channel;
        int flags;
        RouteChNode sameNext;
        RouteChNode sameLast;
        RouteChNode next;
    }

    public static class RouteChannel {
        int number;
        RouteChNode nodes;
        RouteTrack tracks;
        RouteChannel last;
        RouteChannel next;
    }

    public static class RoutePort {
        Place.NBPlace place;
        GetNetlist.SCNiPort port;
        RouteNode node;
        int flags;
        RoutePort last;
        RoutePort next;
    }

    private static class RouteNode {
        GetNetlist.ExtNode extNode;
        RouteRow row;
        RoutePort firstPort;
        RoutePort lastPort;
        RouteNode sameNext;
        RouteNode sameLast;
        RouteNode next;

        private RouteNode() {
        }
    }

    private static class RouteRow {
        int number;
        RouteNode nodes;
        Place.RowList row;
        RouteRow last;
        RouteRow next;

        private RouteRow() {
        }
    }

    public static class SCRoute {
        RouteChannel channels;
        RouteExport exports;
        RouteRow rows;
    }
}

