/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.generator.flag.FlagAnnotations;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlagLibraryCheckerJob
extends Job {
    private static final long serialVersionUID = 0L;

    private void prln(String msg) {
        System.out.println(msg);
    }

    private Set<Cell.CellGroup> getCellGroupsToCheck() {
        HashSet<Cell.CellGroup> groupsToCheck = new HashSet<Cell.CellGroup>();
        Iterator<Library> liIt = Library.getLibraries();
        while (liIt.hasNext()) {
            Library lib = liIt.next();
            Iterator<Cell> cellIt = lib.getCells();
            while (cellIt.hasNext()) {
                FlagAnnotations ann;
                Cell cell = cellIt.next();
                if (cell.getView() != View.SCHEMATIC || (ann = new FlagAnnotations(cell)) == null || !ann.isAtomic()) continue;
                groupsToCheck.add(cell.getCellGroup());
            }
        }
        return groupsToCheck;
    }

    private Cell findLayoutCell(Cell.CellGroup cg) {
        Cell layCell = null;
        Iterator<Cell> cIt = cg.getCells();
        while (cIt.hasNext()) {
            Cell c = cIt.next();
            if (c.getView() != View.LAYOUT) continue;
            if (layCell != null) {
                this.prln("    Cell group has more than one layout Cell");
                break;
            }
            layCell = c;
        }
        return layCell;
    }

    private void checkCell(Cell c) {
        Rectangle2D bnds = c.findEssentialBounds();
        if (bnds == null) {
            this.prln("Stage: " + c.getName() + " is missing essential bounds");
            return;
        }
        Iterator<Export> it = c.getExports();
        while (it.hasNext()) {
            Export e = it.next();
            PortCharacteristic pc = e.getCharacteristic();
            if (pc == PortCharacteristic.PWR || pc == PortCharacteristic.GND || pc == PortCharacteristic.IN || pc == PortCharacteristic.OUT || pc == PortCharacteristic.BIDIR) continue;
            this.prln("Cell: " + c.getName() + " Export " + e + " has undesired characteristic: " + (Object)((Object)pc));
        }
    }

    private void checkCellGroup(Cell.CellGroup cg) {
        this.prln("  Checking layout: " + cg.getName());
        Cell layCell = this.findLayoutCell(cg);
        if (layCell == null) {
            this.prln("    Cell group has no layout Cell");
            return;
        }
        this.checkCell(layCell);
    }

    private void checkCellGroups(Collection<Cell.CellGroup> cellGroups) {
        for (Cell.CellGroup cg : cellGroups) {
            this.checkCellGroup(cg);
        }
    }

    @Override
    public boolean doIt() throws JobException {
        Set<Cell.CellGroup> cellsToCheck = this.getCellGroupsToCheck();
        this.prln("FLAG Found " + cellsToCheck.size() + " atomic Cell groups");
        this.checkCellGroups(cellsToCheck);
        return true;
    }

    public FlagLibraryCheckerJob() {
        super("FLAG library checker", NetworkTool.getNetworkTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
        this.startJob();
    }
}

