/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellId;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.constraint.Layout;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.XMLRules;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.drc.Quick;
import com.sun.electric.tool.drc.Schematic;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DRC
extends Listener {
    protected static DRC tool = new DRC();
    private static HashMap<Technology, Pref> prefDRCOverride = new HashMap();
    private static HashMap<Cell, HashSet<Geometric>> cellsToCheck = new HashMap();
    private static HashMap<Cell, StoreDRCInfo> storedDRCDate = new HashMap();
    private static ErrorLogger errorLoggerIncremental = null;
    private static boolean incrementalRunning = false;
    public static final Variable.Key DRC_LAST_GOOD_DATE = Variable.newKey("DRC_last_good_drc_date");
    public static final Variable.Key DRC_LAST_GOOD_BIT = Variable.newKey("DRC_last_good_drc_bit");
    private static final int DRC_BIT_AREA = 1;
    private static final int DRC_BIT_EXTENSION = 2;
    private static final int DRC_BIT_ST_FOUNDRY = 4;
    private static final int DRC_BIT_TSMC_FOUNDRY = 8;
    private static final int DRC_BIT_MOSIS_FOUNDRY = 16;
    private static Technology currentTechnology = null;
    private static Pref cacheIncrementalDRCOn = Pref.makeBooleanPref("IncrementalDRCOn", DRC.tool.prefs, false);
    private static Pref cacheInteractiveDRCDragOn = Pref.makeBooleanPref("InteractiveDRCDrag", DRC.tool.prefs, true);
    private static Pref cacheErrorLoggingType = Pref.makeStringPref("ErrorLoggingType", DRC.tool.prefs, DRCCheckLogging.DRC_LOG_PER_CELL.name());
    private static Pref cacheErrorCheckLevel = Pref.makeIntPref("ErrorCheckLevel", DRC.tool.prefs, DRCCheckMode.ERROR_CHECK_DEFAULT.mode());
    private static Pref cacheUseMultipleThreads = Pref.makeBooleanPref("UseMultipleThreads", DRC.tool.prefs, false);
    private static Pref cacheNumberOfThreads = Pref.makeIntPref("NumberOfThreads", DRC.tool.prefs, 2);
    private static Pref cacheIgnoreCenterCuts = Pref.makeBooleanPref("IgnoreCenterCuts", DRC.tool.prefs, false);
    private static Pref cacheIgnoreAreaChecking = Pref.makeBooleanPref("IgnoreAreaCheck", DRC.tool.prefs, false);
    private static Pref cacheIgnoreExtensionRuleChecking = Pref.makeBooleanPref("IgnoreExtensionRuleCheck", DRC.tool.prefs, false);
    private static Pref cacheStoreDatesInMemory = Pref.makeBooleanPref("StoreDatesInMemory", DRC.tool.prefs, false);
    private static Pref cacheInteractiveLog = Pref.makeBooleanPref("InteractiveLog", DRC.tool.prefs, false);
    private static Pref cacheMinAreaAlgo = Pref.makeStringPref("MinAreaAlgorithm", DRC.tool.prefs, DRCCheckMinArea.AREA_LOCAL.name());

    public static Layer.Function.Set getMultiLayersSet(Layer layer) {
        Layer.Function.Set thisLayerFunction = layer.getFunction().isPoly() ? new Layer.Function.Set(Layer.Function.POLY1, Layer.Function.GATE) : new Layer.Function.Set(layer.getFunction(), layer.getFunctionExtras());
        return thisLayerFunction;
    }

    public static void createDRCErrorLogger(ErrorLogger errorLogger, Map<Cell, Area> exclusionMap, DRCCheckMode errorTypeSearch, boolean interactiveLogger, DRCErrorType errorType, String msg, Cell cell, double limit, double actual, String rule, PolyBase poly1, Geometric geom1, Layer layer1, PolyBase poly2, Geometric geom2, Layer layer2) {
        boolean onlyWarning;
        if (errorLogger == null) {
            return;
        }
        StringBuffer DRCexclusionMsg = new StringBuffer();
        if (exclusionMap != null && exclusionMap.get(cell) != null) {
            boolean found;
            ArrayList<PolyBase> polyList = new ArrayList<PolyBase>(2);
            ArrayList<Geometric> geomList = new ArrayList<Geometric>(2);
            polyList.add(poly1);
            geomList.add(geom1);
            if (poly2 != null) {
                polyList.add(poly2);
                geomList.add(geom2);
            }
            if (found = DRC.checkExclusionMap(exclusionMap, cell, polyList, geomList, DRCexclusionMsg)) {
                return;
            }
        }
        Cell np1 = geom1 != null ? geom1.getParent() : null;
        Cell np2 = geom2 != null ? geom2.getParent() : null;
        boolean bl = onlyWarning = errorType == DRCErrorType.ZEROLENGTHARCWARN || errorType == DRCErrorType.TECHMIXWARN;
        if (geom2 != null && errorTypeSearch != DRCCheckMode.ERROR_CHECK_EXHAUSTIVE && errorLogger.findMessage(cell, geom1, geom2.getParent(), geom2, !onlyWarning)) {
            return;
        }
        StringBuffer errorMessage = new StringBuffer();
        DRCCheckLogging loggingType = DRC.getErrorLoggingType();
        int sortKey = cell.hashCode();
        if (errorType == DRCErrorType.SPACINGERROR || errorType == DRCErrorType.NOTCHERROR || errorType == DRCErrorType.SURROUNDERROR) {
            if (errorType == DRCErrorType.SPACINGERROR) {
                errorMessage.append("Spacing");
            } else if (errorType == DRCErrorType.SURROUNDERROR) {
                errorMessage.append("Surround");
            } else {
                errorMessage.append("Notch");
            }
            if (layer1 == layer2) {
                errorMessage.append(" (layer '" + layer1.getName() + "')");
            }
            errorMessage.append(": ");
            if (np1 != np2) {
                errorMessage.append(np1 + ", ");
            } else if (np1 != cell && np1 != null) {
                errorMessage.append("[in " + np1 + "] ");
            }
            if (geom1 != null) {
                errorMessage.append(geom1);
            }
            if (layer1 != layer2) {
                errorMessage.append(", layer '" + layer1.getName() + "'");
            }
            if (actual < 0.0) {
                errorMessage.append(" OVERLAPS (BY " + TextUtils.formatDouble(limit - actual) + ") ");
            } else if (actual == 0.0) {
                errorMessage.append(" TOUCHES ");
            } else {
                errorMessage.append(" LESS (BY " + TextUtils.formatDouble(limit - actual) + ") THAN " + TextUtils.formatDouble(limit) + (geom2 != null ? " TO " : ""));
            }
            if (np1 != np2 && np2 != null) {
                errorMessage.append(np2 + ", ");
            }
            if (geom2 != null) {
                errorMessage.append(geom2);
            }
            if (layer1 != layer2) {
                errorMessage.append(", layer '" + layer2.getName() + "'");
            }
            if (msg != null) {
                errorMessage.append("; " + msg);
            }
        } else {
            StringBuffer errorMessagePart2 = null;
            switch (errorType) {
                case RESOLUTION: {
                    errorMessage.append("Resolution error:");
                    errorMessagePart2 = new StringBuffer(msg);
                    break;
                }
                case FORBIDDEN: {
                    errorMessage.append("Forbidden error:");
                    errorMessagePart2 = new StringBuffer(msg);
                    break;
                }
                case SLOTSIZEERROR: {
                    errorMessage.append("Slot size error:");
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    errorMessagePart2.append(" BIGGER THAN " + TextUtils.formatDouble(limit) + " IN LENGTH (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case MINAREAERROR: {
                    errorMessage.append("Minimum area error:");
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    errorMessagePart2.append(" LESS THAN " + TextUtils.formatDouble(limit) + " IN AREA (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case ENCLOSEDAREAERROR: {
                    errorMessage.append("Enclosed area error:");
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    errorMessagePart2.append(" LESS THAN " + TextUtils.formatDouble(limit) + " IN AREA (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case TECHMIXWARN: {
                    errorMessage.append("Technology mixture warning:");
                    errorMessagePart2 = new StringBuffer(msg);
                    break;
                }
                case ZEROLENGTHARCWARN: {
                    errorMessage.append("Zero width warning:");
                    errorMessagePart2 = new StringBuffer(msg);
                    break;
                }
                case CUTERROR: {
                    errorMessage.append("Maximum cut error" + (msg != null ? "(" + msg + "):" : ""));
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    errorMessagePart2.append(" BIGGER THAN " + TextUtils.formatDouble(limit) + " WIDE (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case MINWIDTHERROR: {
                    errorMessage.append("Minimum width/height error" + (msg != null ? "(" + msg + "):" : ""));
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    errorMessagePart2.append(" LESS THAN " + TextUtils.formatDouble(limit) + " WIDE (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case MINSIZEERROR: {
                    errorMessage.append("Minimum size error on " + msg + ":");
                    errorMessagePart2 = new StringBuffer(" LESS THAN " + TextUtils.formatDouble(limit) + " IN SIZE (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case BADLAYERERROR: {
                    errorMessage.append("Invalid layer ('" + layer1.getName() + "'):");
                    break;
                }
                case LAYERSURROUNDERROR: {
                    errorMessage.append("Layer surround error: " + msg);
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    String layerName = layer2 != null ? layer2.getName() : "Select";
                    errorMessagePart2.append(" NEEDS SURROUND OF LAYER '" + layerName + "' BY " + limit);
                }
            }
            errorMessage.append(" " + cell + " ");
            if (geom1 != null) {
                errorMessage.append(geom1);
            }
            if (layer1 != null && loggingType == DRCCheckLogging.DRC_LOG_FLAT) {
                sortKey = layer1.getIndex();
            }
            errorMessage.append(errorMessagePart2);
        }
        if (rule != null && rule.length() > 0) {
            errorMessage.append(" [rule '" + rule + "']");
        }
        errorMessage.append(DRCexclusionMsg);
        ArrayList<Geometric> geomList = new ArrayList<Geometric>();
        ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
        if (poly1 != null) {
            polyList.add(poly1);
        } else if (geom1 != null) {
            geomList.add(geom1);
        }
        if (poly2 != null) {
            polyList.add(poly2);
        } else if (geom2 != null) {
            geomList.add(geom2);
        }
        switch (loggingType) {
            case DRC_LOG_PER_CELL: {
                errorLogger.setGroupName(sortKey, cell.getName());
                break;
            }
            case DRC_LOG_PER_RULE: {
                sortKey = rule.hashCode();
                if (errorLogger.getGroupName(sortKey) != null) break;
                errorLogger.setGroupName(sortKey, rule);
            }
        }
        if (onlyWarning) {
            errorLogger.logWarning(errorMessage.toString(), geomList, null, null, null, polyList, cell, sortKey);
        } else {
            errorLogger.logError(errorMessage.toString(), geomList, null, null, null, polyList, cell, sortKey);
        }
        if (interactiveLogger) {
            Job.getUserInterface().termLogging(errorLogger, false, false);
        }
    }

    private static boolean checkExclusionMap(Map<Cell, Area> exclusionMap, Cell cell, List<PolyBase> polyList, List<Geometric> geomList, StringBuffer DRCexclusionMsg) {
        Area area = exclusionMap.get(cell);
        if (area == null) {
            return false;
        }
        int count = 0;
        int i = -1;
        for (PolyBase thisPoly : polyList) {
            ++i;
            if (thisPoly == null) continue;
            boolean found = area.contains(thisPoly.getBounds2D());
            if (found) {
                ++count;
                continue;
            }
            Rectangle2D rect = geomList.get(i) != null ? geomList.get(i).getBounds() : thisPoly.getBounds2D();
            DRCexclusionMsg.append("\n\t(DRC Exclusion in '" + cell.getName() + "' does not completely contain element (" + rect.getMinX() + "," + rect.getMinY() + ") (" + rect.getMaxX() + "," + rect.getMaxY() + "))");
        }
        return count >= 1;
    }

    private DRC() {
        super("drc");
    }

    @Override
    public void init() {
        this.setOn();
    }

    public static DRC getDRCTool() {
        return tool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void includeGeometric(Geometric geom) {
        if (!DRC.isIncrementalDRCOn()) {
            return;
        }
        Cell cell = geom.getParent();
        HashMap<Cell, HashSet<Geometric>> hashMap = cellsToCheck;
        synchronized (hashMap) {
            HashSet<Geometric> cellSet = cellsToCheck.get(cell);
            if (cellSet == null) {
                cellSet = new HashSet();
                cellsToCheck.put(cell, cellSet);
            }
            cellSet.add(geom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doIncrementalDRCTask() {
        if (!DRC.isIncrementalDRCOn()) {
            return;
        }
        if (incrementalRunning) {
            return;
        }
        Library curLib = Library.getCurrent();
        if (curLib == null) {
            return;
        }
        Cell cellToCheck = Job.getUserInterface().getCurrentCell(curLib);
        HashSet<Geometric> cellSet = null;
        HashMap<Cell, HashSet<Geometric>> hashMap = cellsToCheck;
        synchronized (hashMap) {
            if (cellToCheck != null) {
                cellSet = cellsToCheck.get(cellToCheck);
            }
            if (cellSet == null && cellsToCheck.size() > 0) {
                cellToCheck = cellsToCheck.keySet().iterator().next();
                cellSet = cellsToCheck.get(cellToCheck);
            }
            if (cellSet != null) {
                cellsToCheck.remove(cellToCheck);
            }
        }
        if (cellToCheck == null) {
            return;
        }
        if (!cellToCheck.isLinked()) {
            return;
        }
        if (cellToCheck.getLibrary().isHidden()) {
            return;
        }
        if (cellSet != null) {
            Geometric[] objectsToCheck = new Geometric[cellSet.size()];
            int i = 0;
            for (Geometric geom : cellSet) {
                objectsToCheck[i++] = geom;
            }
            new CheckDRCIncrementally(cellToCheck, objectsToCheck, cellToCheck.getTechnology().isScaleRelevant());
        }
    }

    @Override
    public void endBatch(Snapshot oldSnapshot, Snapshot newSnapshot, boolean undoRedo) {
        for (CellId cellId : newSnapshot.getChangedCells(oldSnapshot)) {
            ImmutableElectricObject d;
            Cell cell = Cell.inCurrentThread(cellId);
            if (cell == null) continue;
            CellBackup oldBackup = oldSnapshot.getCell(cellId);
            Iterator<Geometric> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                d = ni.getD();
                if (oldBackup != null && oldBackup.cellRevision.getNode(d.nodeId) == d) continue;
                DRC.includeGeometric(ni);
            }
            it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                d = ai.getD();
                if (oldBackup != null && oldBackup.cellRevision.getArc(((ImmutableArcInst)d).arcId) == d) continue;
                DRC.includeGeometric(ai);
            }
        }
        DRC.doIncrementalDRCTask();
    }

    public static ErrorLogger getDRCErrorLogger(boolean layout, boolean incremental, String extraMsg) {
        String title;
        ErrorLogger errorLogger = null;
        String string = title = layout ? "Layout " : "Schematic ";
        if (incremental) {
            if (errorLoggerIncremental == null) {
                errorLoggerIncremental = ErrorLogger.newInstance("DRC (incremental)");
            }
            errorLogger = errorLoggerIncremental;
        } else {
            errorLogger = ErrorLogger.newInstance(title + "DRC (full)" + (extraMsg != null ? extraMsg : ""));
        }
        return errorLogger;
    }

    public static void checkDRCHierarchically(Cell cell, Rectangle2D bounds, GeometryHandler.GHMode mode, boolean onlyArea) {
        if (cell == null) {
            return;
        }
        boolean isLayout = true;
        if (cell.isSchematic() || cell.getTechnology() == Schematics.tech || cell.isIcon() || cell.getTechnology() == Artwork.tech) {
            isLayout = false;
        }
        if (mode == null) {
            mode = GeometryHandler.GHMode.ALGO_SWEEP;
        }
        new CheckDRCHierarchically(cell, isLayout, bounds, mode, onlyArea);
    }

    public static DRCRules getRules(Technology tech) {
        DRCRules currentRules = tech.getCachedRules();
        if (currentRules != null && tech == currentTechnology) {
            return currentRules;
        }
        currentRules = tech.getFactoryDesignRules();
        if (currentRules != null) {
            StringBuffer override = DRC.getDRCOverrides(tech);
            currentRules.applyDRCOverrides(override.toString(), tech);
        }
        currentTechnology = tech;
        tech.setCachedRules(currentRules);
        return currentRules;
    }

    public static void setRules(Technology tech, DRCRules newRules) {
        XMLRules factoryRules = tech.getFactoryDesignRules();
        StringBuffer changes = Technology.getRuleDifferences(factoryRules, newRules);
        if (Job.LOCALDEBUGFLAG) {
            System.out.println("This function needs attention");
        }
        StringBuffer override = DRC.getDRCOverrides(tech);
        if (changes.toString().equals(override.toString())) {
            return;
        }
        DRC.setDRCOverrides(changes, tech);
        tech.setRuleVariables(newRules);
        if (currentTechnology == tech) {
            currentTechnology = null;
        }
    }

    public static double getWorstSpacingDistance(Technology tech, int lastMetal) {
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return 0.0;
        }
        return rules.getWorstSpacingDistance(lastMetal);
    }

    public static double getMaxSurround(Layer layer, double maxSize) {
        Technology tech = layer.getTechnology();
        if (tech == null) {
            return -1.0;
        }
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return -1.0;
        }
        return rules.getMaxSurround(tech, layer, maxSize);
    }

    public static DRCTemplate getEdgeRule(Layer layer1, Layer layer2) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getEdgeRule(layer1, layer2);
    }

    public static DRCTemplate getSpacingRule(Layer layer1, Geometric geo1, Layer layer2, Geometric geo2, boolean connected, int multiCut, double wideS, double length) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getSpacingRule(layer1, geo1, layer2, geo2, connected, multiCut, wideS, length);
    }

    public static List<DRCTemplate> getRules(Layer layer1, DRCTemplate.DRCRuleType type) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getRules(layer1, type);
    }

    public static DRCTemplate getExtensionRule(Layer layer1, Layer layer2, boolean isGateExtension) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getExtensionRule(layer1, layer2, isGateExtension);
    }

    public static boolean isAnySpacingRule(Layer layer1, Layer layer2) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return false;
        }
        return rules.isAnySpacingRule(layer1, layer2);
    }

    public static DRCTemplate getMinValue(Layer layer, DRCTemplate.DRCRuleType type) {
        Technology tech = layer.getTechnology();
        if (tech == null) {
            return null;
        }
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getMinValue(layer, type);
    }

    public static boolean isForbiddenNode(int index1, int index2, DRCTemplate.DRCRuleType type, Technology tech) {
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return false;
        }
        int index = index1;
        index = index2 != -1 ? rules.getRuleIndex(index1, index2) : (index += tech.getNumLayers());
        return rules.isForbiddenNode(index, type);
    }

    public static PrimitiveNode.NodeSizeRule getMinSize(NodeProto np) {
        if (np instanceof Cell) {
            return null;
        }
        PrimitiveNode pnp = (PrimitiveNode)np;
        return pnp.getMinSizeRule();
    }

    private static StringBuffer getDRCOverrides(Technology tech) {
        Pref pref = prefDRCOverride.get(tech);
        if (pref == null) {
            pref = Pref.makeStringPref("DRCOverridesFor" + tech.getTechName(), DRC.tool.prefs, "");
            prefDRCOverride.put(tech, pref);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(pref.getString());
        return sb;
    }

    private static void setDRCOverrides(StringBuffer sb, Technology tech) {
        Pref pref;
        if (sb.length() >= 8192) {
            System.out.println("Warning: Design rule overrides are too complex to be saved (are " + sb.length() + " long which is more than the limit of " + 8192 + ")");
        }
        if ((pref = prefDRCOverride.get(tech)) == null) {
            pref = Pref.makeStringPref("DRCOverridesFor" + tech.getTechName(), DRC.tool.prefs, "");
            prefDRCOverride.put(tech, pref);
        }
        pref.setString(sb.toString());
    }

    public static void cleanCellsDueToFoundryChanges(Technology tech, Foundry f) {
        System.out.println("Cleaning good DRC dates in cells using '" + f.getType().name() + "' in '" + tech.getTechName() + "'");
        HashMap<Cell, Cell> cleanDRCDate = new HashMap<Cell, Cell>();
        int bit = 0;
        switch (f.getType()) {
            case MOSIS: {
                bit = 16;
                break;
            }
            case TSMC: {
                bit = 8;
                break;
            }
            case ST: {
                bit = 4;
            }
        }
        boolean inMemory = DRC.isDatesStoredInMemory();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            Iterator<Cell> itC = lib.getCells();
            while (itC.hasNext()) {
                StoreDRCInfo data;
                Cell cell = itC.next();
                if (cell.getTechnology() != tech || (data = DRC.getCellGoodDRCDateAndBits(cell, !inMemory)) == null || (data.bits & bit) == 0) continue;
                cleanDRCDate.put(cell, cell);
            }
        }
        DRC.addDRCUpdate(0, null, cleanDRCDate, null);
    }

    private static StoreDRCInfo getCellGoodDRCDateAndBits(Cell cell, boolean fromDisk) {
        StoreDRCInfo data = storedDRCDate.get(cell);
        boolean firstTime = false;
        if (data == null) {
            boolean validVersion = true;
            Version version = cell.getLibrary().getVersion();
            if (version != null) {
                validVersion = version.compareTo(Version.getVersion()) >= 0;
            }
            data = new StoreDRCInfo(-1L, -1);
            storedDRCDate.put(cell, data);
            firstTime = true;
            if (!validVersion) {
                return null;
            }
        }
        if (fromDisk || !fromDisk && firstTime) {
            int thisByte = 0;
            long lastDRCDateInMilliseconds = 0L;
            Variable varDate = cell.getVar(DRC_LAST_GOOD_DATE, Long.class);
            if (varDate == null) {
                varDate = cell.getVar(DRC_LAST_GOOD_DATE, Integer[].class);
            }
            if (varDate == null) {
                return null;
            }
            Object lastDRCDateObject = varDate.getObject();
            if (lastDRCDateObject instanceof Integer[]) {
                Integer[] lastDRCDateAsInts = (Integer[])lastDRCDateObject;
                long lastDRCDateInSecondsHigh = lastDRCDateAsInts[0].intValue();
                long lastDRCDateInSecondsLow = lastDRCDateAsInts[1].intValue();
                lastDRCDateInMilliseconds = lastDRCDateInSecondsHigh << 32 | lastDRCDateInSecondsLow & 0xFFFFFFFFL;
            } else {
                lastDRCDateInMilliseconds = (Long)lastDRCDateObject;
            }
            Variable varBits = cell.getVar(DRC_LAST_GOOD_BIT, Integer.class);
            if (varBits == null) {
                varBits = cell.getVar(DRC_LAST_GOOD_BIT, Byte.class);
                if (varBits != null) {
                    thisByte = ((Byte)varBits.getObject()).byteValue();
                }
            } else {
                thisByte = (Integer)varBits.getObject();
            }
            data.bits = thisByte;
            data.date = lastDRCDateInMilliseconds;
        } else {
            data = storedDRCDate.get(cell);
        }
        return data;
    }

    public static boolean isCellDRCDateGood(Cell cell, Date date) {
        Date lastChangeDate;
        return date != null && date.after(lastChangeDate = cell.getRevisionDate());
    }

    public static Date getLastDRCDateBasedOnBits(Cell cell, int activeBits, boolean fromDisk) {
        boolean sameManufacturer;
        StoreDRCInfo data = DRC.getCellGoodDRCDateAndBits(cell, fromDisk);
        if (data == null) {
            return null;
        }
        int thisByte = data.bits;
        if (fromDisk) assert (thisByte != 0);
        boolean area = (thisByte & 1) == (activeBits & 1);
        boolean extension = (thisByte & 2) == (activeBits & 2);
        boolean bl = sameManufacturer = (thisByte & 8) == (activeBits & 8) && (thisByte & 4) == (activeBits & 4) && (thisByte & 0x10) == (activeBits & 0x10);
        if (!(activeBits == 0 || area && extension && sameManufacturer)) {
            return null;
        }
        Date lastDRCDate = new Date(data.date);
        Date revisionDate = cell.getRevisionDate();
        return lastDRCDate.after(revisionDate) ? lastDRCDate : null;
    }

    private static void cleanDRCDateAndBits(Cell cell) {
        cell.delVar(DRC_LAST_GOOD_DATE);
        cell.delVar(DRC_LAST_GOOD_BIT);
    }

    public static String explainBits(int bits) {
        boolean on = (bits & 1) != 0;
        String msg = "area bit ";
        msg = msg + (on ? "on" : "off");
        on = (bits & 2) != 0;
        msg = msg + ", extension bit ";
        msg = msg + (on ? "on" : "off");
        if ((bits & 8) != 0) {
            msg = msg + ", TSMC bit";
        } else if ((bits & 4) != 0) {
            msg = msg + ", ST bit";
        } else if ((bits & 0x10) != 0) {
            msg = msg + ", Mosis bit";
        }
        return msg;
    }

    public static int getActiveBits(Technology tech) {
        Foundry foundry;
        int bits = 0;
        if (!DRC.isIgnoreAreaChecking()) {
            bits |= 1;
        }
        if (!DRC.isIgnoreExtensionRuleChecking()) {
            bits |= 2;
        }
        if ((foundry = tech.getSelectedFoundry()) != null) {
            switch (foundry.getType()) {
                case MOSIS: {
                    bits |= 0x10;
                    break;
                }
                case TSMC: {
                    bits |= 8;
                    break;
                }
                case ST: {
                    bits |= 4;
                }
            }
        }
        return bits;
    }

    private static void checkNetworks(ErrorLogger errorLog, Cell cell, boolean isLayout) {
        String msg;
        boolean errorSortNetworks = false;
        boolean errorSortNodes = true;
        HashMap<NodeProto, ArrayList<NodeInst>> strangeNodes = null;
        HashMap<NodeProto, ArrayList<NodeInst>> unconnectedPins = null;
        int numNodes = cell.getNumNodes();
        for (int i = 0; i < numNodes; ++i) {
            ArrayList<NodeInst> nodesOfType;
            boolean isSchematicNode;
            String msg2;
            NodeInst ni = cell.getNode(i);
            NodeProto np = ni.getProto();
            if (!cell.isIcon()) {
                if (ni.isIconOfParent() || np.getFunction() == PrimitiveNode.Function.ART && np != Generic.tech.simProbeNode || np == Generic.tech.invisiblePinNode) {
                    if (ni.hasConnections()) {
                        msg2 = "Network: " + cell + " has connections on " + ni;
                        System.out.println(msg2);
                        errorLog.logError(msg2, ni, cell, null, 1);
                    }
                } else if (np.getFunction() == PrimitiveNode.Function.PIN && cell.getTechnology().isLayout() && !ni.hasConnections()) {
                    ArrayList<NodeInst> pinsOfType;
                    if (unconnectedPins == null) {
                        unconnectedPins = new HashMap<NodeProto, ArrayList<NodeInst>>();
                    }
                    if ((pinsOfType = (ArrayList<NodeInst>)unconnectedPins.get(np)) == null) {
                        pinsOfType = new ArrayList<NodeInst>();
                        unconnectedPins.put(np, pinsOfType);
                    }
                    pinsOfType.add(ni);
                }
            }
            if (!isLayout) continue;
            if (ni.getNameKey().isBus()) {
                msg2 = "Network: Layout " + cell + " has arrayed " + ni;
                System.out.println(msg2);
                errorLog.logError(msg2, ni, cell, null, 0);
            }
            if (ni.isCellInstance()) {
                Cell subCell = (Cell)np;
                isSchematicNode = subCell.isIcon() || subCell.isSchematic();
            } else {
                boolean bl = isSchematicNode = np == Generic.tech.universalPinNode || np.getTechnology() == Schematics.tech;
            }
            if (!isSchematicNode) continue;
            if (strangeNodes == null) {
                strangeNodes = new HashMap<NodeProto, ArrayList<NodeInst>>();
            }
            if ((nodesOfType = (ArrayList<NodeInst>)strangeNodes.get(np)) == null) {
                nodesOfType = new ArrayList<NodeInst>();
                strangeNodes.put(np, nodesOfType);
            }
            nodesOfType.add(ni);
        }
        if (unconnectedPins != null) {
            for (NodeProto np : unconnectedPins.keySet()) {
                ArrayList pinsOfType = (ArrayList)unconnectedPins.get(np);
                msg = "Network: " + cell + " has " + pinsOfType.size() + " unconnected pins " + np;
                System.out.println(msg);
                errorLog.logWarning(msg, Collections.unmodifiableList(pinsOfType), null, null, null, null, cell, 1);
            }
        }
        if (strangeNodes != null) {
            for (NodeProto np : strangeNodes.keySet()) {
                ArrayList nodesOfType = (ArrayList)strangeNodes.get(np);
                msg = "Network: Layout " + cell + " has " + nodesOfType.size() + " " + np.describe(true) + " nodes";
                System.out.println(msg);
                errorLog.logError(msg, Collections.unmodifiableList(nodesOfType), null, cell, 0);
            }
        }
    }

    public static boolean isIncrementalDRCOn() {
        return cacheIncrementalDRCOn.getBoolean();
    }

    public static void setIncrementalDRCOn(boolean on) {
        cacheIncrementalDRCOn.setBoolean(on);
    }

    public static boolean isInteractiveDRCDragOn() {
        return cacheInteractiveDRCDragOn.getBoolean();
    }

    public static void setInteractiveDRCDragOn(boolean on) {
        cacheInteractiveDRCDragOn.setBoolean(on);
    }

    public static DRCCheckLogging getErrorLoggingType() {
        return DRCCheckLogging.valueOf(cacheErrorLoggingType.getString());
    }

    public static void setErrorLoggingType(DRCCheckLogging type) {
        cacheErrorLoggingType.setString(type.name());
    }

    public static DRCCheckMode getErrorType() {
        int val = cacheErrorCheckLevel.getInt();
        for (DRCCheckMode p : DRCCheckMode.values()) {
            if (p.mode() != val) continue;
            return p;
        }
        return null;
    }

    public static void setErrorType(DRCCheckMode type) {
        cacheErrorCheckLevel.setInt(type.mode());
    }

    public static boolean isUseMultipleThreads() {
        return cacheUseMultipleThreads.getBoolean();
    }

    public static void setUseMultipleThreads(boolean on) {
        cacheUseMultipleThreads.setBoolean(on);
    }

    public static int getNumberOfThreads() {
        return cacheNumberOfThreads.getInt();
    }

    public static void setNumberOfThreads(int th) {
        cacheNumberOfThreads.setInt(th);
    }

    public static boolean isIgnoreCenterCuts() {
        return cacheIgnoreCenterCuts.getBoolean();
    }

    public static void setIgnoreCenterCuts(boolean on) {
        cacheIgnoreCenterCuts.setBoolean(on);
    }

    public static boolean isIgnoreAreaChecking() {
        return cacheIgnoreAreaChecking.getBoolean();
    }

    public static void setIgnoreAreaChecking(boolean on) {
        cacheIgnoreAreaChecking.setBoolean(on);
    }

    public static boolean isIgnoreExtensionRuleChecking() {
        return cacheIgnoreExtensionRuleChecking.getBoolean();
    }

    public static void setIgnoreExtensionRuleChecking(boolean on) {
        cacheIgnoreExtensionRuleChecking.setBoolean(on);
    }

    public static boolean isDatesStoredInMemory() {
        return cacheStoreDatesInMemory.getBoolean();
    }

    public static void setDatesStoredInMemory(boolean on) {
        cacheStoreDatesInMemory.setBoolean(on);
    }

    public static boolean isInteractiveLoggingOn() {
        return cacheInteractiveLog.getBoolean();
    }

    public static void setInteractiveLogging(boolean on) {
        cacheInteractiveLog.setBoolean(on);
    }

    public static DRCCheckMinArea getMinAreaAlgoOption() {
        return DRCCheckMinArea.valueOf(cacheMinAreaAlgo.getString());
    }

    public static void setMinAreaAlgoOption(DRCCheckMinArea mode) {
        cacheMinAreaAlgo.setString(mode.name());
    }

    public static void addDRCUpdate(int bits, HashMap<Cell, Date> goodDRCDate, HashMap<Cell, Cell> cleanDRCDate, HashMap<Geometric, List<Variable>> newVariables) {
        boolean vars;
        boolean good = goodDRCDate != null && goodDRCDate.size() > 0;
        boolean clean = cleanDRCDate != null && cleanDRCDate.size() > 0;
        boolean bl = vars = newVariables != null && newVariables.size() > 0;
        if (!(good || clean || vars)) {
            return;
        }
        new DRCUpdate(bits, goodDRCDate, cleanDRCDate, newVariables);
    }

    public static void resetDRCDates(boolean startJob) {
        new DRCReset(startJob);
    }

    public static boolean testAll() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DRCUpdate
    extends Job {
        HashMap<Cell, Date> goodDRCDate;
        HashMap<Cell, Cell> cleanDRCDate;
        HashMap<Geometric, List<Variable>> newVariables;
        int activeBits;

        public DRCUpdate(int bits, HashMap<Cell, Date> goodDRCDate, HashMap<Cell, Cell> cleanDRCDate, HashMap<Geometric, List<Variable>> newVariables) {
            super("Update DRC data", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.goodDRCDate = goodDRCDate;
            this.cleanDRCDate = cleanDRCDate;
            this.newVariables = newVariables;
            this.activeBits = bits;
            if (DRC.isDatesStoredInMemory() && (newVariables == null || newVariables.isEmpty())) {
                try {
                    this.doIt();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.startJob();
            }
        }

        @Override
        public boolean doIt() throws JobException {
            HashSet<Cell> goodDRCCells = new HashSet<Cell>();
            boolean inMemory = DRC.isDatesStoredInMemory();
            if (this.goodDRCDate != null) {
                for (Map.Entry<Cell, Date> entry : this.goodDRCDate.entrySet()) {
                    Cell cell = entry.getKey();
                    if (!cell.isLinked()) {
                        throw new JobException("Cell '" + cell + "' is invalid to update DRC date");
                    }
                    if (inMemory) {
                        storedDRCDate.put(cell, new StoreDRCInfo(entry.getValue().getTime(), this.activeBits));
                        continue;
                    }
                    goodDRCCells.add(cell);
                }
            }
            if (!goodDRCCells.isEmpty()) {
                Layout.setGoodDRCCells(goodDRCCells, this.activeBits, inMemory);
            }
            if (this.cleanDRCDate != null) {
                for (Cell cell : this.cleanDRCDate.keySet()) {
                    if (!cell.isLinked()) {
                        new JobException("Cell '" + cell + "' is invalid to clean DRC date");
                        continue;
                    }
                    StoreDRCInfo data = (StoreDRCInfo)storedDRCDate.get(cell);
                    assert (data != null);
                    data.date = -1L;
                    data.bits = -1;
                    if (inMemory) continue;
                    DRC.cleanDRCDateAndBits(cell);
                }
            }
            if (this.newVariables != null) {
                assert (!inMemory);
                for (Map.Entry entry : this.newVariables.entrySet()) {
                    Geometric ni = (Geometric)entry.getKey();
                    for (Variable var : (List)entry.getValue()) {
                        ni.addVar(var);
                    }
                }
            }
            return true;
        }
    }

    private static class DRCReset
    extends Job {
        DRCReset(boolean startJob) {
            super("Resetting DRC Dates", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            if (startJob) {
                this.startJob();
            } else {
                this.doIt();
            }
        }

        public boolean doIt() {
            storedDRCDate.clear();
            if (!DRC.isDatesStoredInMemory()) {
                Iterator<Library> it = Library.getLibraries();
                while (it.hasNext()) {
                    Library lib = it.next();
                    Iterator<Cell> cIt = lib.getCells();
                    while (cIt.hasNext()) {
                        Cell cell = cIt.next();
                        DRC.cleanDRCDateAndBits(cell);
                    }
                }
            }
            return true;
        }
    }

    private static class CheckDRCIncrementally
    extends CheckDRCJob {
        Geometric[] objectsToCheck;

        protected CheckDRCIncrementally(Cell cell, Geometric[] objectsToCheck, boolean layout) {
            super(cell, tool, Job.Priority.ANALYSIS, layout);
            this.objectsToCheck = objectsToCheck;
            this.startJob();
        }

        public boolean doIt() {
            incrementalRunning = true;
            ErrorLogger errorLog = DRC.getDRCErrorLogger(this.isLayout, true, null);
            errorLog = this.isLayout ? Quick.checkDesignRules(errorLog, this.cell, this.objectsToCheck, null, null) : Schematic.doCheck(errorLog, this.cell, this.objectsToCheck);
            int errorsFound = errorLog.getNumErrors();
            if (errorsFound > 0) {
                System.out.println("Incremental DRC found " + errorsFound + " errors/warnings in " + this.cell);
            }
            incrementalRunning = false;
            DRC.doIncrementalDRCTask();
            return true;
        }
    }

    private static class CheckDRCHierarchically
    extends CheckDRCJob {
        Rectangle2D bounds;
        private GeometryHandler.GHMode mergeMode;
        private boolean onlyArea;

        protected CheckDRCHierarchically(Cell cell, boolean layout, Rectangle2D bounds, GeometryHandler.GHMode mode, boolean onlyA) {
            super(cell, tool, Job.Priority.USER, layout);
            this.bounds = bounds;
            this.mergeMode = mode;
            this.onlyArea = onlyA;
            this.startJob();
        }

        public boolean doIt() {
            long startTime = System.currentTimeMillis();
            ErrorLogger errorLog = DRC.getDRCErrorLogger(this.isLayout, false, null);
            DRC.checkNetworks(errorLog, this.cell, this.isLayout);
            if (this.isLayout) {
                Quick.checkDesignRules(errorLog, this.cell, null, null, this.bounds, this, this.mergeMode, this.onlyArea);
            } else {
                Schematic.doCheck(errorLog, this.cell, null);
            }
            long endTime = System.currentTimeMillis();
            int errorCount = errorLog.getNumErrors();
            int warnCount = errorLog.getNumWarnings();
            System.out.println(errorCount + " errors and " + warnCount + " warnings found (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
            if (this.onlyArea) {
                Job.getUserInterface().termLogging(errorLog, false, false);
            }
            return true;
        }
    }

    public static class CheckDRCJob
    extends Job {
        Cell cell;
        boolean isLayout;

        private static String getJobName(Cell cell) {
            return "Design-Rule Check " + cell;
        }

        protected CheckDRCJob(Cell cell, Listener tool, Job.Priority priority, boolean layout) {
            super(CheckDRCJob.getJobName(cell), tool, Job.Type.EXAMINE, null, null, priority);
            this.cell = cell;
            this.isLayout = layout;
        }

        public boolean doIt() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DRCCheckMode {
        ERROR_CHECK_DEFAULT(0),
        ERROR_CHECK_CELL(1),
        ERROR_CHECK_EXHAUSTIVE(2);

        private final int mode;

        private DRCCheckMode(int m) {
            this.mode = m;
        }

        public int mode() {
            return this.mode;
        }

        public String toString() {
            return this.name();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DRCCheckLogging {
        DRC_LOG_FLAT("Flat"),
        DRC_LOG_PER_CELL("By Cell"),
        DRC_LOG_PER_RULE("By Rule");

        private final String name;

        private DRCCheckLogging(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DRCCheckMinArea {
        AREA_BASIC("Simple"),
        AREA_LOCAL("Local");

        private final String name;

        private DRCCheckMinArea(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class StoreDRCInfo {
        long date;
        int bits;

        StoreDRCInfo(long d, int b) {
            this.date = d;
            this.bits = b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DRCErrorType {
        SPACINGERROR,
        MINWIDTHERROR,
        NOTCHERROR,
        MINSIZEERROR,
        BADLAYERERROR,
        LAYERSURROUNDERROR,
        MINAREAERROR,
        ENCLOSEDAREAERROR,
        SURROUNDERROR,
        FORBIDDEN,
        RESOLUTION,
        CUTERROR,
        SLOTSIZEERROR,
        ZEROLENGTHARCWARN,
        TECHMIXWARN;

    }
}

