/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import java.awt.Color;
import java.util.Iterator;

public class Generic
extends Technology {
    public static final Generic tech = new Generic();
    private Layer universalLay;
    public Layer glyphLay;
    public Layer drcLay;
    public Layer afgLay;
    public PrimitiveNode universalPinNode;
    public PrimitiveNode invisiblePinNode;
    public PrimitiveNode unroutedPinNode;
    public PrimitiveNode cellCenterNode;
    public PrimitiveNode portNode;
    public PrimitiveNode drcNode;
    public PrimitiveNode afgNode;
    public PrimitiveNode essentialBoundsNode;
    public PrimitiveNode simProbeNode;
    public ArcProto universal_arc;
    public ArcProto invisible_arc;
    public ArcProto unrouted_arc;
    private PrimitivePort univPinPort;
    private PrimitivePort invisPinPort;
    private PrimitivePort simProbePort;
    private static Technology.NodeLayer[] NULLNODELAYER = new Technology.NodeLayer[0];

    private Generic() {
        super("generic");
        this.setTechShortName("Generic");
        this.setTechDesc("Useful primitives");
        this.setNonStandard();
        this.setFactoryScale(1000.0, false);
        this.universalLay = Layer.newInstance(this, "Universal", new EGraphics(false, true, null, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        Layer invisible_lay = Layer.newInstance(this, "Invisible", new EGraphics(false, true, null, 0, 180, 180, 180, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        Layer unrouted_lay = Layer.newInstance(this, "Unrouted", new EGraphics(false, true, null, 0, 100, 100, 100, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.glyphLay = Layer.newInstance(this, "Glyph", new EGraphics(false, true, null, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.drcLay = Layer.newInstance(this, "DRC", new EGraphics(false, true, null, 0, 255, 190, 6, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.afgLay = Layer.newInstance(this, "AFG", new EGraphics(false, true, null, 0, 255, 6, 190, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        Layer simprobe_lay = Layer.newInstance(this, "Sim-Probe", new EGraphics(false, true, null, 0, 0, 255, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.universalLay.setFunction(Layer.Function.UNKNOWN);
        invisible_lay.setFunction(Layer.Function.UNKNOWN, 8192);
        unrouted_lay.setFunction(Layer.Function.UNKNOWN);
        this.glyphLay.setFunction(Layer.Function.ART, 8192);
        this.drcLay.setFunction(Layer.Function.ART, 8192);
        this.afgLay.setFunction(Layer.Function.ART, 8192);
        simprobe_lay.setFunction(Layer.Function.ART, 8192);
        this.universal_arc = this.newArcProto("Universal", 0.0, 0.0, ArcProto.Function.UNKNOWN, new Technology.ArcLayer(this.universalLay, 0.0, Poly.Type.FILLED));
        this.universal_arc.setFactoryFixedAngle(true);
        this.universal_arc.setFactoryAngleIncrement(45);
        this.invisible_arc = this.newArcProto("Invisible", 0.0, 0.0, ArcProto.Function.NONELEC, new Technology.ArcLayer(invisible_lay, 0.0, Poly.Type.FILLED));
        this.invisible_arc.setFactoryFixedAngle(true);
        this.invisible_arc.setFactoryAngleIncrement(45);
        this.unrouted_arc = this.newArcProto("Unrouted", 0.0, 0.0, ArcProto.Function.UNROUTED, new Technology.ArcLayer(unrouted_lay, 0.0, Poly.Type.FILLED));
        this.unrouted_arc.setFactoryFixedAngle(false);
        this.unrouted_arc.setFactoryAngleIncrement(0);
        this.universalPinNode = PrimitiveNode.newInstance("Universal-Pin", this, 1.0, 1.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.universalLay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())})});
        this.univPinPort = PrimitivePort.newInstance(this, this.universalPinNode, new ArcProto[]{this.universal_arc}, "univ", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge());
        this.universalPinNode.addPrimitivePorts(new PrimitivePort[]{this.univPinPort});
        this.universalPinNode.setFunction(PrimitiveNode.Function.PIN);
        this.universalPinNode.setWipeOn1or2();
        this.universalPinNode.setCanBeZeroSize();
        this.invisiblePinNode = PrimitiveNode.newInstance0("Invisible-Pin", this, 1.0, 1.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(invisible_lay, 0, Poly.Type.CLOSED, 1, Technology.TechPoint.makeFullBox())});
        this.invisPinPort = PrimitivePort.newInstance(this, this.invisiblePinNode, new ArcProto[]{this.invisible_arc, this.universal_arc}, "center", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter());
        this.invisiblePinNode.addPrimitivePorts(new PrimitivePort[]{this.invisPinPort});
        this.invisiblePinNode.setFunction(PrimitiveNode.Function.PIN);
        this.invisiblePinNode.setWipeOn1or2();
        this.invisiblePinNode.setCanBeZeroSize();
        this.unroutedPinNode = PrimitiveNode.newInstance("Unrouted-Pin", this, 1.0, 1.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(unrouted_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())})});
        this.unroutedPinNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.unroutedPinNode, new ArcProto[]{this.unrouted_arc, this.invisible_arc, this.universal_arc}, "unrouted", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        this.unroutedPinNode.setFunction(PrimitiveNode.Function.PIN);
        this.unroutedPinNode.setWipeOn1or2();
        this.unroutedPinNode.setCanBeZeroSize();
        this.cellCenterNode = PrimitiveNode.newInstance("Facet-Center", this, 0.0, 0.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.glyphLay, 0, Poly.Type.CLOSED, 1, Technology.TechPoint.makeFullBox()), new Technology.NodeLayer(this.glyphLay, 0, Poly.Type.BIGCROSS, 0, Technology.TechPoint.makeCenterBox())});
        this.cellCenterNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.cellCenterNode, new ArcProto[]{this.invisible_arc, this.universal_arc}, "center", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.cellCenterNode.setFunction(PrimitiveNode.Function.ART);
        this.cellCenterNode.setCanBeZeroSize();
        this.portNode = PrimitiveNode.newInstance("Port", this, 6.0, 6.0, new SizeOffset(2.0, 2.0, 2.0, 2.0), new Technology.NodeLayer[]{new Technology.NodeLayer(this.glyphLay, 0, Poly.Type.CLOSED, 1, Technology.TechPoint.makeIndented(2.0))});
        this.portNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.portNode, new ArcProto[]{this.invisible_arc, this.universal_arc}, "center", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        this.portNode.setFunction(PrimitiveNode.Function.ART);
        this.portNode.setCanBeZeroSize();
        this.essentialBoundsNode = PrimitiveNode.newInstance("Essential-Bounds", this, 0.0, 0.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.glyphLay, 0, Poly.Type.OPENED, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromCenter(-1.0), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.fromCenter(-1.0))})});
        this.essentialBoundsNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.essentialBoundsNode, new ArcProto[]{this.invisible_arc, this.universal_arc}, "center", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.essentialBoundsNode.setFunction(PrimitiveNode.Function.ART);
        this.essentialBoundsNode.setCanBeZeroSize();
        this.simProbeNode = PrimitiveNode.newInstance("Simulation-Probe", this, 10.0, 10.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(simprobe_lay, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox())});
        this.simProbePort = PrimitivePort.newInstance(this, this.simProbeNode, new ArcProto[]{this.invisible_arc, this.universal_arc}, "center", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge());
        this.simProbeNode.addPrimitivePorts(new PrimitivePort[]{this.simProbePort});
        this.simProbeNode.setFunction(PrimitiveNode.Function.ART);
        this.simProbeNode.setCanBeZeroSize();
        this.drcNode = this.drcLay.makePureLayerNode("DRC-Node", 2.0, Poly.Type.FILLED, "center", this.invisible_arc, this.universal_arc);
        this.afgNode = this.afgLay.makePureLayerNode("AFG-Node", 2.0, Poly.Type.FILLED, "center", this.invisible_arc, this.universal_arc);
        this.newFoundry(Foundry.Type.NONE, null, new String[0]);
        this.oldNodeNames.put("Cell-Center", this.cellCenterNode);
    }

    public static void setBackgroudColor(Color c) {
        Generic.tech.universalLay.getGraphics().setColor(c);
        Generic.tech.glyphLay.getGraphics().setColor(c);
    }

    protected Poly[] getShapeOfNode(NodeInst ni, boolean electrical, boolean reasonable, Technology.NodeLayer[] primLayers, Layer layerOverride) {
        NodeProto prototype = ni.getProto();
        PrimitiveNode np = (PrimitiveNode)prototype;
        if (np == this.invisiblePinNode && ni.isInvisiblePinWithText()) {
            primLayers = NULLNODELAYER;
        }
        return super.getShapeOfNode(ni, electrical, reasonable, primLayers, layerOverride);
    }

    public void makeUnivList() {
        int tot = 0;
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            tot += tech.getNumArcs();
        }
        ArcProto[] upconn = new ArcProto[tot];
        tot = 0;
        Iterator<Technology> it2 = Technology.getTechnologies();
        while (it2.hasNext()) {
            Technology tech = it2.next();
            Iterator<ArcProto> ait = tech.getArcs();
            while (ait.hasNext()) {
                ArcProto ap = ait.next();
                upconn[tot++] = ap;
            }
        }
        this.univPinPort.setConnections(upconn);
        this.invisPinPort.setConnections(upconn);
        this.simProbePort.setConnections(upconn);
    }

    public static boolean isSpecialGenericNode(NodeInst ni) {
        NodeProto np = ni.getProto();
        return np == Generic.tech.cellCenterNode || np == Generic.tech.drcNode || np == Generic.tech.essentialBoundsNode || np == Generic.tech.afgNode;
    }
}

