/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.LibToTech;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import java.awt.Color;
import java.util.Iterator;

public class GeneralInfo
extends Info {
    String shortName;
    boolean nonElectrical;
    double scale;
    boolean scaleRelevant;
    double resolution;
    String defaultFoundry;
    int defaultNumMetals;
    String description;
    double minRes;
    double minCap;
    double maxSeriesResistance;
    double gateShrinkage;
    boolean includeGateInResistance;
    boolean includeGround;
    double gateCapacitance;
    double wireRatio;
    double diffAlpha;
    Color[] transparentColors;
    String[] spiceLevel1Header;
    String[] spiceLevel2Header;
    String[] spiceLevel3Header;
    double[] conDist;
    double[] unConDist;
    Object[][] menuPalette;
    static Info.SpecialTextDescr[] genTextTable = new Info.SpecialTextDescr[]{new Info.SpecialTextDescr(0.0, 12.0, 46), new Info.SpecialTextDescr(0.0, 9.0, 14), new Info.SpecialTextDescr(0.0, 6.0, 47), new Info.SpecialTextDescr(0.0, 3.0, 48), new Info.SpecialTextDescr(0.0, 0.0, 15), new Info.SpecialTextDescr(0.0, -3.0, 38), new Info.SpecialTextDescr(0.0, -6.0, 39), new Info.SpecialTextDescr(0.0, -9.0, 49), new Info.SpecialTextDescr(0.0, -12.0, 42), new Info.SpecialTextDescr(0.0, -15.0, 43), new Info.SpecialTextDescr(0.0, -18.0, 44), new Info.SpecialTextDescr(0.0, -21.0, 45)};

    void generate(Cell np) {
        GeneralInfo.loadTableEntry(genTextTable, 46, this.shortName);
        GeneralInfo.loadTableEntry(genTextTable, 14, this.scale);
        GeneralInfo.loadTableEntry(genTextTable, 47, this.defaultFoundry);
        GeneralInfo.loadTableEntry(genTextTable, 48, this.defaultNumMetals);
        GeneralInfo.loadTableEntry(genTextTable, 15, this.description);
        GeneralInfo.loadTableEntry(genTextTable, 38, this.minRes);
        GeneralInfo.loadTableEntry(genTextTable, 39, this.minCap);
        GeneralInfo.loadTableEntry(genTextTable, 49, this.maxSeriesResistance);
        GeneralInfo.loadTableEntry(genTextTable, 42, this.gateShrinkage);
        GeneralInfo.loadTableEntry(genTextTable, 43, this.includeGateInResistance);
        GeneralInfo.loadTableEntry(genTextTable, 44, this.includeGround);
        GeneralInfo.loadTableEntry(genTextTable, 45, this.transparentColors);
        GeneralInfo.createSpecialText(np, genTextTable);
    }

    static GeneralInfo parseCell(Cell np) {
        GeneralInfo gi = new GeneralInfo();
        Iterator<NodeInst> it = np.getNodes();
        block15: while (it.hasNext()) {
            NodeInst ni = it.next();
            int opt = Manipulate.getOptionOnNode(ni);
            String str = GeneralInfo.getValueOnNode(ni);
            switch (opt) {
                case 46: {
                    gi.shortName = str;
                    break;
                }
                case 14: {
                    gi.scale = TextUtils.atof(str);
                    gi.scaleRelevant = true;
                    break;
                }
                case 47: {
                    gi.defaultFoundry = str;
                    break;
                }
                case 48: {
                    gi.defaultNumMetals = TextUtils.atoi(str);
                    break;
                }
                case 15: {
                    gi.description = str;
                    break;
                }
                case 38: {
                    gi.minRes = TextUtils.atof(str);
                    break;
                }
                case 39: {
                    gi.minCap = TextUtils.atof(str);
                    break;
                }
                case 49: {
                    gi.maxSeriesResistance = TextUtils.atof(str);
                    break;
                }
                case 42: {
                    gi.gateShrinkage = TextUtils.atof(str);
                    break;
                }
                case 43: {
                    gi.includeGateInResistance = str.equalsIgnoreCase("yes");
                    break;
                }
                case 44: {
                    gi.includeGround = str.equalsIgnoreCase("yes");
                    break;
                }
                case 45: {
                    Color[] colors;
                    Variable var = ni.getVar(TRANSLAYER_KEY);
                    if (var == null || (colors = GeneralInfo.getTransparentColors((String)var.getObject())) == null) continue block15;
                    gi.transparentColors = colors;
                    break;
                }
                case 26: {
                    break;
                }
                default: {
                    LibToTech.pointOutError(ni, np);
                    System.out.println("Unknown object in miscellaneous-information cell (" + ni + ")");
                }
            }
        }
        return gi;
    }

    static Color[] getTransparentColors(String str) {
        String[] colorNames = str.split("/");
        Color[] colors = new Color[colorNames.length];
        for (int i = 0; i < colorNames.length; ++i) {
            String colorName = colorNames[i].trim();
            String[] rgb = colorName.split(",");
            if (rgb.length != 3) {
                return null;
            }
            int r = TextUtils.atoi(rgb[0]);
            int g = TextUtils.atoi(rgb[1]);
            int b = TextUtils.atoi(rgb[2]);
            colors[i] = new Color(r, g, b);
        }
        return colors;
    }

    static String makeTransparentColorsLine(Color[] trans) {
        String str = "The Transparent Colors: ";
        for (int j = 0; j < trans.length; ++j) {
            if (j != 0) {
                str = str + " /";
            }
            str = str + " " + trans[j].getRed() + "," + trans[j].getGreen() + "," + trans[j].getBlue();
        }
        return str;
    }
}

