/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.CellUsage;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.lib.LibFile;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.compaction.Compaction;
import com.sun.electric.tool.drc.AssuraDrcErrors;
import com.sun.electric.tool.drc.CalibreDrcErrors;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.erc.ERCAntenna;
import com.sun.electric.tool.erc.ERCWellCheck;
import com.sun.electric.tool.extract.Connectivity;
import com.sun.electric.tool.extract.LayerCoverage;
import com.sun.electric.tool.extract.LayerCoverageJob;
import com.sun.electric.tool.extract.ParasiticTool;
import com.sun.electric.tool.generator.PadGenerator;
import com.sun.electric.tool.generator.ROMGenerator;
import com.sun.electric.tool.generator.cmosPLA.PLA;
import com.sun.electric.tool.generator.layout.GateLayoutGenerator;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.ncc.Ncc;
import com.sun.electric.tool.ncc.NccJob;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.NccResult;
import com.sun.electric.tool.ncc.NetEquivalence;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.routing.Maze;
import com.sun.electric.tool.routing.MimicStitch;
import com.sun.electric.tool.routing.River;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.sc.GetNetlist;
import com.sun.electric.tool.sc.Maker;
import com.sun.electric.tool.sc.Place;
import com.sun.electric.tool.sc.Route;
import com.sun.electric.tool.sc.SilComp;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.CompileVHDL;
import com.sun.electric.tool.user.GenerateVHDL;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.FastHenryArc;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;

public class ToolMenu {
    private static final String SCLIBNAME = "sclib";
    private static final int READ_LIBRARY = 1;
    private static final int CONVERT_TO_VHDL = 2;
    private static final int COMPILE_VHDL_FOR_SC = 4;
    private static final int PLACE_AND_ROUTE = 8;
    private static final int SHOW_CELL = 16;

    protected static void addToolMenu(MenuBar menuBar) {
        int buckyBit = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        MenuBar.Menu toolMenu = MenuBar.makeMenu("_Tool");
        menuBar.add(toolMenu);
        MenuBar.Menu drcSubMenu = MenuBar.makeMenu("_DRC");
        toolMenu.add(drcSubMenu);
        drcSubMenu.addMenuItem("Check _Hierarchically", KeyStroke.getKeyStroke(116, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DRC.checkHierarchically(false, 2);
            }
        });
        drcSubMenu.addMenuItem("Check _Selection Area Hierarchically", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DRC.checkHierarchically(true, 2);
            }
        });
        drcSubMenu.addMenuItem("Check Area _Coverage", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.layerCoverageCommand(null, 2, true);
            }
        });
        drcSubMenu.addMenuItem("_List Layer Coverage on Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.layerCoverageCommand(Job.Type.EXAMINE, 0, 2);
            }
        });
        drcSubMenu.addSeparator();
        drcSubMenu.addMenuItem("Import _Assura DRC Errors...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.importAssuraDrcErrors();
            }
        });
        drcSubMenu.addMenuItem("Import Calibre _DRC Errors...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.importCalibreDrcErrors();
            }
        });
        MenuBar.Menu builtInSimulationSubMenu = MenuBar.makeMenu("Simulation (Built-in)");
        toolMenu.add(builtInSimulationSubMenu);
        if (Simulation.hasIRSIM()) {
            builtInSimulationSubMenu.addMenuItem("IRSI_M: Simulate Current Cell", null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Simulation.startSimulation(1, false, null, null);
                }
            });
            builtInSimulationSubMenu.addMenuItem("IRSIM: _Write Deck...", null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileMenu.exportCommand(FileType.IRSIM, true);
                }
            });
            builtInSimulationSubMenu.addMenuItem("_IRSIM: Simulate Deck...", null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Simulation.startSimulation(1, true, null, null);
                }
            });
            builtInSimulationSubMenu.addSeparator();
        }
        builtInSimulationSubMenu.addMenuItem("_ALS: Simulate Current Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.startSimulation(0, false, null, null);
            }
        });
        builtInSimulationSubMenu.addSeparator();
        builtInSimulationSubMenu.addMenuItem("Set Signal _High at Main Time", KeyStroke.getKeyStroke(86, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setSignalHigh();
            }
        });
        builtInSimulationSubMenu.addMenuItem("Set Signal _Low at Main Time", KeyStroke.getKeyStroke(71, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setSignalLow();
            }
        });
        builtInSimulationSubMenu.addMenuItem("Set Signal Un_defined at Main Time", KeyStroke.getKeyStroke(88, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setSignalX();
            }
        });
        builtInSimulationSubMenu.addMenuItem("Set Clock on Selected Signal...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setClock();
            }
        });
        builtInSimulationSubMenu.addSeparator();
        builtInSimulationSubMenu.addMenuItem("_Update Simulation Window", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.update();
            }
        });
        builtInSimulationSubMenu.addMenuItem("_Get Information about Selected Signals", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.showSignalInfo();
            }
        });
        builtInSimulationSubMenu.addSeparator();
        builtInSimulationSubMenu.addMenuItem("_Clear Selected Stimuli", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.removeSelectedStimuli();
            }
        });
        builtInSimulationSubMenu.addMenuItem("Clear All Stimuli _on Selected Signals", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.removeStimuliFromSignal();
            }
        });
        builtInSimulationSubMenu.addMenuItem("Clear All S_timuli", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.removeAllStimuli();
            }
        });
        builtInSimulationSubMenu.addSeparator();
        builtInSimulationSubMenu.addMenuItem("_Save Stimuli to Disk...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.saveStimuli();
            }
        });
        builtInSimulationSubMenu.addMenuItem("_Restore Stimuli from Disk...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.restoreStimuli();
            }
        });
        MenuBar.Menu spiceSimulationSubMenu = MenuBar.makeMenu("Simulation (_Spice)");
        toolMenu.add(spiceSimulationSubMenu);
        spiceSimulationSubMenu.addMenuItem("Write Spice _Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.SPICE, true);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Write _CDL Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.CDL, true);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Plot Spice _Listing...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulate.plotSpiceResults();
            }
        });
        spiceSimulationSubMenu.addMenuItem("Plot Spice _for This Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulate.plotSpiceResultsThisCell();
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set Spice _Model...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setSpiceModel();
            }
        });
        spiceSimulationSubMenu.addMenuItem("Add M_ultiplier", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.addMultiplierCommand();
            }
        });
        spiceSimulationSubMenu.addSeparator();
        spiceSimulationSubMenu.addMenuItem("Set Generic Spice _Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set Spice _2 Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_2_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set Spice _3 Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_3_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set _HSpice Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_H_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set _PSpice Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_P_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set _GnuCap Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_GC_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set _SmartSpice Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_SM_TEMPLATE_KEY);
            }
        });
        MenuBar.Menu verilogSimulationSubMenu = MenuBar.makeMenu("Simulation (_Verilog)");
        toolMenu.add(verilogSimulationSubMenu);
        verilogSimulationSubMenu.addMenuItem("Write _Verilog Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.VERILOG, true);
            }
        });
        verilogSimulationSubMenu.addMenuItem("Plot Verilog VCD _Dump...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulate.plotVerilogResults();
            }
        });
        verilogSimulationSubMenu.addMenuItem("Plot Verilog for This _Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulate.plotVerilogResultsThisCell();
            }
        });
        verilogSimulationSubMenu.addSeparator();
        verilogSimulationSubMenu.addMenuItem("Set Verilog _Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Verilog.VERILOG_TEMPLATE_KEY);
            }
        });
        verilogSimulationSubMenu.addSeparator();
        MenuBar.Menu verilogWireTypeSubMenu = MenuBar.makeMenu("Set Verilog _Wire");
        verilogWireTypeSubMenu.addMenuItem("_Wire", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setVerilogWireCommand(0);
            }
        });
        verilogWireTypeSubMenu.addMenuItem("_Trireg", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setVerilogWireCommand(1);
            }
        });
        verilogWireTypeSubMenu.addMenuItem("_Default", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setVerilogWireCommand(2);
            }
        });
        verilogSimulationSubMenu.add(verilogWireTypeSubMenu);
        MenuBar.Menu transistorStrengthSubMenu = MenuBar.makeMenu("_Transistor Strength");
        transistorStrengthSubMenu.addMenuItem("_Weak", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setTransistorStrengthCommand(true);
            }
        });
        transistorStrengthSubMenu.addMenuItem("_Normal", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setTransistorStrengthCommand(false);
            }
        });
        verilogSimulationSubMenu.add(transistorStrengthSubMenu);
        MenuBar.Menu netlisters = MenuBar.makeMenu("Simulation (_Others)");
        toolMenu.add(netlisters);
        netlisters.addMenuItem("Write _Maxwell Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.MAXWELL, true);
            }
        });
        netlisters.addMenuItem("Write _Tegas Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.TEGAS, true);
            }
        });
        netlisters.addMenuItem("Write _SILOS Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.SILOS, true);
            }
        });
        netlisters.addMenuItem("Write _PAL Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.PAL, true);
            }
        });
        netlisters.addSeparator();
        if (!Simulation.hasIRSIM()) {
            netlisters.addMenuItem("Write _IRSIM Deck...", null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileMenu.exportCommand(FileType.IRSIM, true);
                }
            });
        }
        netlisters.addMenuItem("Write _ESIM/RNL Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.ESIM, true);
            }
        });
        netlisters.addMenuItem("Write _RSIM Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.RSIM, true);
            }
        });
        netlisters.addMenuItem("Write _COSMOS Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.COSMOS, true);
            }
        });
        netlisters.addMenuItem("Write M_OSSIM Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.MOSSIM, true);
            }
        });
        netlisters.addSeparator();
        netlisters.addMenuItem("Write _FastHenry Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.FASTHENRY, true);
            }
        });
        netlisters.addMenuItem("Fast_Henry Arc Properties...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FastHenryArc.showFastHenryArcDialog();
            }
        });
        netlisters.addSeparator();
        netlisters.addMenuItem("Write _ArchSim Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.ARCHSIM, true);
            }
        });
        netlisters.addMenuItem("Display ArchSim _Journal...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulate.plotArchSimResults();
            }
        });
        MenuBar.Menu ercSubMenu = MenuBar.makeMenu("_ERC");
        toolMenu.add(ercSubMenu);
        ercSubMenu.addMenuItem("Check _Wells", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ERCWellCheck.analyzeCurCell(2);
            }
        });
        ercSubMenu.addMenuItem("_Antenna Check", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new ERCAntenna();
            }
        });
        MenuBar.Menu nccSubMenu = MenuBar.makeMenu("_NCC");
        toolMenu.add(nccSubMenu);
        nccSubMenu.addMenuItem("Schematic and Layout Views of Cell in _Current Window", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new NccJob(1);
            }
        });
        nccSubMenu.addMenuItem("Cells from _Two Windows", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new NccJob(2);
            }
        });
        MenuBar.Menu networkSubMenu = MenuBar.makeMenu("Net_work");
        toolMenu.add(networkSubMenu);
        networkSubMenu.addMenuItem("Show _Network", KeyStroke.getKeyStroke(75, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.showNetworkCommand();
            }
        });
        networkSubMenu.addMenuItem("_List Networks", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listNetworksCommand();
            }
        });
        networkSubMenu.addMenuItem("List _Connections on Network", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listConnectionsOnNetworkCommand();
            }
        });
        networkSubMenu.addMenuItem("List _Exports on Network", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listExportsOnNetworkCommand();
            }
        });
        networkSubMenu.addMenuItem("List Exports _below Network", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listExportsBelowNetworkCommand();
            }
        });
        networkSubMenu.addMenuItem("List _Geometry on Network", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listGeometryOnNetworkCommand(2);
            }
        });
        networkSubMenu.addMenuItem("List _Total Wire Lengths on All Networks", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listGeomsAllNetworksCommand();
            }
        });
        networkSubMenu.addSeparator();
        networkSubMenu.addMenuItem("E_xtract Current Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Connectivity.extractCurCell(false);
            }
        });
        networkSubMenu.addMenuItem("Extract Current _Hierarchy", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Connectivity.extractCurCell(true);
            }
        });
        networkSubMenu.addSeparator();
        networkSubMenu.addMenuItem("Show _Power and Ground", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.showPowerAndGround();
            }
        });
        networkSubMenu.addMenuItem("_Validate Power and Ground", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.validatePowerAndGround();
            }
        });
        networkSubMenu.addMenuItem("Redo Network N_umbering", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NetworkTool.renumberNetlists();
            }
        });
        MenuBar.Menu logEffortSubMenu = MenuBar.makeMenu("_Logical Effort");
        toolMenu.add(logEffortSubMenu);
        logEffortSubMenu.addMenuItem("_Optimize for Equal Gate Delays", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.optimizeEqualGateDelaysCommand(true);
            }
        });
        logEffortSubMenu.addMenuItem("Optimize for Equal Gate Delays (no _caching)", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.optimizeEqualGateDelaysCommand(false);
            }
        });
        logEffortSubMenu.addMenuItem("_Print Info for Selected Node", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.printLEInfoCommand();
            }
        });
        logEffortSubMenu.addMenuItem("_Back Annotate Wire Lengths for Current Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.backAnnotateCommand();
            }
        });
        logEffortSubMenu.addMenuItem("Clear Sizes on Selected _Node(s)", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.clearSizesNodableCommand();
            }
        });
        logEffortSubMenu.addMenuItem("Clear Sizes in _all Libraries", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.clearSizesCommand();
            }
        });
        logEffortSubMenu.addSeparator();
        logEffortSubMenu.addMenuItem("_Load Logical Effort Libraries (Purple, Red, and Orange)", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.loadLogicalEffortLibraries();
            }
        });
        MenuBar.Menu routingSubMenu = MenuBar.makeMenu("_Routing");
        toolMenu.add(routingSubMenu);
        routingSubMenu.addCheckBox("Enable _Auto-Stitching", Routing.isAutoStitchOn(), null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Routing.toggleEnableAutoStitching(e);
            }
        });
        routingSubMenu.addMenuItem("Auto-_Stitch Now", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AutoStitch.autoStitch(false, true);
            }
        });
        routingSubMenu.addMenuItem("Auto-Stitch _Highlighted Now", KeyStroke.getKeyStroke(113, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AutoStitch.autoStitch(true, true);
            }
        });
        routingSubMenu.addSeparator();
        routingSubMenu.addCheckBox("Enable _Mimic-Stitching", Routing.isMimicStitchOn(), null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Routing.toggleEnableMimicStitching(e);
            }
        });
        routingSubMenu.addMenuItem("Mimic-Stitch _Now", KeyStroke.getKeyStroke(112, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MimicStitch.mimicStitch(true);
            }
        });
        routingSubMenu.addMenuItem("Mimic S_elected", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Routing.getRoutingTool().mimicSelected();
            }
        });
        routingSubMenu.addSeparator();
        routingSubMenu.addMenuItem("Ma_ze Route", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Maze.mazeRoute();
            }
        });
        routingSubMenu.addSeparator();
        routingSubMenu.addMenuItem("_River-Route", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                River.riverRoute();
            }
        });
        routingSubMenu.addSeparator();
        routingSubMenu.addMenuItem("_Unroute", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Routing.unrouteCurrent();
            }
        });
        routingSubMenu.addMenuItem("Get Unrouted _Wire", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.getUnroutedArcCommand();
            }
        });
        routingSubMenu.addMenuItem("_Copy Routing Topology", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Routing.copyRoutingTopology();
            }
        });
        routingSubMenu.addMenuItem("Pas_te Routing Topology", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Routing.pasteRoutingTopology();
            }
        });
        MenuBar.Menu generationSubMenu = MenuBar.makeMenu("_Generation");
        toolMenu.add(generationSubMenu);
        generationSubMenu.addMenuItem("_Coverage Implants Generator", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.layerCoverageCommand(Job.Type.CHANGE, 2, 2);
            }
        });
        generationSubMenu.addMenuItem("_Pad Frame Generator...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.padFrameGeneratorCommand();
            }
        });
        generationSubMenu.addMenuItem("_ROM Generator...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ROMGenerator.generateROM();
            }
        });
        generationSubMenu.addMenuItem("MOSIS CMOS P_LA Generator...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PLA.generate();
            }
        });
        generationSubMenu.addMenuItem("Generate gate layouts (_MoCMOS)", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new GateLayoutGenerator(MoCMOS.tech, "mocmos");
            }
        });
        if (Technology.getTSMC90Technology() != null) {
            generationSubMenu.addMenuItem("Generate gate layouts (_TSMC90)", null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new GateLayoutGenerator(Technology.getTSMC90Technology(), "tsmc90");
                }
            });
        }
        MenuBar.Menu silCompSubMenu = MenuBar.makeMenu("Silicon Co_mpiler");
        toolMenu.add(silCompSubMenu);
        silCompSubMenu.addMenuItem("_Convert Current Cell to Layout", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.doSiliconCompilation(null);
            }
        });
        silCompSubMenu.addSeparator();
        silCompSubMenu.addMenuItem("Compile VHDL to _Netlist View", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.compileVHDL();
            }
        });
        MenuBar.Menu compactionSubMenu = MenuBar.makeMenu("_Compaction");
        toolMenu.add(compactionSubMenu);
        compactionSubMenu.addMenuItem("Do _Compaction", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Compaction.compactNow(null);
            }
        });
        toolMenu.addSeparator();
        toolMenu.addMenuItem("List _Tools", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listToolsCommand();
            }
        });
        MenuBar.Menu languagesSubMenu = MenuBar.makeMenu("Lang_uages");
        languagesSubMenu.addMenuItem("_Run Java Bean Shell Script", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.javaBshScriptCommand();
            }
        });
        toolMenu.add(languagesSubMenu);
    }

    public static void optimizeEqualGateDelaysCommand(boolean newAlg) {
        EditWindow curEdit = EditWindow.needCurrent();
        if (curEdit == null) {
            return;
        }
        LETool letool = LETool.getLETool();
        if (letool == null) {
            System.out.println("Logical Effort tool not found");
            return;
        }
        curEdit.setCell(curEdit.getCell(), VarContext.globalContext);
        if (curEdit.getCell() == null) {
            System.out.println("No current cell");
            return;
        }
        letool.optimizeEqualGateDelays(curEdit.getCell(), curEdit.getVarContext(), curEdit, newAlg);
    }

    public static void printLEInfoCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        VarContext context = wnd.getVarContext();
        if (highlighter.getNumHighlights() == 0) {
            System.out.println("Nothing highlighted");
            return;
        }
        Iterator it = highlighter.getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.EOBJ) continue;
            ElectricObject eobj = h.getElectricObject();
            if (eobj instanceof PortInst) {
                PortInst pi = (PortInst)eobj;
                pi.getInfo();
                eobj = pi.getNodeInst();
            }
            if (!(eobj instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)eobj;
            LETool.printResults(ni, context);
        }
    }

    public static void backAnnotateCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        BackAnnotateJob job = new BackAnnotateJob(cell);
        job.startJob();
    }

    public static boolean layerCoverageCommand(Cell cell, int mode, boolean startJob) {
        Cell curCell = cell;
        if (curCell == null) {
            curCell = WindowFrame.needCurCell();
        }
        if (curCell == null) {
            return false;
        }
        EditWindow wnd = EditWindow.needCurrent();
        Highlighter highlighter = null;
        if (wnd != null && wnd.getCell() == curCell) {
            highlighter = wnd.getHighlighter();
        }
        double width = LayerCoverage.getWidth(curCell.getTechnology());
        double height = LayerCoverage.getHeight(curCell.getTechnology());
        double deltaX = LayerCoverage.getDeltaX(curCell.getTechnology());
        double deltaY = LayerCoverage.getDeltaY(curCell.getTechnology());
        Rectangle2D bbox = curCell.getBounds();
        if (width > bbox.getWidth()) {
            width = bbox.getWidth();
        }
        if (height > bbox.getHeight()) {
            height = bbox.getHeight();
        }
        LayerCoverage.AreaCoverage job = new LayerCoverage.AreaCoverage(curCell, highlighter, mode, width, height, deltaX, deltaY);
        if (startJob) {
            job.startJob();
        } else {
            job.doIt();
        }
        return job.isOK();
    }

    public static void layerCoverageCommand(Job.Type jobType, int func, int mode) {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        Highlighter highlighter = null;
        if (wnd != null && wnd.getCell() == curCell) {
            highlighter = wnd.getHighlighter();
        }
        LayerCoverageJob job = new LayerCoverageJob(null, jobType, curCell, func, mode, highlighter, null, null);
        job.startJob();
    }

    public static void clearSizesNodableCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (highlighter.getNumHighlights() == 0) {
            System.out.println("Nothing highlighted");
            return;
        }
        Iterator it = highlighter.getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.EOBJ) continue;
            ElectricObject eobj = h.getElectricObject();
            if (eobj instanceof PortInst) {
                PortInst pi = (PortInst)eobj;
                pi.getInfo();
                eobj = pi.getNodeInst();
            }
            if (!(eobj instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)eobj;
            LETool.clearStoredSizesJob(ni);
        }
        System.out.println("Sizes cleared");
    }

    public static void clearSizesCommand() {
        Iterator it = Library.getVisibleLibraries().iterator();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            LETool.clearStoredSizesJob(lib);
        }
        System.out.println("Sizes cleared");
    }

    public static void loadLogicalEffortLibraries() {
        if (Library.findLibrary("purpleGeneric180") != null) {
            return;
        }
        URL url = LibFile.getLibFile("purpleGeneric180.jelib");
        FileMenu.ReadLibrary job = new FileMenu.ReadLibrary(url, FileType.JELIB, null);
    }

    public static void showNetworkCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Set nets = highlighter.getHighlightedNetworks();
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted netlist display (network information unavailable).  Please try again");
            return;
        }
        highlighter.showNetworks(nets, netlist, cell);
        WindowFrame.show3DHighlight();
        highlighter.finished();
    }

    public static void listNetworksCommand() {
        Cell cell = WindowFrame.getCurrentCell();
        if (cell == null) {
            return;
        }
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted netlist display (network information unavailable).  Please try again");
            return;
        }
        int total = 0;
        Iterator it = netlist.getNetworks();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            String netName = net.describe(false);
            if (netName.length() == 0) continue;
            StringBuffer infstr = new StringBuffer();
            infstr.append("'" + netName + "'");
            boolean connected = false;
            Iterator aIt = net.getArcs();
            while (aIt.hasNext()) {
                ArcInst ai = (ArcInst)aIt.next();
                if (!connected) {
                    connected = true;
                    infstr.append(", on arcs:");
                }
                infstr.append(" " + ai.describe(true));
            }
            boolean exported = false;
            Iterator eIt = net.getExports();
            while (eIt.hasNext()) {
                Export pp = (Export)eIt.next();
                if (!exported) {
                    exported = true;
                    infstr.append(", with exports:");
                }
                infstr.append(" " + pp.getName());
            }
            System.out.println(infstr.toString());
            ++total;
        }
        if (total == 0) {
            System.out.println("There are no networks in this cell");
        }
    }

    public static void listConnectionsOnNetworkCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Set nets = highlighter.getHighlightedNetworks();
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted query (network information unavailable).  Please try again");
            return;
        }
        Iterator it = nets.iterator();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            System.out.println("Network " + net.describe(true) + ":");
            int total = 0;
            Iterator nIt = netlist.getNodables();
            while (nIt.hasNext()) {
                HashSet ports;
                Nodable no = (Nodable)nIt.next();
                NodeProto np = no.getProto();
                HashMap<Network, HashSet<PortProto>> portNets = new HashMap<Network, HashSet<PortProto>>();
                Iterator pIt = np.getPorts();
                while (pIt.hasNext()) {
                    PortProto pp = (PortProto)pIt.next();
                    if (pp instanceof PrimitivePort && ((PrimitivePort)pp).isIsolated()) {
                        NodeInst ni = (NodeInst)no;
                        Iterator cIt = ni.getConnections();
                        while (cIt.hasNext()) {
                            Connection con = (Connection)cIt.next();
                            ArcInst ai = con.getArc();
                            Network oNet = netlist.getNetwork(ai, 0);
                            HashSet<PortProto> ports2 = (HashSet<PortProto>)portNets.get(oNet);
                            if (ports2 == null) {
                                ports2 = new HashSet<PortProto>();
                                portNets.put(oNet, ports2);
                            }
                            ports2.add(pp);
                        }
                        continue;
                    }
                    int width = 1;
                    if (pp instanceof Export) {
                        Export e = (Export)pp;
                        width = netlist.getBusWidth(e);
                    }
                    for (int i = 0; i < width; ++i) {
                        Network oNet = netlist.getNetwork(no, pp, i);
                        HashSet<PortProto> ports3 = (HashSet<PortProto>)portNets.get(oNet);
                        if (ports3 == null) {
                            ports3 = new HashSet<PortProto>();
                            portNets.put(oNet, ports3);
                        }
                        ports3.add(pp);
                    }
                }
                if (portNets.size() <= 1 || (ports = (HashSet)portNets.get(net)) == null) continue;
                if (total == 0) {
                    System.out.println("  Connects to:");
                }
                String name = null;
                name = no instanceof NodeInst ? ((NodeInst)no).describe(false) : no.getName();
                Iterator pIt2 = ports.iterator();
                while (pIt2.hasNext()) {
                    PortProto pp = (PortProto)pIt2.next();
                    System.out.println("    Node " + name + ", port " + pp.getName());
                    ++total;
                }
            }
            if (total != 0) continue;
            System.out.println("  Not connected");
        }
    }

    public static void listExportsOnNetworkCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Set nets = highlighter.getHighlightedNetworks();
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted query (network information unavailable).  Please try again");
            return;
        }
        Iterator it = nets.iterator();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            System.out.println("Network '" + net.describe(true) + "':");
            HashSet listedExports = new HashSet();
            System.out.println("  Going up the hierarchy from " + cell + ":");
            if (ToolMenu.findPortsUp(netlist, net, cell, listedExports)) break;
            System.out.println("  Going down the hierarchy from " + cell + ":");
            if (!ToolMenu.findPortsDown(netlist, net, cell, listedExports)) continue;
            break;
        }
    }

    public static void listExportsBelowNetworkCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Set nets = highlighter.getHighlightedNetworks();
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted query (network information unavailable).  Please try again");
            return;
        }
        Iterator it = nets.iterator();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            System.out.println("Network " + net.describe(true) + ":");
            if (!ToolMenu.findPortsDown(netlist, net, cell, new HashSet())) continue;
            break;
        }
    }

    private static boolean findPortsUp(Netlist netlist, Network net, Cell cell, HashSet listedExports) {
        Iterator it = cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            int width = netlist.getBusWidth(pp);
            for (int i = 0; i < width; ++i) {
                Network ppNet = netlist.getNetwork(pp, i);
                if (ppNet != net || listedExports.contains(pp)) continue;
                listedExports.add(pp);
                System.out.println("    Export " + pp.getName() + " in " + cell);
                Cell instanceCell = cell.iconView();
                if (instanceCell == null) {
                    instanceCell = cell;
                }
                Iterator uIt = instanceCell.getUsagesOf();
                while (uIt.hasNext()) {
                    CellUsage u = (CellUsage)uIt.next();
                    Cell superCell = u.getParent();
                    Netlist superNetlist = cell.acquireUserNetlist();
                    if (superNetlist == null) {
                        System.out.println("Sorry, a deadlock aborted query (network information unavailable).  Please try again");
                        return true;
                    }
                    Iterator nIt = superNetlist.getNodables();
                    while (nIt.hasNext()) {
                        Network superNet;
                        Nodable no = (Nodable)nIt.next();
                        if (no.getProto() != cell || !ToolMenu.findPortsUp(superNetlist, superNet = superNetlist.getNetwork(no, pp, i), superCell, listedExports)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean findPortsDown(Netlist netlist, Network net, Cell cell, HashSet listedExports) {
        Iterator it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable no = (Nodable)it.next();
            NodeProto subnp = no.getProto();
            if (!(subnp instanceof Cell)) continue;
            Cell subCell = (Cell)subnp;
            Iterator pIt = subCell.getPorts();
            while (pIt.hasNext()) {
                Export pp = (Export)pIt.next();
                int width = netlist.getBusWidth(pp);
                for (int i = 0; i < width; ++i) {
                    Network oNet = netlist.getNetwork(no, pp, i);
                    if (oNet != net || listedExports.contains(pp)) continue;
                    listedExports.add(pp);
                    System.out.println("    Export " + pp.getName() + " in " + subCell);
                    Netlist subNetlist = subCell.acquireUserNetlist();
                    if (subNetlist == null) {
                        System.out.println("Sorry, a deadlock aborted query (network information unavailable).  Please try again");
                        return true;
                    }
                    Network subNet = subNetlist.getNetwork(pp, i);
                    if (!ToolMenu.findPortsDown(subNetlist, subNet, subCell, listedExports)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void listGeometryOnNetworkCommand(int mode) {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        HashSet nets = (HashSet)wnd.getHighlighter().getHighlightedNetworks();
        if (nets.isEmpty()) {
            System.out.println("No network in " + cell + " selected");
            return;
        }
        LayerCoverageJob.listGeometryOnNetworks(cell, nets, true, mode);
    }

    public static void listGeomsAllNetworksCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        ListGeomsAllNetworksJob job = new ListGeomsAllNetworksJob(cell);
    }

    public static void showPowerAndGround() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted query (network information unavailable).  Please try again");
            return;
        }
        HashSet<Network> pAndG = new HashSet<Network>();
        Iterator it = cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            if (!pp.isPower() && !pp.isGround()) continue;
            int width = netlist.getBusWidth(pp);
            for (int i = 0; i < width; ++i) {
                Network net = netlist.getNetwork(pp, i);
                pAndG.add(net);
            }
        }
        it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun != PrimitiveNode.Function.CONPOWER && fun != PrimitiveNode.Function.CONGROUND) continue;
            Iterator cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = (Connection)cIt.next();
                ArcInst ai = con.getArc();
                int width = netlist.getBusWidth(ai);
                for (int i = 0; i < width; ++i) {
                    Network net = netlist.getNetwork(ai, i);
                    pAndG.add(net);
                }
            }
        }
        highlighter.clear();
        it = pAndG.iterator();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            highlighter.addNetwork(net, cell);
        }
        highlighter.finished();
        if (pAndG.size() == 0) {
            System.out.println("This cell has no Power or Ground networks");
        }
    }

    public static void validatePowerAndGround() {
        System.out.println("Validating power and ground networks");
        int total = 0;
        Iterator lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = (Library)lIt.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                Iterator pIt = cell.getPorts();
                while (pIt.hasNext()) {
                    Export pp = (Export)pIt.next();
                    if (pp.isNamedGround() && pp.getCharacteristic() != PortCharacteristic.GND) {
                        System.out.println("Cell " + cell.describe(true) + ", export " + pp.getName() + ": does not have 'GROUND' characteristic");
                        ++total;
                    }
                    if (!pp.isNamedPower() || pp.getCharacteristic() == PortCharacteristic.PWR) continue;
                    System.out.println("Cell " + cell.describe(true) + ", export " + pp.getName() + ": does not have 'POWER' characteristic");
                    ++total;
                }
            }
        }
        if (total == 0) {
            System.out.println("No problems found");
        } else {
            System.out.println("Found " + total + " export problems");
        }
    }

    public static void addMultiplierCommand() {
        Cell cell = WindowFrame.needCurCell();
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        NodeInst ni = (NodeInst)highlighter.getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        AddMultiplier job = new AddMultiplier(ni);
    }

    public static void makeTemplate(Variable.Key templateKey) {
        MakeTemplate job = new MakeTemplate(templateKey);
    }

    public static void getUnroutedArcCommand() {
        User.getUserTool().setCurrentArcProto(Generic.tech.unrouted_arc);
    }

    public static void padFrameGeneratorCommand() {
        String fileName = OpenFile.chooseInputFile(FileType.PADARR, null);
        if (fileName != null) {
            PadGenerator.makePadFrame(fileName);
        }
    }

    public static void listToolsCommand() {
        System.out.println("Tools in Electric:");
        Iterator it = Tool.getTools();
        while (it.hasNext()) {
            Tool tool = (Tool)it.next();
            StringBuffer infstr = new StringBuffer();
            if (tool.isOn()) {
                infstr.append("On");
            } else {
                infstr.append("Off");
            }
            if (tool.isBackground()) {
                infstr.append(", Background");
            }
            if (tool.isFixErrors()) {
                infstr.append(", Correcting");
            }
            if (tool.isIncremental()) {
                infstr.append(", Incremental");
            }
            if (tool.isAnalysis()) {
                infstr.append(", Analysis");
            }
            if (tool.isSynthesis()) {
                infstr.append(", Synthesis");
            }
            System.out.println(tool.getName() + ": " + infstr.toString());
        }
    }

    public static void javaBshScriptCommand() {
        String fileName = OpenFile.chooseInputFile(FileType.JAVA, null);
        if (fileName != null) {
            EvalJavaBsh.runScript(fileName);
        }
    }

    public static void doSiliconCompilation(Job completion) {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        int activities = 24;
        Cell originalCell = cell;
        if (cell.getView() != View.NETLISTQUISC) {
            if (cell.getView() == View.SCHEMATIC) {
                Cell vhdlCell = cell.otherView(View.VHDL);
                if (vhdlCell != null && vhdlCell.getRevisionDate().after(cell.getRevisionDate())) {
                    cell = vhdlCell;
                } else {
                    activities |= 6;
                }
            }
            if (cell.getView() == View.VHDL) {
                Cell netListCell = cell.otherView(View.NETLISTQUISC);
                if (netListCell != null && netListCell.getRevisionDate().after(cell.getRevisionDate())) {
                    cell = netListCell;
                } else {
                    activities |= 4;
                }
            }
        }
        if (SilComp.getCellLib() == null) {
            Library lib = Library.findLibrary(SCLIBNAME);
            if (lib != null) {
                SilComp.setCellLib(lib);
            } else {
                activities |= 1;
            }
        }
        DoNextActivity sJob = new DoNextActivity(cell, activities, originalCell, null, completion);
    }

    public static void compileVHDL() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (cell.getView() != View.VHDL) {
            System.out.println("Must be editing a VHDL cell before compiling it");
            return;
        }
        DoNextActivity sJob = new DoNextActivity(cell, 20, cell, null, null);
    }

    public static void makeVHDL() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (cell.getView() != View.SCHEMATIC) {
            System.out.println("Must be editing a Schematic cell before converting it to VHDL");
            return;
        }
        DoNextActivity sJob = new DoNextActivity(cell, 18, cell, null, null);
    }

    public static void parasiticCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        Highlighter highlighter = wnd.getHighlighter();
        Set nets = highlighter.getHighlightedNetworks();
        Iterator it = nets.iterator();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            ParasiticTool.getParasiticTool().netwokParasitic(net, cell);
        }
    }

    public static void importAssuraDrcErrors() {
        String fileName = OpenFile.chooseInputFile(FileType.ERR, null);
        if (fileName == null) {
            return;
        }
        AssuraDrcErrors.importErrors(fileName);
    }

    public static void importCalibreDrcErrors() {
        String fileName = OpenFile.chooseInputFile(FileType.DB, null);
        if (fileName == null) {
            return;
        }
        CalibreDrcErrors.importErrors(fileName);
    }

    private static class DoNextActivity
    extends Job {
        private Cell cell;
        private Cell originalCell;
        private VarContext originalContext;
        private int activities;
        private Job completion;

        private DoNextActivity(Cell cell, int activities, Cell originalCell, VarContext originalContext, Job completion) {
            super("Silicon-Compiler activity", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.activities = activities;
            this.originalCell = originalCell;
            this.originalContext = originalContext;
            this.completion = completion;
            this.startJob();
        }

        public boolean doIt() {
            if ((this.activities & 1) != 0) {
                System.out.println("Reading Standard Cell Library 'sclib' ...");
                URL fileURL = LibFile.getLibFile("sclib.jelib");
                Library lib = LibraryFiles.readLibrary(fileURL, null, FileType.JELIB, false);
                Undo.noUndoAllowed();
                if (lib != null) {
                    SilComp.setCellLib(lib);
                }
                System.out.println(" Done");
                DoNextActivity sJob = new DoNextActivity(this.cell, this.activities & 0xFFFFFFFE, this.originalCell, this.originalContext, this.completion);
                return true;
            }
            if ((this.activities & 2) != 0) {
                System.out.print("Generating VHDL from " + this.cell + " ...");
                List vhdlStrings = GenerateVHDL.convertCell(this.cell);
                if (vhdlStrings == null) {
                    System.out.println("No VHDL produced");
                    return false;
                }
                String cellName = this.cell.getName() + "{vhdl}";
                Cell vhdlCell = this.cell.getLibrary().findNodeProto(cellName);
                if (vhdlCell == null && (vhdlCell = Cell.makeInstance(this.cell.getLibrary(), cellName)) == null) {
                    return false;
                }
                String[] array = new String[vhdlStrings.size()];
                for (int i = 0; i < vhdlStrings.size(); ++i) {
                    array[i] = (String)vhdlStrings.get(i);
                }
                vhdlCell.setTextViewContents(array);
                System.out.println(" Done, created " + vhdlCell);
                DoNextActivity sJob = new DoNextActivity(vhdlCell, this.activities & 0xFFFFFFFD, this.originalCell, this.originalContext, this.completion);
                return true;
            }
            if ((this.activities & 4) != 0) {
                System.out.print("Compiling VHDL in " + this.cell + " ...");
                CompileVHDL c = new CompileVHDL(this.cell);
                if (c.hasErrors()) {
                    System.out.println("ERRORS during compilation, no netlist produced");
                    return false;
                }
                List netlistStrings = c.getQUISCNetlist();
                if (netlistStrings == null) {
                    System.out.println("No netlist produced");
                    return false;
                }
                String cellName = this.cell.getName() + "{net.quisc}";
                Cell netlistCell = this.cell.getLibrary().findNodeProto(cellName);
                if (netlistCell == null && (netlistCell = Cell.makeInstance(this.cell.getLibrary(), cellName)) == null) {
                    return false;
                }
                String[] array = new String[netlistStrings.size()];
                for (int i = 0; i < netlistStrings.size(); ++i) {
                    array[i] = (String)netlistStrings.get(i);
                }
                netlistCell.setTextViewContents(array);
                System.out.println(" Done, created " + netlistCell);
                DoNextActivity sJob = new DoNextActivity(netlistCell, this.activities & 0xFFFFFFFB, this.originalCell, this.originalContext, this.completion);
                return true;
            }
            if ((this.activities & 8) != 0) {
                System.out.print("Reading netlist in " + this.cell + " ...");
                GetNetlist gnl = new GetNetlist();
                if (gnl.readNetCurCell(this.cell)) {
                    System.out.println();
                    return false;
                }
                System.out.println(" Done");
                System.out.print("Placing cells ...");
                Place place = new Place();
                String err = place.placeCells(gnl);
                if (err != null) {
                    System.out.println("\n" + err);
                    return false;
                }
                System.out.println(" Done");
                System.out.print("Routing cells ...");
                Route route = new Route();
                err = route.routeCells(gnl);
                if (err != null) {
                    System.out.println("\n" + err);
                    return false;
                }
                System.out.println(" Done");
                System.out.print("Generating layout ...");
                Maker maker = new Maker();
                Object result = maker.makeLayout(gnl);
                if (result instanceof String) {
                    System.out.println("\n" + (String)result);
                    if (Technology.getCurrent() == Schematics.tech) {
                        System.out.println("Should switch to a layout technology first (currently in Schematics)");
                    }
                    return false;
                }
                if (result instanceof Cell) {
                    Cell newCell = (Cell)result;
                    System.out.println(" Done, created " + newCell);
                    DoNextActivity sJob = new DoNextActivity(newCell, this.activities & 0xFFFFFFF7, this.originalCell, this.originalContext, this.completion);
                }
                System.out.println();
                return true;
            }
            if ((this.activities & 0x10) != 0) {
                WindowFrame.createEditWindow(this.cell);
                DoNextActivity sJob = new DoNextActivity(this.cell, this.activities & 0xFFFFFFEF, this.originalCell, this.originalContext, this.completion);
                return true;
            }
            if (this.completion != null) {
                this.completion.startJob();
            }
            return false;
        }
    }

    private static class MakeTemplate
    extends Job {
        private Variable.Key templateKey;

        protected MakeTemplate(Variable.Key templateKey) {
            super("Make template", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.templateKey = templateKey;
            this.startJob();
        }

        public boolean doIt() {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return false;
            }
            Variable templateVar = cell.getVar(this.templateKey);
            if (templateVar != null) {
                System.out.println("This cell already has a template");
                return false;
            }
            templateVar = cell.newDisplayVar(this.templateKey, "*Undefined");
            if (templateVar != null) {
                templateVar.setInterior(true);
                templateVar.setDispPart(TextDescriptor.DispPos.NAMEVALUE);
                System.out.println("Set " + this.templateKey.getName().replaceFirst("ATTR_", "") + " for " + cell);
            }
            return true;
        }
    }

    private static class AddMultiplier
    extends Job {
        private NodeInst ni;

        protected AddMultiplier(NodeInst ni) {
            super("Add Spice Multiplier", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.startJob();
        }

        public boolean doIt() {
            Variable var = this.ni.newDisplayVar(Simulation.M_FACTOR_KEY, new Double(1.0));
            if (var != null) {
                var.setOff(-1.5, -1.0);
                var.setDispPart(TextDescriptor.DispPos.NAMEVALUE);
            }
            return true;
        }
    }

    private static class ListGeomsAllNetworksJob
    extends Job {
        private Cell cell;

        public ListGeomsAllNetworksJob(Cell cell) {
            super("ListGeomsAllNetworks", User.getUserTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            Netlist netlist = this.cell.getNetlist(true);
            ArrayList networks = new ArrayList();
            Iterator it = netlist.getNetworks();
            while (it.hasNext()) {
                networks.add(it.next());
            }
            Collections.sort(networks, new TextUtils.NetworksByName());
            it = networks.iterator();
            while (it.hasNext()) {
                Network net = (Network)it.next();
                HashSet<Network> nets = new HashSet<Network>();
                nets.add(net);
                LayerCoverageJob.GeometryOnNetwork geoms = LayerCoverageJob.listGeometryOnNetworks(this.cell, nets, false, 1);
                if (geoms.getTotalWireLength() == 0.0) continue;
                System.out.println("Network " + net + " has wire length " + geoms.getTotalWireLength());
            }
            return true;
        }
    }

    private static class BackAnnotateJob
    extends Job {
        private Cell cell;

        public BackAnnotateJob(Cell cell) {
            super("BackAnnotate", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
        }

        public boolean doIt() {
            NccOptions options;
            NccResult result;
            Cell[] schLayCells = NccUtils.findSchematicAndLayout(this.cell);
            if (schLayCells == null) {
                System.out.println("Could not find schematic and layout cells for " + this.cell.describe(true));
                return false;
            }
            if (this.cell.getView() == View.LAYOUT) {
                schLayCells[1] = this.cell;
            }
            if ((result = Ncc.compare(schLayCells[0], null, schLayCells[1], null, options = new NccOptions(), this)) == null || !result.topologyMatch()) {
                System.out.println("Ncc failed, can't back-annotate");
                return false;
            }
            int wiresUpdated = 0;
            ArrayList<Network> networks = new ArrayList<Network>();
            HashMap<Network, NodeInst> map = new HashMap<Network, NodeInst>();
            Iterator it = schLayCells[0].getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                Variable var = ni.getVar("ATTR_LEWIRE");
                if (var == null) continue;
                var = ni.getVar("ATTR_L");
                if (var == null) {
                    System.out.println("No attribute L on wire model " + ni.describe(true) + ", ignoring it.");
                    continue;
                }
                PortInst pi = ni.getPortInst(0);
                if (pi == null) continue;
                Netlist netlist = schLayCells[0].getNetlist(true);
                Network schNet = netlist.getNetwork(pi);
                networks.add(schNet);
                map.put(schNet, ni);
            }
            Collections.sort(networks, new TextUtils.NetworksByName());
            it = networks.iterator();
            while (it.hasNext()) {
                Network schNet = (Network)it.next();
                NetEquivalence equiv = result.getNetEquivalence();
                HierarchyEnumerator.NetNameProxy proxy = equiv.findEquivalent(VarContext.globalContext, schNet);
                if (proxy == null) {
                    System.out.println("No matching network in layout for " + proxy.toString() + ", ignoring");
                    continue;
                }
                Network layNet = proxy.getNet();
                Cell netcell = layNet.getParent();
                HashSet<Network> nets = new HashSet<Network>();
                nets.add(layNet);
                LayerCoverageJob.GeometryOnNetwork geoms = LayerCoverageJob.listGeometryOnNetworks(netcell, nets, false, 1);
                double length = geoms.getTotalWireLength();
                NodeInst ni = (NodeInst)map.get(schNet);
                ni.updateVar("ATTR_L", (Object)new Double(length));
                ++wiresUpdated;
                System.out.println("Updated wire model " + ni.getName() + " on layout network " + proxy.toString() + " to: " + length + " lambda");
            }
            System.out.println("Updated " + wiresUpdated + " wire models in " + schLayCells[0] + " from layout " + schLayCells[1]);
            return true;
        }
    }
}

