/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class ZoomAndPanListener
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    public static ZoomAndPanListener theOne = new ZoomAndPanListener();
    private int startX;
    private int startY;
    private int lastX;
    private int lastY;
    private ToolBar.CursorMode mode;
    private static double[] panningAmounts = new double[]{0.15, 0.3, 0.6};

    private ZoomAndPanListener() {
    }

    public void mousePressed(MouseEvent evt) {
        this.lastX = this.startX = evt.getX();
        this.lastY = this.startY = evt.getY();
        this.mode = ToolBar.getCursorMode();
        if (this.mode == ToolBar.CursorMode.ZOOM) {
            if ((evt.getModifiers() & 2) != 0) {
                this.mode = ToolBar.CursorMode.PAN;
            }
        } else if (this.mode == ToolBar.CursorMode.PAN && (evt.getModifiers() & 2) != 0) {
            this.mode = ToolBar.CursorMode.ZOOM;
        }
        ZoomAndPanListener.setProperCursor(evt);
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
        ZoomAndPanListener.setProperCursor(evt);
    }

    public static void setProperCursor(MouseEvent evt) {
        if (ToolBar.getCursorMode() == ToolBar.CursorMode.ZOOM) {
            if ((evt.getModifiers() & 1) != 0) {
                TopLevel.setCurrentCursor(ToolBar.zoomOutCursor);
            } else {
                TopLevel.setCurrentCursor(ToolBar.zoomCursor);
            }
        }
    }

    public void mouseDragged(MouseEvent evt) {
        ZoomAndPanListener.setProperCursor(evt);
        int newX = evt.getX();
        int newY = evt.getY();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            if (wnd == null) {
                return;
            }
            Highlighter highlighter = wnd.getHighlighter();
            double scale = wnd.getScale();
            if (this.mode == ToolBar.CursorMode.ZOOM) {
                highlighter.clear();
                Point2D start = wnd.screenToDatabase(this.startX, this.startY);
                Point2D end = wnd.screenToDatabase(newX, newY);
                double minSelX = Math.min(start.getX(), end.getX());
                double maxSelX = Math.max(start.getX(), end.getX());
                double minSelY = Math.min(start.getY(), end.getY());
                double maxSelY = Math.max(start.getY(), end.getY());
                highlighter.addArea(new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY), wnd.getCell());
                highlighter.finished();
                wnd.clearDoingAreaDrag();
                wnd.repaint();
            } else if (this.mode == ToolBar.CursorMode.PAN) {
                Point2D pt = wnd.getScheduledOffset();
                wnd.setOffset(new Point2D.Double(pt.getX() - (double)(newX - this.lastX) / scale, pt.getY() + (double)(newY - this.lastY) / scale));
                wnd.repaintContents(null);
            }
            this.lastX = newX;
            this.lastY = newY;
        }
    }

    public void mouseReleased(MouseEvent evt) {
        ZoomAndPanListener.setProperCursor(evt);
        if (this.mode != ToolBar.CursorMode.ZOOM) {
            return;
        }
        int newX = evt.getX();
        int newY = evt.getY();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            if (wnd == null) {
                return;
            }
            Highlighter highlighter = wnd.getHighlighter();
            highlighter.clear();
            highlighter.finished();
            Point2D start = wnd.screenToDatabase(this.startX, this.startY);
            Point2D end = wnd.screenToDatabase(newX, newY);
            double minSelX = Math.min(start.getX(), end.getX());
            double maxSelX = Math.max(start.getX(), end.getX());
            double minSelY = Math.min(start.getY(), end.getY());
            double maxSelY = Math.max(start.getY(), end.getY());
            if ((evt.getModifiers() & 1) != 0) {
                wnd.setScale(wnd.getScale() * 0.5);
                Point2D.Double offset = new Point2D.Double((minSelX + maxSelX) / 2.0, (minSelY + maxSelY) / 2.0);
                wnd.setOffset(offset);
                wnd.repaintContents(null);
                TopLevel.setCurrentCursor(ToolBar.zoomCursor);
            } else {
                Rectangle2D.Double bounds = new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY);
                if (((RectangularShape)bounds).getWidth() > 0.0 || ((RectangularShape)bounds).getHeight() > 0.0) {
                    wnd.focusScreen(bounds);
                } else {
                    System.out.println("To zoom-in, drag an area");
                }
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
        int clicks = evt.getWheelRotation();
        System.out.println("Mouse wheel rolled by " + clicks);
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    public static void redrawDisplay() {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        wnd.repaintContents(null);
    }

    public static void panXOrY(int direction, WindowFrame wf, int ticks) {
        wf.getContent().panXOrY(direction, panningAmounts, ticks);
    }

    public static void centerSelection() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Rectangle2D bounds = highlighter.getHighlightedArea(wnd);
        if (bounds == null) {
            return;
        }
        wnd.setOffset(new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
        wnd.repaintContents(null);
    }

    public static void centerCursor(ActionEvent e) {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Point pt = wnd.getLastMousePosition();
        Point2D center = wnd.screenToDatabase(pt.x, pt.y);
        wnd.setOffset(center);
        wnd.repaintContents(null);
    }
}

