/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.SavedViews;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.MessagesWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.ui.ZoomAndPanListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.Iterator;
import javax.swing.KeyStroke;

public class WindowMenu {
    protected static void addWindowMenu(MenuBar menuBar) {
        int buckyBit = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        MenuBar.Menu windowMenu = MenuBar.makeMenu("_Window");
        menuBar.add(windowMenu);
        MenuBar.MenuItem m = windowMenu.addMenuItem("_Fill Window", KeyStroke.getKeyStroke(57, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.fullDisplay();
            }
        });
        menuBar.addDefaultKeyBinding(m, KeyStroke.getKeyStroke(105, buckyBit), null);
        m = windowMenu.addMenuItem("Redisplay _Window", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZoomAndPanListener.redrawDisplay();
            }
        });
        m = windowMenu.addMenuItem("Zoom _Out", KeyStroke.getKeyStroke(48, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.zoomOutDisplay();
            }
        });
        menuBar.addDefaultKeyBinding(m, KeyStroke.getKeyStroke(96, buckyBit), null);
        m = windowMenu.addMenuItem("_Zoom In", KeyStroke.getKeyStroke(55, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.zoomInDisplay();
            }
        });
        menuBar.addDefaultKeyBinding(m, KeyStroke.getKeyStroke(103, buckyBit), null);
        MenuBar.Menu specialZoomSubMenu = MenuBar.makeMenu("_Special Zoom");
        windowMenu.add(specialZoomSubMenu);
        m = specialZoomSubMenu.addMenuItem("Focus on _Highlighted", KeyStroke.getKeyStroke(70, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.focusOnHighlighted();
            }
        });
        menuBar.addDefaultKeyBinding(m, KeyStroke.getKeyStroke(101, buckyBit), null);
        m = specialZoomSubMenu.addMenuItem("_Zoom Box", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.zoomBoxCommand();
            }
        });
        specialZoomSubMenu.addMenuItem("Make _Grid Just Visible", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.makeGridJustVisibleCommand();
            }
        });
        specialZoomSubMenu.addMenuItem("Match Other _Window", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.matchOtherWindowCommand();
            }
        });
        windowMenu.addSeparator();
        m = windowMenu.addMenuItem("Pan _Left", KeyStroke.getKeyStroke(52, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZoomAndPanListener.panXOrY(0, WindowFrame.getCurrentWindowFrame(), 1);
            }
        });
        menuBar.addDefaultKeyBinding(m, KeyStroke.getKeyStroke(100, buckyBit), null);
        m = windowMenu.addMenuItem("Pan _Right", KeyStroke.getKeyStroke(54, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZoomAndPanListener.panXOrY(0, WindowFrame.getCurrentWindowFrame(), -1);
            }
        });
        menuBar.addDefaultKeyBinding(m, KeyStroke.getKeyStroke(102, buckyBit), null);
        m = windowMenu.addMenuItem("Pan _Up", KeyStroke.getKeyStroke(56, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZoomAndPanListener.panXOrY(1, WindowFrame.getCurrentWindowFrame(), -1);
            }
        });
        menuBar.addDefaultKeyBinding(m, KeyStroke.getKeyStroke(104, buckyBit), null);
        m = windowMenu.addMenuItem("Pan _Down", KeyStroke.getKeyStroke(50, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZoomAndPanListener.panXOrY(1, WindowFrame.getCurrentWindowFrame(), 1);
            }
        });
        menuBar.addDefaultKeyBinding(m, KeyStroke.getKeyStroke(98, buckyBit), null);
        MenuBar.Menu centerSubMenu = MenuBar.makeMenu("Cen_ter");
        windowMenu.add(centerSubMenu);
        centerSubMenu.addMenuItem("_Selection", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZoomAndPanListener.centerSelection();
            }
        });
        centerSubMenu.addMenuItem("_Cursor", KeyStroke.getKeyStroke(53, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZoomAndPanListener.centerCursor(e);
            }
        });
        windowMenu.addMenuItem("Saved _Views...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SavedViews.showSavedViewsDialog();
            }
        });
        windowMenu.addSeparator();
        windowMenu.addMenuItem("Toggle _Grid", KeyStroke.getKeyStroke(71, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.toggleGridCommand();
            }
        });
        windowMenu.addSeparator();
        MenuBar.Menu windowPartitionSubMenu = MenuBar.makeMenu("Ad_just Position");
        windowMenu.add(windowPartitionSubMenu);
        windowPartitionSubMenu.addMenuItem("Tile _Horizontally", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.tileHorizontallyCommand();
            }
        });
        windowPartitionSubMenu.addMenuItem("Tile _Vertically", KeyStroke.getKeyStroke(120, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.tileVerticallyCommand();
            }
        });
        windowPartitionSubMenu.addMenuItem("_Cascade", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.cascadeWindowsCommand();
            }
        });
        windowMenu.addMenuItem("Clos_e Window", KeyStroke.getKeyStroke(87, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowFrame curWF = WindowFrame.getCurrentWindowFrame();
                curWF.finished();
            }
        });
        if (!TopLevel.isMDIMode()) {
            windowMenu.addSeparator();
            m = windowMenu.addMenuItem("Move to Ot_her Display", null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WindowMenu.moveToOtherDisplayCommand();
                }
            });
            if (WindowMenu.getAllGraphicsDevices().length < 2) {
                m.setEnabled(false);
            }
        }
        windowMenu.addSeparator();
        MenuBar.Menu colorSubMenu = MenuBar.makeMenu("_Color Schemes");
        windowMenu.add(colorSubMenu);
        colorSubMenu.addMenuItem("_Restore Default Colors", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.defaultBackgroundCommand();
            }
        });
        colorSubMenu.addMenuItem("_Black Background Colors", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.blackBackgroundCommand();
            }
        });
        colorSubMenu.addMenuItem("_White Background Colors", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.whiteBackgroundCommand();
            }
        });
        MenuBar.Menu messagesSubMenu = MenuBar.makeMenu("_Messages Window");
        windowMenu.add(messagesSubMenu);
        messagesSubMenu.addMenuItem("_Save Messages...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TopLevel.getMessagesWindow().save();
            }
        });
        messagesSubMenu.addMenuItem("_Clear", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TopLevel.getMessagesWindow().clear();
            }
        });
        messagesSubMenu.addMenuItem("Set F_ont...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TopLevel.getMessagesWindow().selectFont();
            }
        });
        Class plugin3D = Resources.get3DClass("ui.J3DMenu");
        if (plugin3D != null) {
            try {
                Method createMethod = plugin3D.getDeclaredMethod("add3DMenus", MenuBar.Menu.class);
                createMethod.invoke((Object)plugin3D, windowMenu);
            }
            catch (Exception e) {
                System.out.println("Can't load 3D sub menu class: " + e.getMessage());
                ActivityLogger.logException(e);
            }
        }
        MenuBar.Menu sideBarSubMenu = MenuBar.makeMenu("Side _Bar");
        windowMenu.add(sideBarSubMenu);
        sideBarSubMenu.addMenuItem("On _Left", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowFrame.setSideBarLocation(true);
            }
        });
        sideBarSubMenu.addMenuItem("On _Right", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowFrame.setSideBarLocation(false);
            }
        });
    }

    public static void fullDisplay() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        wf.getContent().fillScreen();
    }

    public static void zoomOutDisplay() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        wf.getContent().zoomOutContents();
    }

    public static void zoomInDisplay() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        wf.getContent().zoomInContents();
    }

    public static void zoomBoxCommand() {
        EventListener oldListener = WindowFrame.getListener();
        WindowFrame.setListener(ClickZoomWireListener.theOne);
        ClickZoomWireListener.theOne.zoomBoxSingleShot(oldListener);
    }

    public static void makeGridJustVisibleCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Rectangle2D displayable = wnd.displayableBounds();
        Dimension sz = wnd.getSize();
        double scaleX = wnd.getGridXSpacing() * (double)sz.width / 5.0 / displayable.getWidth();
        double scaleY = wnd.getGridYSpacing() * (double)sz.height / 5.0 / displayable.getHeight();
        double scale = Math.min(scaleX, scaleY);
        wnd.setScale(wnd.getScale() / scale);
        wnd.repaintContents(null);
    }

    public static void matchOtherWindowCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        int numOthers = 0;
        EditWindow other = null;
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            EditWindow wfWnd;
            WindowFrame wf = (WindowFrame)it.next();
            if (!(wf.getContent() instanceof EditWindow) || (wfWnd = (EditWindow)wf.getContent()) == wnd) continue;
            ++numOthers;
            other = wfWnd;
        }
        if (numOthers != 1) {
            System.out.println("There must be exactly two windows in order for one to match the other");
            return;
        }
        wnd.setScale(other.getScale());
        wnd.repaintContents(null);
    }

    public static void focusOnHighlighted() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        wf.getContent().focusOnHighlighted();
    }

    public static void toggleGridCommand() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        if (wf.getContent() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)wf.getContent();
            if (wnd == null) {
                return;
            }
            wnd.setGrid(!wnd.isGrid());
        } else if (wf.getContent() instanceof WaveformWindow) {
            WaveformWindow ww = (WaveformWindow)wf.getContent();
            ww.toggleGridPoints();
        } else {
            System.out.println("Cannot draw a grid in this type of window");
        }
    }

    public static void tileHorizontallyCommand() {
        Rectangle[] areas = WindowMenu.getWindowAreas();
        for (int j = 0; j < areas.length; ++j) {
            Rectangle area = areas[j];
            int count = 0;
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = (WindowFrame)it.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX();
                int locY = (int)wfBounds.getCenterY();
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                ++count;
            }
            if (count == 0) continue;
            int windowHeight = area.height / count;
            count = 0;
            Iterator it2 = WindowFrame.getWindows();
            while (it2.hasNext()) {
                WindowFrame wf = (WindowFrame)it2.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX();
                int locY = (int)wfBounds.getCenterY();
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                Rectangle windowArea = new Rectangle(area.x, area.y + count * windowHeight, area.width, windowHeight);
                ++count;
                wf.setWindowSize(windowArea);
            }
        }
    }

    public static void tileVerticallyCommand() {
        Rectangle[] areas = WindowMenu.getWindowAreas();
        for (int j = 0; j < areas.length; ++j) {
            Rectangle area = areas[j];
            int count = 0;
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = (WindowFrame)it.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX();
                int locY = (int)wfBounds.getCenterY();
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                ++count;
            }
            if (count == 0) continue;
            int windowWidth = area.width / count;
            count = 0;
            Iterator it2 = WindowFrame.getWindows();
            while (it2.hasNext()) {
                WindowFrame wf = (WindowFrame)it2.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX();
                int locY = (int)wfBounds.getCenterY();
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                Rectangle windowArea = new Rectangle(area.x + count * windowWidth, area.y, windowWidth, area.height);
                ++count;
                wf.setWindowSize(windowArea);
            }
        }
    }

    public static void cascadeWindowsCommand() {
        Rectangle[] areas = WindowMenu.getWindowAreas();
        for (int j = 0; j < areas.length; ++j) {
            Rectangle area = areas[j];
            int count = 0;
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = (WindowFrame)it.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX();
                int locY = (int)wfBounds.getCenterY();
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                ++count;
            }
            if (count == 0) continue;
            int numRuns = 1;
            int windowXSpacing = 0;
            int windowYSpacing = 0;
            int windowWidth = area.width;
            int windowHeight = area.height;
            if (count > 1) {
                windowWidth = area.width * 3 / 4;
                windowHeight = area.height * 3 / 4;
                int windowSpacing = Math.min(area.width - windowWidth, area.height - windowHeight) / (count - 1);
                if (windowSpacing < 70) {
                    numRuns = 70 / windowSpacing;
                    if (70 % windowSpacing != 0) {
                        ++numRuns;
                    }
                    windowSpacing *= numRuns;
                }
                windowXSpacing = (area.width - windowWidth) / (count - 1) * numRuns;
                windowYSpacing = (area.height - windowHeight) / (count - 1) * numRuns;
            }
            count = 0;
            Iterator it2 = WindowFrame.getWindows();
            while (it2.hasNext()) {
                WindowFrame wf = (WindowFrame)it2.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX();
                int locY = (int)wfBounds.getCenterY();
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                int index = count / numRuns;
                Rectangle windowArea = new Rectangle(area.x + index * windowXSpacing, area.y + index * windowYSpacing, windowWidth, windowHeight);
                ++count;
                wf.setWindowSize(windowArea);
            }
        }
    }

    private static Rectangle[] getWindowAreas() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        Rectangle[] areas = new Rectangle[gs.length];
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            areas[j] = gc.getBounds();
        }
        MessagesWindow mw = TopLevel.getMessagesWindow();
        Rectangle mb = mw.getMessagesLocation();
        WindowMenu.removeOccludingRectangle(areas, mb);
        return areas;
    }

    private static void removeOccludingRectangle(Rectangle[] areas, Rectangle occluding) {
        int cX = occluding.x + occluding.width / 2;
        int cY = occluding.y + occluding.height / 2;
        for (int i = 0; i < areas.length; ++i) {
            int lX = (int)areas[i].getMinX();
            int hX = (int)areas[i].getMaxX();
            int lY = (int)areas[i].getMinY();
            int hY = (int)areas[i].getMaxY();
            if (cX <= lX || cX >= hX || cY <= lY || cY >= hY) continue;
            if (occluding.width > occluding.height) {
                if (occluding.getMaxY() - (double)lY < (double)hY - occluding.getMinY()) {
                    lY = (int)occluding.getMaxY();
                } else {
                    hY = (int)occluding.getMinY();
                }
            } else if (occluding.getMaxX() - (double)lX < (double)hX - occluding.getMinX()) {
                lX = (int)occluding.getMaxX();
            } else {
                hX = (int)occluding.getMinX();
            }
            areas[i].x = lX;
            areas[i].width = hX - lX;
            areas[i].y = lY;
            areas[i].height = hY - lY;
        }
    }

    public static void defaultBackgroundCommand() {
        User.setColorBackground(Color.LIGHT_GRAY.getRGB());
        User.setColorGrid(Color.BLACK.getRGB());
        User.setColorHighlight(Color.WHITE.getRGB());
        User.setColorPortHighlight(Color.YELLOW.getRGB());
        User.setColorText(Color.BLACK.getRGB());
        User.setColorInstanceOutline(Color.BLACK.getRGB());
        User.setColorWaveformBackground(Color.BLACK.getRGB());
        User.setColorWaveformForeground(Color.WHITE.getRGB());
        User.setColorWaveformStimuli(Color.RED.getRGB());
        EditWindow.repaintAllContents();
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            wf.loadComponentMenuForTechnology();
        }
    }

    public static void blackBackgroundCommand() {
        User.setColorBackground(Color.BLACK.getRGB());
        User.setColorGrid(Color.WHITE.getRGB());
        User.setColorHighlight(Color.RED.getRGB());
        User.setColorPortHighlight(Color.YELLOW.getRGB());
        User.setColorText(Color.WHITE.getRGB());
        User.setColorInstanceOutline(Color.WHITE.getRGB());
        User.setColorWaveformBackground(Color.BLACK.getRGB());
        User.setColorWaveformForeground(Color.WHITE.getRGB());
        User.setColorWaveformStimuli(Color.RED.getRGB());
        EditWindow.repaintAllContents();
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            wf.loadComponentMenuForTechnology();
        }
    }

    public static void whiteBackgroundCommand() {
        User.setColorBackground(Color.WHITE.getRGB());
        User.setColorGrid(Color.BLACK.getRGB());
        User.setColorHighlight(Color.RED.getRGB());
        User.setColorPortHighlight(Color.DARK_GRAY.getRGB());
        User.setColorText(Color.BLACK.getRGB());
        User.setColorInstanceOutline(Color.BLACK.getRGB());
        User.setColorWaveformBackground(Color.WHITE.getRGB());
        User.setColorWaveformForeground(Color.BLACK.getRGB());
        User.setColorWaveformStimuli(Color.RED.getRGB());
        EditWindow.repaintAllContents();
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            wf.loadComponentMenuForTechnology();
        }
    }

    private static GraphicsDevice[] getAllGraphicsDevices() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        return gs;
    }

    public static void moveToOtherDisplayCommand() {
        int i;
        if (TopLevel.isMDIMode()) {
            return;
        }
        WindowFrame curWF = WindowFrame.getCurrentWindowFrame();
        WindowContent content = curWF.getContent();
        GraphicsConfiguration curConfig = content.getPanel().getGraphicsConfiguration();
        GraphicsDevice curDevice = curConfig.getDevice();
        GraphicsDevice[] gs = WindowMenu.getAllGraphicsDevices();
        for (int j = 0; j < gs.length; ++j) {
        }
        for (i = 0; i < gs.length && gs[i] != curDevice; ++i) {
        }
        i = i == gs.length - 1 ? 0 : ++i;
        curWF.moveEditWindow(gs[i].getDefaultConfiguration());
    }
}

