/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.Mos;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.strategy.OutlierRecord;
import com.sun.electric.tool.ncc.strategy.OutlierTrans;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Iterator;

public class StratSizes
extends Strategy {
    private static final Integer CODE_OUTLIER = new Integer(1);
    private static final Integer CODE_REST = new Integer(2);
    private OutlierRecord outlierRecord;

    private StratSizes(NccGlobals globals) {
        super(globals);
    }

    private boolean widthsMatch(OutlierTrans o1, OutlierTrans o2) {
        return NccUtils.sizesMatch(o1.outlier.getWidth(), o2.outlier.getWidth(), this.globals.getOptions());
    }

    private OutlierTrans[] findThinestWidestShortestLongest(Circuit c) {
        double minWid = Double.MAX_VALUE;
        double maxWid = Double.MIN_VALUE;
        double minLen = Double.MAX_VALUE;
        double maxLen = Double.MIN_VALUE;
        double sumWid = 0.0;
        double sumLen = 0.0;
        int numTrans = 0;
        Mos thinnest = null;
        Mos widest = null;
        Mos shortest = null;
        Mos longest = null;
        Iterator it = c.getNetObjs();
        while (it.hasNext()) {
            NetObject no = (NetObject)it.next();
            if (!(no instanceof Mos)) {
                return null;
            }
            Mos m = (Mos)no;
            double w = m.getWidth();
            if (w < minWid) {
                thinnest = m;
                minWid = w;
            }
            if (w > maxWid) {
                widest = m;
                maxWid = w;
            }
            sumWid += w;
            double l = m.getLength();
            if (l < minLen) {
                shortest = m;
                minLen = l;
            }
            if (l > maxLen) {
                longest = m;
                maxLen = l;
            }
            sumLen += l;
            ++numTrans;
        }
        LayoutLib.error(numTrans == 0, "Empty circuit?");
        if (sumWid == 0.0) {
            return null;
        }
        double avgWid = sumWid / (double)numTrans;
        double thinDev = (avgWid - minWid) / avgWid;
        double wideDev = (maxWid - avgWid) / avgWid;
        double avgLen = sumLen / (double)numTrans;
        double shortDev = (avgLen - minLen) / avgLen;
        double longDev = (maxWid - avgLen) / avgLen;
        return new OutlierTrans[]{new OutlierTrans(thinnest, thinDev), new OutlierTrans(widest, wideDev), new OutlierTrans(shortest, shortDev), new OutlierTrans(longest, longDev)};
    }

    private OutlierRecord maxDeviation(OutlierRecord o1, OutlierRecord o2) {
        return o1.deviation() >= o2.deviation() ? o1 : o2;
    }

    private OutlierRecord buildOutlierRecord(EquivRecord r) {
        Object first = null;
        ArrayList<OutlierTrans> thins = new ArrayList<OutlierTrans>();
        ArrayList<OutlierTrans> wides = new ArrayList<OutlierTrans>();
        ArrayList<OutlierTrans> shorts = new ArrayList<OutlierTrans>();
        ArrayList<OutlierTrans> longs = new ArrayList<OutlierTrans>();
        Iterator it = r.getCircuits();
        while (it.hasNext()) {
            Circuit c = (Circuit)it.next();
            OutlierTrans[] o = this.findThinestWidestShortestLongest(c);
            if (o == null) {
                return null;
            }
            thins.add(o[0]);
            wides.add(o[1]);
            shorts.add(o[2]);
            longs.add(o[3]);
        }
        OutlierRecord thinestMOSs = new OutlierRecord(thins);
        OutlierRecord widestMOSs = new OutlierRecord(wides);
        OutlierRecord shortestMOSs = new OutlierRecord(shorts);
        OutlierRecord longestMOSs = new OutlierRecord(longs);
        OutlierRecord outlier = this.maxDeviation(thinestMOSs, widestMOSs);
        outlier = this.maxDeviation(outlier, shortestMOSs);
        outlier = this.maxDeviation(outlier, longestMOSs);
        return outlier;
    }

    private OutlierRecord findOutlierRecordWithLargestDeviation() {
        OutlierRecord furthestOut = null;
        Iterator frontier = this.globals.getPartLeafEquivRecs().getUnmatched();
        while (frontier.hasNext()) {
            OutlierRecord farOut;
            EquivRecord r = (EquivRecord)frontier.next();
            if (r.isMismatched() || (farOut = this.buildOutlierRecord(r)) == null) continue;
            if (furthestOut == null) {
                furthestOut = farOut;
                continue;
            }
            furthestOut = this.maxDeviation(furthestOut, farOut);
        }
        return furthestOut;
    }

    private LeafList doYourJob() {
        OutlierRecord r = this.findOutlierRecordWithLargestDeviation();
        if (r == null) {
            return new LeafList();
        }
        this.outlierRecord = r;
        return this.doFor(r.getEquivRecord());
    }

    public Integer doFor(NetObject n) {
        Mos t = (Mos)n;
        return this.outlierRecord.isOutlier(t) ? CODE_OUTLIER : CODE_REST;
    }

    public static LeafList doYourJob(NccGlobals globals) {
        StratSizes ss = new StratSizes(globals);
        return ss.doYourJob();
    }
}

