/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.DrcRings;
import com.sun.electric.tool.generator.layout.Gallery;
import com.sun.electric.tool.generator.layout.GenerateLayoutForGatesInSchematic;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;

public class GateLayoutGenerator
extends Job {
    private Technology technology;
    private static final DrcRings.Filter FILTER = new DrcRings.Filter(){

        public boolean skip(NodeInst ni) {
            return ni.getProto().getName().indexOf("mosWellTie_") != -1;
        }
    };

    private Library generateLayout(Library outLib, Cell cell, VarContext context, Technology technology) {
        StdCellParams stdCell;
        Technology tsmc90 = Technology.getTSMC90Technology();
        if (tsmc90 != null && technology == tsmc90) {
            Tech.setTechnology("tsmc90");
            stdCell = GateLayoutGenerator.sportParams(outLib);
        } else {
            Tech.setTechnology("mocmos");
            stdCell = GateLayoutGenerator.locoParams(outLib);
        }
        GenerateLayoutForGatesInSchematic visitor = new GenerateLayoutForGatesInSchematic(stdCell);
        HierarchyEnumerator.enumerateCell(cell, context, null, visitor);
        Cell gallery = Gallery.makeGallery(outLib);
        DrcRings.addDrcRings(gallery, FILTER, stdCell);
        return outLib;
    }

    private static StdCellParams locoParams(Library outLib) {
        StdCellParams stdCell = new StdCellParams(outLib, "mocmos");
        stdCell.enableNCC("purpleFour");
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(21.0);
        stdCell.setGndY(-21.0);
        stdCell.setNmosWellHeight(42.0);
        stdCell.setPmosWellHeight(42.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    private static StdCellParams sportParams(Library outLib) {
        StdCellParams stdCell = new StdCellParams(outLib, "tsmc90");
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(24.5);
        stdCell.setGndY(-24.5);
        stdCell.setNmosWellHeight(84.0);
        stdCell.setPmosWellHeight(84.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    public boolean doIt() {
        String outLibNm = "autoGenLib";
        String outLibDir = "";
        Library outLib = LayoutLib.openLibForWrite(outLibNm, outLibDir + outLibNm);
        EditWindow wnd = EditWindow.getCurrent();
        Cell cell = wnd.getCell();
        VarContext context = wnd.getVarContext();
        if (cell == null) {
            System.out.println("Please open the schematic for which you want to generate gate layouts.");
            return false;
        }
        if (!cell.isSchematic()) {
            System.out.println("The current cell isn't a schematic. This command only works on schematics.");
            return false;
        }
        System.out.println("Generating layouts for gates in the schematic: " + cell.getName() + " and its descendents");
        System.out.println("Output goes to library: autoGenLib");
        this.generateLayout(outLib, cell, context, this.technology);
        System.out.println("done.");
        return true;
    }

    public GateLayoutGenerator(Technology technology) {
        super("Generate gate layouts", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.ANALYSIS);
        this.technology = technology;
        this.startJob();
    }
}

