/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.text.Name;
import java.util.ConcurrentModificationException;
import java.util.HashSet;

public class ImmutableCell {
    public final String name;
    final ImmutableNodeInst[] nodes;
    private static final ImmutableNodeInst[] NULL_NODES;
    static final /* synthetic */ boolean $assertionsDisabled;

    ImmutableCell(String name, ImmutableNodeInst[] nodes) {
        this.name = name;
        this.nodes = nodes;
        this.check();
    }

    public int maxNodeId() {
        return this.nodes.length - 1;
    }

    public ImmutableNodeInst getNodeById(int nodeId) {
        return nodeId < this.nodes.length ? this.nodes[nodeId] : null;
    }

    private ImmutableNodeInst getNodeByIdSurely(int nodeId) {
        ImmutableNodeInst node = this.nodes[nodeId];
        if (node == null) {
            throw new ArrayIndexOutOfBoundsException(nodeId);
        }
        return node;
    }

    public int findNodeId(String name) {
        if (name != null) {
            for (int i = 0; i < this.nodes.length; ++i) {
                ImmutableNodeInst node = this.nodes[i];
                if (node == null || !node.name.equals(name)) continue;
                return i;
            }
        }
        return -1;
    }

    public static ImmutableCell newInstance(String name, ImmutableNodeInst[] nodes) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        ImmutableNodeInst[] newNodes = ImmutableCell.clone(nodes, NULL_NODES);
        ImmutableCell.checkNames(newNodes);
        return new ImmutableCell(name, newNodes);
    }

    public ImmutableCell withName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.name == name) {
            return this;
        }
        return new ImmutableCell(name, this.nodes);
    }

    public ImmutableCell withNodes(ImmutableNodeInst[] nodes) {
        ImmutableNodeInst[] newNodes = ImmutableCell.clone(nodes, this.nodes);
        if (newNodes == this.nodes) {
            return this;
        }
        boolean checkNames = false;
        for (int i = 0; i < newNodes.length; ++i) {
            ImmutableNodeInst newNode;
            ImmutableNodeInst oldNode = this.getNodeById(i);
            if (oldNode == (newNode = newNodes[i])) continue;
            if (oldNode == null) {
                checkNames = true;
                continue;
            }
            if (newNode == null || newNode.name.equals(oldNode.name)) continue;
            checkNames = true;
        }
        if (checkNames) {
            ImmutableCell.checkNames(newNodes);
        }
        return new ImmutableCell(this.name, newNodes);
    }

    public ImmutableCell withNode(int nodeId, ImmutableNodeInst node) {
        ImmutableNodeInst oldNode = this.getNodeById(nodeId);
        if (node == oldNode) {
            return this;
        }
        int length = this.nodes.length;
        boolean checkName = false;
        if (oldNode == null) {
            checkName = true;
            if (nodeId >= length) {
                length = nodeId + 1;
            }
        } else if (node == null) {
            if (nodeId == length - 1) {
                while (--length > 0 && this.nodes[length - 1] == null) {
                }
            }
        } else if (!node.name.equals(oldNode.name)) {
            checkName = true;
        }
        if (checkName && this.findNodeId(node.name.toString()) >= 0) {
            throw new IllegalArgumentException("node " + node.name + " exists");
        }
        ImmutableNodeInst[] newNodes = new ImmutableNodeInst[length];
        System.arraycopy(this.nodes, 0, newNodes, 0, Math.min(this.nodes.length, length));
        if (nodeId < length) {
            newNodes[nodeId] = node;
        }
        return new ImmutableCell(this.name, newNodes);
    }

    public ImmutableCell withNodeProto(int nodeId, int protoId) {
        return this.withNode(nodeId, this.getNodeByIdSurely(nodeId).withProto(protoId));
    }

    public ImmutableCell withNodeName(int nodeId, Name name) {
        return this.withNode(nodeId, this.getNodeByIdSurely(nodeId).withName(name, 0));
    }

    public ImmutableCell withNodeAnchor(int nodeId, EPoint anchor) {
        return this.withNode(nodeId, this.getNodeByIdSurely(nodeId).withAnchor(anchor));
    }

    private static ImmutableNodeInst[] clone(ImmutableNodeInst[] nodes, ImmutableNodeInst[] oldNodes) {
        ImmutableNodeInst[] newNodes = NULL_NODES;
        if (nodes != null) {
            int length;
            for (length = nodes.length; length > 0 && nodes[length - 1] == null; --length) {
            }
            if (length == oldNodes.length) {
                int i;
                for (i = length - 1; i >= 0 && nodes[i] == oldNodes[i]; --i) {
                }
                if (i < 0) {
                    return oldNodes;
                }
            }
            if (length > 0) {
                newNodes = new ImmutableNodeInst[length];
                System.arraycopy(nodes, 0, newNodes, 0, length);
                if (newNodes[length - 1] == null) {
                    throw new ConcurrentModificationException();
                }
            }
        }
        return newNodes;
    }

    public void check() {
        if (!($assertionsDisabled || this.name != null && this.nodes != null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.nodes.length != 0 && this.nodes[this.nodes.length - 1] == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            ImmutableNodeInst node = this.nodes[i];
            if (node == null) continue;
            node.check();
        }
        ImmutableCell.checkNames(this.nodes);
    }

    private static void checkNames(ImmutableNodeInst[] nodes) {
        HashSet<Name> names = new HashSet<Name>();
        for (int i = 0; i < nodes.length; ++i) {
            ImmutableNodeInst node = nodes[i];
            if (node == null) continue;
            if (names.contains(node.name)) {
                throw new IllegalArgumentException("Duplicate node " + node.name);
            }
            names.add(node.name);
        }
    }

    void checkProto(ImmutableCell[] cells) {
        for (int i = 0; i < this.nodes.length; ++i) {
            ImmutableNodeInst node = this.nodes[i];
            if (node == null) continue;
            node.checkProto(cells);
        }
    }

    static {
        $assertionsDisabled = !ImmutableCell.class.desiredAssertionStatus();
        NULL_NODES = new ImmutableNodeInst[0];
    }
}

