;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2012, 2013, 2014, 2015, 2016, 2018, 2019, 2021 Ludovic Courtès <ludo@gnu.org>
;;; Copyright © 2017 Caleb Ristvedt <caleb.ristvedt@cune.org>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (guix config)
  #:export (%guix-package-name
            %guix-version
            %guix-bug-report-address
            %guix-home-page-url

            %channel-metadata

            %storedir
            %localstatedir
            %sysconfdir

            %store-directory
            %state-directory
            %store-database-directory
            %config-directory

            %system
            %gzip
            %bzip2
            %xz))

;;; Commentary:
;;;
;;; Compile-time configuration of Guix.  When adding a substitution variable
;;; here, make sure to equip (guix scripts pull) to substitute it.
;;;
;;; Code:

(define %guix-package-name
  "GNU Guix")

(define %guix-version
  "1.3.0rc1")

(define %guix-bug-report-address
  "bug-guix@gnu.org")

(define %guix-home-page-url
  "https://www.gnu.org/software/guix/")

(define %channel-metadata
  ;; When true, this is an sexp containing metadata for the 'guix' channel
  ;; this file was built from.  This is used by (guix describe).
  (let ((url    "https://git.savannah.gnu.org/git/guix.git")
        (commit "0d353b06ec6571972d2e8a3e3a3f0b27aa950e1c")
        (intro  '("9edb3f66fd807b096b48283debdcddccfea34bad" . "BBB0 2DDF 2CEA F6A8 0D1D  E643 A2A0 6DF2 A33A 54FA")))
    (and url commit
         `(repository
           (version 0)
           (url ,url)
           (branch "master")                      ;XXX: doesn't really matter
           (commit ,commit)
           (name guix)
           ,@(if intro
                 `((introduction
                    (channel-introduction
                     (version 0)
                     (commit ,(car intro))
                     (signer ,(cdr intro)))))
                 '())))))

(define %storedir
  "/gnu/store")

(define %localstatedir
  "/var")

(define %sysconfdir
  "/etc")

(define %store-directory
  (or (and=> (getenv "NIX_STORE_DIR") canonicalize-path)
      %storedir))

(define %state-directory
  ;; This must match `NIX_STATE_DIR' as defined in `nix/local.mk'.
  (or (getenv "GUIX_STATE_DIRECTORY")
      (string-append %localstatedir "/guix")))

(define %store-database-directory
  (or (getenv "GUIX_DATABASE_DIRECTORY")
      (string-append %state-directory "/db")))

(define %config-directory
  ;; This must match `GUIX_CONFIGURATION_DIRECTORY' as defined in `nix/local.mk'.
  (or (getenv "GUIX_CONFIGURATION_DIRECTORY")
      (string-append %sysconfdir "/guix")))

(define %system
  "x86_64-linux")

(define %gzip
  "/gnu/store/378zjf2kgajcfd7mfr98jn5xyc5wa3qv-gzip-1.10/bin/gzip")

(define %bzip2
  "/gnu/store/a9f7wmc75hbpg520phw9z4l9asm3qvsw-bzip2-1.0.8/bin/bzip2")

(define %xz
  "/gnu/store/9860f1abqj8wjjnwl8a9v54pdcc3bhgf-xz-5.2.4/bin/xz")

;;; config.scm ends here
