/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.io;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.PrologStream;
import gnu.prolog.vm.TermConstants;

public class Predicate_open
extends ExecuteOnlyCode {
    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        Term tsource_sink = args[0];
        Term tmode = args[1];
        Term tstream = args[2];
        Term optionsList = args[3];
        AtomTerm source_sink = null;
        AtomTerm mode = null;
        VariableTerm vstream = null;
        PrologStream.OpenOptions options = new PrologStream.OpenOptions(source_sink, mode, interpreter.getEnvironment());
        if (tsource_sink instanceof VariableTerm) {
            PrologException.instantiationError();
        }
        if (!(tsource_sink instanceof AtomTerm)) {
            PrologException.domainError(TermConstants.sourceSinkAtom, tsource_sink);
        }
        source_sink = (AtomTerm)tsource_sink;
        if (tmode instanceof VariableTerm) {
            PrologException.instantiationError();
        }
        if (!(tmode instanceof AtomTerm)) {
            PrologException.typeError(TermConstants.atomAtom, tmode);
        }
        if (tmode != PrologStream.readAtom && tmode != PrologStream.writeAtom && tmode != PrologStream.appendAtom) {
            PrologException.domainError(TermConstants.ioModeAtom, tmode);
        }
        mode = (AtomTerm)tmode;
        if (!(tstream instanceof VariableTerm)) {
            PrologException.typeError(TermConstants.variableAtom, tstream);
        }
        vstream = (VariableTerm)tstream;
        Term cur = optionsList;
        while (cur != TermConstants.emptyListAtom) {
            Term val;
            if (cur instanceof VariableTerm) {
                PrologException.instantiationError();
            }
            if (!(cur instanceof CompoundTerm)) {
                PrologException.typeError(TermConstants.listAtom, optionsList);
            }
            CompoundTerm ct = (CompoundTerm)cur;
            if (ct.tag != TermConstants.listTag) {
                PrologException.typeError(TermConstants.listAtom, optionsList);
            }
            Term head = ct.args[0].dereference();
            cur = ct.args[1].dereference();
            if (head instanceof VariableTerm) {
                PrologException.instantiationError();
            }
            if (!(head instanceof CompoundTerm)) {
                PrologException.domainError(TermConstants.streamOptionAtom, head);
            }
            CompoundTerm op = (CompoundTerm)head;
            if (op.tag == PrologStream.typeTag) {
                val = op.args[0].dereference();
                if (val != PrologStream.textAtom && val != PrologStream.binaryAtom) {
                    PrologException.domainError(TermConstants.streamOptionAtom, op);
                }
                options.type = (AtomTerm)val;
                continue;
            }
            if (op.tag == PrologStream.repositionTag) {
                val = op.args[0].dereference();
                if (val != TermConstants.trueAtom && val != TermConstants.falseAtom) {
                    PrologException.domainError(TermConstants.streamOptionAtom, op);
                }
                options.reposition = (AtomTerm)val;
                continue;
            }
            if (op.tag == PrologStream.aliasTag) {
                val = op.args[0].dereference();
                if (!(val instanceof AtomTerm)) {
                    PrologException.domainError(TermConstants.streamOptionAtom, op);
                }
                options.aliases.add((AtomTerm)val);
                continue;
            }
            if (op.tag == PrologStream.eofActionTag) {
                val = op.args[0].dereference();
                if (val != PrologStream.errorAtom && val != PrologStream.eofCodeAtom && val != PrologStream.resetAtom) {
                    PrologException.domainError(TermConstants.streamOptionAtom, op);
                }
                options.reposition = (AtomTerm)val;
                continue;
            }
            PrologException.domainError(TermConstants.streamOptionAtom, op);
        }
        options.filename = source_sink;
        options.mode = mode;
        vstream.value = interpreter.getEnvironment().open(source_sink, mode, options);
        interpreter.addVariableUndo(vstream);
        return 1;
    }
}

