/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.ImplUtils;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class AccessibleByteArrayOutputStream
extends ByteArrayOutputStream {
    public AccessibleByteArrayOutputStream() {
    }

    public AccessibleByteArrayOutputStream(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public byte[] toByteArray(int start, int end) {
        if (start < 0 || end >= this.count || start > end) {
            throw new IndexOutOfBoundsException("start: " + start + ", end: " + end + ", count: " + this.count);
        }
        return Arrays.copyOfRange(this.buf, start, end);
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.buf, 0, this.count).asReadOnlyBuffer();
    }

    public int count() {
        return this.count;
    }

    @Override
    public String toString(Charset charset) {
        return new String(this.buf, 0, this.count, charset);
    }

    public String bomAwareToString(String contentType) {
        return ImplUtils.bomAwareToString(this.buf, 0, this.count, contentType);
    }

    @Override
    public void close() {
    }
}

