/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.edge;

import java.awt.Color;
import org.freeplane.core.util.ObjectRule;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.edge.EdgeColorContext;

public class AutomaticEdgeStyle {
    private final ModeController modeController;
    private final MapModel mapModel;
    private final EdgeColorContext edgeColorContext;

    public AutomaticEdgeStyle(ModeController modeController, MapModel mapModel, EdgeColorContext edgeColorContext) {
        this.modeController = modeController;
        this.mapModel = mapModel;
        this.edgeColorContext = edgeColorContext;
    }

    public Color resolve(ObjectRule<Color, EdgeController.Rules> edgeColorRule) {
        if (edgeColorRule == null) {
            return EdgeController.STANDARD_EDGE_COLOR;
        }
        if (edgeColorRule.hasValue()) {
            return edgeColorRule.getValue();
        }
        EdgeController.Rules rule = edgeColorRule.getRule();
        if (rule == null) {
            return EdgeController.STANDARD_EDGE_COLOR;
        }
        Color color = this.resolve(rule);
        if (color != null && this.shouldCache(rule)) {
            edgeColorRule.setCache(color);
        }
        return color != null ? color : EdgeController.STANDARD_EDGE_COLOR;
    }

    private Color resolve(EdgeController.Rules rule) {
        switch (rule) {
            case BY_PARENT: {
                return this.edgeColorContext.getParentEdgeColor();
            }
            case BY_COLUMN: {
                return this.resolvePaletteColor(this.edgeColorContext.computeColumnPaletteIndex(), true);
            }
            case BY_BRANCH: {
                return this.resolvePaletteColor(this.edgeColorContext.computeBranchPaletteIndex(), false);
            }
            case BY_LEVEL: {
                return this.resolvePaletteColor(this.edgeColorContext.computeLevelPaletteIndex(), false);
            }
        }
        return null;
    }

    private boolean shouldCache(EdgeController.Rules rule) {
        return rule != EdgeController.Rules.BY_PARENT;
    }

    private Color resolvePaletteColor(int paletteIndex, boolean useStandardColorFallback) {
        if (this.modeController == null || this.mapModel == null) {
            return useStandardColorFallback ? EdgeController.STANDARD_EDGE_COLOR : null;
        }
        if (paletteIndex == -1) {
            return null;
        }
        EdgeController edgeController = this.modeController.getExtension(EdgeController.class);
        if (edgeController == null) {
            return useStandardColorFallback ? EdgeController.STANDARD_EDGE_COLOR : null;
        }
        if (edgeController.areEdgeColorsAvailable(this.mapModel)) {
            return edgeController.getEdgeColor(this.mapModel, paletteIndex);
        }
        return useStandardColorFallback ? EdgeController.STANDARD_EDGE_COLOR : null;
    }
}

